/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.onedrive;

import android.net.Uri;
import android.os.Bundle;
import com.zipow.videobox.util.IPickerResult;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class OneDriveAppPickerResult
implements IPickerResult {
    private Bundle mData;
    protected ArrayList<String> mFilterExtensions = new ArrayList();

    public OneDriveAppPickerResult(Bundle data, List<String> filterExtensions) {
        this.mData = data;
        if (filterExtensions != null) {
            this.mFilterExtensions.addAll(filterExtensions);
        }
    }

    public static IPickerResult fromBundle(Bundle data, List<String> filterExtensions) {
        if (data == null) {
            return null;
        }
        OneDriveAppPickerResult result = new OneDriveAppPickerResult(data, filterExtensions);
        if (result.getLink() == null) {
            return null;
        }
        return result;
    }

    @Override
    public String getName() {
        String extension = this.mData.getString("extension");
        if (StringUtil.isEmptyOrNull((String)extension)) {
            return this.mData.getString("name");
        }
        return this.mData.getString("name") + extension;
    }

    @Override
    public long getSize() {
        return this.mData.getLong("size", -1L);
    }

    @Override
    public Uri getLink() {
        return (Uri)this.mData.getParcelable("link");
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean acceptFileType() {
        if (this.mFilterExtensions.size() <= 0) {
            return true;
        }
        String extension = this.mData.getString("extension");
        if (StringUtil.isEmptyOrNull((String)extension)) {
            return false;
        }
        return this.mFilterExtensions.contains(extension.toLowerCase());
    }
}

