/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.onedrive;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.Item;
import com.onedrive.sdk.extensions.OneDriveClient;
import com.zipow.videobox.onedrive.IODFoldLoaderListener;
import com.zipow.videobox.onedrive.OneDriveConfig;
import com.zipow.videobox.onedrive.OneDriveDefaultCallback;
import com.zipow.videobox.onedrive.OneDriveEntry;
import com.zipow.videobox.onedrive.OneDriveLoadFolderTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.IDownloadFileListener;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncURLDownloadFile;

public class OneDrive {
    private IOneDriveClient mClient;
    private OneDriveStatus mStatus;
    private Listener mAuthListener;
    private boolean mIsCanceled;
    private StatusChangedListener mStatusListener;
    private List<OneDriveLoadFolderTask> mFolderLoaders = new ArrayList<OneDriveLoadFolderTask>();
    private List<ZMAsyncURLDownloadFile> mDownloadOperations = new ArrayList<ZMAsyncURLDownloadFile>();
    private OneDriveDefaultCallback<IOneDriveClient> mLoginCallBack = new OneDriveDefaultCallback<IOneDriveClient>(){

        @Override
        public void success(IOneDriveClient result) {
            OneDrive.this.mClient = result;
            OneDrive.this.mStatus = OneDriveStatus.CONNECTED;
            if (OneDrive.this.mAuthListener != null) {
                if (!OneDrive.this.mIsCanceled) {
                    OneDrive.this.mAuthListener.onAuthSuccess();
                }
                OneDrive.this.mIsCanceled = false;
            }
        }

        @Override
        public void failure(ClientException error) {
            OneDrive.this.mStatus = OneDriveStatus.NOT_CONNECTED;
            if (OneDrive.this.mAuthListener != null) {
                if (!OneDrive.this.mIsCanceled) {
                    OneDrive.this.mAuthListener.onAuthError(error);
                }
                OneDrive.this.mIsCanceled = false;
            }
        }
    };
    private ICallback<Void> mLogoutCallBack = new OneDriveDefaultCallback<Void>(){

        @Override
        public void success(Void result) {
            OneDrive.this.mAuthListener = null;
            if (OneDrive.this.mStatusListener != null) {
                OneDrive.this.mStatusListener.onLogout(OneDrive.this);
            }
        }

        @Override
        public void failure(ClientException error) {
            OneDrive.this.mStatus = OneDriveStatus.NOT_CONNECTED;
        }
    };

    public OneDrive(Context application, StatusChangedListener l, boolean isBusiness) {
        this.mClient = new OneDriveClient.Builder().fromConfig(isBusiness ? OneDriveConfig.createBusinessConfig(application) : OneDriveConfig.createConfig(application)).build();
        this.mStatus = OneDriveStatus.UNKNOWN;
        this.mStatusListener = l;
    }

    public IOneDriveClient getmClient() {
        return this.mClient;
    }

    public void setListener(Listener l) {
        this.mAuthListener = l;
    }

    public void onResume(Activity activity) {
        this.login(activity);
    }

    public void initial() {
        if (this.mStatus != OneDriveStatus.UNKNOWN && this.mStatus != OneDriveStatus.NOT_CONNECTED) {
            return;
        }
        this.mClient.validate();
        this.mStatus = OneDriveStatus.INITIALED;
    }

    public void login(Activity activity) {
        if (this.isAuthed()) {
            if (this.mAuthListener != null) {
                this.mAuthListener.onAuthSuccess();
            }
            return;
        }
        if (this.isAuthing()) {
            return;
        }
        this.mIsCanceled = false;
        this.mClient.login(activity, this.mLoginCallBack);
        if (this.mAuthListener != null) {
            this.mAuthListener.onAuthStarting();
        }
        this.mStatus = OneDriveStatus.CONNECTING;
    }

    public void logout() {
        if (this.mStatus == OneDriveStatus.UNKNOWN) {
            return;
        }
        this.mClient.getAuthenticator().logout(this.mLogoutCallBack);
        this.mStatus = OneDriveStatus.UNKNOWN;
    }

    public boolean isAuthed() {
        return this.mStatus == OneDriveStatus.CONNECTED;
    }

    public boolean isAuthing() {
        return this.mStatus == OneDriveStatus.CONNECTING;
    }

    public boolean asyncLoadFolder(OneDriveEntry oneDriveEntry, IODFoldLoaderListener l) {
        if (oneDriveEntry == null || !oneDriveEntry.isDir()) {
            return false;
        }
        return this.asyncLoadFolderByItemId(oneDriveEntry.getObject().getItemId(), l);
    }

    public boolean asyncLoadFolderByItemId(String itemId, IODFoldLoaderListener l) {
        if (StringUtil.isEmptyOrNull((String)itemId)) {
            return false;
        }
        OneDriveLoadFolderTask oneDriveLoadFolderTask = new OneDriveLoadFolderTask(this, itemId, l);
        this.mFolderLoaders.add(oneDriveLoadFolderTask);
        oneDriveLoadFolderTask.execute();
        return true;
    }

    public void removeDownloadFileTask(ZMAsyncURLDownloadFile downloadFileTask) {
        this.mDownloadOperations.remove(downloadFileTask);
    }

    public void removeLoadFolderTask(OneDriveLoadFolderTask oneDriveLoadFolderTask) {
        this.mFolderLoaders.remove(oneDriveLoadFolderTask);
    }

    public boolean asyncDownloadFile(Item item, String outPath, IDownloadFileListener iDownloadFileListener) {
        if (item == null || item.isFolder()) {
            return false;
        }
        if (!this.isAuthed()) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)outPath)) {
            return false;
        }
        String fileId = item.getItemId();
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return false;
        }
        String outfilePath = new File(outPath, item.getShowName()).getAbsolutePath();
        if (!StringUtil.isEmptyOrNull((String)outfilePath)) {
            ZMAsyncURLDownloadFile zmAsyncURLDownloadFile = new ZMAsyncURLDownloadFile(Uri.parse((String)item.getDownloadUrl()), item.size.longValue(), outfilePath, iDownloadFileListener);
            this.mDownloadOperations.add(zmAsyncURLDownloadFile);
            zmAsyncURLDownloadFile.execute((Object[])new Void[0]);
        }
        return true;
    }

    public void cancel() {
        for (ZMAsyncURLDownloadFile operation : this.mDownloadOperations) {
            operation.cancel(true);
        }
        this.mDownloadOperations.clear();
        for (OneDriveLoadFolderTask loader : this.mFolderLoaders) {
            loader.cancel();
        }
        this.mFolderLoaders.clear();
    }

    public void cancelAuth() {
        this.mIsCanceled = true;
    }

    public static interface Listener {
        public void onAuthStarting();

        public void onAuthSuccess();

        public void onAuthError(ClientException var1);
    }

    public static interface StatusChangedListener {
        public void onLogout(OneDrive var1);
    }

    private static enum OneDriveStatus {
        UNKNOWN,
        INITIALED,
        CONNECTING,
        CONNECTED,
        NOT_CONNECTED;

    }
}

