/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.onedrive;

import android.app.Activity;
import android.content.DialogInterface;
import android.net.Uri;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.Item;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.onedrive.IODFoldLoaderListener;
import com.zipow.videobox.onedrive.OneDrive;
import com.zipow.videobox.onedrive.OneDriveEntry;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFileListBaseAdapter;
import us.zoom.androidlib.app.ZMFileListEntry;
import us.zoom.androidlib.app.ZMFileListListener;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.IDownloadFileListener;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncURLDownloadFile;
import us.zoom.videomeetings.R;

public abstract class BaseOneDriveFileListAdapter
extends ZMFileListBaseAdapter
implements OneDrive.Listener {
    private ZMFileListListener mListener;
    protected OneDrive mOneDrive;
    private Item mCurrentItem;
    private String mCachedDir;
    private IODFoldLoaderListener mFloaderListener = new IODFoldLoaderListener(){

        @Override
        public void onLoadFoldCompleted(Item parentItem, List<Item> contents) {
            BaseOneDriveFileListAdapter.this.dismissWaitingDialog();
            BaseOneDriveFileListAdapter.this.mCurrentItem = parentItem;
            BaseOneDriveFileListAdapter.this.mFileList.clear();
            for (Item obj : contents) {
                if (!obj.isFolder() && !BaseOneDriveFileListAdapter.this.acceptFileType(obj.getPath())) continue;
                OneDriveEntry entry = new OneDriveEntry(obj, parentItem);
                BaseOneDriveFileListAdapter.this.mFileList.add(entry);
            }
            BaseOneDriveFileListAdapter.this.sortFileList();
            BaseOneDriveFileListAdapter.this.notifyDataSetChanged();
            if (BaseOneDriveFileListAdapter.this.mListener != null) {
                BaseOneDriveFileListAdapter.this.mListener.onRefresh();
            }
        }

        @Override
        public void onError(ClientException exception) {
            BaseOneDriveFileListAdapter.this.dismissWaitingDialog();
            if (BaseOneDriveFileListAdapter.this.mListener != null) {
                String message = exception.getMessage();
                if (StringUtil.isEmptyOrNull((String)message) || BaseOneDriveFileListAdapter.this.mCurrentItem != null && !StringUtil.isEmptyOrNull((String)BaseOneDriveFileListAdapter.this.mCurrentItem.getPath())) {
                    message = BaseOneDriveFileListAdapter.this.mActivity.getString(R.string.zm_msg_load_dir_fail, new Object[]{BaseOneDriveFileListAdapter.this.mCurrentItem.getPath()});
                }
                BaseOneDriveFileListAdapter.this.mListener.onOpenDirFailed(message);
            }
        }

        @Override
        public void onCanceled(String path) {
            BaseOneDriveFileListAdapter.this.dismissWaitingDialog();
        }
    };
    private IDownloadFileListener mFileDownloadListener = new IDownloadFileListener(){

        public void onDownloadCompleted(ZMAsyncURLDownloadFile task, Uri input, String output) {
            BaseOneDriveFileListAdapter.this.mOneDrive.removeDownloadFileTask(task);
            BaseOneDriveFileListAdapter.this.dismissWaitingDialog();
            if (BaseOneDriveFileListAdapter.this.mListener != null) {
                BaseOneDriveFileListAdapter.this.mListener.onSelectedFile(output, FileUtils.getFileName((String)output));
            }
        }

        public void onDownloadFailed(ZMAsyncURLDownloadFile task, Uri input) {
            BaseOneDriveFileListAdapter.this.mOneDrive.removeDownloadFileTask(task);
            BaseOneDriveFileListAdapter.this.dismissWaitingDialog();
            String output = task.getmOutput();
            if (!StringUtil.isEmptyOrNull((String)output)) {
                return;
            }
            if (BaseOneDriveFileListAdapter.this.mListener != null) {
                String message = BaseOneDriveFileListAdapter.this.mActivity.getString(R.string.zm_msg_load_file_fail, new Object[]{output});
                BaseOneDriveFileListAdapter.this.mListener.onOpenFileFailed(message);
            }
        }

        public void onDownloadProgress(ZMAsyncURLDownloadFile task, long totalBytes, long bytesRead) {
            String message = BaseOneDriveFileListAdapter.this.mActivity.getString(R.string.zm_msg_download_file_progress, new Object[]{(int)((float)bytesRead / (float)totalBytes * 100.0f)});
            BaseOneDriveFileListAdapter.this.updateProgressWaitingDialog(message);
        }

        public void onDownloadCanceled(ZMAsyncURLDownloadFile task, Uri input) {
            BaseOneDriveFileListAdapter.this.mOneDrive.removeDownloadFileTask(task);
            BaseOneDriveFileListAdapter.this.dismissWaitingDialog();
        }
    };
    private DialogInterface.OnCancelListener mWaitingDialogCancelListener = new DialogInterface.OnCancelListener(){

        public void onCancel(DialogInterface dialog) {
            BaseOneDriveFileListAdapter.this.mOneDrive.cancel();
            if (BaseOneDriveFileListAdapter.this.mActivity != null && BaseOneDriveFileListAdapter.this.mActivity.isActive()) {
                BaseOneDriveFileListAdapter.this.mActivity.onBackPressed();
            }
        }
    };
    private DialogInterface.OnCancelListener mAuthingDialogCancelListener = new DialogInterface.OnCancelListener(){

        public void onCancel(DialogInterface dialog) {
            BaseOneDriveFileListAdapter.this.mOneDrive.cancelAuth();
            if (BaseOneDriveFileListAdapter.this.mActivity != null && BaseOneDriveFileListAdapter.this.mActivity.isActive()) {
                BaseOneDriveFileListAdapter.this.mActivity.onBackPressed();
            }
        }
    };

    public void init(ZMActivity activity, ZMFileListListener l) {
        super.init(activity, l);
        this.mListener = l;
        this.mCachedDir = AppUtil.getCachePath();
    }

    public void login() {
        this.mOneDrive.login((Activity)this.mActivity);
    }

    public void logout() {
        this.mOneDrive.logout();
    }

    public void onResume() {
        this.mOneDrive.onResume((Activity)this.mActivity);
    }

    public void onDestroy() {
        this.cancel();
        this.mOneDrive.setListener(null);
    }

    public boolean isNeedAuth() {
        return true;
    }

    public boolean onBackPressed() {
        this.cancel();
        return super.onBackPressed();
    }

    private void cancel() {
        this.mOneDrive.cancel();
    }

    public boolean openDir(String itemId) {
        boolean ret;
        if (StringUtil.isEmptyOrNull((String)itemId)) {
            itemId = "root";
        }
        if (ret = this.mOneDrive.asyncLoadFolderByItemId(itemId, this.mFloaderListener)) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
        return ret;
    }

    protected void openDir(ZMFileListEntry dir) {
        if (dir == null || !dir.isDir()) {
            return;
        }
        if (!(dir instanceof OneDriveEntry)) {
            return;
        }
        OneDriveEntry entry = (OneDriveEntry)dir;
        boolean ret = this.mOneDrive.asyncLoadFolder(entry, this.mFloaderListener);
        if (ret) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
    }

    protected void openFile(ZMFileListEntry file) {
        if (file == null) {
            return;
        }
        if (!AppUtil.hasEnoughDiskSpace(this.mCachedDir, file.getBytes())) {
            this.alertMemoryNotEnough(this.mActivity.getString(R.string.zm_title_error), this.mActivity.getString(R.string.zm_msg_memory_size_insufficient));
            return;
        }
        if (!(file instanceof OneDriveEntry)) {
            return;
        }
        OneDriveEntry oneDriveEntry = (OneDriveEntry)file;
        if (oneDriveEntry == null) {
            return;
        }
        if (oneDriveEntry.isDir() || !this.acceptFileType(oneDriveEntry.getPath())) {
            return;
        }
        if (this.mOneDrive.asyncDownloadFile(oneDriveEntry.getObject(), this.mCachedDir, this.mFileDownloadListener)) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_download_file_progress, new Object[]{0}), this.mWaitingDialogCancelListener);
        }
    }

    public boolean isRootDir() {
        return this.mCurrentItem == null || this.mCurrentItem.isRoot();
    }

    public String getCurrentDirName() {
        if (this.mCurrentItem == null) {
            return "";
        }
        return StringUtil.safeString((String)this.mCurrentItem.getShowName());
    }

    public String getCurrentDirPath() {
        if (this.mCurrentItem == null) {
            return "root";
        }
        return this.mCurrentItem.getItemId();
    }

    protected void gotoParentDir() {
        if (this.isRootDir() || !this.mOneDrive.isAuthed()) {
            return;
        }
        if (this.mCurrentItem == null || this.mCurrentItem.isRoot()) {
            return;
        }
        if (this.mOneDrive.asyncLoadFolderByItemId(this.mCurrentItem.getmPItemId(), this.mFloaderListener)) {
            this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mWaitingDialogCancelListener);
        }
    }

    @Override
    public void onAuthStarting() {
        this.showWaitingDialog(this.mActivity.getString(R.string.zm_msg_loading), this.mAuthingDialogCancelListener);
        if (this.mListener != null) {
            this.mListener.onStarting();
        }
    }

    @Override
    public void onAuthSuccess() {
        this.dismissWaitingDialog();
        if (this.mListener != null) {
            this.mListener.onStarted(true, null);
        }
    }

    @Override
    public void onAuthError(ClientException exception) {
        this.dismissWaitingDialog();
        if (this.mListener != null) {
            this.mListener.onStarted(false, this.mActivity.getString(R.string.zm_alert_auth_token_failed_msg));
        }
    }
}

