/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.nos;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.zipow.videobox.ptapp.IncomingCallManager;
import com.zipow.videobox.util.NotificationMgr;

public class NosCallActionRceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String action;
        if (intent != null && !TextUtils.isEmpty((CharSequence)(action = intent.getAction()))) {
            if (action.equals("nos_call_accept")) {
                this.handleAcceptAction(context, intent);
            } else if (action.equals("nos_call_cancel")) {
                this.handleCancelAction(context);
            }
        }
    }

    private void handleCancelAction(Context context) {
        if (context != null) {
            NotificationMgr.removeNosCallNotification(context);
        }
    }

    private void handleAcceptAction(Context context, Intent intent) {
        if (context != null && intent != null) {
            String callBody = intent.getStringExtra("call_body");
            int messageType = intent.getIntExtra("call_type", 0);
            if (TextUtils.isEmpty((CharSequence)callBody)) {
                return;
            }
            String[] items = callBody.split(";");
            String token = "";
            String meetingNo = "";
            String meetingoption = "";
            String nsCommand = "";
            String fromUserID = "";
            String fromUserDevice = "";
            String fromUserName = "";
            String password = "";
            String scheduleOption = "";
            String isPhoneCall = "";
            if (items.length >= 10) {
                token = items[0];
                meetingNo = items[1];
                meetingoption = items[2];
                nsCommand = items[3];
                fromUserID = items[4];
                fromUserDevice = items[5];
                fromUserName = items[6];
                password = items[7];
                scheduleOption = items[8];
                isPhoneCall = items[9];
            }
            long mtNumber = 0L;
            long mtOption = 0L;
            try {
                mtNumber = Long.parseLong(meetingNo);
                mtOption = Long.parseLong(meetingoption);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IncomingCallManager incomingCallManager = IncomingCallManager.getInstance();
            incomingCallManager.initialize(context);
            incomingCallManager.acceptCall(context, true);
        }
    }
}

