/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.nos;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.firebase.iid.FirebaseInstanceId;
import com.zipow.videobox.AutoRecoveryUtil;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.WakeUpMessagesReceiver;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.nos.NosmgrNetworkStatusReceiver;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.SystemInfoHelper;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.ZMAuthUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.thirdparty.login.facebook.AuthToken;
import us.zoom.thirdparty.login.facebook.FBSessionStore;
import us.zoom.videomeetings.R;

public class NOSMgr {
    private static final String TAG = NOSMgr.class.getSimpleName();
    private static final String NEED_UNREGISTER_C2DM = "need_unregister_c2dm";
    private static final List<String> GCM_NOT_SUPPORT_COUNTRY_CODE = Arrays.asList("CN");
    public static final int XMPP_MSG_TYPE_TXT = 1;
    public static final int XMPP_MSG_TYPE_VIDEO = 2;
    public static final int XMPP_MSG_TYPE_IMG = 3;
    public static final int XMPP_MSG_TYPE_AUDIO = 4;
    public static final int XMPP_MSG_TYPE_FILE = 5;
    public static final int XMPP_MSG_TYPE_VIDEOCALL = 6;
    public static final int XMPP_MSG_TYPE_SCREENSHARECALL = 7;
    public static final int XMPP_MSG_TYPE_AUDIOCALL = 8;
    private static final int GCM_REGISTER_TIMEOUT = 10000;
    private static NOSMgr instance = null;
    private boolean mbRegistering = false;
    private boolean mbUnregistering = false;
    private boolean mbTCPConnected = false;
    private boolean mbGCMRegistered = false;
    private NosmgrNetworkStatusReceiver mNosmgrNetworkStatusReceiver;
    private Context mContext;
    private Handler mHandler = new Handler();

    public static synchronized NOSMgr getInstance() {
        if (instance == null) {
            instance = new NOSMgr();
        }
        return instance;
    }

    private NOSMgr() {
    }

    public void initialize(Context context) {
        this.mContext = context;
    }

    public String getSenderId(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return ZMAuthUtil.getBaiduPushSendId();
        }
        return context.getString(R.string.zm_config_gcm_sender_id);
    }

    public boolean isTCPConnected() {
        return this.mbTCPConnected;
    }

    public boolean isGCMRegistered() {
        return this.mbGCMRegistered;
    }

    public void register() {
        if (this.isC2DMCapable(this.mContext)) {
            String cachedRegistrationId = PreferenceUtil.readStringValue("fcm_registration_token", null);
            int cacheVersionCode = PreferenceUtil.readIntValue("fcm_registration_id_version_code", 0);
            if (!StringUtil.isEmptyOrNull((String)cachedRegistrationId) && cacheVersionCode == AndroidAppUtil.getAppVersionCode((Context)this.mContext)) {
                PTApp ptApp = PTApp.getInstance();
                ptApp.nos_SetDeviceToken(cachedRegistrationId, SystemInfoHelper.getDeviceId());
            } else {
                String refreshedToken = FirebaseInstanceId.getInstance().getToken();
                if (!TextUtils.isEmpty((CharSequence)refreshedToken)) {
                    PreferenceUtil.saveStringValue("fcm_registration_token", refreshedToken);
                    PreferenceUtil.saveIntValue("fcm_registration_id_version_code", AndroidAppUtil.getAppVersionCode((Context)this.mContext));
                    PTApp ptApp = PTApp.getInstance();
                    ptApp.nos_SetDeviceToken(cachedRegistrationId, SystemInfoHelper.getDeviceId());
                }
            }
        } else {
            PreferenceUtil.saveStringValue("fcm_registration_token", null);
            PreferenceUtil.saveIntValue("fcm_registration_id_version_code", 0);
            if (!"us.zoom.videomeetings".equals(this.mContext.getPackageName())) {
                this.createLongConnectionToNOS();
            }
        }
    }

    public void unregister() {
        this.unregisterC2DM();
    }

    public void onQueryIPLocation(PTAppProtos.IPLocationInfo info) {
        if (!this.isC2DMCapable(this.mContext) && this.isGCMRegistered()) {
            this.mbGCMRegistered = false;
        }
    }

    private boolean registerC2DM() {
        if (this.mContext == null) {
            return false;
        }
        String cachedRegistrationId = PreferenceUtil.readStringValue("gcm_registration_token", null);
        int cacheVersionCode = PreferenceUtil.readIntValue("gcm_registration_id_version_code", 0);
        if (!StringUtil.isEmptyOrNull((String)cachedRegistrationId) && cacheVersionCode == AndroidAppUtil.getAppVersionCode((Context)this.mContext)) {
            this.mbGCMRegistered = true;
            this.mbUnregistering = false;
            PTApp ptApp = PTApp.getInstance();
            ptApp.nos_SetDeviceToken(cachedRegistrationId, SystemInfoHelper.getDeviceId());
            VideoBoxApplication.getInstance().enableWakeUpMessagesReceiver(false);
            return true;
        }
        this.mbRegistering = true;
        this.mbUnregistering = false;
        PreferenceUtil.saveStringValue("gcm_registration_token", null);
        PreferenceUtil.saveIntValue("gcm_registration_id_version_code", 0);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                boolean bRegistered = false;
                try {
                    Class<?> gcmClazz = Class.forName("com.google.android.gms.gcm.GoogleCloudMessaging");
                    if (gcmClazz != null) {
                        Method methodGetInstance = gcmClazz.getMethod("getInstance", Context.class);
                        Method methodRegister = gcmClazz.getMethod("register", String[].class);
                        Object msg = null;
                        if (methodGetInstance != null) {
                            msg = methodGetInstance.invoke(null, NOSMgr.this.mContext);
                        }
                        if (methodRegister != null && msg != null) {
                            Object res = methodRegister.invoke(msg, new Object[]{new String[]{NOSMgr.this.getSenderId(NOSMgr.this.mContext)}});
                            if (res == null) return;
                            NOSMgr.this.onRegisterC2DMSuccess((String)res);
                            return;
                        }
                    }
                    if (bRegistered) return;
                }
                catch (Exception exception) {
                    if (bRegistered) return;
                    NOSMgr.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            NOSMgr.this.onRequestC2DMFailed("gcm service not available");
                        }
                    });
                    return;
                }
                catch (Throwable throwable) {
                    if (bRegistered) throw throwable;
                    NOSMgr.this.mHandler.post(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                NOSMgr.this.mHandler.post(new /* invalid duplicate definition of identical inner class */);
                return;
            }
        }.start();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!NOSMgr.this.isGCMRegistered()) {
                    NOSMgr.this.onRequestC2DMFailed("timeout, time=10000");
                }
            }
        }, 10000L);
        return true;
    }

    public void onXMPPConnectSuccess() {
        PTApp.getInstance().getIPLocation(true);
    }

    private void unregisterC2DM() {
        if (this.mContext == null) {
            return;
        }
        if (!this.isC2DMCapable(this.mContext)) {
            return;
        }
        this.mbUnregistering = true;
        this.mbGCMRegistered = false;
        PreferenceUtil.saveStringValue("gcm_registration_id", null);
        PreferenceUtil.saveLongValue("gcm_registration_id_timestamp", 0L);
        Intent unregIntent = new Intent("com.google.android.c2dm.intent.UNREGISTER");
        unregIntent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(), (int)0));
        try {
            VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
            if (videoBoxApplication == null) {
                CompatUtils.startService((Context)this.mContext, (Intent)unregIntent, (boolean)true, (boolean)true);
            } else {
                CompatUtils.startService((Context)this.mContext, (Intent)unregIntent, (!videoBoxApplication.isAtFront() ? 1 : 0) != 0, (boolean)videoBoxApplication.isMultiProcess());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onRequestC2DMFailed(String error) {
        if (this.mbRegistering && !this.mbUnregistering) {
            this.mbRegistering = false;
            if (!"us.zoom.videomeetings".equals(this.mContext.getPackageName())) {
                this.createLongConnectionToNOS();
            }
        } else if (this.mbUnregistering && !this.mbRegistering) {
            this.mbUnregistering = false;
            this.onUnregisterC2DMFailed();
        }
    }

    private void onUnregisterC2DMFailed() {
        PreferenceUtil.saveBooleanValue(NEED_UNREGISTER_C2DM, true);
        ComponentName component = new ComponentName(this.mContext, NosmgrNetworkStatusReceiver.class);
        try {
            this.mContext.getPackageManager().setComponentEnabledSetting(component, 1, 1);
            if (OsUtil.isAtLeastN() && this.mNosmgrNetworkStatusReceiver == null) {
                this.mNosmgrNetworkStatusReceiver = new NosmgrNetworkStatusReceiver();
                Context context = VideoBoxApplication.getGlobalContext();
                if (context != null) {
                    context.registerReceiver((BroadcastReceiver)this.mNosmgrNetworkStatusReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onRegisterC2DMSuccess(String registrationId) {
        if (StringUtil.isEmptyOrNull((String)registrationId)) {
            return;
        }
        if (!this.mbRegistering) {
            return;
        }
        PreferenceUtil.saveStringValue("gcm_registration_token", registrationId);
        PreferenceUtil.saveIntValue("gcm_registration_id_version_code", AndroidAppUtil.getAppVersionCode((Context)this.mContext));
        this.mbRegistering = false;
        this.mbGCMRegistered = true;
        PTApp ptApp = PTApp.getInstance();
        if (!ptApp.isWebSignedOn()) {
            String recentJid = ptApp.getRecentJid();
            if (!StringUtil.isEmptyOrNull((String)recentJid)) {
                boolean keepLoggin = false;
                if (ptApp.getPTLoginType() == 0) {
                    AuthToken authToken = FBSessionStore.getSession((Context)this.mContext, (String)"facebook-session");
                    if (authToken.isSessionValid()) {
                        keepLoggin = true;
                    }
                } else if (ptApp.getPTLoginType() == 2) {
                    keepLoggin = true;
                } else if (ptApp.getPTLoginType() == 100 || ptApp.getPTLoginType() == 101) {
                    keepLoggin = true;
                }
                if (keepLoggin) {
                    ptApp.nos_UpdateDeviceToken(registrationId, SystemInfoHelper.getDeviceId(), recentJid);
                }
            }
        } else {
            ptApp.nos_SetDeviceToken(registrationId, SystemInfoHelper.getDeviceId());
        }
        VideoBoxApplication.getInstance().enableWakeUpMessagesReceiver(true);
    }

    protected void onUnregisteredC2DM() {
        this.mbUnregistering = false;
        this.mbGCMRegistered = false;
        PreferenceUtil.saveBooleanValue(NEED_UNREGISTER_C2DM, false);
        ComponentName component = new ComponentName(this.mContext, NosmgrNetworkStatusReceiver.class);
        try {
            if (OsUtil.isAtLeastN() && this.mNosmgrNetworkStatusReceiver != null) {
                Context context = VideoBoxApplication.getGlobalContext();
                if (context != null) {
                    context.unregisterReceiver((BroadcastReceiver)this.mNosmgrNetworkStatusReceiver);
                }
                this.mNosmgrNetworkStatusReceiver = null;
            }
            this.mContext.getPackageManager().setComponentEnabledSetting(component, 2, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (PTApp.getInstance().isWebSignedOn() && !this.isTCPConnected()) {
            this.register();
        }
    }

    public void onReceiveC2DMMessage(Bundle data) {
        this.onReceivePushMessage(data, true, 2);
    }

    private void onReceivePushMessage(final Bundle data, final boolean reconnectedIfXMPPFailed, final int channel) {
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null) {
            return;
        }
        if (!mainboard.isInitialized()) {
            WakeUpMessagesReceiver.setHasMessageReceived();
            AutoRecoveryUtil.getInstance().autoRecovery((Context)VideoBoxApplication.getInstance());
        }
        if (!mainboard.isInitialized()) {
            return;
        }
        if (data == null) {
            return;
        }
        String targetDeviceID = data.getString("targetDeviceID");
        String caption = data.getString("caption");
        String body = data.getString("body");
        String timeStr = data.getString("time");
        String xmppmt = data.getString("xmppmt");
        String mb = data.getString("mb");
        String senderId = data.getString("senderid");
        String senderName = data.getString("sendername");
        if (caption == null && body == null && xmppmt == null && mb == null && senderId == null && senderName != null) {
            return;
        }
        boolean bForceDisableGCM = PreferenceUtil.readBooleanValue("forceDisableGCM", false);
        if (bForceDisableGCM && channel == 2) {
            return;
        }
        String myDeviceId = SystemInfoHelper.getDeviceId();
        if (!StringUtil.isEmptyOrNull((String)targetDeviceID) && !targetDeviceID.equals(myDeviceId)) {
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        if (!PTApp.getInstance().isWebSignedOn() && ptApp.getPTLoginType() == 102) {
            return;
        }
        if (body != null) {
            if (!TextUtils.isEmpty((CharSequence)timeStr)) {
                try {
                    int time = Integer.parseInt(timeStr);
                    int curTime = (int)(System.currentTimeMillis() / 1000L);
                    if (curTime - time > 600) {
                        return;
                    }
                }
                catch (Exception time) {
                    // empty catch block
                }
            }
            ptApp.nos_NotificationReceived(caption, body);
            WakeUpMessagesReceiver.setHasMessageReceived();
        } else if (xmppmt != null) {
            int msgType = 0;
            try {
                msgType = Integer.valueOf(xmppmt);
            }
            catch (Exception e) {
                return;
            }
            ptApp.nos_MessageNotificationReceived(msgType, mb, senderId, senderName);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!reconnectedIfXMPPFailed) {
                        return;
                    }
                    PTApp ptapp = PTApp.getInstance();
                    ZoomMessenger messenger = ptapp.getZoomMessenger();
                    if (messenger != null && !messenger.isConnectionGood()) {
                        NOSMgr.this.onReceivePushMessage(data, false, channel);
                    }
                }
            }, 10000L);
            WakeUpMessagesReceiver.setHasMessageReceived();
        }
    }

    private boolean isC2DMCapable(Context context) {
        boolean gcmAlways = PreferenceUtil.readBooleanValue("gcmAlways", false);
        if (gcmAlways) {
            return true;
        }
        return true;
    }

    private void createLongConnectionToNOS() {
        PTApp.getInstance().nos_SetDeviceToken("", SystemInfoHelper.getDeviceId());
        this.mbTCPConnected = true;
        VideoBoxApplication.getInstance().enableWakeUpMessagesReceiver(PTApp.getInstance().isDirectCallAvailable());
        VideoBoxApplication.getInstance().notifyStabilityServiceToProtectPT();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            messenger.setMsgUI(ZoomMessengerUI.getInstance());
            ZoomBuddy myself = messenger.getMyself();
            if (myself != null) {
                String jid = myself.getJid();
                PTApp.getInstance().setRencentZoomJid(jid);
                if (!StringUtil.isEmptyOrNull((String)jid)) {
                    PTUI.getInstance().startXmppAutoSignInTimer();
                }
            }
        }
    }

    public void onNetworkState(boolean hasDataNetwork) {
        boolean needUnRegisterC2DM;
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null) {
            return;
        }
        if (!mainboard.isInitialized()) {
            VideoBoxApplication.getInstance().initPTMainboard();
        }
        if (hasDataNetwork && (needUnRegisterC2DM = PreferenceUtil.readBooleanValue(NEED_UNREGISTER_C2DM, false))) {
            this.unregisterC2DM();
        }
    }
}

