/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.kubi;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.kubi.IKubiService;
import com.zipow.videobox.kubi.KubiService;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.StringUtil;

public class KubiServiceManager {
    private static final String TAG = KubiServiceManager.class.getSimpleName();
    private static KubiServiceManager instance;
    private ServiceConnection mKubiServiceConnection = null;
    private IKubiService mKubiService = null;
    private Context mContext = null;
    private ListenerList mConnectionListenerList = new ListenerList();

    public static synchronized KubiServiceManager getInstance(Context context) {
        if (instance == null) {
            instance = new KubiServiceManager(context);
        }
        return instance;
    }

    private KubiServiceManager(Context context) {
        if (context == null) {
            throw new RuntimeException("context is null");
        }
        this.mContext = context.getApplicationContext();
    }

    public void addConnectionListener(IKubiServiceConnectionListener l) {
        this.mConnectionListenerList.add((IListener)l);
    }

    public void removeConnectionListener(IKubiServiceConnectionListener l) {
        this.mConnectionListenerList.remove((IListener)l);
    }

    public void startKubiService() {
        this.startKubiService(null);
    }

    private boolean isKubiSupported() {
        return this.mContext != null && HardwareUtil.isBluetoothLESupported((Context)this.mContext);
    }

    public void startKubiService(String action) {
        VideoBoxApplication videoBoxApplication;
        if (this.mContext == null) {
            return;
        }
        if (!this.isKubiSupported()) {
            return;
        }
        Intent i = new Intent();
        i.setClassName(this.mContext.getPackageName(), KubiService.class.getName());
        if (!StringUtil.isEmptyOrNull((String)action)) {
            i.setAction("us.zoom.videomeetings.KubiContract.ACTION_START_KUBI_SERVICE_NO_AUTO_CONNECT");
        }
        CompatUtils.startService((Context)this.mContext, (Intent)i, (!(videoBoxApplication = VideoBoxApplication.getInstance()).isAtFront() ? 1 : 0) != 0, (boolean)videoBoxApplication.isMultiProcess());
    }

    public void stopKubiService() {
        if (this.mContext == null) {
            return;
        }
        if (!this.isKubiSupported()) {
            return;
        }
        Intent i = new Intent();
        i.setClassName(this.mContext.getPackageName(), KubiService.class.getName());
        try {
            this.mContext.stopService(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IKubiService getKubiService() {
        return this.mKubiService;
    }

    public void connectKubiService(boolean autoCreate) {
        if (this.mKubiService != null) {
            return;
        }
        if (this.mContext == null) {
            return;
        }
        if (!this.isKubiSupported()) {
            return;
        }
        if (this.mKubiServiceConnection == null) {
            this.mKubiServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName componentName, IBinder serviceBounder) {
                    IKubiService service = IKubiService.Stub.asInterface(serviceBounder);
                    KubiServiceManager.this.onKubiServiceConnected(service);
                }

                public void onServiceDisconnected(ComponentName name) {
                    KubiServiceManager.this.onKubiServiceDisconnected();
                }
            };
        }
        Intent i = new Intent();
        i.setClassName(this.mContext.getPackageName(), KubiService.class.getName());
        int flags = 64;
        if (autoCreate) {
            flags |= 1;
        }
        boolean ret = this.mContext.bindService(i, this.mKubiServiceConnection, flags);
    }

    private void onKubiServiceConnected(IKubiService service) {
        IListener[] listeners;
        this.mKubiService = service;
        for (IListener l : listeners = this.mConnectionListenerList.getAll()) {
            IKubiServiceConnectionListener connectionListener = (IKubiServiceConnectionListener)l;
            connectionListener.onKubiServiceConnected(this.mKubiService);
        }
    }

    private void onKubiServiceDisconnected() {
        IListener[] listeners;
        this.mKubiService = null;
        this.mKubiServiceConnection = null;
        for (IListener l : listeners = this.mConnectionListenerList.getAll()) {
            IKubiServiceConnectionListener connectionListener = (IKubiServiceConnectionListener)l;
            connectionListener.onKubiServiceDisconnected();
        }
    }

    public static interface IKubiServiceConnectionListener
    extends IListener {
        public void onKubiServiceConnected(IKubiService var1);

        public void onKubiServiceDisconnected();
    }
}

