/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.googledrive;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.android.http.AndroidHttp;
import com.google.api.client.googleapis.extensions.android.gms.auth.UserRecoverableAuthIOException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import com.zipow.cmmlib.AppUtil;
import com.zipow.google_login.GoogleAuthActivity;
import com.zipow.videobox.googledrive.GoogleDriveObjectEntry;
import com.zipow.videobox.googledrive.GoogleDriveUtil;
import com.zipow.videobox.googledrive.GoogleUtil;
import com.zipow.videobox.googledrive.ZMGoogleCredential;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;
import us.zoom.videomeetings.R;

public class GoogleDrive {
    private static final String TAG = GoogleDrive.class.getSimpleName();
    public static final String ROOT_ID = "root";
    private static final long TIME_OUT = 60000L;
    private static int BUFFER_SIZE = 1024;
    private ZMActivity mActivity;
    private Handler mHandler;
    private String mClientId;
    private String mSecret;
    private String[] mScopes;
    private String mRedirectUrl;
    private GoogleDriveAuthListener mListener;
    private String mAuthCode;
    private String mAuthErrorMsg;
    private Credential mCredential;
    private Drive mDrive;
    private ZMGoogleCredential mCredentialServer;
    private DriveChangeListener mChangeListener;
    private boolean mbRefreshTokenFailed = false;
    private DriveStatus mStatus;
    private List<GDAsyncLoadFolder> mLoadFolderTasks = new ArrayList<GDAsyncLoadFolder>();
    private List<GDAsyncDownloadFile> mDownloadFileTasks = new ArrayList<GDAsyncDownloadFile>();
    private Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            GoogleDrive.this.mStatus = DriveStatus.ERROR;
            if (GoogleDrive.this.mListener != null) {
                GoogleDrive.this.mListener.onAuthUnknowError();
            }
        }
    };
    private Runnable mAuthCancelRunnable = new Runnable(){

        @Override
        public void run() {
            GoogleDrive.this.mAuthCode = null;
            GoogleDrive.this.mStatus = DriveStatus.INITIAL;
            if (GoogleDrive.this.mListener != null) {
                GoogleDrive.this.mListener.onAuthCancel();
            }
        }
    };
    private ZMGoogleCredential.CredentialListener mCredentialListener = new ZMGoogleCredential.CredentialListener(){

        @Override
        public void onCompeleted(final Credential credential) {
            GoogleDrive.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    GoogleDrive.this.mCredential = credential;
                    if (GoogleDrive.this.mCredential == null) {
                        GoogleDrive.this.mStatus = DriveStatus.ERROR;
                        if (GoogleDrive.this.mListener != null) {
                            GoogleDrive.this.mListener.onAuthError(GoogleDrive.this.mActivity.getString(R.string.zm_alert_auth_token_failed_msg));
                        }
                        return;
                    }
                    GoogleDrive.this.mDrive = GoogleDrive.this.getDriveService(GoogleDrive.this.mCredential);
                    GoogleDrive.this.mStatus = DriveStatus.CREDENTIALED;
                    if (GoogleDrive.this.mListener != null) {
                        GoogleDrive.this.mListener.onAuthSuccess();
                    }
                }
            });
        }

        @Override
        public void onCancel() {
            GoogleDrive.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    GoogleDrive.this.mStatus = DriveStatus.AUTHCODED;
                    if (GoogleDrive.this.mListener != null) {
                        GoogleDrive.this.mListener.onAuthCancel();
                    }
                }
            });
        }

        @Override
        public void onError(final Exception e) {
            GoogleDrive.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (e != null) {
                        GoogleDrive.this.setError(e.getMessage());
                    } else {
                        GoogleDrive.this.setError(null);
                    }
                }
            });
        }

        @Override
        public void onRefreshToken(Credential credential, Credential newCredential) {
            if (GoogleDrive.this.mCredential != credential) {
                return;
            }
            if (newCredential == null) {
                GoogleDrive.this.setError(null);
                return;
            }
            GoogleDrive.this.mDrive = GoogleDrive.this.getDriveService(GoogleDrive.this.mCredential);
            GoogleDrive.this.mStatus = DriveStatus.CREDENTIALED;
        }

        @Override
        public void onRefreshTokenError(Credential credential, String errMsg) {
            GoogleDrive.this.mbRefreshTokenFailed = true;
        }
    };

    public GoogleDrive(String clientId, String secret, String[] scopes, String redirect, DriveChangeListener changeListener) {
        this.mChangeListener = changeListener;
        this.mClientId = clientId;
        this.mSecret = secret;
        this.mScopes = scopes;
        this.mRedirectUrl = redirect;
        this.mStatus = DriveStatus.INITIAL;
        this.mCredentialServer = new ZMGoogleCredential(this.mClientId, this.mSecret, this.mScopes, this.mCredentialListener);
    }

    public void bind(ZMActivity activity, Handler handler, GoogleDriveAuthListener l) {
        this.cancelAllRunnable();
        this.mActivity = activity;
        this.mHandler = handler;
        this.mListener = l;
    }

    public boolean isAuthed() {
        return this.mStatus.equals((Object)DriveStatus.CREDENTIALED);
    }

    public void login() {
        if (this.isAuthed()) {
            return;
        }
        if (this.mStatus.equals((Object)DriveStatus.ERROR)) {
            this.resetAuth();
            this.cancelAllRunnable();
        }
        if (this.mListener != null) {
            this.mListener.onAuthStarting();
        }
        if (this.mStatus.equals((Object)DriveStatus.INITIAL)) {
            this.startAuthCode();
        } else if (this.mStatus.equals((Object)DriveStatus.AUTHCODING)) {
            this.handleWebAuthResult();
        } else if (this.mStatus.equals((Object)DriveStatus.AUTHCODED)) {
            this.startCredential();
        } else {
            this.postTimeout();
        }
    }

    public void relogin() {
        this.resetAuth();
        this.cancelAllRunnable();
        this.login();
    }

    private void postTimeout() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mTimeOutRunnable);
        this.mHandler.postDelayed(this.mTimeOutRunnable, 60000L);
    }

    private void resetAuth() {
        this.mAuthCode = null;
        this.mAuthErrorMsg = null;
        this.mCredential = null;
        this.mDrive = null;
        this.mbRefreshTokenFailed = false;
        this.mStatus = DriveStatus.INITIAL;
    }

    private void startAuthCode() {
        if (!this.mStatus.equals((Object)DriveStatus.INITIAL)) {
            return;
        }
        this.mStatus = DriveStatus.AUTHCODING;
        this.startWebAuth();
    }

    public void startWebAuth() {
        if (this.mActivity == null) {
            return;
        }
        Intent intent = new Intent((Context)this.mActivity, GoogleAuthActivity.class);
        intent.putExtra("EXTRA_GOOGLE_CLIENT_ID", this.mClientId);
        intent.putExtra("EXTRA_GOOGLE_REDIRECT_URI", this.mRedirectUrl);
        try {
            this.mActivity.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return url;
        }
    }

    private void handleWebAuthResult() {
        if (this.mActivity == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)this.mAuthCode)) {
            if (!StringUtil.isEmptyOrNull((String)this.mAuthErrorMsg)) {
                this.setError(this.mAuthErrorMsg);
            } else {
                this.setError(null);
            }
            return;
        }
        this.mStatus = DriveStatus.AUTHCODED;
        this.startCredential();
    }

    private void startCredential() {
        if (!this.mStatus.equals((Object)DriveStatus.AUTHCODED)) {
            return;
        }
        this.mStatus = DriveStatus.CREDENTIALING;
        if (this.mListener != null) {
            this.mListener.onAuthCredentialStarting();
        }
        this.mCredentialServer.exchangeCode(this.mAuthCode, this.mRedirectUrl);
    }

    public void logout() {
        if (this.mChangeListener != null) {
            this.mChangeListener.onLogout(this);
        }
        this.resetAuth();
        this.cancelAllRunnable();
    }

    public void onDestroy() {
        this.cancelAuth();
        this.cancelAllAsyncTask();
    }

    public boolean cancelAuth() {
        if (this.mStatus.equals((Object)DriveStatus.AUTHCODING)) {
            this.mStatus = DriveStatus.INITIAL;
        } else if (this.mStatus.equals((Object)DriveStatus.CREDENTIALING) && this.mCredentialServer != null) {
            this.mCredentialServer.cancel();
            this.mStatus = DriveStatus.AUTHCODED;
        }
        return true;
    }

    private void cancelAllAsyncTask() {
        for (GDAsyncLoadFolder gDAsyncLoadFolder : this.mLoadFolderTasks) {
            gDAsyncLoadFolder.cancel(true);
        }
        this.mLoadFolderTasks.clear();
        for (GDAsyncDownloadFile gDAsyncDownloadFile : this.mDownloadFileTasks) {
            gDAsyncDownloadFile.cancel(true);
        }
        this.mDownloadFileTasks.clear();
    }

    private String getExtendByMimeType(String mimType) {
        return AndroidAppUtil.getFileExtendNameFromMimType((String)mimType);
    }

    public boolean downloadFile(GoogleDriveObjectEntry file, String outPath, DriveFileListener l) {
        String fileId;
        if (file == null || file.isDir() || StringUtil.isEmptyOrNull((String)outPath) || !this.isAuthed()) {
            return false;
        }
        String outfilePath = AppUtil.getShareCachePathByExtension(outPath, file.getDisplayName());
        String extension = AndroidAppUtil.getFileExtendName((String)file.getDisplayName());
        if (StringUtil.isEmptyOrNull((String)extension)) {
            extension = this.getExtendByMimeType(file.getMimeType());
            outfilePath = outfilePath + extension;
        }
        if (StringUtil.isEmptyOrNull((String)(fileId = file.getId()))) {
            return false;
        }
        GDAsyncDownloadFile task = new GDAsyncDownloadFile(fileId, file.getDisplayName(), outfilePath, l);
        this.mDownloadFileTasks.add(task);
        task.execute(new Void[0]);
        return true;
    }

    public boolean loadFolder(String path, String folderId, DriveFoldListener l) {
        if (!this.isAuthed() || StringUtil.isEmptyOrNull((String)folderId) && StringUtil.isEmptyOrNull((String)path)) {
            return false;
        }
        for (GDAsyncLoadFolder task : this.mLoadFolderTasks) {
            task.cancel(false);
        }
        this.mLoadFolderTasks.clear();
        GDAsyncLoadFolder task = new GDAsyncLoadFolder(path, folderId, l);
        this.mLoadFolderTasks.add(task);
        task.execute(new Void[0]);
        return true;
    }

    private Drive getDriveService(Credential credential) {
        if (credential == null) {
            return null;
        }
        return new Drive.Builder(AndroidHttp.newCompatibleTransport(), GoogleUtil.getDefaultJsonFactory(), (HttpRequestInitializer)credential).build();
    }

    public void setAuthCode(String authCode) {
        this.mAuthCode = authCode;
    }

    public void setAuthErrorMsg(String errorMsg) {
        this.mAuthErrorMsg = errorMsg;
    }

    private void setError(String errMsg) {
        this.mStatus = DriveStatus.ERROR;
        this.mAuthErrorMsg = null;
        this.mAuthCode = null;
        this.mCredential = null;
        this.mDrive = null;
        if (this.mListener != null) {
            if (!StringUtil.isEmptyOrNull((String)errMsg)) {
                this.mListener.onAuthError(errMsg);
            } else {
                this.mListener.onAuthError(null);
            }
        }
    }

    private void cancelAllRunnable() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mAuthCancelRunnable);
        this.mHandler.removeCallbacks(this.mTimeOutRunnable);
    }

    public static boolean canAuthGoogleViaBrowser(Context context) {
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.example.com"));
        List list = pm.queryIntentActivities(intent, 65536);
        return list != null && list.size() > 0;
    }

    public class GDAsyncLoadFolder
    extends ZMAsyncTask<Void, Void, Runnable> {
        private String mPath;
        private String mFolderId;
        private ArrayList<GoogleDriveObjectEntry> mFiles = new ArrayList();
        private DriveFoldListener mFolderListener;
        private boolean isByPath = false;

        public GDAsyncLoadFolder(String path, String folderId, DriveFoldListener l) {
            this.mFolderId = folderId;
            this.mFolderListener = l;
            this.mPath = path;
            if (StringUtil.isEmptyOrNull((String)this.mFolderId)) {
                this.isByPath = true;
            }
        }

        public String getFolderId() {
            return this.mFolderId;
        }

        public String getPath() {
            return this.mPath;
        }

        private FileList getFileList(String id2) throws IOException, UserRecoverableAuthIOException {
            String qStr = "'" + id2 + "' in parents and trashed=false and (mimeType = 'text/plain'or mimeType = 'application/pdf'or mimeType = 'image/bmp'or mimeType = 'image/gif'or mimeType = 'image/jpeg'or mimeType = 'image/png'or mimeType = 'application/vnd.google-apps.folder')";
            FileList fList = (FileList)GoogleDrive.this.mDrive.files().list().setQ(qStr).execute();
            return fList;
        }

        protected Runnable doInBackground(Void ... params) {
            if (GoogleDrive.this.mDrive == null || this.isByPath && StringUtil.isEmptyOrNull((String)this.mPath)) {
                return new OnErrorRunnable(new Exception(GoogleDrive.this.mActivity.getString(R.string.zm_msg_load_dir_fail, new Object[]{""})));
            }
            if (this.isCancelled()) {
                return new OnCanceledRunnable();
            }
            try {
                FileList fList = null;
                if (!this.isByPath) {
                    fList = this.getFileList(this.mFolderId);
                } else if (StringUtil.isEmptyOrNull((String)this.mPath) || this.mPath.equals(File.separator)) {
                    this.mFolderId = GoogleDrive.ROOT_ID;
                    fList = this.getFileList(GoogleDrive.ROOT_ID);
                } else {
                    String[] parts = this.mPath.split(File.separator);
                    String folderId = GoogleDrive.ROOT_ID;
                    com.google.api.services.drive.model.File file = null;
                    for (int index = 0; index < parts.length; ++index) {
                        if (file != null) {
                            folderId = file.getId();
                        }
                        fList = this.getFileList(folderId);
                        if (this.isCancelled()) {
                            return new OnCanceledRunnable();
                        }
                        if (index >= parts.length - 1 || (file = this.findFolderByName(fList, parts[index + 1])) != null) continue;
                        return new OnErrorRunnable(new Exception(GoogleDrive.this.mActivity.getString(R.string.zm_msg_load_dir_fail, new Object[]{this.mPath})));
                    }
                    this.mFolderId = folderId;
                }
                if (this.isCancelled()) {
                    return new OnCanceledRunnable();
                }
                if (fList == null) {
                    return new OnErrorRunnable(new Exception(GoogleDrive.this.mActivity.getString(R.string.zm_msg_load_dir_fail, new Object[]{this.mPath})));
                }
                for (com.google.api.services.drive.model.File fl : fList.getItems()) {
                    if (fl == null) continue;
                    GoogleDriveObjectEntry entry = new GoogleDriveObjectEntry(this.mPath, fl);
                    this.mFiles.add(entry);
                }
            }
            catch (UserRecoverableAuthIOException e) {
                return new OnRequestAuthorizationRunnable();
            }
            catch (IOException e) {
                return new OnErrorRunnable(e);
            }
            return new OnCompletedRunnable();
        }

        private com.google.api.services.drive.model.File findFolderByName(FileList list, String name) {
            if (list == null || StringUtil.isEmptyOrNull((String)name)) {
                return null;
            }
            for (com.google.api.services.drive.model.File folder : list.getItems()) {
                if (!GoogleDriveUtil.isFolder(folder) || !name.equals(folder.getTitle())) continue;
                return folder;
            }
            return null;
        }

        protected void onPostExecute(Runnable result) {
            GoogleDrive.this.mLoadFolderTasks.remove((Object)this);
            if (result == null) {
                return;
            }
            result.run();
        }

        public class OnCanceledRunnable
        implements Runnable {
            @Override
            public void run() {
                if (GDAsyncLoadFolder.this.mFolderListener != null) {
                    GDAsyncLoadFolder.this.mFolderListener.onLoadFolderCanceled(GDAsyncLoadFolder.this, GDAsyncLoadFolder.this.mFolderId);
                }
            }
        }

        public class OnErrorRunnable
        implements Runnable {
            private Exception mError;

            public OnErrorRunnable(Exception e) {
                this.mError = e;
            }

            @Override
            public void run() {
                if (GoogleDrive.this.mbRefreshTokenFailed) {
                    if (GDAsyncLoadFolder.this.mFolderListener != null) {
                        GDAsyncLoadFolder.this.mFolderListener.onRefreshTokenFailed(GDAsyncLoadFolder.this.mPath, GDAsyncLoadFolder.this.mFolderId);
                    }
                    GoogleDrive.this.relogin();
                    return;
                }
                if (GDAsyncLoadFolder.this.mFolderListener != null) {
                    GDAsyncLoadFolder.this.mFolderListener.onLoadFolderFailed(GDAsyncLoadFolder.this, GDAsyncLoadFolder.this.mFolderId, this.mError);
                }
            }
        }

        public class OnCompletedRunnable
        implements Runnable {
            @Override
            public void run() {
                if (GDAsyncLoadFolder.this.mFolderListener != null) {
                    GDAsyncLoadFolder.this.mFolderListener.onLoadFolderCompeleted(GDAsyncLoadFolder.this, GDAsyncLoadFolder.this.mFolderId, GDAsyncLoadFolder.this.mFiles);
                }
            }
        }

        public class OnRequestAuthorizationRunnable
        implements Runnable {
            @Override
            public void run() {
                GoogleDrive.this.relogin();
            }
        }
    }

    public class GDAsyncDownloadFile
    extends ZMAsyncTask<Void, Long, Runnable> {
        private String mFileId;
        private String mOutPath;
        private DriveFileListener mFileListener;
        private String mFileName;

        public GDAsyncDownloadFile(String fileId, String name, String out, DriveFileListener l) {
            this.mFileId = fileId;
            this.mOutPath = out;
            this.mFileListener = l;
            this.mFileName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Runnable doInBackground(Void ... params) {
            BufferedOutputStream out;
            InputStream is;
            com.google.api.services.drive.model.File file;
            if (GoogleDrive.this.mDrive == null || StringUtil.isEmptyOrNull((String)this.mFileId) || StringUtil.isEmptyOrNull((String)this.mOutPath)) {
                return new OnErrorRunnable();
            }
            if (this.isCancelled()) {
                return new onCanceledRunnable();
            }
            try {
                file = (com.google.api.services.drive.model.File)GoogleDrive.this.mDrive.files().get(this.mFileId).execute();
            }
            catch (IOException e) {
                return new OnErrorRunnable();
            }
            if (this.isCancelled()) {
                return new onCanceledRunnable();
            }
            long fileSize = file.getFileSize();
            String url = file.getDownloadUrl();
            if (fileSize <= 0L || StringUtil.isEmptyOrNull((String)url)) {
                return new OnErrorRunnable();
            }
            try {
                GenericUrl requestUrl = new GenericUrl(url);
                is = GoogleDrive.this.mDrive.getRequestFactory().buildGetRequest(requestUrl).execute().getContent();
            }
            catch (IOException e) {
                return new OnErrorRunnable();
            }
            if (this.isCancelled()) {
                return new onCanceledRunnable();
            }
            byte[] buffer = new byte[BUFFER_SIZE];
            try {
                out = new BufferedOutputStream(new FileOutputStream(this.mOutPath));
            }
            catch (FileNotFoundException e1) {
                this.closeSilently(is);
                return new OnErrorRunnable();
            }
            long readBytes = 0L;
            try {
                int bytesRead;
                while ((bytesRead = is.read(buffer)) != -1) {
                    if (this.isCancelled()) {
                        onCanceledRunnable onCanceledRunnable2 = new onCanceledRunnable();
                        return onCanceledRunnable2;
                    }
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                    this.publishProgress(new Long[]{fileSize, readBytes += (long)bytesRead});
                }
            }
            catch (IOException e) {
                OnErrorRunnable onErrorRunnable2 = new OnErrorRunnable();
                return onErrorRunnable2;
            }
            finally {
                this.closeSilently(is);
                this.closeSilently(out);
            }
            if (this.isCancelled()) {
                return new onCanceledRunnable();
            }
            return new OnCompeletedRunnable();
        }

        protected void onPostExecute(Runnable result) {
            GoogleDrive.this.mDownloadFileTasks.remove((Object)this);
            result.run();
        }

        protected void onProgressUpdate(Long ... values) {
            long totalBytes = values[0];
            long bytesRead = values[1];
            if (this.mFileListener != null) {
                this.mFileListener.onDownloadProgress(this.mFileId, this.mFileName, totalBytes, bytesRead);
            }
            super.onProgressUpdate((Object[])values);
        }

        private void closeSilently(Closeable c) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private class OnErrorRunnable
        implements Runnable {
            private Exception mException = null;

            @Override
            public void run() {
                if (GoogleDrive.this.mbRefreshTokenFailed) {
                    if (GDAsyncDownloadFile.this.mFileListener != null) {
                        GDAsyncDownloadFile.this.mFileListener.onRefreshTokenFailed(GDAsyncDownloadFile.this.mFileId, GDAsyncDownloadFile.this.mFileName, GDAsyncDownloadFile.this.mOutPath);
                    }
                    GoogleDrive.this.relogin();
                    return;
                }
                if (GDAsyncDownloadFile.this.mFileListener != null) {
                    GDAsyncDownloadFile.this.mFileListener.onDownloadFailed(GDAsyncDownloadFile.this.mFileId, GDAsyncDownloadFile.this.mFileName, this.mException);
                }
            }
        }

        private class onCanceledRunnable
        implements Runnable {
            private onCanceledRunnable() {
            }

            @Override
            public void run() {
                if (GDAsyncDownloadFile.this.mFileListener != null) {
                    GDAsyncDownloadFile.this.mFileListener.onDownloadCanceled(GDAsyncDownloadFile.this.mFileId, GDAsyncDownloadFile.this.mFileName);
                }
            }
        }

        private class OnCompeletedRunnable
        implements Runnable {
            private OnCompeletedRunnable() {
            }

            @Override
            public void run() {
                if (GDAsyncDownloadFile.this.mFileListener != null) {
                    GDAsyncDownloadFile.this.mFileListener.onDownloadCompleted(GDAsyncDownloadFile.this.mFileId, GDAsyncDownloadFile.this.mFileName, GDAsyncDownloadFile.this.mOutPath);
                }
            }
        }
    }

    private static enum DriveStatus {
        INITIAL,
        AUTHCODING,
        AUTHCODED,
        CREDENTIALING,
        CREDENTIALED,
        ERROR;

    }

    public static interface DriveChangeListener {
        public void onLogout(GoogleDrive var1);
    }

    public static interface DriveFoldListener {
        public void onLoadFolderCompeleted(GDAsyncLoadFolder var1, String var2, ArrayList<GoogleDriveObjectEntry> var3);

        public void onLoadFolderCanceled(GDAsyncLoadFolder var1, String var2);

        public void onLoadFolderFailed(GDAsyncLoadFolder var1, String var2, Exception var3);

        public void onRefreshTokenFailed(String var1, String var2);
    }

    public static interface DriveFileListener {
        public void onDownloadCompleted(String var1, String var2, String var3);

        public void onDownloadFailed(String var1, String var2, Exception var3);

        public void onDownloadProgress(String var1, String var2, long var3, long var5);

        public void onDownloadCanceled(String var1, String var2);

        public void onRefreshTokenFailed(String var1, String var2, String var3);
    }

    public static interface GoogleDriveAuthListener {
        public void onAuthStarting();

        public void onAuthCredentialStarting();

        public void onAuthSuccess();

        public void onAuthCancel();

        public void onAuthError(String var1);

        public void onAuthUnknowError();
    }
}

