/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.mm;

import android.content.Context;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddyGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class MMInvitePhoneContactsFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
TextView.OnEditorActionListener,
ABContactsCache.IABContactsCacheListener,
View.OnClickListener,
AdapterView.OnItemClickListener {
    private static final int REQUEST_PERMISSION_CONTACTS = 100;
    private View mPanelTitleBar;
    private EditText mEdtSearch;
    private FrameLayout mPanelListViews;
    private Drawable mDimmedForground = null;
    private View mPanelSearchBarReal;
    private View mPanelSearch;
    private EditText mEdtSearchReal;
    private Button mBtnClearSearchView;
    private boolean isKeyboardOpen;
    private QuickSearchListView mContactListView;
    private String mFilterKey;
    private List<ABContactsCache.Contact> mContacts = new ArrayList<ABContactsCache.Contact>();
    private ContactAdapter mAdapter;
    private Button mBtnInvite;
    private Map<String, String> mZMContacts = new HashMap<String, String>();
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = MMInvitePhoneContactsFragment.this.mEdtSearchReal.getText().toString();
            MMInvitePhoneContactsFragment.this.filter(key);
            if (key.length() > 0 && MMInvitePhoneContactsFragment.this.mContactListView.getListView().getCount() > 0 || MMInvitePhoneContactsFragment.this.mPanelTitleBar.getVisibility() == 0) {
                MMInvitePhoneContactsFragment.this.mPanelListViews.setForeground(null);
            } else {
                MMInvitePhoneContactsFragment.this.mPanelListViews.setForeground(MMInvitePhoneContactsFragment.this.mDimmedForground);
            }
        }
    };
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void Indicate_BuddyGroupsRemoved(List<String> groupIDs) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }

        @Override
        public void Indicate_BuddyGroupAdded(String groupID) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }

        @Override
        public void Indicate_BuddyGroupInfoUpdated(String groupID) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }

        @Override
        public void Indicate_BuddyGroupMembersAdded(String groupID, List<String> jidList) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }

        @Override
        public void Indicate_BuddyGroupMembersRemoved(String groupID, List<String> jidList) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }

        @Override
        public void Indicate_BuddyGroupMembersChanged(PTAppProtos.ChangedBuddyGroups changedBuddyGroups, boolean bLastPage) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }

        @Override
        public void Indicate_BuddyGroupMemberAdded(String groupName, String jid) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }

        @Override
        public void Indicate_BuddyGroupMemberRemoved(String groupName, String jid) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
            MMInvitePhoneContactsFragment.this.onIndicateInfoUpdatedWithJID(jid);
        }
    };
    private PTUI.IPhoneABListener mIPhoneABListener = new PTUI.IPhoneABListener(){

        @Override
        public void onPhoneABEvent(int event, long result, Object content) {
            MMInvitePhoneContactsFragment.this.loadZoomContactInPhoneGroup();
        }
    };

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, MMInvitePhoneContactsFragment.class.getName(), args, requestCode, true, 1);
    }

    public static void showAsActivity(Fragment fragment, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMInvitePhoneContactsFragment.class.getName(), args, requestCode, true, 1);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_invite_phone_contacts, container, false);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mPanelListViews = (FrameLayout)view.findViewById(R.id.panelListViews);
        this.mPanelSearchBarReal = view.findViewById(R.id.panelSearchBarReal);
        this.mEdtSearchReal = (EditText)view.findViewById(R.id.edtSearchReal);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelSearch = view.findViewById(R.id.panelSearch);
        this.mContactListView = (QuickSearchListView)view.findViewById(R.id.contactListView);
        this.mBtnInvite = (Button)view.findViewById(R.id.btnInvite);
        this.mAdapter = new ContactAdapter((Context)this.getActivity());
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        this.mContactListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mContactListView.setAdapter((QuickSearchListView.QuickSearchListDataAdapter)this.mAdapter);
        view.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        this.mBtnInvite.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearchReal.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearchReal.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                MMInvitePhoneContactsFragment.this.mHandler.removeCallbacks(MMInvitePhoneContactsFragment.this.mRunnableFilter);
                MMInvitePhoneContactsFragment.this.mHandler.postDelayed(MMInvitePhoneContactsFragment.this.mRunnableFilter, 300L);
                MMInvitePhoneContactsFragment.this.updateClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.compatPCModeForSearch();
        return view;
    }

    private void compatPCModeForSearch() {
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            public void onFocusChange(final View v, boolean hasFocus) {
                if (hasFocus) {
                    MMInvitePhoneContactsFragment.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (!MMInvitePhoneContactsFragment.this.isAdded() || !MMInvitePhoneContactsFragment.this.isResumed()) {
                                return;
                            }
                            int id2 = v.getId();
                            if (id2 != R.id.edtSearch) {
                                return;
                            }
                            EditText editText = (EditText)v;
                            if (editText.hasFocus()) {
                                MMInvitePhoneContactsFragment.this.onKeyboardOpen();
                            }
                        }
                    }, 500L);
                }
            }
        };
        this.mEdtSearch.setOnFocusChangeListener(onFocusChangeListener);
    }

    public void onStart() {
        super.onStart();
        this.loadZoomContactInPhoneGroup();
        this.loadContacts();
        ABContactsCache cache = ABContactsCache.getInstance();
        if (cache.needReloadAll()) {
            cache.reloadAllContacts();
        }
        cache.addListener(this);
        PTUI.getInstance().addPhoneABListener(this.mIPhoneABListener);
        ZoomMessengerUI.getInstance().addListener(this.mMessengerUIListener);
    }

    public void onStop() {
        PTUI.getInstance().removePhoneABListener(this.mIPhoneABListener);
        ABContactsCache.getInstance().removeListener(this);
        ZoomMessengerUI.getInstance().removeListener(this.mMessengerUIListener);
        super.onStop();
    }

    public void onResume() {
        super.onResume();
        this.requestContactPermission();
        this.mContactListView.onResume();
    }

    public void onPause() {
        super.onPause();
    }

    private void onIndicateInfoUpdatedWithJID(String jid) {
        IMAddrBookItem buddy = ZMBuddySyncInstance.getInsatance().getBuddyByJid(jid);
        if (buddy == null) {
            this.mZMContacts.remove(jid);
        } else {
            String number = buddy.getBuddyPhoneNumber();
            if (StringUtil.isEmptyOrNull((String)number)) {
                this.mZMContacts.remove(jid);
            } else {
                this.mZMContacts.put(jid, number);
            }
        }
        this.mAdapter.setZoomPhoneContacts(this.mZMContacts.values());
        this.mAdapter.notifyDataSetChanged();
    }

    private void loadZoomContactInPhoneGroup() {
        this.mZMContacts.clear();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddyGroup buddyGroup = messenger.getAddressbookContactBuddyGroup();
        if (buddyGroup == null || buddyGroup.getBuddyCount() == 0) {
            return;
        }
        for (int i = 0; i < buddyGroup.getBuddyCount(); ++i) {
            String number;
            ZoomBuddy buddy = buddyGroup.getBuddyAt(i);
            if (buddy == null || StringUtil.isEmptyOrNull((String)(number = buddy.getPhoneNumber()))) continue;
            this.mZMContacts.put(buddy.getJid(), number);
        }
        this.mAdapter.setZoomPhoneContacts(this.mZMContacts.values());
        this.mAdapter.notifyDataSetChanged();
    }

    private void requestContactPermission() {
        if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.READ_CONTACTS") == 0) {
            return;
        }
        this.zm_requestPermissions(new String[]{"android.permission.READ_CONTACTS"}, 100);
        AppUtil.saveRequestContactPermissionTime();
    }

    public void onRequestPermissionsResult(final int requestCode, final @NonNull String[] permissions, final @NonNull int[] grantResults) {
        EventTaskManager manager = this.getEventTaskManager();
        if (manager == null) {
            return;
        }
        manager.push(new EventAction(){

            public void run(IUIElement ui) {
                ((MMInvitePhoneContactsFragment)ui).handleContactsRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    private void handleContactsRequestPermissionResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 100: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    ABContactsCache.getInstance().reloadAllContacts();
                    break;
                }
                this.dismiss();
            }
        }
    }

    private void doFilter() {
        ArrayList<ABContactsCache.Contact> contacts = new ArrayList<ABContactsCache.Contact>();
        if (StringUtil.isEmptyOrNull((String)this.mFilterKey)) {
            contacts.addAll(this.mContacts);
        } else {
            for (ABContactsCache.Contact contact : this.mContacts) {
                if (contact == null || !contact.filter(this.mFilterKey)) continue;
                contacts.add(contact);
            }
        }
        this.mAdapter.setData(contacts);
        this.mAdapter.notifyDataSetChanged();
    }

    private void filter(String key) {
        if (key == null) {
            return;
        }
        if (StringUtil.isSameString((String)(key = key.trim().toLowerCase(CompatUtils.getLocalDefault())), (String)this.mFilterKey)) {
            return;
        }
        this.mFilterKey = key;
        this.doFilter();
    }

    private void loadContacts() {
        ABContactsCache cache = ABContactsCache.getInstance();
        int count = cache.getCachedContactsCount();
        this.mContacts.clear();
        for (int i = 0; i < count; ++i) {
            this.mContacts.add(cache.getCachedContact(i));
        }
        Collections.sort(this.mContacts, new ABContactsCache.ContactsComparator(CompatUtils.getLocalDefault()));
        this.doFilter();
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.isKeyboardOpen) {
            return;
        }
        this.isKeyboardOpen = true;
        if (this.mEdtSearch.hasFocus()) {
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelListViews.setForeground(this.mDimmedForground);
            this.mPanelSearchBarReal.setVisibility(0);
            this.mPanelSearch.setVisibility(8);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mEdtSearchReal.requestFocus();
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MMInvitePhoneContactsFragment.this.mPanelListViews.getParent().requestLayout();
                }
            });
        }
    }

    @Override
    public void onKeyboardClosed() {
        this.isKeyboardOpen = false;
        if (this.mEdtSearch == null) {
            return;
        }
        if (this.mEdtSearchReal.length() == 0 || this.mContactListView.getListView().getCount() == 0) {
            this.mPanelListViews.setForeground(null);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mPanelSearch.setVisibility(0);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MMInvitePhoneContactsFragment.this.mContactListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return this.handleBackPressed();
    }

    public boolean handleBackPressed() {
        if (this.mPanelSearchBarReal.getVisibility() == 0) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mPanelSearch.setVisibility(0);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.isKeyboardOpen = false;
            return true;
        }
        return false;
    }

    private void updateClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearchReal.getText().length() > 0 ? 0 : 8);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public void onContactsCacheUpdated() {
        this.loadContacts();
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnCancel) {
            this.dismiss();
        } else if (id2 == R.id.btnInvite) {
            this.onClickBtnInvite();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearchReal.setText((CharSequence)"");
        if (!this.isKeyboardOpen) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(8);
            this.mPanelSearch.setVisibility(0);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MMInvitePhoneContactsFragment.this.mContactListView.requestLayout();
                }
            });
        }
    }

    private void onClickBtnInvite() {
        Set<String> phoneNumbers = this.mAdapter.getCheckedPhoneNumbers();
        if (CollectionsUtil.isCollectionEmpty(phoneNumbers)) {
            return;
        }
        String[] numbers = new String[phoneNumbers.size()];
        phoneNumbers.toArray(numbers);
        List smsAppList = AndroidAppUtil.querySMSActivities((Context)this.getActivity());
        if (CollectionsUtil.isCollectionEmpty((Collection)smsAppList)) {
            return;
        }
        AndroidAppUtil.sendSMSVia((ResolveInfo)((ResolveInfo)smsAppList.get(0)), (Context)this.getActivity(), (String[])numbers, (String)this.getString(R.string.zm_msg_invite_by_sms_33300));
        this.dismiss();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object item = this.mContactListView.getItemAtPosition(position);
        if (item == null || !(item instanceof ABContactsCache.Contact)) {
            return;
        }
        ABContactsCache.Contact contact = (ABContactsCache.Contact)item;
        boolean isCheck = this.mAdapter.getCheckedPhoneNumbers().contains(contact.normalizedNumber);
        this.mAdapter.setContactChecked(contact.normalizedNumber, !isCheck);
        this.mAdapter.notifyDataSetChanged();
        this.mBtnInvite.setEnabled(!this.mAdapter.getCheckedPhoneNumbers().isEmpty());
        int size = this.mAdapter.getCheckedPhoneNumbers().size();
        String text = size == 0 ? this.getString(R.string.zm_btn_invite) : this.getString(R.string.zm_btn_invite_33300, new Object[]{size});
        this.mBtnInvite.setText((CharSequence)text);
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    static class ContactAdapter
    extends QuickSearchListView.QuickSearchListDataAdapter {
        private List<ABContactsCache.Contact> mData = new ArrayList<ABContactsCache.Contact>();
        private Context mContext;
        private Set<String> mCheckedPhoneNumbers = new HashSet<String>();
        private Set<String> mZoomPhoneContacts = new HashSet<String>();

        @NonNull
        public Set<String> getCheckedPhoneNumbers() {
            return this.mCheckedPhoneNumbers;
        }

        public ContactAdapter(Context context) {
            if (context == null) {
                throw new RuntimeException("can not init ContactAdapter with context null");
            }
            this.mContext = context;
        }

        public void setData(List<ABContactsCache.Contact> data) {
            this.mData.clear();
            if (data != null) {
                this.mData.addAll(data);
            }
        }

        public void notifyDataSetChanged() {
            for (int i = 0; i < this.mData.size(); ++i) {
                ABContactsCache.Contact contact = this.mData.get(i);
                if (!this.mZoomPhoneContacts.contains(contact.normalizedNumber)) continue;
                this.mData.remove(i);
                --i;
            }
            super.notifyDataSetChanged();
        }

        public void setZoomPhoneContacts(Collection<String> contacts) {
            this.mZoomPhoneContacts.clear();
            if (contacts != null) {
                this.mZoomPhoneContacts.addAll(contacts);
            }
        }

        public void setContactChecked(String phoneNumber, boolean isChecked) {
            if (StringUtil.isEmptyOrNull((String)phoneNumber)) {
                return;
            }
            if (isChecked) {
                this.mCheckedPhoneNumbers.add(phoneNumber);
            } else {
                this.mCheckedPhoneNumbers.remove(phoneNumber);
            }
        }

        public String getItemSortKey(Object item) {
            if (item instanceof ABContactsCache.Contact) {
                return ((ABContactsCache.Contact)item).sortKey;
            }
            return null;
        }

        public int getCount() {
            return this.mData.size();
        }

        public ABContactsCache.Contact getItem(int position) {
            if (position < 0 || position >= this.mData.size()) {
                return null;
            }
            return this.mData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_phone_contact_item, null);
            }
            TextView name = (TextView)convertView.findViewById(R.id.txtContactName);
            TextView number = (TextView)convertView.findViewById(R.id.txtContactNumber);
            TextView inZoom = (TextView)convertView.findViewById(R.id.txtInZoom);
            CheckedTextView checked = (CheckedTextView)convertView.findViewById(R.id.checked);
            ABContactsCache.Contact contact = this.getItem(position);
            if (contact == null) {
                return convertView;
            }
            name.setText((CharSequence)contact.displayName);
            number.setText((CharSequence)contact.normalizedNumber);
            inZoom.setVisibility(8);
            checked.setVisibility(0);
            checked.setChecked(this.mCheckedPhoneNumbers != null && this.mCheckedPhoneNumbers.contains(contact.normalizedNumber));
            return convertView;
        }
    }
}

