/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAQuestion;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ZMQAAskDialog
extends ZMDialogFragment
implements View.OnClickListener {
    private static final String TAG = ZMQAAskDialog.class.getSimpleName();
    private TextView mBtnSend;
    private EditText mEdtQuestion;
    private View mOptionAnonymously;
    private CheckBox mChkAnonymously;
    private View mTxtAnonymously;
    private String mQuestionId;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private ConfUI.IConfUIListener mConfUIListener;
    private long mLastClickSendTime = 0L;
    private static String mLastAskQuestion;
    private Handler mHandler = new Handler();
    private Runnable mShowKeyboardRunnable = new Runnable(){

        @Override
        public void run() {
            if (ZMQAAskDialog.this.mEdtQuestion != null) {
                ZMQAAskDialog.this.mEdtQuestion.requestFocus();
                UIUtil.openSoftKeyboard((Context)ZMQAAskDialog.this.getActivity(), (View)ZMQAAskDialog.this.mEdtQuestion);
            }
        }
    };

    public static void show(ZMActivity activity) {
        if (activity != null && activity.isActive()) {
            new ZMQAAskDialog().show(activity.getSupportFragmentManager(), ZMQAAskDialog.class.getName());
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View view = this.createContent(savedInstanceState);
        if (view == null) {
            return this.createEmptyDialog();
        }
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTheme(R.style.ZMDialog_Material_RoundRect).setView(view, true);
        ZMAlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this.mEdtQuestion);
    }

    private View createContent(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mQuestionId = savedInstanceState.getString("mQuestionId");
        }
        ContextThemeWrapper context = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material_RoundRect);
        View view = View.inflate((Context)context, (int)R.layout.zm_dialog_qa_ask, null);
        view.findViewById(R.id.imgClose).setOnClickListener((View.OnClickListener)this);
        this.mEdtQuestion = (EditText)view.findViewById(R.id.edtQuestion);
        this.mBtnSend = (TextView)view.findViewById(R.id.btnSend);
        this.mBtnSend.setOnClickListener((View.OnClickListener)this);
        this.mOptionAnonymously = view.findViewById(R.id.optionAnonymously);
        this.mChkAnonymously = (CheckBox)view.findViewById(R.id.chkAnonymously);
        this.mTxtAnonymously = view.findViewById(R.id.txtAnonymously);
        this.mOptionAnonymously.setOnClickListener((View.OnClickListener)this);
        this.mChkAnonymously.setEnabled(ConfMgr.getInstance().isAllowAskQuestionAnonymously());
        this.mEdtQuestion.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 4) {
                    ZMQAAskDialog.this.onClickBtnSend();
                }
                return false;
            }
        });
        this.mEdtQuestion.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                mLastAskQuestion = ZMQAAskDialog.this.mEdtQuestion.getEditableText().toString();
                ZMQAAskDialog.this.mBtnSend.setEnabled(mLastAskQuestion.length() != 0);
            }
        });
        if (!StringUtil.isEmptyOrNull((String)mLastAskQuestion) && !StringUtil.isEmptyOrNull((String)mLastAskQuestion)) {
            this.mEdtQuestion.setText((CharSequence)mLastAskQuestion);
            this.mEdtQuestion.setSelection(mLastAskQuestion.length());
            this.mBtnSend.setEnabled(true);
        }
        return view;
    }

    public void onPause() {
        super.onPause();
        this.mHandler.removeCallbacks(this.mShowKeyboardRunnable);
        ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    return ZMQAAskDialog.this.onConfStatusChanged2(cmd, ret);
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onAddQuestion(String questionID, boolean bSuccess) {
                    ZMQAAskDialog.this.onAddQuestion(questionID, bSuccess);
                }

                @Override
                public void notifyConnectResult(boolean bConnectSuccess) {
                    ZMQAAskDialog.this.notifyConnectResult(bConnectSuccess);
                }

                @Override
                public void onQuestionMarkedAsDismissed(String question_id) {
                    if (StringUtil.isSameStringForNotAllowNull((String)question_id, (String)ZMQAAskDialog.this.mQuestionId)) {
                        ZMQAAskDialog.this.onClickBtnBack();
                    }
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        this.updateData();
        if (UIUtil.isPortraitMode((Context)this.getContext())) {
            this.mHandler.postDelayed(this.mShowKeyboardRunnable, 100L);
        }
    }

    private boolean onConfStatusChanged2(int cmd, long ret) {
        if (cmd == 30) {
            this.onQAAnonymouslyStatusChanged();
        }
        return true;
    }

    private void updateData() {
        if (!StringUtil.isEmptyOrNull((String)this.mQuestionId)) {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            if (qacomponent == null) {
                return;
            }
            ZoomQAQuestion question = qacomponent.getQuestionByID(this.mQuestionId);
            if (question != null) {
                this.updateQuestionState(question.getState());
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("mQuestionId", this.mQuestionId);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.imgClose) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSend) {
            this.onClickBtnSend();
        } else if (id2 == R.id.optionAnonymously) {
            this.onClickCheckAnonymously();
        }
    }

    public void onQAAnonymouslyStatusChanged() {
        boolean enableAnonymously = ConfMgr.getInstance().isAllowAskQuestionAnonymously();
        if (enableAnonymously) {
            this.mTxtAnonymously.setEnabled(true);
            this.mChkAnonymously.setEnabled(true);
            this.mOptionAnonymously.setEnabled(true);
        } else {
            this.mChkAnonymously.setChecked(false);
            this.mTxtAnonymously.setEnabled(false);
            this.mChkAnonymously.setEnabled(false);
            this.mOptionAnonymously.setEnabled(false);
        }
    }

    private void onClickBtnSend() {
        long curTime = System.currentTimeMillis();
        long delta = curTime - this.mLastClickSendTime;
        if (delta > 0L && delta < 1000L) {
            return;
        }
        this.mLastClickSendTime = curTime;
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtQuestion);
        String question = this.mEdtQuestion.getText().toString().trim();
        if (question.length() == 0) {
            return;
        }
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return;
        }
        this.mQuestionId = qacomponent.addQuestion(question, null, this.mChkAnonymously.isChecked());
        if (StringUtil.isEmptyOrNull((String)this.mQuestionId)) {
            this.showSendFailedMessage();
        } else {
            this.showWaitingDialog();
        }
    }

    private void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        fm.executePendingTransactions();
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        }
    }

    private void onClickCheckAnonymously() {
        if (ConfMgr.getInstance().isAllowAskQuestionAnonymously()) {
            this.mChkAnonymously.setChecked(!this.mChkAnonymously.isChecked());
        }
    }

    private void onAddQuestion(String questionID, boolean bSuccess) {
        if (StringUtil.isSameString((String)questionID, (String)this.mQuestionId)) {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            if (qacomponent == null) {
                return;
            }
            ZoomQAQuestion question = qacomponent.getQuestionByID(this.mQuestionId);
            this.updateQuestionState(question.getState());
        }
    }

    private void updateQuestionState(int state) {
        switch (state) {
            case 1: {
                mLastAskQuestion = null;
                this.dismissWaitingDialog();
                this.dismiss();
                break;
            }
            case 3: {
                this.dismissWaitingDialog();
                this.showSendFailedMessage();
            }
        }
    }

    private void onClickBtnBack() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtQuestion);
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private void notifyConnectResult(boolean bConnectSuccess) {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null && qacomponent.isStreamConflict()) {
            this.dismiss();
        }
    }

    private void showSendFailedMessage() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_qa_msg_send_question_failed, (int)1).show();
    }
}

