/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa;

import android.content.Context;
import android.support.annotation.NonNull;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.qa.ZoomQAAnswer;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAQuestion;
import com.zipow.videobox.fragment.meeting.qa.ZMQuestionsMode;
import com.zipow.videobox.fragment.meeting.qa.model.BaseQAMultiItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQAAttendeeActionItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQADividerItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQALiveAnswerItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQAPanelistActionItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQAPanelistExpandCollapseItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQAQuestionItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQATextAnswerItemEntity;
import com.zipow.videobox.fragment.meeting.qa.model.ZMQAWaitingLiveAnswerItemEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ZMQAHelper {
    public static final int MAX_SHOW_FEEDBACK_COUNT = 2;

    public static int getTabWidth(Context context, int tabCount) {
        int tabWidth = (int)(UIUtil.getDisplayMinWidthInDip((Context)context) / (float)tabCount);
        return tabWidth - tabWidth / (tabCount * tabCount);
    }

    public static List<BaseQAMultiItemEntity> getZoomQuestionsForAttendee(int questionsMode, @NonNull HashMap<String, String> expandItemIds) {
        ArrayList<BaseQAMultiItemEntity> baseAttendeeQAMultiItemEntries;
        block4: {
            ZoomQAComponent qacomponent;
            block3: {
                qacomponent = ConfMgr.getInstance().getQAComponent();
                if (qacomponent == null) {
                    return null;
                }
                baseAttendeeQAMultiItemEntries = new ArrayList<BaseQAMultiItemEntity>();
                if (questionsMode != ZMQuestionsMode.MODE_ATTENDEE_ALL_QUESTIONS.ordinal()) break block3;
                int count = qacomponent.getQuestionCount();
                for (int i = 0; i < count; ++i) {
                    int state;
                    ZoomQAQuestion question = qacomponent.getQuestionAt(i);
                    if (question == null || (state = question.getState()) == 3 || state == 4) continue;
                    String itemId = question.getItemID();
                    ZMQAHelper.splitQuestionIntoListItemsForAttendee(baseAttendeeQAMultiItemEntries, question, itemId != null && expandItemIds.containsKey(itemId), i != count - 1);
                }
                break block4;
            }
            if (questionsMode != ZMQuestionsMode.MODE_ATTENDEE_MY_QUESTIONS.ordinal()) break block4;
            int count = qacomponent.getMyQuestionCount();
            for (int i = 0; i < count; ++i) {
                int state;
                ZoomQAQuestion question = qacomponent.getMyQuestionAt(i);
                if (question == null || (state = question.getState()) == 3 || state == 4) continue;
                String itemId = question.getItemID();
                ZMQAHelper.splitQuestionIntoListItemsForAttendee(baseAttendeeQAMultiItemEntries, question, itemId != null && expandItemIds.containsKey(itemId), i != count - 1);
            }
        }
        return baseAttendeeQAMultiItemEntries;
    }

    public static List<BaseQAMultiItemEntity> getZoomQuestionsForPanelist(int questionsMode, @NonNull HashMap<String, String> expandItemIds) {
        ArrayList<BaseQAMultiItemEntity> baseAttendeeQAMultiItemEntries;
        block5: {
            ZoomQAComponent qacomponent;
            block6: {
                block4: {
                    qacomponent = ConfMgr.getInstance().getQAComponent();
                    if (qacomponent == null) {
                        return null;
                    }
                    baseAttendeeQAMultiItemEntries = new ArrayList<BaseQAMultiItemEntity>();
                    if (questionsMode != ZMQuestionsMode.MODE_OPEN_QUESTIONS.ordinal()) break block4;
                    int count = qacomponent.getOpenQuestionCount();
                    for (int i = 0; i < count; ++i) {
                        int state;
                        ZoomQAQuestion question = qacomponent.getOpenQuestionAt(i);
                        if (question == null || (state = question.getState()) == 3 || state == 4) continue;
                        String itemId = question.getItemID();
                        ZMQAHelper.splitQuestionIntoListItemsForPanelist(baseAttendeeQAMultiItemEntries, question, itemId != null && expandItemIds.containsKey(itemId), i != count - 1, false);
                    }
                    break block5;
                }
                if (questionsMode != ZMQuestionsMode.MODE_ANSWERED_QUESTIONS.ordinal()) break block6;
                int count = qacomponent.getAnsweredQuestionCount();
                for (int i = 0; i < count; ++i) {
                    int state;
                    ZoomQAQuestion question = qacomponent.getAnsweredQuestionAt(i);
                    if (question == null || (state = question.getState()) == 3 || state == 4) continue;
                    String itemId = question.getItemID();
                    ZMQAHelper.splitQuestionIntoListItemsForPanelist(baseAttendeeQAMultiItemEntries, question, itemId != null && expandItemIds.containsKey(itemId), i != count - 1, false);
                }
                break block5;
            }
            if (questionsMode != ZMQuestionsMode.MODE_DISMISSED_QUESTIONS.ordinal()) break block5;
            int count = qacomponent.getDismissedQuestionCount();
            for (int i = 0; i < count; ++i) {
                int state;
                ZoomQAQuestion question = qacomponent.getDismissedQuestionAt(i);
                if (question == null || (state = question.getState()) == 3 || state == 4) continue;
                String itemId = question.getItemID();
                ZMQAHelper.splitQuestionIntoListItemsForPanelist(baseAttendeeQAMultiItemEntries, question, itemId != null && expandItemIds.containsKey(itemId), i != count - 1, true);
            }
        }
        return baseAttendeeQAMultiItemEntries;
    }

    private static void splitQuestionIntoListItemsForAttendee(@NonNull List<BaseQAMultiItemEntity> baseAttendeeQAMultiItemEntries, @NonNull ZoomQAQuestion question, boolean isExpanded, boolean showDivider) {
        int count;
        BaseQAMultiItemEntity attendeeQAMultiItemEntry = new ZMQAQuestionItemEntity(question.getItemID(), question);
        baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        boolean isDismissed = question.isMarkedAsDismissed();
        if (ZMQAHelper.isShouldShowLiveAnswerItemForPanelist(question)) {
            attendeeQAMultiItemEntry = new ZMQALiveAnswerItemEntity(question.getItemID(), question);
            baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        }
        if ((count = question.getAnswerCount()) > 0) {
            boolean isShowFeedback = false;
            int textAnswerCount = 0;
            for (int i = 0; i < count; ++i) {
                ZoomQAAnswer answer = question.getAnswerAt(i);
                if (answer == null || answer.isLiveAnswer()) continue;
                if (++textAnswerCount > 2) {
                    isShowFeedback = true;
                    if (!isExpanded) continue;
                }
                attendeeQAMultiItemEntry = new ZMQATextAnswerItemEntity(question.getItemID(), question, i);
                baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
            }
            if (isShowFeedback || ZMQAHelper.isAttendeeCanComment() && !isDismissed) {
                attendeeQAMultiItemEntry = new ZMQAAttendeeActionItemEntity(question.getItemID(), question, isShowFeedback, textAnswerCount);
                baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
            }
        } else if (ZMQAHelper.isAttendeeCanComment() && !isDismissed) {
            attendeeQAMultiItemEntry = new ZMQAAttendeeActionItemEntity(question.getItemID(), question, false, 1);
            baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        }
        if (showDivider) {
            attendeeQAMultiItemEntry = new ZMQADividerItemEntity(question.getItemID(), question);
            baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        }
    }

    private static void splitQuestionIntoListItemsForPanelist(@NonNull List<BaseQAMultiItemEntity> baseAttendeeQAMultiItemEntries, @NonNull ZoomQAQuestion question, boolean isExpanded, boolean showDivider, boolean isDismissed) {
        BaseQAMultiItemEntity attendeeQAMultiItemEntry = new ZMQAQuestionItemEntity(question.getItemID(), question);
        baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        if (ZMQAHelper.isShouldShowLiveAnswerItemForPanelist(question)) {
            attendeeQAMultiItemEntry = new ZMQALiveAnswerItemEntity(question.getItemID(), question);
            baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        }
        int count = question.getAnswerCount();
        boolean isShowFeedback = false;
        int textAnswerCount = 0;
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                ZoomQAAnswer answer = question.getAnswerAt(i);
                if (answer == null || answer.isLiveAnswer()) continue;
                if (++textAnswerCount > 2) {
                    isShowFeedback = true;
                    if (!isExpanded) continue;
                }
                attendeeQAMultiItemEntry = new ZMQATextAnswerItemEntity(question.getItemID(), question, i);
                baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
            }
        }
        if (isShowFeedback) {
            attendeeQAMultiItemEntry = new ZMQAPanelistExpandCollapseItemEntity(question.getItemID(), question, textAnswerCount);
            baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        }
        if (ZMQAHelper.isShouldShowLiveAnsweringForPanelist(question) && !isDismissed) {
            attendeeQAMultiItemEntry = new ZMQAWaitingLiveAnswerItemEntity(question.getItemID(), question);
            baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        } else if (!isDismissed) {
            attendeeQAMultiItemEntry = new ZMQAPanelistActionItemEntity(question.getItemID(), question);
            baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        }
        if (showDivider) {
            attendeeQAMultiItemEntry = new ZMQADividerItemEntity(question.getItemID(), question);
            baseAttendeeQAMultiItemEntries.add(attendeeQAMultiItemEntry);
        }
    }

    public static boolean isShouldShowLiveAnsweringForPanelist(@NonNull ZoomQAQuestion question) {
        return !question.hasLiveAnswers() && question.amILiveAnswering();
    }

    public static boolean isShouldShowLiveAnswerItemForPanelist(@NonNull ZoomQAQuestion question) {
        return question.hasLiveAnswers() || !question.amILiveAnswering() && question.getLiveAnsweringCount() > 0 || question.amILiveAnswering() && question.getLiveAnsweringCount() > 1;
    }

    public static boolean isShouldHideLiveAnswerButtonForPanelist(@NonNull ZoomQAQuestion question) {
        return question.hasTextAnswers() && question.isMarkedAsAnswered() || question.hasLiveAnswers() || question.getLiveAnsweringCount() > 0;
    }

    public static boolean isAttendeeCanUpvote() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return false;
        }
        return confMgr.isAllowAttendeeViewAllQuestion() && confMgr.isAllowAttendeeUpvoteQuestion();
    }

    public static boolean isAttendeeCanComment() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return false;
        }
        return confMgr.isAllowAttendeeViewAllQuestion() && confMgr.isAllowAttendeeAnswerQuestion();
    }

    public static boolean isQuestionSent(String questionId) {
        if (!StringUtil.isEmptyOrNull((String)questionId)) {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            if (qacomponent == null) {
                return false;
            }
            ZoomQAQuestion question = qacomponent.getQuestionByID(questionId);
            return question != null && question.getState() == 1;
        }
        return false;
    }

    public static boolean isAnswerSent(String answerId) {
        if (!StringUtil.isEmptyOrNull((String)answerId)) {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            if (qacomponent == null) {
                return false;
            }
            ZoomQAAnswer answer = qacomponent.getAnswerByID(answerId);
            return answer != null && answer.getState() == 1;
        }
        return false;
    }

    public static int getQustionCount(int questionMode) {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return 0;
        }
        if (questionMode == ZMQuestionsMode.MODE_ATTENDEE_ALL_QUESTIONS.ordinal()) {
            return qacomponent.getQuestionCount();
        }
        if (questionMode == ZMQuestionsMode.MODE_ATTENDEE_MY_QUESTIONS.ordinal()) {
            return qacomponent.getMyQuestionCount();
        }
        if (questionMode == ZMQuestionsMode.MODE_OPEN_QUESTIONS.ordinal()) {
            return qacomponent.getOpenQuestionCount();
        }
        if (questionMode == ZMQuestionsMode.MODE_ANSWERED_QUESTIONS.ordinal()) {
            return qacomponent.getAnsweredQuestionCount();
        }
        if (questionMode == ZMQuestionsMode.MODE_DISMISSED_QUESTIONS.ordinal()) {
            return qacomponent.getDismissedQuestionCount();
        }
        return qacomponent.getQuestionCount();
    }

    public static String getLiveAnsweringNames(@NonNull Context context, @NonNull ZoomQAQuestion question) {
        int count;
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return null;
        }
        StringBuffer suffix = new StringBuffer();
        if (question.amILiveAnswering()) {
            suffix.append(context.getString(R.string.zm_lbl_content_you));
        }
        if ((count = question.getLiveAnsweringCount()) > 0) {
            for (int i = 0; i < count; ++i) {
                String name;
                String jid = question.getLiveAnsweringJIDAt(i);
                if (qacomponent.isJIDMyself(jid) || StringUtil.isEmptyOrNull((String)(name = qacomponent.getUserNameByJID(jid)))) continue;
                if (suffix.length() > 0) {
                    suffix.append(",");
                }
                suffix.append(name);
            }
        }
        return suffix.toString();
    }
}

