/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting.qa;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.fragment.meeting.qa.ZMQAAttendeeTabFragment;
import com.zipow.videobox.fragment.meeting.qa.ZMQAHelper;
import com.zipow.videobox.fragment.meeting.qa.ZMQuestionsMode;
import com.zipow.videobox.fragment.meeting.qa.dialog.ZMQAAskDialog;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMViewPager;
import us.zoom.androidlib.widget.segement.OnTabSelectListener;
import us.zoom.androidlib.widget.segement.ZMSegmentTabLayout;
import us.zoom.videomeetings.R;

public class ZMQAAttendeeViewerFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final String TAG = ZMQAAttendeeViewerFragment.class.getSimpleName();
    private static int[] TITLE_IDS = new int[]{R.string.zm_qa_tab_all_question_41047, R.string.zm_qa_tab_my_question_41047};
    private static int[] NO_ITEM_TXT_MSG = new int[]{R.string.zm_qa_msg_no_question, R.string.zm_qa_msg_no_question};
    private View llContent;
    private ZMViewPager mZMViewPager;
    private TabViewPagerAdapter mTabViewPagerAdapter;
    private ZMSegmentTabLayout mZMSegmentTabLayout;
    private View mPanelNoItemMsg;
    private TextView mTxtNoTitle;
    private TextView mTxtNoItemMsg;
    private View mBtnAsk;
    private View mBtnBack;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, ZMQAAttendeeViewerFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_qa_attendee_viewer, container, false);
        this.llContent = view.findViewById(R.id.llContent);
        this.mZMSegmentTabLayout = (ZMSegmentTabLayout)view.findViewById(R.id.zmSegmentTabLayout);
        this.mZMSegmentTabLayout.setTabWidth((float)ZMQAHelper.getTabWidth(this.getContext(), TITLE_IDS.length));
        this.mZMViewPager = (ZMViewPager)view.findViewById(R.id.viewPager);
        this.mZMViewPager.setDisableScroll(true);
        this.mTabViewPagerAdapter = new TabViewPagerAdapter(this.getChildFragmentManager());
        this.mZMViewPager.setAdapter((PagerAdapter)this.mTabViewPagerAdapter);
        this.mZMSegmentTabLayout.setTabData(this.getTabTitles());
        this.mZMSegmentTabLayout.setOnTabSelectListener(new OnTabSelectListener(){

            public void onTabSelect(int position) {
                ZMQAAttendeeViewerFragment.this.mZMViewPager.setCurrentItem(position);
            }

            public void onTabReselect(int position) {
            }
        });
        this.mBtnAsk = view.findViewById(R.id.btnAsk);
        this.mBtnBack = view.findViewById(R.id.btnBack);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        this.mTxtNoTitle = (TextView)view.findViewById(R.id.txtNoMessageTitle);
        this.mTxtNoItemMsg = (TextView)view.findViewById(R.id.txtNoItemMsg);
        this.mBtnAsk.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onPause() {
        super.onPause();
        ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onRefreshQAUI() {
                    ZMQAAttendeeViewerFragment.this.updateData();
                }

                @Override
                public void onReceiveQuestion(String questionID) {
                    ZMQAAttendeeViewerFragment.this.updateData();
                }

                @Override
                public void onAddQuestion(String questionID, boolean bSuccess) {
                    if (ZMQAHelper.isQuestionSent(questionID)) {
                        ZMQAAttendeeViewerFragment.this.updateData();
                    }
                }

                @Override
                public void onReceiveAnswer(String answerID) {
                    ZMQAAttendeeViewerFragment.this.updateData();
                }

                @Override
                public void notifyConnectResult(boolean bConnectSuccess) {
                    ZMQAAttendeeViewerFragment.this.updateData();
                }

                @Override
                public void onQuestionMarkedAsDismissed(String question_id) {
                    ZMQAAttendeeViewerFragment.this.updateData();
                }

                @Override
                public void onReopenQuestion(String question_id) {
                    ZMQAAttendeeViewerFragment.this.updateData();
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        this.updateData();
    }

    private void updateData() {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null && qacomponent.isStreamConflict()) {
            this.llContent.setVisibility(8);
            this.mPanelNoItemMsg.setVisibility(0);
            this.mTxtNoTitle.setVisibility(8);
            this.mTxtNoItemMsg.setText(R.string.zm_qa_msg_stream_conflict);
            this.mBtnAsk.setVisibility(8);
        } else {
            this.mBtnAsk.setVisibility(0);
            int count = qacomponent.getQuestionCount();
            if (qacomponent.getQuestionCount() > 0) {
                this.llContent.setVisibility(0);
                this.mPanelNoItemMsg.setVisibility(8);
            } else {
                this.llContent.setVisibility(8);
                this.mPanelNoItemMsg.setVisibility(0);
                this.mTxtNoTitle.setVisibility(0);
                this.mTxtNoItemMsg.setText(R.string.zm_qa_msg_no_question_41047);
            }
            this.mZMSegmentTabLayout.updateTabData(this.getTabTitles());
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mBtnAsk) {
            this.onClickBtnAsk();
        }
    }

    private void onClickBtnAsk() {
        ZMQAAskDialog.show((ZMActivity)this.getActivity());
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private String[] getTabTitles() {
        String[] titles = new String[TITLE_IDS.length];
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null) {
            int count = 0;
            for (int i = 0; i < TITLE_IDS.length; ++i) {
                if (i == 0) {
                    count = qacomponent.getQuestionCount();
                } else if (i == 1) {
                    count = qacomponent.getMyQuestionCount();
                }
                titles[i] = count == 0 ? this.getString(TITLE_IDS[i]) : this.getString(TITLE_IDS[i]) + "(" + (count > 99 ? "99+" : String.valueOf(count)) + ")";
            }
        } else {
            for (int i = 0; i < TITLE_IDS.length; ++i) {
                titles[i] = this.getString(TITLE_IDS[i]);
            }
        }
        return titles;
    }

    static class TabViewPagerAdapter
    extends FragmentPagerAdapter {
        private List<Fragment> mCacheFragments = new ArrayList<Fragment>();

        public TabViewPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public int getCount() {
            return TITLE_IDS.length;
        }

        public Fragment getItem(int position) {
            if (position < this.mCacheFragments.size()) {
                return this.mCacheFragments.get(position);
            }
            ZMQAAttendeeTabFragment fragment = null;
            if (position == 0) {
                fragment = ZMQAAttendeeTabFragment.newInstance(ZMQuestionsMode.MODE_ATTENDEE_ALL_QUESTIONS.ordinal());
            } else if (position == 1) {
                fragment = ZMQAAttendeeTabFragment.newInstance(ZMQuestionsMode.MODE_ATTENDEE_MY_QUESTIONS.ordinal());
            }
            if (fragment != null) {
                this.mCacheFragments.add(fragment);
            }
            return fragment;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            super.destroyItem(container, position, object);
            if (position < this.mCacheFragments.size()) {
                this.mCacheFragments.remove(position);
            }
        }
    }
}

