/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment.meeting;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.widget.Toast;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.meeting.PromoteOrDowngradeItem;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class PromoteOrDowngradeMockFragment {
    private static final String KEY_PENDING_ATTENDEE = "pending_item";
    private static final String KEY_CURRENT_ATTENDEE = "current_item";
    private PromoteOrDowngradeItem mCurPromoteOrDowngradeItem;
    private PromoteOrDowngradeItem mPendingPromoteOrDowngradeItem;
    private final Fragment mZMFragment;

    public PromoteOrDowngradeMockFragment(Fragment zmFragment) {
        this.mZMFragment = zmFragment;
    }

    public void onCreateView(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mCurPromoteOrDowngradeItem = (PromoteOrDowngradeItem)savedInstanceState.getSerializable(KEY_CURRENT_ATTENDEE);
            this.mPendingPromoteOrDowngradeItem = (PromoteOrDowngradeItem)savedInstanceState.getSerializable(KEY_PENDING_ATTENDEE);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.putSerializable(KEY_CURRENT_ATTENDEE, (Serializable)this.mCurPromoteOrDowngradeItem);
            outState.putSerializable(PromoteOrDowngradeItem.class.getName(), (Serializable)this.mPendingPromoteOrDowngradeItem);
        }
    }

    public void promoteOrDowngrade(PromoteOrDowngradeItem attendeeItem) {
        boolean isPromote;
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isConfLocked()) {
            this.confirmToUnlockMeeting(attendeeItem);
            return;
        }
        boolean bl = isPromote = attendeeItem.getmAction() == 1;
        if (isPromote ? ConfMgr.getInstance().promotePanelist(attendeeItem.getmJid()) : ConfMgr.getInstance().downgradeToAttendee(attendeeItem.getmJid())) {
            this.mCurPromoteOrDowngradeItem = (PromoteOrDowngradeItem)attendeeItem.clone();
            this.showWaitingDialog();
        }
    }

    public long getCurUserId() {
        if (this.mCurPromoteOrDowngradeItem == null) {
            return -1L;
        }
        return this.mCurPromoteOrDowngradeItem.getmUserId();
    }

    private void showWaitingDialog() {
        if (this.mZMFragment == null) {
            return;
        }
        FragmentManager fm = this.mZMFragment.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "FreshWaitingDialog");
    }

    private void dismissWaitingDialog() {
        if (this.mZMFragment == null) {
            return;
        }
        FragmentManager fm = this.mZMFragment.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("FreshWaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        }
    }

    public void onPromotePanelistResult(int error) {
        this.dismissWaitingDialog();
        if (error != 0) {
            this.showErrorPromotePanelistMessage(error);
        } else if (this.mCurPromoteOrDowngradeItem != null && !StringUtil.isEmptyOrNull((String)this.mCurPromoteOrDowngradeItem.getmJid())) {
            this.showRejoinMessage(this.mCurPromoteOrDowngradeItem);
        }
        this.mCurPromoteOrDowngradeItem = null;
    }

    public void onDePromotePanelist(int res) {
        this.dismissWaitingDialog();
        if (res != 0) {
            this.showErrorDePromotePanelistMessage(res);
        } else if (this.mCurPromoteOrDowngradeItem != null) {
            this.showRejoinMessage(this.mCurPromoteOrDowngradeItem);
        }
        this.mCurPromoteOrDowngradeItem = null;
    }

    public void onConfLockStatusChanged() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && !confStatus.isConfLocked()) {
            this.checkContinuePromoteOrDePromote();
        }
    }

    private void showErrorPromotePanelistMessage(int error) {
        String message;
        if (this.mZMFragment == null) {
            return;
        }
        FragmentActivity context = this.mZMFragment.getActivity();
        if (context == null) {
            return;
        }
        switch (error) {
            case 3035: {
                int limit = 0;
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext != null) {
                    limit = confContext.getParticipantLimit();
                }
                message = context.getString(R.string.zm_webinar_msg_failed_to_promote_max_panelists, new Object[]{limit});
                break;
            }
            default: {
                message = context.getString(R.string.zm_webinar_msg_failed_to_promote_panelist, new Object[]{error});
            }
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)context).setTitle(message).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    private void showErrorDePromotePanelistMessage(int error) {
        if (this.mZMFragment == null) {
            return;
        }
        FragmentActivity context = this.mZMFragment.getActivity();
        if (context == null) {
            return;
        }
        String message = context.getString(R.string.zm_webinar_msg_failed_to_downgrade_to_attendee, new Object[]{error});
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)context).setTitle(message).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    private void unlockMeeting(PromoteOrDowngradeItem item) {
        this.mPendingPromoteOrDowngradeItem = item;
        ConfMgr.getInstance().handleConfCmd(57);
    }

    private void checkContinuePromoteOrDePromote() {
        if (this.mPendingPromoteOrDowngradeItem != null) {
            this.promoteOrDowngrade(this.mPendingPromoteOrDowngradeItem);
            this.mPendingPromoteOrDowngradeItem = null;
        }
    }

    private void confirmToUnlockMeeting(final PromoteOrDowngradeItem item) {
        if (this.mZMFragment == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.mZMFragment.getActivity();
        if (activity == null) {
            return;
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_webinar_msg_change_role_on_meeting_locked).setPositiveButton(R.string.zm_mi_unlock_meeting, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PromoteOrDowngradeMockFragment.this.unlockMeeting(item);
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.show();
    }

    private void showRejoinMessage(PromoteOrDowngradeItem promoteOrDowngradeItem) {
        if (promoteOrDowngradeItem == null || promoteOrDowngradeItem.getmName() == null) {
            return;
        }
        if (this.mZMFragment == null) {
            return;
        }
        FragmentActivity context = this.mZMFragment.getActivity();
        if (context == null) {
            return;
        }
        String message = context.getString(promoteOrDowngradeItem.getmAction() == 1 ? R.string.zm_webinar_msg_user_will_rejoin_as_panelist : R.string.zm_webinar_msg_user_will_rejoin_as_attendee, new Object[]{promoteOrDowngradeItem.getmName()});
        Toast.makeText((Context)context, (CharSequence)message, (int)1).show();
    }
}

