/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ZMErrorMessageDialog
extends ZMDialogFragment {
    private static String ARGS_DIALOG_TITLE = "args_dialog_title";
    private static String ARGS_DIALOG_MESSAGE = "args_dialog_message";
    private ErrorMessageAdapter mAdapter;

    public static void show(FragmentManager fragmentMgr, String title, ArrayList<String> messages, String tag) {
        if (fragmentMgr == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putString(ARGS_DIALOG_TITLE, title);
        args.putStringArrayList(ARGS_DIALOG_MESSAGE, messages);
        ZMErrorMessageDialog dlg = new ZMErrorMessageDialog();
        dlg.setArguments(args);
        if (StringUtil.isEmptyOrNull((String)tag)) {
            dlg.show(fragmentMgr, ZMErrorMessageDialog.class.getName());
        } else {
            dlg.show(fragmentMgr, tag);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View messageView = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_error_message_listview, null, false);
        ListView list = (ListView)messageView.findViewById(R.id.messageList);
        Bundle bundle = this.getArguments();
        String title = bundle.getString(ARGS_DIALOG_TITLE);
        ArrayList messages = bundle.getStringArrayList(ARGS_DIALOG_MESSAGE);
        this.mAdapter = new ErrorMessageAdapter((Context)this.getActivity(), messages);
        list.setAdapter((ListAdapter)this.mAdapter);
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setView(messageView).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        return builder.create();
    }

    public void onResume() {
        super.onResume();
        this.mAdapter.notifyDataSetChanged();
    }

    public class ErrorMessageAdapter
    extends BaseAdapter {
        private Context mContext;
        private ArrayList<String> mMessages = new ArrayList();

        public ErrorMessageAdapter(Context context, ArrayList<String> messages) {
            this.mContext = context;
            this.mMessages.addAll(messages);
        }

        public int getCount() {
            return this.mMessages.size();
        }

        public Object getItem(int position) {
            if (position >= this.getCount()) {
                return null;
            }
            return this.mMessages.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object obj = this.getItem(position);
            if (obj == null) {
                return null;
            }
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            if (inflater == null) {
                return null;
            }
            View view = null;
            if (convertView != null && "errorMessageItem".equals(convertView.getTag())) {
                view = convertView;
            } else {
                view = inflater.inflate(R.layout.zm_error_message_item, parent, false);
                view.setTag((Object)"errorMessageItem");
            }
            TextView messageView = (TextView)view.findViewById(R.id.message);
            String message = (String)obj;
            messageView.setText((CharSequence)(this.mContext.getString(R.string.zm_big_dot) + " " + message));
            return view;
        }
    }
}

