/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class WebinarRegisterDialog
extends ZMDialogFragment
implements TextWatcher,
TextView.OnEditorActionListener {
    private static final String ARG_SCREEN_NAME = "screenName";
    private static final String ARG_EMAIL = "email";
    private static final String ARG_INSTRUCTION = "instruction";
    private EditText mEdtScreenName = null;
    private EditText mEdtEmail = null;
    private Button mBtnOK = null;
    private TextView mInstruction;

    public static void show(FragmentManager fm, String defName, String defEmail, int instruction) {
        WebinarRegisterDialog dialog = new WebinarRegisterDialog();
        Bundle args = new Bundle();
        args.putString(ARG_SCREEN_NAME, defName);
        args.putString(ARG_EMAIL, defEmail);
        args.putInt(ARG_INSTRUCTION, instruction);
        dialog.setArguments(args);
        dialog.show(fm, WebinarRegisterDialog.class.getName());
    }

    public WebinarRegisterDialog() {
        this.setCancelable(true);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_webinar_register, null, false);
        this.mInstruction = (TextView)view.findViewById(R.id.txtInstructions);
        this.mEdtScreenName = (EditText)view.findViewById(R.id.edtScreenName);
        this.mEdtEmail = (EditText)view.findViewById(R.id.edtEmail);
        this.mEdtEmail.setImeOptions(2);
        this.mEdtEmail.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mEdtScreenName.addTextChangedListener((TextWatcher)this);
        this.mEdtEmail.addTextChangedListener((TextWatcher)this);
        String screenName = null;
        String email = null;
        int instruction = 0;
        Bundle args = this.getArguments();
        if (args != null) {
            screenName = args.getString(ARG_SCREEN_NAME);
            email = args.getString(ARG_EMAIL);
            instruction = args.getInt(ARG_INSTRUCTION);
        }
        if (savedInstanceState == null) {
            if (screenName != null) {
                this.mEdtScreenName.setText((CharSequence)screenName);
            }
            if (email != null) {
                this.mEdtEmail.setText((CharSequence)email);
            }
            if (instruction != 0) {
                this.mInstruction.setText(instruction);
            }
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        return dialog;
    }

    public void onResume() {
        super.onResume();
        this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
        this.mBtnOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!WebinarRegisterDialog.this.isValidInput()) {
                    return;
                }
                WebinarRegisterDialog.this.onClickBtnOK();
            }
        });
        this.updateButtons();
    }

    public void onCancel(DialogInterface dialog) {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        if (confActivity != null) {
            confActivity.confirmWebinarRegisterInfo(null, null, true);
        }
    }

    private void onClickBtnOK() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnOK);
        String email = this.mEdtEmail.getText().toString().trim();
        String screenName = this.mEdtScreenName.getText().toString().trim();
        if (screenName.length() == 0) {
            this.mEdtScreenName.requestFocus();
            return;
        }
        if (email.length() == 0) {
            this.mEdtEmail.requestFocus();
            return;
        }
        this.dismissAllowingStateLoss();
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        if (confActivity != null) {
            confActivity.confirmWebinarRegisterInfo(screenName, email, false);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.mBtnOK != null) {
            this.mBtnOK.setEnabled(this.isValidInput());
        }
    }

    private boolean isValidInput() {
        String email = this.mEdtEmail.getText().toString().trim();
        String name = this.mEdtScreenName.getText().toString().trim();
        return !StringUtil.isEmptyOrNull((String)name) && StringUtil.isValidEmailAddress((String)email);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 2: {
                this.onClickBtnOK();
                return true;
            }
        }
        return false;
    }
}

