/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.util.ConfLocalHelper;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class SwitchAudioSourceDialog
extends ZMDialogFragment
implements HeadsetUtil.IHeadsetConnectionListener {
    private ConfActivity mConfActivity;
    private ZMMenuAdapter<SwitchAudioSourceMenuItem> mMenuAdapter;

    public static void showDialog(FragmentManager fm) {
        if (fm == null) {
            return;
        }
        SwitchAudioSourceDialog dlg = new SwitchAudioSourceDialog();
        dlg.show(fm, SwitchAudioSourceDialog.class.getName());
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final ConfActivity confActivity = this.getConfActivity();
        if (confActivity == null) {
            return this.createEmptyDialog();
        }
        this.mMenuAdapter = new ZMMenuAdapter((Context)confActivity, false);
        this.mMenuAdapter.setShowSelectedStatus(true);
        ArrayList<SwitchAudioSourceMenuItem> items = this.buildMenuItems();
        if (items == null) {
            return this.createEmptyDialog();
        }
        this.mMenuAdapter.addAll(items);
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)confActivity).setTitle(R.string.zm_btn_switch_audio_source).setAdapter(this.mMenuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SwitchAudioSourceMenuItem mi = (SwitchAudioSourceMenuItem)((Object)SwitchAudioSourceDialog.this.mMenuAdapter.getItem(which));
                SwitchAudioSourceDialog.this.onSelectContextMenuItem(mi, confActivity);
            }
        }).create();
        dlg.setCanceledOnTouchOutside(true);
        return dlg;
    }

    private ArrayList<SwitchAudioSourceMenuItem> buildMenuItems() {
        ArrayList<SwitchAudioSourceMenuItem> items = new ArrayList<SwitchAudioSourceMenuItem>();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return null;
        }
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return null;
        }
        int curAudioSourceType = ConfUI.getInstance().getCurrentAudioSourceType();
        int switchableAudioSourceType = ConfUI.getInstance().getSwitchableAudioSourceType();
        if (curAudioSourceType == 0) {
            String strLabel = this.getString(R.string.zm_mi_speaker_phone);
            SwitchAudioSourceMenuItem item = new SwitchAudioSourceMenuItem(0, strLabel, true);
            items.add(item);
            switch (switchableAudioSourceType) {
                case 3: {
                    strLabel = this.getString(R.string.zm_mi_bluetooth);
                    item = new SwitchAudioSourceMenuItem(switchableAudioSourceType, strLabel, false);
                    items.add(item);
                    break;
                }
                case 1: {
                    strLabel = this.getString(R.string.zm_mi_ear_phone);
                    item = new SwitchAudioSourceMenuItem(switchableAudioSourceType, strLabel, false);
                    items.add(item);
                    break;
                }
                case 2: {
                    strLabel = this.getString(R.string.zm_mi_wired_headset);
                    item = new SwitchAudioSourceMenuItem(switchableAudioSourceType, strLabel, false);
                    items.add(item);
                }
            }
        } else {
            String strLabel = this.getString(R.string.zm_mi_speaker_phone);
            SwitchAudioSourceMenuItem item = new SwitchAudioSourceMenuItem(0, strLabel, false);
            items.add(item);
            switch (curAudioSourceType) {
                case 3: {
                    strLabel = this.getString(R.string.zm_mi_bluetooth);
                    item = new SwitchAudioSourceMenuItem(curAudioSourceType, strLabel, true);
                    items.add(item);
                    break;
                }
                case 1: {
                    strLabel = this.getString(R.string.zm_mi_ear_phone);
                    item = new SwitchAudioSourceMenuItem(curAudioSourceType, strLabel, true);
                    items.add(item);
                    break;
                }
                case 2: {
                    strLabel = this.getString(R.string.zm_mi_wired_headset);
                    item = new SwitchAudioSourceMenuItem(curAudioSourceType, strLabel, true);
                    items.add(item);
                }
            }
        }
        return items;
    }

    private ConfActivity getConfActivity() {
        if (this.mConfActivity == null) {
            this.mConfActivity = (ConfActivity)this.getActivity();
        }
        return this.mConfActivity;
    }

    public void onResume() {
        super.onResume();
        HeadsetUtil.getInstance().addListener((HeadsetUtil.IHeadsetConnectionListener)this);
        ConfActivity confActivity = this.getConfActivity();
        if (confActivity == null) {
            return;
        }
        if (!confActivity.canSwitchAudioSource()) {
            this.dismiss();
        }
        this.updateMenuAdapter();
    }

    private void updateMenuAdapter() {
        if (this.mMenuAdapter != null) {
            this.mMenuAdapter.clear();
            ArrayList<SwitchAudioSourceMenuItem> items = this.buildMenuItems();
            if (items != null) {
                this.mMenuAdapter.addAll(items);
            }
            this.mMenuAdapter.notifyDataSetChanged();
        }
    }

    public void onPause() {
        super.onPause();
        HeadsetUtil.getInstance().removeListener((HeadsetUtil.IHeadsetConnectionListener)this);
    }

    public void onHeadsetStatusChanged(boolean wiredHeadsetConnected, boolean bluetoothHeadsetConnected) {
        this.updateMenuAdapter();
    }

    public void onBluetoothScoAudioStatus(boolean on) {
        this.updateMenuAdapter();
    }

    private void onSelectContextMenuItem(SwitchAudioSourceMenuItem mi, ConfActivity activity) {
        int curAudioSourceType = ConfUI.getInstance().getCurrentAudioSourceType();
        if (mi.getAction() != curAudioSourceType) {
            ConfLocalHelper.switchAudioSource((Context)activity, activity.getMyAudioType());
        }
    }

    static class SwitchAudioSourceMenuItem
    extends ZMSimpleMenuItem {
        public SwitchAudioSourceMenuItem(int action, String label, boolean selected) {
            super(action, label, null, selected);
        }
    }
}

