/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class SignupFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_SUCCESS = 1;
    private static final int STATUS_WAITING_SIGNUP = 2;
    private static final int STATUS_WAITING_SEND_EMAIL = 3;
    private Button mBtnBack;
    private Button mBtnSignup;
    private Button mBtnResendActiveEmail;
    private TextView mLinkAcceptTerms;
    private TextView mTxtWaiting;
    private EditText mEdtFirstName;
    private EditText mEdtLastName;
    private EditText mEdtEmail;
    private CheckBox mChkAcceptTerms;
    private View mPanelSignup;
    private View mPanelSuccess;
    private View mPanelWaiting;
    private TextView mTxtEmail;
    private View mBtnSignIn;
    private int mSignupStatus = 0;

    public static void showInActivity(ZMActivity activity) {
        SignupFragment f = new SignupFragment();
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, SignupFragment.class.getName()).commit();
    }

    public static SignupFragment getSignupFragment(FragmentManager fm) {
        return (SignupFragment)fm.findFragmentByTag(SignupFragment.class.getName());
    }

    public SignupFragment() {
        this.setStyle(1, R.style.ZMDialog);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        String url;
        View view = inflater.inflate(R.layout.zm_signup, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnSignup = (Button)view.findViewById(R.id.btnSignup);
        this.mBtnResendActiveEmail = (Button)view.findViewById(R.id.btnResendActiveEmail);
        this.mLinkAcceptTerms = (TextView)view.findViewById(R.id.linkAcceptTerms);
        this.mTxtWaiting = (TextView)view.findViewById(R.id.txtWaiting);
        this.mEdtFirstName = (EditText)view.findViewById(R.id.edtFirstName);
        this.mEdtLastName = (EditText)view.findViewById(R.id.edtLastName);
        this.mEdtEmail = (EditText)view.findViewById(R.id.edtEmail);
        this.mChkAcceptTerms = (CheckBox)view.findViewById(R.id.chkAcceptTerms);
        this.mPanelSignup = view.findViewById(R.id.panelSignup);
        this.mPanelSuccess = view.findViewById(R.id.panelSuccess);
        this.mPanelWaiting = view.findViewById(R.id.panelWaiting);
        this.mTxtEmail = (TextView)view.findViewById(R.id.txtEmail);
        this.mBtnSignIn = view.findViewById(R.id.btnSignIn);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSignup.setOnClickListener((View.OnClickListener)this);
        this.mBtnResendActiveEmail.setOnClickListener((View.OnClickListener)this);
        this.mChkAcceptTerms.setOnClickListener((View.OnClickListener)this);
        this.mBtnSignIn.setOnClickListener((View.OnClickListener)this);
        this.mLinkAcceptTerms.setMovementMethod(LinkMovementMethod.getInstance());
        TextWatcher inputValidator = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                SignupFragment.this.updateSignupButton();
            }
        };
        this.mEdtFirstName.addTextChangedListener(inputValidator);
        this.mEdtLastName.addTextChangedListener(inputValidator);
        this.mEdtEmail.addTextChangedListener(inputValidator);
        if (savedInstanceState != null) {
            this.mSignupStatus = savedInstanceState.getInt("mSignupStatus", 0);
        }
        if (!StringUtil.isEmptyOrNull((String)(url = PTApp.getInstance().getURLByType(10)))) {
            String html = this.getString(R.string.zm_lbl_accept_terms, new Object[]{url});
            this.mLinkAcceptTerms.setText((CharSequence)Html.fromHtml((String)html));
        }
        PTUI.getInstance().addPTUIListener(this);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("mSignupStatus", this.mSignupStatus);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSignup) {
            this.onClickSignupButton();
        } else if (id2 == R.id.chkAcceptTerms) {
            this.onClickChkAcceptTerms();
        } else if (id2 == R.id.btnResendActiveEmail) {
            this.onClickBtnResendActiveEmail();
        } else if (id2 == R.id.btnSignIn) {
            this.onClickbtnSignIn();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickSignupButton() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtFirstName);
        if (!this.validateInput()) {
            return;
        }
        String firstName = this.mEdtFirstName.getText().toString();
        String lastName = this.mEdtLastName.getText().toString();
        String email = this.mEdtEmail.getText().toString();
        boolean res = PTApp.getInstance().signup(firstName, lastName, email, null);
        if (res) {
            this.mSignupStatus = 2;
            this.updateUI();
        } else {
            this.showSignupErrorDialog();
        }
    }

    private void onClickBtnResendActiveEmail() {
        String firstName = this.mEdtFirstName.getText().toString();
        String lastName = this.mEdtLastName.getText().toString();
        String email = this.mEdtEmail.getText().toString();
        boolean res = PTApp.getInstance().sendActivationEmail(firstName, lastName, email);
        if (res) {
            this.mSignupStatus = 3;
            this.updateUI();
        } else {
            this.showSendEmailErrorDialog();
        }
    }

    private void onClickChkAcceptTerms() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtFirstName);
        this.updateSignupButton();
    }

    private void onClickbtnSignIn() {
        this.dismiss();
        LoginActivity.show((Context)this.getActivity(), false, 0);
    }

    private void updateUI() {
        switch (this.mSignupStatus) {
            case 0: {
                this.mBtnSignup.setVisibility(0);
                this.mPanelSignup.setVisibility(0);
                this.mPanelSuccess.setVisibility(8);
                this.mPanelWaiting.setVisibility(8);
                this.updateSignupButton();
                break;
            }
            case 1: {
                this.mBtnSignup.setVisibility(8);
                this.mPanelSignup.setVisibility(8);
                this.mPanelSuccess.setVisibility(0);
                this.mPanelWaiting.setVisibility(8);
                String email = this.mEdtEmail.getText().toString();
                this.mTxtEmail.setText((CharSequence)email);
                break;
            }
            case 2: {
                this.mBtnSignup.setVisibility(8);
                this.mPanelSignup.setVisibility(8);
                this.mPanelSuccess.setVisibility(8);
                this.mPanelWaiting.setVisibility(0);
                this.mTxtWaiting.setText(R.string.zm_msg_signingup);
                break;
            }
            case 3: {
                this.mBtnSignup.setVisibility(8);
                this.mPanelSignup.setVisibility(8);
                this.mPanelSuccess.setVisibility(8);
                this.mPanelWaiting.setVisibility(0);
                this.mTxtWaiting.setText(R.string.zm_msg_sending_activation_email);
            }
        }
    }

    private void updateSignupButton() {
        this.mBtnSignup.setEnabled(this.validateInput());
    }

    private boolean validateInput() {
        String firstName = this.mEdtFirstName.getText().toString();
        String lastName = this.mEdtLastName.getText().toString();
        String email = this.mEdtEmail.getText().toString();
        if (!StringUtil.isValidEmailAddress((String)email)) {
            return false;
        }
        if (firstName.length() == 0) {
            return false;
        }
        if (lastName.length() == 0) {
            return false;
        }
        return this.mChkAcceptTerms.isChecked();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 38: {
                this.onSignupRet(result);
                break;
            }
            case 39: {
                this.onSendActivationEmailRet(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void onSignupRet(final long result) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push(new EventAction(){

                public void run(IUIElement ui) {
                    ((SignupFragment)ui).handleOnSignupRet(result);
                }
            });
        }
    }

    private void handleOnSignupRet(long result) {
        switch ((int)result) {
            case 0: {
                this.mSignupStatus = 1;
                break;
            }
            case 1005: {
                this.mSignupStatus = 0;
                this.showAccountAlreadyExistDialog();
                break;
            }
            default: {
                this.mSignupStatus = 0;
                this.showSignupErrorDialog();
            }
        }
        this.updateUI();
    }

    private void onSendActivationEmailRet(final long result) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push(new EventAction(){

                public void run(IUIElement ui) {
                    ((SignupFragment)ui).handleOnSendActivationEmailRet(result);
                }
            });
        }
    }

    private void handleOnSendActivationEmailRet(long result) {
        switch ((int)result) {
            case 0: {
                this.mSignupStatus = 1;
                break;
            }
            default: {
                this.mSignupStatus = 1;
                this.showSendEmailErrorDialog();
            }
        }
        this.updateUI();
    }

    private void showAccountAlreadyExistDialog() {
        String email = this.mEdtEmail.getText().toString();
        String msg = this.getString(R.string.zm_msg_account_already_exist, new Object[]{email});
        UIUtil.showSimpleMessageDialog((Activity)this.getActivity(), null, (String)msg);
    }

    private void showSignupErrorDialog() {
        UIUtil.showSimpleMessageDialog((Activity)this.getActivity(), (int)0, (int)R.string.zm_msg_signup_failed);
    }

    private void showSendEmailErrorDialog() {
        UIUtil.showSimpleMessageDialog((Activity)this.getActivity(), (int)0, (int)R.string.zm_msg_send_active_email_failed);
    }
}

