/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import com.zipow.videobox.FeedbackActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.FeedbackFragment;
import com.zipow.videobox.fragment.NewVersionDialog;
import com.zipow.videobox.fragment.PrivacyPolicyFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UpgradeUtil;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMSendMessageFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class SettingAboutFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    public static final int REQUEST_PERMISSION_BY_UPDATE = 106;
    private View mBtnFeedback;
    private Button mBtnBack;
    private View mBtnRecommend;
    private ImageView mImgIndicatorNewVersion;
    private View mOptionVersion;
    private View mProgressBarCheckingUpdate;
    private View mBtnPrivacy;
    private View mPanelTitleBar;
    private static final String ARGS_SHOW_IN_VIEW = "showInView";
    private boolean mIsCheckingUpdates = false;
    private static final int REQUEST_PERMISSION_WRITE = 100;

    public static boolean needShowAboutTip(Context context) {
        if (context == null) {
            return false;
        }
        return SettingAboutFragment.hasNewVersion(context);
    }

    private static boolean hasNewVersion(Context context) {
        String latestVersion = PTApp.getInstance().getLatestVersionString();
        String thisVersion = context.getString(R.string.zm_version_name);
        return !StringUtil.isEmptyOrNull((String)latestVersion) && !thisVersion.equals(latestVersion);
    }

    public static void showAsActivity(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, SettingAboutFragment.class.getName(), args, 0);
    }

    public static void showSettingAboutFragmentInView(Fragment fragment, int viewId) {
        SettingAboutFragment aboutFragment = new SettingAboutFragment();
        Bundle args = new Bundle();
        args.putBoolean(ARGS_SHOW_IN_VIEW, true);
        aboutFragment.setArguments(args);
        FragmentManager fragmentManager = fragment.getChildFragmentManager();
        fragmentManager.beginTransaction().add(viewId, (Fragment)aboutFragment, SettingAboutFragment.class.getName()).commit();
    }

    public static SettingAboutFragment getSettingAboutFragmentInView(Fragment fragment) {
        FragmentManager fragmentManager = fragment.getChildFragmentManager();
        Fragment f = fragmentManager.findFragmentByTag(SettingAboutFragment.class.getName());
        if (f != null && f instanceof SettingAboutFragment) {
            return (SettingAboutFragment)f;
        }
        return null;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_setting_about, null);
        this.mBtnFeedback = view.findViewById(R.id.btnFeedback);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnRecommend = view.findViewById(R.id.btnRecommend);
        this.mImgIndicatorNewVersion = (ImageView)view.findViewById(R.id.imgIndicatorNewVersion);
        this.mOptionVersion = view.findViewById(R.id.optionVersion);
        this.mProgressBarCheckingUpdate = view.findViewById(R.id.progressBarCheckingUpdate);
        this.mBtnPrivacy = view.findViewById(R.id.btnPrivacy);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mBtnRecommend.setEnabled(AndroidAppUtil.hasSMSApp((Context)this.getActivity()) || AndroidAppUtil.hasEmailApp((Context)this.getActivity()));
        if (savedInstanceState != null) {
            this.mIsCheckingUpdates = savedInstanceState.getBoolean("mIsCheckingUpdates", false);
        }
        this.mBtnFeedback.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnRecommend.setOnClickListener((View.OnClickListener)this);
        this.mOptionVersion.setOnClickListener((View.OnClickListener)this);
        this.mBtnPrivacy.setOnClickListener((View.OnClickListener)this);
        PTUI.getInstance().addPTUIListener(this);
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        boolean showInView;
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null && (showInView = args.getBoolean(ARGS_SHOW_IN_VIEW, false))) {
            this.mPanelTitleBar.setVisibility(8);
        }
    }

    private void updateNewVersionIndicator() {
        boolean hasNewVersion = SettingAboutFragment.hasNewVersion((Context)this.getActivity());
        if (hasNewVersion) {
            this.mIsCheckingUpdates = false;
        }
        if (this.mIsCheckingUpdates) {
            this.mImgIndicatorNewVersion.setVisibility(8);
            this.mProgressBarCheckingUpdate.setVisibility(0);
        } else {
            this.mProgressBarCheckingUpdate.setVisibility(8);
            if (hasNewVersion) {
                this.mImgIndicatorNewVersion.setVisibility(0);
            } else {
                this.mImgIndicatorNewVersion.setVisibility(8);
            }
        }
    }

    private void updateFeedbackButton() {
        if (PTApp.getInstance().isFeedbackOff()) {
            this.mBtnFeedback.setVisibility(8);
        } else {
            this.mBtnFeedback.setVisibility(0);
        }
    }

    public void onResume() {
        super.onResume();
        this.updateNewVersionIndicator();
        this.updateFeedbackButton();
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putBoolean("mIsCheckingUpdates", this.mIsCheckingUpdates);
        }
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 25: {
                this.onNewVersionReady();
                break;
            }
            case 28: {
                this.onNoNewVersion();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void onNoNewVersion() {
        this.getNonNullEventTaskManagerOrThrowException().push("onNoNewVersion", new EventAction(){

            public void run(IUIElement ui) {
                ((SettingAboutFragment)ui).handleOnNoNewVersion();
            }
        });
    }

    private void handleOnNoNewVersion() {
        if (this.mIsCheckingUpdates) {
            this.showNoNewVersionMessage();
        }
        this.mIsCheckingUpdates = false;
        this.updateNewVersionIndicator();
    }

    private void onNewVersionReady() {
        this.getNonNullEventTaskManagerOrThrowException().push("onNewVersionReady", new EventAction(){

            public void run(IUIElement ui) {
                ((SettingAboutFragment)ui).handleOnNewVersionReady();
            }
        });
    }

    private void handleOnNewVersionReady() {
        this.mIsCheckingUpdates = false;
        this.updateNewVersionIndicator();
        this.showNewVersionDialog();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnFeedback) {
            this.onClickBtnSendFeedback();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnRecommend) {
            this.onClickBtnRecommend();
        } else if (id2 == R.id.optionVersion) {
            this.onClickOptionVersion();
        } else if (id2 == R.id.btnPrivacy) {
            this.onClickPrivacyPolicy();
        }
    }

    private void onClickPrivacyPolicy() {
        PrivacyPolicyFragment.showAsActivity((Fragment)this);
    }

    private void onClickBtnSendFeedback() {
        if (this.getShowsDialog()) {
            FeedbackFragment.showDialog(this.getFragmentManager());
            this.dismiss();
        } else {
            FeedbackActivity.show((Context)this.getActivity());
        }
    }

    private void onClickBtnBack() {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private void onClickBtnRecommend() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        String topic = PTApp.getInstance().getZoomInvitationEmailSubject();
        String content = PTApp.getInstance().getZoomInvitationEmailBody();
        String smsContent = activity.getString(R.string.zm_msg_sms_invitation_content);
        ZMSendMessageFragment.show((Context)this.getActivity(), (FragmentManager)this.getFragmentManager(), null, null, (String)topic, (String)content, (String)smsContent, null, null, (int)3);
    }

    private void onClickOptionVersion() {
        String latestVersion = PTApp.getInstance().getLatestVersionString();
        String thisVersion = this.getString(R.string.zm_version_name);
        if (!StringUtil.isEmptyOrNull((String)latestVersion) && !thisVersion.equals(latestVersion)) {
            this.showNewVersionDialog();
            PTApp.getInstance().checkForUpdates(false, true);
        } else {
            this.mIsCheckingUpdates = true;
            this.updateNewVersionIndicator();
            PTApp.getInstance().checkForUpdates(true, true);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 106 && this.checkStoragePermission()) {
            UpgradeUtil.upgrade((ZMActivity)this.getActivity());
        }
    }

    private boolean checkStoragePermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private void showNewVersionDialog() {
        PreferenceUtil.saveLongValue("last_show_new_version_time", System.currentTimeMillis());
        String version = PTApp.getInstance().getLatestVersionString();
        String note = PTApp.getInstance().getLatestVersionReleaseNote();
        if (StringUtil.isEmptyOrNull((String)version)) {
            return;
        }
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        NewVersionDialog oldDlg = (NewVersionDialog)fm.findFragmentByTag(NewVersionDialog.class.getName());
        if (oldDlg != null) {
            oldDlg.setArguments(version, note);
            return;
        }
        NewVersionDialog oldNewVersionDialog = NewVersionDialog.getLastInstance();
        if (oldNewVersionDialog != null) {
            oldNewVersionDialog.setArguments(version, note);
            return;
        }
        PTApp.getInstance().setLastUpdateNotesDisplayTime(System.currentTimeMillis());
        NewVersionDialog.RequestPermissionListener RequestPermissionListener2 = new NewVersionDialog.RequestPermissionListener(){

            @Override
            public void requestPermission() {
                SettingAboutFragment.this.zm_requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 106);
            }
        };
        NewVersionDialog dlg = NewVersionDialog.newInstance(version, note, RequestPermissionListener2);
        dlg.show(fm, NewVersionDialog.class.getName());
    }

    private void showNoNewVersionMessage() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)context).setTitle(R.string.zm_msg_no_new_version).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dialog.show();
    }
}

