/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.HttpAuthHandler;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ServerNamePasswordDialog
extends ZMDialogFragment
implements TextWatcher {
    private static final String ARG_SERVER = "server";
    private static final String ARG_PORT = "port";
    private static final String ARG_IS_PROXY_SERVER = "isProxyServer";
    private static final String ARG_FINISH_ACTIVITY_ON_DISMISS = "finishActivityOnDismiss";
    private static final String ARG_HANDLE_WEBVIEW = "handleWebView";
    private EditText mEdtUserName = null;
    private EditText mEdtPassword = null;
    private Button mBtnOK = null;
    private HttpAuthHandler mHttpAuthHandler;
    private WebView mWebView;
    private String mHost;
    private String mRealm;
    private String mServer = "";
    private int mPort = 0;
    private boolean mIsProxyServer = true;
    private boolean mFinishActivityOnDismiss = false;

    public static ServerNamePasswordDialog newInstance(String server, int port, boolean isProxyServer, boolean finishActivityOnDismiss) {
        return ServerNamePasswordDialog.newInstance(server, port, isProxyServer, finishActivityOnDismiss, null, null, null, null);
    }

    public static ServerNamePasswordDialog newInstance(String server, int port, boolean isProxyServer, boolean finishActivityOnDismiss, String host, String realm, WebView webView, HttpAuthHandler handler) {
        ServerNamePasswordDialog dialog = new ServerNamePasswordDialog();
        Bundle args = new Bundle();
        args.putString(ARG_SERVER, server);
        args.putInt(ARG_PORT, port);
        args.putBoolean(ARG_IS_PROXY_SERVER, isProxyServer);
        args.putBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS, finishActivityOnDismiss);
        if (handler != null) {
            args.putBoolean(ARG_HANDLE_WEBVIEW, true);
        }
        dialog.setArguments(args);
        dialog.mHttpAuthHandler = handler;
        dialog.mWebView = webView;
        dialog.mHost = host;
        dialog.mRealm = realm;
        return dialog;
    }

    public ServerNamePasswordDialog() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        if (args != null) {
            this.mServer = args.getString(ARG_SERVER);
            this.mPort = args.getInt(ARG_PORT);
            this.mIsProxyServer = args.getBoolean(ARG_IS_PROXY_SERVER);
            this.mFinishActivityOnDismiss = args.getBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS);
        }
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_proxy_user_password, null, false);
        this.mEdtUserName = (EditText)view.findViewById(R.id.edtUserName);
        this.mEdtPassword = (EditText)view.findViewById(R.id.edtPassword);
        TextView txtInstructions = (TextView)view.findViewById(R.id.txtInstructions);
        int title = 0;
        if (this.mIsProxyServer) {
            txtInstructions.setText((CharSequence)this.getActivity().getString(R.string.zm_lbl_proxy_name_password_instructions, new Object[]{this.mServer + ":" + this.mPort}));
            title = R.string.zm_title_proxy_settings;
        } else {
            txtInstructions.setText((CharSequence)this.getActivity().getString(R.string.zm_lbl_server_name_password_instructions, new Object[]{this.mServer}));
            title = R.string.zm_title_login;
        }
        this.mEdtUserName.addTextChangedListener((TextWatcher)this);
        this.mEdtPassword.addTextChangedListener((TextWatcher)this);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        return dialog;
    }

    public void onResume() {
        super.onResume();
        Bundle args = this.getArguments();
        if (args != null && args.getBoolean(ARG_HANDLE_WEBVIEW) && this.mHttpAuthHandler == null) {
            this.getDialog().cancel();
            return;
        }
        this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
        this.mBtnOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!ServerNamePasswordDialog.this.checkInput()) {
                    return;
                }
                ServerNamePasswordDialog.this.onOK();
            }
        });
        this.updateButtons();
    }

    public void onDestroy() {
        if (this.mHttpAuthHandler != null) {
            this.mHttpAuthHandler.cancel();
        }
        super.onDestroy();
    }

    private void onOK() {
        String userName = this.mEdtUserName.getText().toString();
        String password = this.mEdtPassword.getText().toString();
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)activity, (View)this.mEdtUserName);
        }
        if (this.mWebView != null && this.mHost != null) {
            this.mWebView.setHttpAuthUsernamePassword(this.mHost, this.mRealm, userName, password);
            this.mWebView = null;
        }
        if (this.mHttpAuthHandler != null) {
            this.mHttpAuthHandler.proceed(userName, password);
            this.mHttpAuthHandler = null;
        }
        if (this.mIsProxyServer) {
            PTApp.getInstance().userInputUsernamePasswordForProxy(this.mServer, this.mPort, userName, password, false);
        }
        this.dismissAllowingStateLoss();
        if (this.mFinishActivityOnDismiss && activity != null) {
            activity.finish();
        }
    }

    public void onCancel(DialogInterface dialog) {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)activity, (View)this.mEdtUserName);
        }
        if (this.mIsProxyServer) {
            PTApp.getInstance().userInputUsernamePasswordForProxy(this.mServer, this.mPort, "", "", true);
        }
        if (this.mFinishActivityOnDismiss && activity != null) {
            activity.finish();
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.mBtnOK != null) {
            if (StringUtil.isEmptyOrNull((String)this.mEdtUserName.getText().toString()) || StringUtil.isEmptyOrNull((String)this.mEdtPassword.getText().toString())) {
                this.mBtnOK.setEnabled(false);
            } else {
                this.mBtnOK.setEnabled(true);
            }
        }
    }

    private boolean checkInput() {
        return !StringUtil.isEmptyOrNull((String)this.mEdtUserName.getText().toString()) && !StringUtil.isEmptyOrNull((String)this.mEdtPassword.getText().toString());
    }
}

