/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class SelectDialInCountryFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
TextView.OnEditorActionListener {
    public static final String RESULT_ARG_ADD_DIALIN_COUNTRIES = "RESULT_ARG_ADD_DIALIN_COUNTRIES";
    public static final String RESULT_ARG_MINUS_DIALIN_COUNTRIES = "RESULT_ARG_MINUS_DIALIN_COUNTRIES";
    private static final String ARG_DIALIN_COUNTRIES = "ARG_DIALIN_COUNTRIES";
    private static final String ARG_DIALIN_SELECT_COUNTRIES = "ARG_DIALIN_SELECT_COUNTRIES";
    private EditText mEdtSearch;
    private EditText mEdtSearchDummy;
    private View mPanelSearchBar;
    private View mBtnClearSearchView;
    private QuickSearchListView mDialInListView;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private Drawable mDimmedForground = null;
    private DialInCountryAdapter mDialInCountryAdapter;
    private ArrayList<DialInCountry> mDialInCountries;
    private ArrayList<String> mDialInSelectedCountries;
    private final Handler mHandler = new Handler();
    private final Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = SelectDialInCountryFragment.this.mEdtSearch.getText().toString();
            SelectDialInCountryFragment.this.mDialInCountryAdapter.setFilter(key);
            if (key.length() > 0 && SelectDialInCountryFragment.this.mDialInCountryAdapter.getCount() > 0 || SelectDialInCountryFragment.this.mPanelTitleBar.getVisibility() == 0) {
                SelectDialInCountryFragment.this.mListContainer.setForeground(null);
            } else {
                SelectDialInCountryFragment.this.mListContainer.setForeground(SelectDialInCountryFragment.this.mDimmedForground);
            }
        }
    };
    private final ArrayList<String> mAddCountries = new ArrayList();
    private final ArrayList<String> mMinusCountries = new ArrayList();

    public static void showAsActivity(Fragment fragment, int requestCode, ArrayList<DialInCountry> dialInCountries, List<String> selectedCountries) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putParcelableArrayList(ARG_DIALIN_COUNTRIES, dialInCountries);
        ArrayList<String> sCountries = new ArrayList<String>();
        if (selectedCountries != null && !selectedCountries.isEmpty()) {
            sCountries.addAll(selectedCountries);
        }
        args.putStringArrayList(ARG_DIALIN_SELECT_COUNTRIES, sCountries);
        SimpleActivity.show(fragment, SelectDialInCountryFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            if (bundle.containsKey(ARG_DIALIN_COUNTRIES)) {
                this.mDialInCountries = bundle.getParcelableArrayList(ARG_DIALIN_COUNTRIES);
            }
            if (bundle.containsKey(ARG_DIALIN_SELECT_COUNTRIES)) {
                this.mDialInSelectedCountries = bundle.getStringArrayList(ARG_DIALIN_SELECT_COUNTRIES);
            }
        }
        View view = inflater.inflate(R.layout.zm_select_dialin_country, container, false);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mEdtSearchDummy = (EditText)view.findViewById(R.id.edtSearchDummy);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        this.mDialInListView = (QuickSearchListView)view.findViewById(R.id.phoneNumberListView);
        this.mBtnClearSearchView = view.findViewById(R.id.btnClearSearchView);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        view.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnOK).setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        FragmentActivity context = this.getActivity();
        this.mDialInCountryAdapter = new DialInCountryAdapter((Context)context, this);
        this.mDialInListView.setAdapter((QuickSearchListView.QuickSearchListDataAdapter)this.mDialInCountryAdapter);
        this.mDialInListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SelectDialInCountryFragment.this.onDialInItemClick(position);
            }
        });
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                SelectDialInCountryFragment.this.mHandler.removeCallbacks(SelectDialInCountryFragment.this.mRunnableFilter);
                SelectDialInCountryFragment.this.mHandler.postDelayed(SelectDialInCountryFragment.this.mRunnableFilter, 300L);
                SelectDialInCountryFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateBtnClearSearchView();
        this.mDialInCountryAdapter.reloadAll();
        this.mDialInCountryAdapter.notifyDataSetChanged();
        this.mDialInListView.onResume();
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearchDummy.hasFocus()) {
            this.mEdtSearchDummy.setVisibility(8);
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelSearchBar.setVisibility(0);
            this.mListContainer.setForeground(this.mDimmedForground);
            this.mEdtSearch.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearchDummy.setVisibility(0);
        this.mPanelSearchBar.setVisibility(4);
        this.mListContainer.setForeground(null);
        this.mPanelTitleBar.setVisibility(0);
        this.mDialInListView.post(new Runnable(){

            @Override
            public void run() {
                SelectDialInCountryFragment.this.mDialInListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    private ArrayList<DialInCountry> getmDialInCountries() {
        return this.mDialInCountries;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    private void onDialInItemClick(int position) {
        Object item = this.mDialInListView.getItemAtPosition(position);
        if (item instanceof DialInCountry) {
            DialInCountry dialInCountry = (DialInCountry)item;
            if (dialInCountry.isSelected && !this.canContinueUnSelectItem()) {
                return;
            }
            boolean bl = dialInCountry.isSelected = !dialInCountry.isSelected;
            if (dialInCountry.isSelected) {
                this.mMinusCountries.remove(dialInCountry.countryName);
                if (!this.mAddCountries.contains(dialInCountry.countryName) && this.mDialInSelectedCountries != null && !this.mDialInSelectedCountries.contains(dialInCountry.countryName)) {
                    this.mAddCountries.add(dialInCountry.countryName);
                }
            } else {
                this.mAddCountries.remove(dialInCountry.countryName);
                if (!this.mMinusCountries.contains(dialInCountry.countryName) && this.mDialInSelectedCountries != null && this.mDialInSelectedCountries.contains(dialInCountry.countryName)) {
                    this.mMinusCountries.add(dialInCountry.countryName);
                }
            }
            this.mDialInCountryAdapter.notifyDataSetChanged();
        }
    }

    private boolean canContinueUnSelectItem() {
        return this.mDialInSelectedCountries.size() + this.mAddCountries.size() - this.mMinusCountries.size() > 1;
    }

    public void dismiss() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        }
        this.finishFragment(true);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnCancel) {
            this.onClickBtnCancel();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnOK) {
            this.onClickOk();
        }
    }

    private void onClickOk() {
        if (!this.getShowsDialog()) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            Intent data = new Intent();
            data.putExtra(RESULT_ARG_ADD_DIALIN_COUNTRIES, this.mAddCountries);
            data.putExtra(RESULT_ARG_MINUS_DIALIN_COUNTRIES, this.mMinusCountries);
            activity.setResult(-1, data);
        }
        this.dismiss();
    }

    private void onClickBtnCancel() {
        this.dismiss();
    }

    private void onClickBtnClearSearchView() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.mEdtSearch.setText((CharSequence)"");
        this.mDialInCountryAdapter.setFilter(null);
    }

    public static class DialInCountryAdapter
    extends QuickSearchListView.QuickSearchListDataAdapter {
        private final Context mContext;
        private final List<DialInCountry> mList = new ArrayList<DialInCountry>();
        private final List<DialInCountry> mListFiltered = new ArrayList<DialInCountry>();
        private String mFilter;
        private final SelectDialInCountryFragment mFragment;

        public DialInCountryAdapter(Context context, SelectDialInCountryFragment fragment) {
            this.mContext = context;
            this.mFragment = fragment;
            this.loadAll();
        }

        public void setFilter(String filter) {
            this.mFilter = filter;
            this.updateFilteredList();
            this.notifyDataSetChanged();
        }

        private void updateFilteredList() {
            this.mListFiltered.clear();
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                Locale locale = CompatUtils.getLocalDefault();
                String filter = this.mFilter.toLowerCase(locale);
                for (DialInCountry item : this.mList) {
                    if (!item.countryName.toLowerCase(locale).contains(filter)) continue;
                    this.mListFiltered.add(item);
                }
            }
        }

        private void loadAll() {
            ArrayList dialInCountries = this.mFragment.getmDialInCountries();
            if (dialInCountries != null && !dialInCountries.isEmpty()) {
                this.mList.addAll(dialInCountries);
                Collections.sort(this.mList, new DialInCountryItemComparator(CompatUtils.getLocalDefault()));
            }
        }

        public void reloadAll() {
            this.mList.clear();
            this.loadAll();
        }

        public int getCount() {
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.size();
            }
            return this.mList.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.get(position);
            }
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null || !"dropdown".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_select_dialin_country_item, null);
                convertView.setTag((Object)"dropdown");
            }
            this.bindView(position, convertView);
            return convertView;
        }

        private void bindView(int position, View view) {
            TextView txtCountryName = (TextView)view.findViewById(R.id.txtCountryName);
            ImageView imgSelected = (ImageView)view.findViewById(R.id.imgSelected);
            DialInCountry item = (DialInCountry)this.getItem(position);
            txtCountryName.setText((CharSequence)item.countryName);
            imgSelected.setVisibility(item.isSelected ? 0 : 4);
            if (item.isSelected && !this.mFragment.canContinueUnSelectItem()) {
                imgSelected.setAlpha(0.3f);
                view.setClickable(true);
            } else {
                view.setClickable(false);
                imgSelected.setAlpha(1.0f);
            }
        }

        public String getItemSortKey(Object oItem) {
            DialInCountry item = (DialInCountry)oItem;
            return item.sortKey;
        }

        public boolean isEnabled(int position) {
            DialInCountry item = (DialInCountry)this.getItem(position);
            if (item != null && item.isSelected && !this.mFragment.canContinueUnSelectItem()) {
                return false;
            }
            return super.isEnabled(position);
        }
    }

    static class DialInCountryItemComparator
    implements Comparator<DialInCountry> {
        private final Collator mCollator;

        public DialInCountryItemComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(DialInCountry lhs, DialInCountry rhs) {
            if (lhs == rhs) {
                return 0;
            }
            return this.mCollator.compare(lhs.countryName, rhs.countryName);
        }
    }

    public static class DialInCountry
    implements Parcelable {
        public String countryName;
        public boolean isSelected;
        private final String sortKey;
        public static final Parcelable.Creator<DialInCountry> CREATOR = new Parcelable.Creator<DialInCountry>(){

            public DialInCountry createFromParcel(Parcel source) {
                return new DialInCountry(source);
            }

            public DialInCountry[] newArray(int size) {
                return new DialInCountry[size];
            }
        };

        public DialInCountry(String countryName, boolean isSelected) {
            if (countryName != null) {
                this.countryName = countryName;
            }
            this.isSelected = isSelected;
            this.sortKey = SortUtil.getSortKey((String)this.countryName, (Locale)CompatUtils.getLocalDefault());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.countryName);
            dest.writeByte(this.isSelected ? (byte)1 : 0);
            dest.writeString(this.sortKey);
        }

        protected DialInCountry(Parcel in) {
            this.countryName = in.readString();
            this.isSelected = in.readByte() != 0;
            this.sortKey = in.readString();
        }
    }
}

