/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class SelectCountryCodeFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
TextView.OnEditorActionListener {
    public static final String RESULT_ARG_COUNTRY_CODE = "countryCode";
    private static final String ARG_FILTER_COUNTRY_CODES = "supportCountryCodes";
    private static final String ARG_SUPPORT_SIP = "supportSip";
    private View mBtnCancel;
    private EditText mEdtSearch;
    private EditText mEdtSearchDummy;
    private View mPanelSearchBar;
    private View mBtnClearSearchView;
    private ListView mCountryCodeListView;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private Drawable mDimmedForground = null;
    private CountryCodeAdapter mCountryCodeAdapter;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = SelectCountryCodeFragment.this.mEdtSearch.getText().toString();
            SelectCountryCodeFragment.this.mCountryCodeAdapter.setFilter(key);
            if (key.length() > 0 && SelectCountryCodeFragment.this.mCountryCodeAdapter.getCount() > 0 || SelectCountryCodeFragment.this.mPanelTitleBar.getVisibility() == 0) {
                SelectCountryCodeFragment.this.mListContainer.setForeground(null);
            } else {
                SelectCountryCodeFragment.this.mListContainer.setForeground(SelectCountryCodeFragment.this.mDimmedForground);
            }
        }
    };

    public static void showAsActivity(Fragment fragment, int requestCode) {
        SelectCountryCodeFragment.showAsActivity(fragment, null, false, requestCode);
    }

    public static void showAsActivity(Fragment fragment, ArrayList<CountryCodeItem> filterCountryCodes, boolean supportSip, int requestCode) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putSerializable(ARG_FILTER_COUNTRY_CODES, filterCountryCodes);
        args.putBoolean(ARG_SUPPORT_SIP, supportSip);
        SimpleActivity.show(fragment, SelectCountryCodeFragment.class.getName(), args, requestCode, true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_select_country_code, container, false);
        this.mBtnCancel = view.findViewById(R.id.btnCancel);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mEdtSearchDummy = (EditText)view.findViewById(R.id.edtSearchDummy);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        this.mCountryCodeListView = (ListView)view.findViewById(R.id.countryCodeListView);
        this.mBtnClearSearchView = view.findViewById(R.id.btnClearSearchView);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mBtnCancel.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        FragmentActivity context = this.getActivity();
        Bundle args = this.getArguments();
        ArrayList filterCountryCodes = null;
        boolean supportSip = false;
        if (args != null) {
            filterCountryCodes = (ArrayList)args.getSerializable(ARG_FILTER_COUNTRY_CODES);
            supportSip = args.getBoolean(ARG_SUPPORT_SIP, false);
        }
        this.mCountryCodeAdapter = new CountryCodeAdapter((Context)context, filterCountryCodes, supportSip);
        this.mCountryCodeListView.setAdapter((ListAdapter)this.mCountryCodeAdapter);
        this.mCountryCodeListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Object item = SelectCountryCodeFragment.this.mCountryCodeListView.getItemAtPosition(position);
                if (item instanceof CountryCodeItem) {
                    SelectCountryCodeFragment.this.onSelectCountryCode((CountryCodeItem)item);
                }
            }
        });
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                SelectCountryCodeFragment.this.mHandler.removeCallbacks(SelectCountryCodeFragment.this.mRunnableFilter);
                SelectCountryCodeFragment.this.mHandler.postDelayed(SelectCountryCodeFragment.this.mRunnableFilter, 300L);
                SelectCountryCodeFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateBtnClearSearchView();
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearchDummy.hasFocus()) {
            this.mEdtSearchDummy.setVisibility(8);
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelSearchBar.setVisibility(0);
            this.mListContainer.setForeground(this.mDimmedForground);
            this.mEdtSearch.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearchDummy.setVisibility(0);
        this.mPanelSearchBar.setVisibility(4);
        this.mListContainer.setForeground(null);
        this.mPanelTitleBar.setVisibility(0);
        this.mCountryCodeListView.post(new Runnable(){

            @Override
            public void run() {
                SelectCountryCodeFragment.this.mCountryCodeListView.requestLayout();
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    private void onSelectCountryCode(CountryCodeItem item) {
        if (!this.getShowsDialog()) {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            Intent data = new Intent();
            data.putExtra(RESULT_ARG_COUNTRY_CODE, (Serializable)item);
            activity.setResult(-1, data);
        }
        this.dismiss();
    }

    public void dismiss() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        }
        this.finishFragment(true);
    }

    public void onClick(View v) {
        if (v == this.mBtnCancel) {
            this.onClickBtnCancel();
        } else if (v == this.mBtnClearSearchView) {
            this.onClickBtnClearSearchView();
        }
    }

    private void onClickBtnCancel() {
        this.dismiss();
    }

    private void onClickBtnClearSearchView() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.mEdtSearch.setText((CharSequence)"");
        this.mCountryCodeAdapter.setFilter(null);
    }

    public static class CountryCodeAdapter
    extends BaseAdapter {
        private Context mContext;
        private List<CountryCodeItem> mList = new ArrayList<CountryCodeItem>();
        private List<CountryCodeItem> mListFiltered = new ArrayList<CountryCodeItem>();
        private String mFilter;
        private ArrayList<CountryCodeItem> mFilterCountryCodes;
        private boolean mSupportSip;

        public CountryCodeAdapter(Context activity, ArrayList<CountryCodeItem> filterCountryCodes, boolean supportSip) {
            this.mContext = activity;
            this.mFilterCountryCodes = filterCountryCodes;
            this.mSupportSip = supportSip;
            this.loadAll();
        }

        public void setFilter(String filter) {
            if (filter != null) {
                filter = filter.trim();
            }
            this.mFilter = filter;
            this.updateFilteredList();
            this.notifyDataSetChanged();
        }

        private void updateFilteredList() {
            this.mListFiltered.clear();
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                Locale locale = CompatUtils.getLocalDefault();
                String filter = this.mFilter.toLowerCase(locale);
                for (CountryCodeItem item : this.mList) {
                    if (!item.countryName.toLowerCase(locale).contains(filter) && !item.countryCode.contains(filter)) continue;
                    this.mListFiltered.add(item);
                }
            }
        }

        public void loadAll() {
            if (this.mFilterCountryCodes != null && !this.mFilterCountryCodes.isEmpty()) {
                if (this.mSupportSip) {
                    this.loadAllForSupportSip();
                } else {
                    this.loadAllForNoSupportSip();
                }
            } else {
                this.loadAllDefault();
            }
        }

        public int getCountryCodeIndex(String isoCountryCode) {
            int i = 0;
            for (CountryCodeItem item : this.mList) {
                if (item.isoCountryCode.equals(isoCountryCode.toUpperCase(Locale.US))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getCount() {
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.size();
            }
            return this.mList.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.get(position);
            }
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null || !"dropdown".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_menu_item, null);
                convertView.setTag((Object)"dropdown");
            }
            this.bindView(position, convertView);
            return convertView;
        }

        private void bindView(int position, View view) {
            ImageView imgIcon = (ImageView)view.findViewById(R.id.imgIcon);
            TextView txtLabel = (TextView)view.findViewById(R.id.txtLabel);
            CountryCodeItem item = (CountryCodeItem)this.getItem(position);
            txtLabel.setText((CharSequence)(item.countryName + "(+" + item.countryCode + ")"));
            imgIcon.setVisibility(8);
        }

        private void loadAllForSupportSip() {
            HashMap<String, String> isoCountryCodeMap = new HashMap<String, String>();
            for (CountryCodeItem code : this.mFilterCountryCodes) {
                String isoCountryCode;
                if (code == null || code.isoCountryCode == null || isoCountryCodeMap.containsKey(isoCountryCode = code.isoCountryCode)) continue;
                isoCountryCodeMap.put(isoCountryCode, isoCountryCode);
                String displayName = code.countryName;
                if (StringUtil.isEmptyOrNull((String)displayName)) {
                    Locale locale = new Locale("", isoCountryCode.toLowerCase(Locale.US));
                    displayName = locale.getDisplayCountry();
                }
                CountryCodeItem item = new CountryCodeItem(code.countryCode, isoCountryCode, displayName);
                this.mList.add(item);
            }
            Collections.sort(this.mList, new CountryCodeItemComparator(CompatUtils.getLocalDefault()));
        }

        private void loadAllForNoSupportSip() {
            HashMap<String, String> countryCodes = new HashMap<String, String>();
            for (int i = 0; i < CountryCodeUtil.countryCodeTable.length; ++i) {
                countryCodes.put(CountryCodeUtil.countryCodeTable[i][0].toString(), CountryCodeUtil.countryCodeTable[i][1].toString());
            }
            HashMap<String, String> isoCountryCodeMap = new HashMap<String, String>();
            for (CountryCodeItem code : this.mFilterCountryCodes) {
                String isoCountryCode;
                if (code == null || code.isoCountryCode == null || !countryCodes.containsKey(isoCountryCode = code.isoCountryCode) || isoCountryCodeMap.containsKey(isoCountryCode)) continue;
                isoCountryCodeMap.put(isoCountryCode, isoCountryCode);
                String displayName = code.countryName;
                if (StringUtil.isEmptyOrNull((String)displayName)) {
                    Locale locale = new Locale("", isoCountryCode.toLowerCase(Locale.US));
                    displayName = locale.getDisplayCountry();
                }
                CountryCodeItem item = new CountryCodeItem(code.countryCode, isoCountryCode, displayName);
                this.mList.add(item);
            }
            Collections.sort(this.mList, new CountryCodeItemComparator(CompatUtils.getLocalDefault()));
        }

        private void loadAllDefault() {
            String displayName = null;
            for (int i = 0; i < CountryCodeUtil.countryCodeTable.length; ++i) {
                String isoCountryCode = CountryCodeUtil.countryCodeTable[i][0].toString();
                String phoneCountryCode = CountryCodeUtil.countryCodeTable[i][1].toString();
                Locale locale = new Locale("", isoCountryCode.toLowerCase(Locale.US));
                displayName = locale.getDisplayCountry();
                CountryCodeItem item = new CountryCodeItem(phoneCountryCode, isoCountryCode, displayName);
                this.mList.add(item);
            }
            Collections.sort(this.mList, new CountryCodeItemComparator(CompatUtils.getLocalDefault()));
        }
    }

    static class CountryCodeItemComparator
    implements Comparator<CountryCodeItem> {
        private Collator mCollator;

        public CountryCodeItemComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(CountryCodeItem lhs, CountryCodeItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            return this.mCollator.compare(lhs.countryName, rhs.countryName);
        }
    }

    public static class CountryCodeItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String countryCode;
        public String isoCountryCode;
        public String countryName;

        public CountryCodeItem(String countryCode, String isoCountryCode, String countryName) {
            this.countryCode = countryCode;
            this.isoCountryCode = isoCountryCode;
            this.countryName = countryName;
        }

        public static CountryCodeItem from(CountryCodeItem item) {
            if (item == null) {
                return null;
            }
            CountryCodeItem newItem = new CountryCodeItem(item.countryCode, item.isoCountryCode, item.countryName);
            return newItem;
        }

        public static CountryCodeItem readFromPreference(String key) {
            HashSet<String> keys = new HashSet<String>();
            keys.add(key + SelectCountryCodeFragment.RESULT_ARG_COUNTRY_CODE);
            keys.add(key + "isoCountryCode");
            keys.add(key + "countryName");
            HashMap<String, String> values = PreferenceUtil.readMapStringValues(keys, null);
            if (values != null) {
                return new CountryCodeItem(values.get(key + SelectCountryCodeFragment.RESULT_ARG_COUNTRY_CODE), values.get(key + "isoCountryCode"), values.get(key + "countryName"));
            }
            return null;
        }

        public void savePreference(String key) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(key + SelectCountryCodeFragment.RESULT_ARG_COUNTRY_CODE, this.countryCode);
            values.put(key + "isoCountryCode", this.isoCountryCode);
            values.put(key + "countryName", this.countryName);
            PreferenceUtil.saveMapStringValues(values);
        }
    }
}

