/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.ZMWebUtil;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class SSOSiteDialog
extends ZMDialogFragment
implements TextWatcher {
    private static final String TAG = SSOSiteDialog.class.getSimpleName();
    private static final String ARG_DEF_SITE_URL = "defSiteUrl";
    private EditText mEdtUrl = null;
    private Button mBtnOK = null;

    public static SSOSiteDialog newInstance(String defSiteUrl) {
        SSOSiteDialog dialog = new SSOSiteDialog();
        Bundle args = new Bundle();
        args.putString(ARG_DEF_SITE_URL, defSiteUrl);
        dialog.setArguments(args);
        return dialog;
    }

    public SSOSiteDialog() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        String defSiteUrl = null;
        Bundle args = this.getArguments();
        if (args != null) {
            defSiteUrl = args.getString(ARG_DEF_SITE_URL);
        }
        if (StringUtil.isEmptyOrNull(defSiteUrl)) {
            defSiteUrl = "https://";
        }
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_sso_site, null, false);
        this.mEdtUrl = (EditText)view.findViewById(R.id.edtUrl);
        this.mEdtUrl.setText((CharSequence)defSiteUrl);
        try {
            this.mEdtUrl.setSelection(defSiteUrl.length(), defSiteUrl.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mEdtUrl.addTextChangedListener((TextWatcher)this);
        this.mEdtUrl.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                UIUtil.closeSoftKeyboard((Context)SSOSiteDialog.this.getActivity(), (View)v);
                SSOSiteDialog.this.onOK();
                return true;
            }
        });
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_login_with_sso).setView(view).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        return dialog;
    }

    public void onResume() {
        super.onResume();
        this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
        this.mBtnOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!SSOSiteDialog.this.checkInput()) {
                    return;
                }
                SSOSiteDialog.this.onOK();
            }
        });
        this.updateButtons();
    }

    private void onOK() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)activity, (View)this.mEdtUrl);
        }
        this.dismissAllowingStateLoss();
        String url = this.mEdtUrl.getText().toString().trim();
        if (StringUtil.isEmptyOrNull((String)url)) {
            return;
        }
        String lowerSiteUrl = url.toLowerCase();
        url = lowerSiteUrl.startsWith("http://") ? "http://" + url.substring(7) : (lowerSiteUrl.startsWith("https://") ? "https://" + url.substring(8) : "https://" + url);
        if (!lowerSiteUrl.endsWith(ZMWebUtil.getZmUrlSSOPostfix()) && !lowerSiteUrl.contains(".")) {
            url = url + ZMWebUtil.getZmUrlSSOPostfix();
        }
        PTApp.getInstance().setSSOURL(url);
        if (activity != null) {
            ((LoginActivity)activity).loginSSOSite(url);
        }
    }

    public void onCancel(DialogInterface dialog) {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtUrl);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.mBtnOK != null) {
            if (StringUtil.isEmptyOrNull((String)this.mEdtUrl.getText().toString())) {
                this.mBtnOK.setEnabled(false);
            } else {
                this.mBtnOK.setEnabled(true);
            }
        }
    }

    private boolean checkInput() {
        return !StringUtil.isEmptyOrNull((String)this.mEdtUrl.getText().toString());
    }
}

