/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.ContextThemeWrapper;
import android.view.View;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.dialog.ConfirmStopRecordDialog;
import com.zipow.videobox.util.ConfLocalHelper;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class RecordControlDialog
extends ZMDialogFragment
implements View.OnClickListener {
    private View mPauseRecord;
    private View mStopRecord;
    private View mResumeRecord;

    public static void show(FragmentManager fm) {
        RecordControlDialog f = new RecordControlDialog();
        Bundle args = new Bundle();
        f.setArguments(args);
        f.show(fm, RecordControlDialog.class.getName());
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setView(this.createContent()).setTheme(R.style.ZMDialog_Material_Transparent).create();
        return dialog;
    }

    private View createContent() {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_record_control, null);
        this.mPauseRecord = view.findViewById(R.id.btnPauseRecord);
        this.mStopRecord = view.findViewById(R.id.btnStopRecord);
        this.mResumeRecord = view.findViewById(R.id.btnResumeRecord);
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr != null && recordMgr.isCMRPaused()) {
            this.mPauseRecord.setVisibility(8);
            this.mResumeRecord.setVisibility(0);
            this.mResumeRecord.setOnClickListener((View.OnClickListener)this);
        } else {
            this.mPauseRecord.setVisibility(0);
            this.mResumeRecord.setVisibility(8);
            this.mPauseRecord.setOnClickListener((View.OnClickListener)this);
        }
        this.mStopRecord.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnPauseRecord) {
            ConfLocalHelper.pauseRecord();
        } else if (id2 == R.id.btnStopRecord) {
            ZMActivity zmActivity = (ZMActivity)this.getActivity();
            if (zmActivity != null) {
                ConfirmStopRecordDialog.showConfirmStopRecordDialog(zmActivity);
            }
        } else if (id2 == R.id.btnResumeRecord) {
            ConfLocalHelper.resumeRecord();
        }
        this.dismiss();
    }

    public void dismiss() {
        this.finishFragment(true);
    }
}

