/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.confapp.AttentionTrackEventSinkUI;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.ZoomRaiseHandInWebinar;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.fragment.ConfChatAttendeeListFragment;
import com.zipow.videobox.fragment.PAttendeeListActionDialog;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class QAWebinarAttendeeListFragment
extends ConfChatAttendeeListFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
TextView.OnEditorActionListener {
    public static final int MENU_ITEM_PROMOTE_TO_PANELIST = 0;
    public static final int MENU_ITEM_EXPEL = 1;
    public static final int MENU_ITEM_LOWERHAND = 2;
    private static final int THRESHOD_SHOW_SIDEBAR = 500;
    private static final int DELAY_REFRESH_TIME = 600;
    private static final String TAG = QAWebinarAttendeeListFragment.class.getSimpleName();
    private View mBtnCancel;
    private View mBtnLowerHandAll;
    private EditText mEdtSearch;
    private EditText mEdtSearchDummy;
    private View mPanelSearchBar;
    private View mBtnClearSearchView;
    private QuickSearchListView mAttendeeListView;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private TextView mTxtTitle;
    private Drawable mDimmedForground = null;
    private WebinarAttendeeListAdapter mBuddyAdapter;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private ConfUI.IConfUIListener mConfUIListener;
    private AttentionTrackEventSinkUI.IAttentionTrackEventSinkUIListener mAttentionTrackEventSinkUIListener;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = QAWebinarAttendeeListFragment.this.mEdtSearch.getText().toString();
            QAWebinarAttendeeListFragment.this.mBuddyAdapter.setFilter(key);
            if (key.length() > 0 && QAWebinarAttendeeListFragment.this.mBuddyAdapter.getCount() > 0 || QAWebinarAttendeeListFragment.this.mPanelTitleBar.getVisibility() == 0) {
                QAWebinarAttendeeListFragment.this.mListContainer.setForeground(null);
            } else {
                QAWebinarAttendeeListFragment.this.mListContainer.setForeground(QAWebinarAttendeeListFragment.this.mDimmedForground);
            }
            key = key.trim();
            if (StringUtil.isEmptyOrNull((String)key)) {
                QAWebinarAttendeeListFragment.this.refresh();
            }
            QAWebinarAttendeeListFragment.this.checkSideBar();
            QAWebinarAttendeeListFragment.this.mBuddyAdapter.notifyDataSetChanged();
        }
    };
    private Runnable mRunnableUpdateData = new Runnable(){

        @Override
        public void run() {
            QAWebinarAttendeeListFragment.this.refresh();
        }
    };

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        if (activity == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(activity, QAWebinarAttendeeListFragment.class.getName(), args, requestCode, true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_qa_webinar_attendee, container, false);
        this.mBtnCancel = view.findViewById(R.id.btnCancel);
        this.mBtnLowerHandAll = view.findViewById(R.id.btnLowerHandAll);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mEdtSearchDummy = (EditText)view.findViewById(R.id.edtSearchDummy);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        this.mAttendeeListView = (QuickSearchListView)view.findViewById(R.id.attendeesListView);
        this.mBtnClearSearchView = view.findViewById(R.id.btnClearSearchView);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mBtnCancel.setOnClickListener((View.OnClickListener)this);
        this.mBtnLowerHandAll.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        FragmentActivity context = this.getActivity();
        this.enableAttendeeItemPopMenu(this.mAttendeeListView.getListView());
        this.mBuddyAdapter = new WebinarAttendeeListAdapter((Context)context);
        this.mAttendeeListView.setCategoryChars("*#ABCDEFGHIJKLMNOPQRSTUVWXYZ", "*#ABCDEFGHIJKLMNOPQRSTUVWXYZ", "*#AB.IJK.RST.Z", "*#A.IJ.RS.Z", "*#A.I.R.Z");
        this.mAttendeeListView.setCategoryTitle('*', null);
        this.mAttendeeListView.setAdapter((QuickSearchListView.QuickSearchListDataAdapter)this.mBuddyAdapter);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                QAWebinarAttendeeListFragment.this.mHandler.removeCallbacks(QAWebinarAttendeeListFragment.this.mRunnableFilter);
                QAWebinarAttendeeListFragment.this.mHandler.postDelayed(QAWebinarAttendeeListFragment.this.mRunnableFilter, 300L);
                QAWebinarAttendeeListFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, final long ret) {
                    EventTaskManager eventTaskMgr = QAWebinarAttendeeListFragment.this.getEventTaskManager();
                    if (eventTaskMgr != null && cmd == 97) {
                        eventTaskMgr.pushLater("onTelephonyUserCountChanged", new EventAction("onTelephonyUserCountChanged"){

                            public void run(IUIElement ui) {
                                QAWebinarAttendeeListFragment f = (QAWebinarAttendeeListFragment)ui;
                                f.onTelephonyUserCountChanged((int)ret);
                            }
                        });
                    }
                    return true;
                }

                @Override
                public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
                    switch (cmd) {
                        case 9: 
                        case 21: {
                            QAWebinarAttendeeListFragment.this.updateUserAudioStatus(userId);
                            break;
                        }
                        case 27: 
                        case 28: {
                            QAWebinarAttendeeListFragment.this.talkPrivilegeChange(userId);
                            break;
                        }
                        case 1: 
                        case 43: 
                        case 44: {
                            QAWebinarAttendeeListFragment.this.processOnHostOrCoHostChanged(userId);
                            break;
                        }
                        case 45: {
                            QAWebinarAttendeeListFragment.this.userGuestStatusChanged(userId);
                            break;
                        }
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onUserListUpdated() {
                    QAWebinarAttendeeListFragment.this.postRefresh();
                }

                @Override
                public void onUserListInitialized() {
                    QAWebinarAttendeeListFragment.this.refresh();
                }

                @Override
                public void onUserRemoved(String jid) {
                    QAWebinarAttendeeListFragment.this.onUserRemoved(jid);
                }

                @Override
                public void onWebinarAttendeeRaisedHand(long nodeID) {
                    QAWebinarAttendeeListFragment.this.attendeeRaiseOrLowerHand(nodeID);
                }

                @Override
                public void onWebinarAttendeeLowerHand(long nodeID) {
                    QAWebinarAttendeeListFragment.this.attendeeRaiseOrLowerHand(nodeID);
                }

                @Override
                public void onChattedAttendeeUpdated(long nodeID) {
                    QAWebinarAttendeeListFragment.this.postRefresh();
                }
            };
        }
        if (this.mAttentionTrackEventSinkUIListener == null) {
            this.mAttentionTrackEventSinkUIListener = new AttentionTrackEventSinkUI.SimpleAttentionTrackEventSinkUIListener(){

                @Override
                public void OnConfAttentionTrackStatusChanged(boolean bEnabled) {
                }

                @Override
                public void OnWebinarAttendeeAttentionStatusChanged(int nUserID, boolean bInAttentionMode) {
                    QAWebinarAttendeeListFragment.this.postRefresh();
                }
            };
        }
        AttentionTrackEventSinkUI.getInstance().addListener(this.mAttentionTrackEventSinkUIListener);
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        if (this.mBuddyAdapter.getBuddyCount() >= 600) {
            this.showWaitingDialog();
            this.mHandler.postDelayed(this.mRunnableUpdateData, 500L);
        } else {
            this.updateData();
        }
        this.updateTitle();
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateBtnClearSearchView();
        this.mAttendeeListView.onResume();
        this.mBuddyAdapter.notifyDataSetChanged();
    }

    public void onDestroyView() {
        this.mHandler.removeCallbacks(this.mRunnableFilter);
        this.mHandler.removeCallbacks(this.mRunnableUpdateData);
        super.onDestroyView();
    }

    private void postRefresh() {
        this.mHandler.removeCallbacks(this.mRunnableUpdateData);
        this.mHandler.postDelayed(this.mRunnableUpdateData, 600L);
    }

    private void onTelephonyUserCountChanged(int count) {
        this.mBuddyAdapter.refreshTelephonyUserCountItem();
        this.checkSideBar();
        this.mBuddyAdapter.notifyDataSetChanged();
    }

    private void refresh() {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.pushLater("refreshAll", new EventAction("refreshAll"){

                public void run(IUIElement ui) {
                    QAWebinarAttendeeListFragment f = (QAWebinarAttendeeListFragment)ui;
                    f.updateData();
                }
            });
        } else {
            this.updateData();
        }
    }

    private void updateData() {
        this.mBuddyAdapter.reloadAll();
        this.dismissWaitingDialog();
        if (this.mBuddyAdapter.getCount() > 500) {
            if (this.mAttendeeListView.isQuickSearchEnabled()) {
                this.mAttendeeListView.setQuickSearchEnabled(false);
            }
        } else if (!this.mAttendeeListView.isQuickSearchEnabled()) {
            this.mAttendeeListView.setQuickSearchEnabled(true);
        }
        this.mBuddyAdapter.notifyDataSetChanged();
        this.updateTitle();
    }

    private void onUserRemoved(String jid) {
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.dismissPAttendeeListActionDialogForUserId(zmActivity.getSupportFragmentManager(), jid);
        }
    }

    private void updateUserAudioStatus(long nodeId) {
        this.postRefresh();
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.refreshAction(zmActivity.getSupportFragmentManager(), nodeId);
        }
    }

    private void talkPrivilegeChange(long nodeId) {
        this.postRefresh();
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.refreshAction(zmActivity.getSupportFragmentManager(), nodeId);
        }
    }

    private void processOnHostOrCoHostChanged(long userId) {
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.refreshAction(zmActivity.getSupportFragmentManager(), userId);
        }
    }

    private void userGuestStatusChanged(long userId) {
        this.postRefresh();
    }

    private void attendeeRaiseOrLowerHand(long nodeId) {
        ZMActivity zmActivity = (ZMActivity)this.getActivity();
        if (zmActivity != null) {
            PAttendeeListActionDialog.refreshAction(zmActivity.getSupportFragmentManager(), nodeId);
        }
    }

    private void checkSideBar() {
        if (this.mBuddyAdapter.getCount() >= 500) {
            if (this.mAttendeeListView.isQuickSearchEnabled()) {
                this.mAttendeeListView.setQuickSearchEnabled(false);
            }
        } else if (!this.mAttendeeListView.isQuickSearchEnabled()) {
            this.refresh();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        ConfUI.getInstance().removeListener(this.mConfUIListener);
        AttentionTrackEventSinkUI.getInstance().removeListener(this.mAttentionTrackEventSinkUIListener);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearchDummy.hasFocus()) {
            this.mEdtSearchDummy.setVisibility(8);
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelSearchBar.setVisibility(0);
            this.mListContainer.setForeground(this.mDimmedForground);
            this.mEdtSearch.requestFocus();
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        String key = this.mEdtSearch.getText().toString();
        if (StringUtil.isEmptyOrNull((String)key) || this.mBuddyAdapter.getBuddyCount() == 0) {
            this.mEdtSearch.setText(null);
            this.mEdtSearchDummy.setVisibility(0);
            this.mPanelSearchBar.setVisibility(4);
            this.mListContainer.setForeground(null);
            this.mPanelTitleBar.setVisibility(0);
            this.mAttendeeListView.post(new Runnable(){

                @Override
                public void run() {
                    QAWebinarAttendeeListFragment.this.mAttendeeListView.requestLayout();
                }
            });
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.mPanelSearchBar.getVisibility() == 0) {
            this.mEdtSearch.setText(null);
            this.mEdtSearchDummy.setVisibility(0);
            this.mPanelSearchBar.setVisibility(4);
            this.mListContainer.setForeground(null);
            this.mPanelTitleBar.setVisibility(0);
            this.mAttendeeListView.post(new Runnable(){

                @Override
                public void run() {
                    QAWebinarAttendeeListFragment.this.mAttendeeListView.requestLayout();
                }
            });
            return true;
        }
        return false;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    public void dismiss() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        }
        this.finishFragment(true);
    }

    private void updateTitle() {
        if (!this.isAdded()) {
            return;
        }
        int count = 0;
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent != null) {
            count = qacomponent.getBuddyCount();
        }
        this.mTxtTitle.setText((CharSequence)this.getString(R.string.zm_title_webinar_attendee, new Object[]{count}));
    }

    public void onClick(View v) {
        if (v == this.mBtnCancel) {
            this.onClickBtnCancel();
        } else if (v == this.mBtnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (v == this.mBtnLowerHandAll) {
            this.onClickBtnLowerHandAll();
        }
    }

    private void onClickBtnCancel() {
        this.dismiss();
    }

    private void onClickBtnLowerHandAll() {
        ZoomRaiseHandInWebinar raiseHandInWebinar = ConfMgr.getInstance().getRaiseHandAPIObj();
        if (raiseHandInWebinar == null || !raiseHandInWebinar.lowerAllHand()) {
            // empty if block
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        this.mBuddyAdapter.setFilter(null);
    }

    @Override
    protected void onRemoveItem(String jid) {
        this.postRefresh();
    }

    @Override
    public ConfChatAttendeeItem getItemAtPosition(int position) {
        Object item = this.mAttendeeListView.getItemAtPosition(position);
        if (item instanceof ConfChatAttendeeItem) {
            return (ConfChatAttendeeItem)item;
        }
        return null;
    }

    public static class WebinarAttendeeListAdapter
    extends QuickSearchListView.QuickSearchListDataAdapter {
        private Context mContext;
        private List<ConfChatAttendeeItem> mList = new ArrayList<ConfChatAttendeeItem>();
        private List<ConfChatAttendeeItem> mListFiltered = new ArrayList<ConfChatAttendeeItem>();
        private HashMap<String, String> mCacheSortKeys = new HashMap();
        private String mFilter;
        private ConfChatAttendeeItem mTelephonyUserCountItem = null;

        public WebinarAttendeeListAdapter(Context activity) {
            this.mContext = activity;
        }

        public boolean isDataSorted() {
            return true;
        }

        public void setFilter(String filter) {
            if (filter != null) {
                filter = filter.trim();
            }
            this.mFilter = filter;
            this.updateFilteredList();
        }

        private void updateFilteredList() {
            this.mListFiltered.clear();
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                String filter = this.mFilter.toLowerCase(CompatUtils.getLocalDefault());
                ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
                if (qacomponent == null) {
                    return;
                }
                List<ZoomQABuddy> arrBuddies = qacomponent.getBuddyListByNameFilter(filter);
                if (arrBuddies == null) {
                    return;
                }
                int count = arrBuddies.size();
                if (count <= 0) {
                    return;
                }
                for (int i = 0; i < count; ++i) {
                    int role;
                    ZoomQABuddy buddy = arrBuddies.get(i);
                    if (buddy == null || (role = buddy.getRole()) != 0) continue;
                    ConfChatAttendeeItem item = new ConfChatAttendeeItem(buddy);
                    this.mListFiltered.add(item);
                }
            }
        }

        public int getBuddyCount() {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            if (qacomponent == null) {
                return 0;
            }
            return qacomponent.getBuddyCount();
        }

        private void loadAll() {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            if (qacomponent == null) {
                return;
            }
            List<ZoomQABuddy> arrBuddies = qacomponent.getBuddyListByNameFilter(this.mFilter);
            if (arrBuddies == null) {
                return;
            }
            int count = arrBuddies.size();
            if (count <= 0) {
                return;
            }
            if (count > 0) {
                boolean enabeSideBar;
                boolean bl = enabeSideBar = count <= 500;
                if (enabeSideBar) {
                    for (int i = 0; i < count; ++i) {
                        ConfChatAttendeeItem item;
                        int role;
                        ZoomQABuddy buddy = arrBuddies.get(i);
                        if (buddy == null || (role = buddy.getRole()) != 0) continue;
                        String name = buddy.getName();
                        String key = null;
                        if (name != null) {
                            key = this.mCacheSortKeys.get(name);
                        }
                        if (key == null) {
                            item = new ConfChatAttendeeItem(buddy);
                            this.mCacheSortKeys.put(name, item.getSortKey());
                        } else {
                            item = new ConfChatAttendeeItem(buddy, key);
                        }
                        this.mList.add(item);
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        int role;
                        ZoomQABuddy buddy = arrBuddies.get(i);
                        if (buddy == null || (role = buddy.getRole()) != 0) continue;
                        ConfChatAttendeeItem item = new ConfChatAttendeeItem(buddy, null);
                        this.mList.add(item);
                    }
                }
            }
            this.refreshTelephonyUserCountItem();
        }

        public void reloadAll() {
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                this.updateFilteredList();
            } else {
                this.mList.clear();
                this.loadAll();
            }
        }

        public void refreshTelephonyUserCountItem() {
            int telUserCount = ConfMgr.getInstance().getViewOnlyTelephonyUserCount();
            if (telUserCount > 0) {
                String name = this.mContext.getResources().getQuantityString(R.plurals.zm_lbl_webinar_telephony_user_count, telUserCount, new Object[]{telUserCount});
                ConfChatAttendeeItem item = new ConfChatAttendeeItem(name, null, 0L, 0);
                item.setSortKey("*");
                this.clearTelephonyUserCountInfo();
                this.mTelephonyUserCountItem = item;
                this.mList.add(0, item);
            } else {
                this.clearTelephonyUserCountInfo();
            }
        }

        private void clearTelephonyUserCountInfo() {
            if (this.mTelephonyUserCountItem == null) {
                return;
            }
            this.mList.remove(this.mTelephonyUserCountItem);
            this.mTelephonyUserCountItem = null;
        }

        public int getCount() {
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.size();
            }
            return this.mList.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            if (!StringUtil.isEmptyOrNull((String)this.mFilter)) {
                return this.mListFiltered.get(position);
            }
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object obj = this.getItem(position);
            if (obj == null || !(obj instanceof ConfChatAttendeeItem)) {
                return null;
            }
            return ((ConfChatAttendeeItem)obj).getView(this.mContext, convertView);
        }

        public String getItemSortKey(Object oItem) {
            ConfChatAttendeeItem item = (ConfChatAttendeeItem)oItem;
            return item.getSortKey();
        }
    }
}

