/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.MMNotificationDndSettingsFragment;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class PresenceStatusFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final String TAG = PresenceStatusFragment.class.getSimpleName();
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;
    private View panelPsDnd;
    private View panelPsAvailable;
    private TextView txtTimeInterval;
    private ImageView imgPsDnd;
    private ImageView imgPsAvailable;
    private NotificationSettingUI.INotificationSettingUIListener mListener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnDNDSettingsUpdated() {
            PresenceStatusFragment.this.updateTimeInterval();
        }

        @Override
        public void OnDNDNowSettingUpdated() {
            PresenceStatusFragment.this.updateTimeInterval();
        }

        @Override
        public void OnSnoozeSettingsUpdated() {
            PresenceStatusFragment.this.updateTimeInterval();
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_presence_status, null);
        this.panelPsDnd = view.findViewById(R.id.panelPsDnd);
        this.txtTimeInterval = (TextView)view.findViewById(R.id.txtTimeInterval);
        this.panelPsAvailable = view.findViewById(R.id.panelPsAvailable);
        this.imgPsDnd = (ImageView)view.findViewById(R.id.imgPsDnd);
        this.imgPsAvailable = (ImageView)view.findViewById(R.id.imgPsAvailable);
        this.panelPsDnd.setOnClickListener((View.OnClickListener)this);
        this.panelPsAvailable.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.setPresence(this.getPresence());
        this.updateTimeInterval();
    }

    public void onStart() {
        super.onStart();
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public void On_MyPresenceChanged(int presence, int presenceStatus) {
                    PresenceStatusFragment.this.setPresence(presence);
                    PresenceStatusFragment.this.updateTimeInterval();
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        NotificationSettingUI.getInstance().addListener(this.mListener);
    }

    public void onStop() {
        NotificationSettingUI.getInstance().removeListener(this.mListener);
        if (this.mZoomMessengerUIListener != null) {
            ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        }
        super.onStop();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.panelPsDnd) {
            this.onClickPanelDnd();
        } else if (id2 == R.id.panelPsAvailable) {
            this.onClickPanelAvailable();
        }
    }

    public boolean setPresence(int presence) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        switch (presence) {
            case 3: {
                this.imgPsAvailable.setVisibility(0);
                this.imgPsDnd.setVisibility(4);
                break;
            }
            case 2: 
            case 4: {
                this.imgPsDnd.setVisibility(0);
                this.imgPsAvailable.setVisibility(4);
                break;
            }
        }
        return messenger.setPresence(presence);
    }

    public int getPresence() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return 0;
        }
        return messenger.getMyPresence();
    }

    private void onClickPanelAvailable() {
        this.setPresence(3);
        this.shutdownDND();
    }

    public static void showAsActivity(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, PresenceStatusFragment.class.getName(), args, 0);
    }

    private void onClickBtnBack() {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private void onClickPanelDnd() {
        String title = this.getString(R.string.zm_lbl_notification_snoozed_19898);
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        long[] snoozedSetting = mgr.getSnoozeSettings();
        if (snoozedSetting == null) {
            return;
        }
        long time = snoozedSetting[2] - snoozedSetting[1];
        if (time > 0L) {
            int t;
            long now = CmmTime.getMMNow();
            if (snoozedSetting[2] - now >= 0L && now - snoozedSetting[1] >= 0L) {
                time = snoozedSetting[2] - now;
            }
            if ((t = (int)(time / 60000L)) == 0) {
                t = 1;
            }
            String hour = t / 60 > 0 ? this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, t / 60, new Object[]{t / 60}) : "";
            String min = t % 60 > 0 ? this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_min_19898, t % 60, new Object[]{t % 60}) : "";
            title = this.getString(R.string.zm_lbl_notification_snoozed_resume_in_19898, new Object[]{hour, min});
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)this.getActivity(), false);
        ArrayList<SnoozedContextMenuItem> items = new ArrayList<SnoozedContextMenuItem>();
        if (time > 0L) {
            items.add(new SnoozedContextMenuItem(this.getString(R.string.zm_lbl_notification_snoozed_turn_off_19898), 0));
        }
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_min_19898, 20, new Object[]{20}), 1));
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, 1, new Object[]{1}), 2));
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, 2, new Object[]{2}), 3));
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, 4, new Object[]{4}), 4));
        items.add(new SnoozedContextMenuItem(this.getResources().getQuantityString(R.plurals.zm_lbl_notification_snoozed_hour_19898, 8, new Object[]{8}), 5));
        items.add(new SnoozedContextMenuItem(this.getResources().getString(R.string.zm_lbl_profile_set_time_period_40739), 6));
        TextView titleView = new TextView((Context)this.getActivity());
        if (Build.VERSION.SDK_INT < 23) {
            titleView.setTextAppearance((Context)this.getActivity(), R.style.ZMTextView_Small);
        } else {
            titleView.setTextAppearance(R.style.ZMTextView_Small);
        }
        int padding = UIUtil.dip2px((Context)this.getActivity(), (float)20.0f);
        titleView.setPadding(padding, padding, padding, padding / 2);
        titleView.setText((CharSequence)title);
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitleView((View)titleView).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SnoozedContextMenuItem mi = (SnoozedContextMenuItem)((Object)menuAdapter.getItem(which));
                PresenceStatusFragment.this.onSelectContextMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectContextMenuItem(SnoozedContextMenuItem item) {
        if (item == null) {
            return;
        }
        int duration = 0;
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        if (item.getAction() == 6) {
            MMNotificationDndSettingsFragment.showAsActivity((Fragment)this);
            return;
        }
        switch (item.getAction()) {
            case 0: {
                this.onClickPanelAvailable();
                return;
            }
            case 2: {
                duration = 60;
                this.setPresence(4);
                break;
            }
            case 3: {
                duration = 120;
                this.setPresence(4);
                break;
            }
            case 4: {
                duration = 240;
                this.setPresence(4);
                break;
            }
            case 5: {
                duration = 480;
                this.setPresence(4);
                break;
            }
            case 1: {
                duration = 20;
                this.setPresence(4);
                break;
            }
            default: {
                duration = 0;
            }
        }
        long now = CmmTime.getMMNow();
        mgr.applySnoozeSettings(duration, now, now + (long)(duration * 60000));
        this.updateTimeInterval();
    }

    private void shutdownDND() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        long now = CmmTime.getMMNow();
        mgr.applySnoozeSettings(0L, now, now);
        NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
        this.txtTimeInterval.setVisibility(4);
        if (dndSettings == null) {
            return;
        }
        if (dndSettings.isEnable()) {
            dndSettings.setEnable(false);
            mgr.applyDndSettings(dndSettings);
        }
    }

    private void updateTimeInterval() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        long[] snoozeSettings = mgr.getSnoozeSettings();
        if (snoozeSettings != null) {
            this.txtTimeInterval.setVisibility(0);
            if (snoozeSettings[2] > CmmTime.getMMNow()) {
                String start = TimeUtil.formatTime((Context)this.getActivity(), (long)snoozeSettings[1]);
                String end = TimeUtil.formatTime((Context)this.getActivity(), (long)snoozeSettings[2]);
                this.txtTimeInterval.setText((CharSequence)this.getString(R.string.zm_lbl_notification_dnd_19898, new Object[]{start, end}));
            } else {
                this.txtTimeInterval.setText((CharSequence)"");
            }
        }
    }

    public static class SnoozedContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_TURN_OFF = 0;
        public static final int ACTION_20_MINUTE = 1;
        public static final int ACTION_1_HOUR = 2;
        public static final int ACTION_2_HOUR = 3;
        public static final int ACTION_4_HOUR = 4;
        public static final int ACTION_8_HOUR = 5;
        public static final int ACTION_SET_TIME_PERIOD = 6;

        public SnoozedContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

