/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.videobox.fragment.ZMErrorMessageDialog;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomProductHelper;
import com.zipow.videobox.view.ConfNumberEditText;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.io.Serializable;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.videomeetings.R;
import us.zoom.videomeetings.ZMBuildConfig;

public class PMIModifyIDFragment
extends ZMFragment
implements View.OnClickListener,
TextView.OnEditorActionListener {
    private final String TAG = PMIModifyIDFragment.class.getSimpleName();
    private PTUI.SimpleMeetingMgrListener mMeetingMgrListener;
    private Button mBtnBack;
    private Button mBtnApply;
    private ConfNumberEditText mEdtConfNumber;
    private TextView mTxtInstructions;
    private ScheduledMeetingItem mMeetingItem;
    private int mPMIDigits = 10;

    public static void showInActivity(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        PMIModifyIDFragment f = PMIModifyIDFragment.newInstance();
        Bundle args = new Bundle();
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, PMIModifyIDFragment.class.getName()).commit();
    }

    public static PMIModifyIDFragment newInstance() {
        PMIModifyIDFragment f = new PMIModifyIDFragment();
        return f;
    }

    public static PMIModifyIDFragment findFragment(ZMActivity activity) {
        if (activity == null) {
            return null;
        }
        return (PMIModifyIDFragment)activity.getSupportFragmentManager().findFragmentByTag(PMIModifyIDFragment.class.getName());
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        if (this.mMeetingMgrListener == null) {
            this.mMeetingMgrListener = new PTUI.SimpleMeetingMgrListener(){

                @Override
                public void onListMeetingResult(int result) {
                    PMIModifyIDFragment.this.onListMeetingResult(result);
                }

                @Override
                public void onPMIEvent(int event, int result, MeetingInfo item) {
                    PMIModifyIDFragment.this.onPMIEvent(event, result, item);
                }
            };
        }
        PTUI.getInstance().addMeetingMgrListener(this.mMeetingMgrListener);
        this.updateUI();
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removeMeetingMgrListener(this.mMeetingMgrListener);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_pmi_modify_id, container, false);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnApply = (Button)view.findViewById(R.id.btnApply);
        this.mEdtConfNumber = (ConfNumberEditText)view.findViewById(R.id.edtConfNumber);
        this.mTxtInstructions = (TextView)view.findViewById(R.id.txtInstructions);
        if (Build.VERSION.SDK_INT < 11) {
            this.mEdtConfNumber.setGravity(3);
        }
        this.mBtnApply.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        TextWatcher watcher = new TextWatcher(){

            public void afterTextChanged(Editable s) {
                PMIModifyIDFragment.this.validateInput();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        };
        this.mEdtConfNumber.addTextChangedListener(watcher);
        if (this.mEdtConfNumber != null) {
            this.mEdtConfNumber.setImeOptions(6);
            this.mEdtConfNumber.setOnEditorActionListener(this);
        }
        return view;
    }

    private void validateInput() {
        this.mBtnApply.setEnabled(this.validateConfNumber());
    }

    private boolean validateConfNumber() {
        String str = this.mEdtConfNumber.getText().toString();
        str = str.replaceAll("\\s", "");
        String expr = ResourcesUtil.getString((Context)this.getActivity(), (int)R.string.zm_config_pmi_regex);
        if (expr != null) {
            try {
                if (!str.matches(expr)) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str.length() == this.mPMIDigits;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    private void updateUI() {
        int iLongIDFormatType = ResourcesUtil.getInteger((Context)this.getActivity(), (int)R.integer.zm_config_long_meeting_id_format_type, (int)1);
        if (ZMBuildConfig.BUILD_TARGET == 0) {
            int vendor = 0;
            ZoomProductHelper productHelper = PTApp.getInstance().getZoomProductHelper();
            if (productHelper != null) {
                vendor = productHelper.getCurrentVendor();
            }
            if (vendor == 1) {
                this.mPMIDigits = 11;
                this.mEdtConfNumber.setFormatType(iLongIDFormatType);
            } else {
                this.mPMIDigits = 10;
                this.mEdtConfNumber.setFormatType(0);
            }
        } else {
            this.mPMIDigits = ResourcesUtil.getInteger((Context)this.getActivity(), (int)R.integer.zm_config_pmi_digits_for_pso, (int)11);
        }
        if (this.mPMIDigits >= 11) {
            this.mTxtInstructions.setText(R.string.zm_lbl_personal_meeting_id_modify_instruction_11);
            this.mEdtConfNumber.setFormatType(iLongIDFormatType);
        } else {
            this.mTxtInstructions.setText(R.string.zm_lbl_personal_meeting_id_modify_instruction_10);
            this.mEdtConfNumber.setFormatType(0);
        }
        InputFilter[] filters = this.mEdtConfNumber.getFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (!(filters[i] instanceof InputFilter.LengthFilter)) continue;
            filters[i] = new InputFilter.LengthFilter(this.mPMIDigits + 2);
        }
        this.mEdtConfNumber.setFilters(filters);
        if (this.mMeetingItem == null) {
            this.mMeetingItem = this.getPersonalMeeting();
            if (this.mMeetingItem != null) {
                this.mEdtConfNumber.setText(StringUtil.formatConfNumber((long)this.mMeetingItem.getMeetingNo()));
                this.mEdtConfNumber.setSelection(this.mEdtConfNumber.getText().length());
                this.validateInput();
            }
        }
    }

    private ScheduledMeetingItem getPersonalMeeting() {
        MeetingInfo meetingInfo;
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper != null && (meetingInfo = meetingHelper.getPmiMeetingItem()) != null) {
            return ScheduledMeetingItem.fromMeetingInfo(meetingInfo);
        }
        return null;
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mBtnApply) {
            this.onClickBtnSave();
        }
    }

    private void onClickBtnSave() {
        long newNo;
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnApply);
        if (this.mMeetingItem == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showErrorMessage(5000);
            return;
        }
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper == null) {
            return;
        }
        long oldNo = this.mMeetingItem.getMeetingNo();
        if (oldNo == (newNo = this.getConfNumber())) {
            return;
        }
        boolean res = helper.modifyPMI(oldNo, newNo);
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showErrorMessage(5000);
        }
    }

    private long getConfNumber() {
        String number = this.mEdtConfNumber.getText().toString();
        if ((number = number.replaceAll("\\s", "")).length() > 0) {
            try {
                return Long.parseLong(number);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    private void onListMeetingResult(int result) {
        this.updateUI();
    }

    private void onPMIEvent(int event, int result, MeetingInfo item) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.dismissEditSuccess(ScheduledMeetingItem.fromMeetingInfo(item));
        } else {
            this.showErrorMessage(result);
        }
    }

    private void showWaitingDialog() {
        WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_waiting_edit_meeting);
        dialog.setCancelable(true);
        dialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
    }

    private void dismissWaitingDialog() {
        WaitingDialog dialog = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    public void dismissEditSuccess(ScheduledMeetingItem item) {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            Intent intent = new Intent();
            intent.putExtra("meetingItem", (Serializable)item);
            activity.setResult(-1, intent);
            activity.finish();
        }
    }

    private void onClickBtnBack() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.finish();
        }
    }

    private void showErrorMessage(int result) {
        String message = "";
        switch (result) {
            case 3015: 
            case 3016: {
                message = this.getString(R.string.zm_lbl_personal_meeting_id_change_fail_invalid);
                break;
            }
            case 5000: 
            case 5003: {
                message = this.getString(R.string.zm_lbl_profile_change_fail_cannot_connect_service);
                break;
            }
            case 3002: {
                message = this.getString(R.string.zm_lbl_personal_meeting_id_change_fail_meeting_started);
                break;
            }
            default: {
                message = this.getString(R.string.zm_lbl_personal_meeting_id_change_fail_unknown, new Object[]{result});
            }
        }
        String title = this.getString(R.string.zm_title_pmi_change_fail);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(message);
        ZMErrorMessageDialog.show(this.getFragmentManager(), title, messages, "PMIModifyIDFragment error dialog");
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 6: {
                this.onClickBtnSave();
                return true;
            }
        }
        return false;
    }
}

