/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.fragment.ScheduleChooseUserTypeFragment;
import com.zipow.videobox.fragment.ScheduleFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.io.Serializable;
import java.util.TimeZone;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class PMIEditFragment
extends ZMFragment
implements View.OnClickListener {
    private PTUI.SimpleMeetingMgrListener mMeetingMgrListener;
    private static final int REQUEST_MODIFY_ID = 100;
    private static final int REQUEST_JOIN_USER_TYPE = 2001;
    private Button mBtnBack;
    private Button mBtnSave;
    private TextView mTxtConfNumber;
    private EditText mEdtPassword;
    private CheckedTextView mChkEnableJBH;
    private View mOptionConfNumber;
    private View mOptionEnableJBH;
    private CheckedTextView mChkHostVideo;
    private CheckedTextView mChkAttendeeVideo;
    private TextView mTxtAudioOption;
    private View mOptionAudio;
    private View mOptionHostVideo;
    private View mOptionAttendeeVideo;
    private EditText mEdt3rdPartyAudioInfo;
    private View mOption3rdPartyAudioInfo;
    private View mOptionOnlySignJoin;
    private View mOptionJoinUserType;
    private TextView mTxtJoinUserType;
    private CheckedTextView mChkOnlySignJoin;
    private int mSelectedAudioOption = 2;
    private boolean mHostVideoOn = true;
    private boolean mAttendeeVideoOn = true;
    private String mJoinSpecifiedDomains;
    private int mJoinUserType;
    private ScheduledMeetingItem mMeetingItem;

    public static void showInActivity(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        PMIEditFragment f = PMIEditFragment.newInstance();
        Bundle args = new Bundle();
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, PMIEditFragment.class.getName()).commit();
    }

    public static PMIEditFragment newInstance() {
        PMIEditFragment f = new PMIEditFragment();
        return f;
    }

    public static PMIEditFragment findFragment(ZMActivity activity) {
        if (activity == null) {
            return null;
        }
        return (PMIEditFragment)activity.getSupportFragmentManager().findFragmentByTag(PMIEditFragment.class.getName());
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        if (this.mMeetingMgrListener == null) {
            this.mMeetingMgrListener = new PTUI.SimpleMeetingMgrListener(){

                @Override
                public void onListMeetingResult(int result) {
                    PMIEditFragment.this.onListMeetingResult(result);
                }

                @Override
                public void onPMIEvent(int event, int result, MeetingInfo item) {
                    PMIEditFragment.this.onPMIEvent(event, result, item);
                }
            };
        }
        PTUI.getInstance().addMeetingMgrListener(this.mMeetingMgrListener);
        this.updateUI();
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removeMeetingMgrListener(this.mMeetingMgrListener);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_pmi_edit, container, false);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnSave = (Button)view.findViewById(R.id.btnSave);
        this.mTxtConfNumber = (TextView)view.findViewById(R.id.txtConfNumber);
        this.mEdtPassword = (EditText)view.findViewById(R.id.edtPassword);
        this.mChkEnableJBH = (CheckedTextView)view.findViewById(R.id.chkEnableJBH);
        this.mOptionConfNumber = view.findViewById(R.id.optionConfNumber);
        this.mOptionEnableJBH = view.findViewById(R.id.optionEnableJBH);
        this.mChkHostVideo = (CheckedTextView)view.findViewById(R.id.chkHostVideo);
        this.mChkAttendeeVideo = (CheckedTextView)view.findViewById(R.id.chkAttendeeVideo);
        this.mTxtAudioOption = (TextView)view.findViewById(R.id.txtAudioOption);
        this.mOptionAudio = view.findViewById(R.id.optionAudio);
        this.mOptionHostVideo = view.findViewById(R.id.optionHostVideo);
        this.mOptionAttendeeVideo = view.findViewById(R.id.optionAttendeeVideo);
        this.mEdt3rdPartyAudioInfo = (EditText)view.findViewById(R.id.edt3rdPartyAudioInfo);
        this.mOption3rdPartyAudioInfo = view.findViewById(R.id.option3rdPartyAudioInfo);
        this.mChkOnlySignJoin = (CheckedTextView)view.findViewById(R.id.chkOnlySignJoin);
        this.mOptionOnlySignJoin = view.findViewById(R.id.optionOnlySignJoin);
        this.mOptionJoinUserType = view.findViewById(R.id.optionJoinUserType);
        this.mTxtJoinUserType = (TextView)view.findViewById(R.id.txtJoinUserType);
        this.mEdtPassword.setKeyListener((KeyListener)new ScheduleFragment.PasswordKeyListener());
        this.mBtnSave.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mOptionEnableJBH.setOnClickListener((View.OnClickListener)this);
        this.mOptionHostVideo.setOnClickListener((View.OnClickListener)this);
        this.mOptionAttendeeVideo.setOnClickListener((View.OnClickListener)this);
        this.mOptionAudio.setOnClickListener((View.OnClickListener)this);
        this.mOptionOnlySignJoin.setOnClickListener((View.OnClickListener)this);
        this.mOptionJoinUserType.setOnClickListener((View.OnClickListener)this);
        TextWatcher inputWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PMIEditFragment.this.mBtnSave.setEnabled(PMIEditFragment.this.validateInput());
            }
        };
        this.mEdtPassword.addTextChangedListener(inputWatcher);
        this.mEdt3rdPartyAudioInfo.addTextChangedListener(inputWatcher);
        if (savedInstanceState != null) {
            this.mChkEnableJBH.setChecked(savedInstanceState.getBoolean("enableJBH"));
            this.mHostVideoOn = savedInstanceState.getBoolean("mHostVideoOn");
            this.mAttendeeVideoOn = savedInstanceState.getBoolean("mAttendeeVideoOn");
            this.mSelectedAudioOption = savedInstanceState.getInt("mSelectedAudioOption");
            this.mChkOnlySignJoin.setChecked(savedInstanceState.getBoolean("mOnlySpecifiedDomainsJoin"));
            this.mJoinUserType = savedInstanceState.getInt("mJoinUserType");
            this.mJoinSpecifiedDomains = savedInstanceState.getString("mJoinSpecifiedDomains");
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.mTxtJoinUserType.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    PMIEditFragment.this.updateJoinUserType();
                }
            });
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("enableJBH", this.mChkEnableJBH.isChecked());
        outState.putBoolean("mHostVideoOn", this.mHostVideoOn);
        outState.putBoolean("mAttendeeVideoOn", this.mAttendeeVideoOn);
        outState.putInt("mSelectedAudioOption", this.mSelectedAudioOption);
        outState.putBoolean("mOnlySignJoin", this.mChkOnlySignJoin.isChecked());
        outState.putInt("mJoinUserType", this.mJoinUserType);
        outState.putString("mJoinSpecifiedDomains", this.mJoinSpecifiedDomains);
    }

    private void updateUI() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        boolean isOnlySignJoin = PTApp.getInstance().isSignedInUserMeetingOn();
        boolean isSpecifiedDomains = PTApp.getInstance().isSpecifiedDomainsMeetingOn();
        if (isSpecifiedDomains) {
            this.mOptionOnlySignJoin.setVisibility(8);
            this.mOptionJoinUserType.setVisibility(0);
        } else if (isOnlySignJoin) {
            this.mOptionOnlySignJoin.setVisibility(0);
            this.mOptionJoinUserType.setVisibility(8);
        } else {
            this.mOptionOnlySignJoin.setVisibility(8);
            this.mOptionJoinUserType.setVisibility(8);
        }
        if (this.mMeetingItem == null) {
            this.mMeetingItem = this.getPersonalMeeting();
            if (this.mMeetingItem != null) {
                this.mChkEnableJBH.setChecked(this.mMeetingItem.getCanJoinBeforeHost());
                String password = this.mMeetingItem.getPassword();
                this.mEdtPassword.setText((CharSequence)password);
                this.mHostVideoOn = !this.mMeetingItem.isHostVideoOff();
                boolean bl = this.mAttendeeVideoOn = !this.mMeetingItem.isAttendeeVideoOff();
                this.mSelectedAudioOption = this.mMeetingItem.isSelfTelephoneOn() ? (profile.hasSelfTelephony() ? 3 : (profile.isDisablePSTN() ? 0 : 2)) : (this.mMeetingItem.isTelephonyOff() || profile.isDisablePSTN() ? 0 : (this.mMeetingItem.isVoipOff() ? 1 : 2));
                this.mChkOnlySignJoin.setChecked(this.mMeetingItem.isOnlySignJoin());
                if (this.mMeetingItem.isOnlySignJoin()) {
                    String domains = this.mMeetingItem.getSpecialDomains();
                    if (!TextUtils.isEmpty((CharSequence)domains)) {
                        this.mJoinUserType = 3;
                        this.mJoinSpecifiedDomains = domains;
                    } else {
                        this.mJoinUserType = 2;
                    }
                } else {
                    this.mJoinUserType = 1;
                }
            }
        } else {
            this.mMeetingItem = this.getPersonalMeeting();
        }
        if (this.mMeetingItem != null) {
            long lMeetingNo = this.mMeetingItem.getMeetingNo();
            String sMeetingNo = String.valueOf(lMeetingNo);
            int iFormat = 0;
            if (sMeetingNo.length() > 10) {
                iFormat = ResourcesUtil.getInteger((Context)this.getActivity(), (int)R.integer.zm_config_long_meeting_id_format_type, (int)iFormat);
            }
            this.mTxtConfNumber.setText((CharSequence)StringUtil.formatConfNumber((long)lMeetingNo, (int)iFormat));
        }
        this.updateAudioOptions();
        this.updateJoinUserType();
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper != null) {
            this.checkShowVideoOptions(meetingHelper.alwaysUsePMI());
        }
        this.updateVideoOptions();
        this.mBtnSave.setEnabled(this.validateInput());
    }

    private void updateVideoOptions() {
        this.mChkHostVideo.setChecked(this.mHostVideoOn);
        this.mChkAttendeeVideo.setChecked(this.mAttendeeVideoOn);
    }

    private boolean updateAudioOptions() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null && profile.isDisablePSTN() && !profile.hasSelfTelephony()) {
            this.mOptionAudio.setVisibility(8);
            this.mOption3rdPartyAudioInfo.setVisibility(8);
            return false;
        }
        this.mOptionAudio.setVisibility(0);
        switch (this.mSelectedAudioOption) {
            case 0: {
                this.mTxtAudioOption.setText(R.string.zm_lbl_audio_option_voip);
                this.mOption3rdPartyAudioInfo.setVisibility(8);
                this.mBtnSave.setEnabled(this.validateInput());
                break;
            }
            case 1: {
                this.mTxtAudioOption.setText(R.string.zm_lbl_audio_option_telephony);
                this.mOption3rdPartyAudioInfo.setVisibility(8);
                this.mBtnSave.setEnabled(this.validateInput());
                break;
            }
            case 2: {
                this.mTxtAudioOption.setText(R.string.zm_lbl_audio_option_voip_and_telephony_detail);
                this.mOption3rdPartyAudioInfo.setVisibility(8);
                this.mBtnSave.setEnabled(this.validateInput());
                break;
            }
            case 3: {
                String info;
                this.mTxtAudioOption.setText(R.string.zm_lbl_audio_option_3rd_party);
                this.mOption3rdPartyAudioInfo.setVisibility(0);
                if (this.mEdt3rdPartyAudioInfo.getText().length() == 0 && profile != null && (info = profile.getMyTelephoneInfo()) != null) {
                    this.mEdt3rdPartyAudioInfo.setText((CharSequence)info);
                }
                this.mBtnSave.setEnabled(this.validateInput());
            }
        }
        return true;
    }

    private void updateJoinUserType() {
        if (this.mJoinUserType == 3 && TextUtils.isEmpty((CharSequence)this.mJoinSpecifiedDomains)) {
            this.mJoinUserType = 2;
        }
        switch (this.mJoinUserType) {
            case 2: {
                this.mTxtJoinUserType.setText(R.string.zm_lbl_allow_join_signed);
                break;
            }
            case 1: {
                this.mTxtJoinUserType.setText(R.string.zm_lbl_allow_join_everyone);
                break;
            }
            case 3: {
                String[] domains = this.mJoinSpecifiedDomains.split(";");
                StringBuilder builder = new StringBuilder();
                int width = this.mTxtJoinUserType.getMeasuredWidth();
                for (int i = 0; i < domains.length; ++i) {
                    String str = domains[i];
                    String label = width > 0 ? TextUtils.ellipsize((CharSequence)str, (TextPaint)this.mTxtJoinUserType.getPaint(), (float)width, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString() : str;
                    builder.append(label);
                    if (i == domains.length - 1) continue;
                    builder.append("\n");
                }
                this.mTxtJoinUserType.setText((CharSequence)builder.toString());
                break;
            }
        }
    }

    private void checkShowVideoOptions(boolean usePMIForInstantMeetings) {
        if (usePMIForInstantMeetings) {
            this.mOptionHostVideo.setVisibility(8);
            this.mOptionAttendeeVideo.setVisibility(8);
        } else {
            this.mOptionHostVideo.setVisibility(0);
            this.mOptionAttendeeVideo.setVisibility(0);
        }
    }

    private ScheduledMeetingItem getPersonalMeeting() {
        MeetingInfo meetingInfo;
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper != null && (meetingInfo = meetingHelper.getPmiMeetingItem()) != null) {
            return ScheduledMeetingItem.fromMeetingInfo(meetingInfo);
        }
        return null;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1) {
            this.dismiss(false);
        } else if (requestCode == 2001 && resultCode == -1 && data != null) {
            this.mJoinSpecifiedDomains = data.getStringExtra("EXTRA_SPECIFIED_DOMAINS");
            this.mJoinUserType = data.getIntExtra("EXTRA_JOIN_USER_TYPE", 2);
            this.updateJoinUserType();
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mOptionEnableJBH) {
            this.onClickEnableJBH();
        } else if (v == this.mBtnSave) {
            this.onClickBtnSave();
        } else if (v == this.mOptionHostVideo) {
            this.onClickChkHostVideo();
        } else if (v == this.mOptionAttendeeVideo) {
            this.onClickChkAttendeeVideo();
        } else if (v == this.mOptionAudio) {
            this.onClickOptionAudio();
        } else if (v == this.mOptionOnlySignJoin) {
            this.onClickOnlySignJoin();
        } else if (v == this.mOptionJoinUserType) {
            this.onClickOptionJoinUserType();
        }
    }

    private void onClickOptionJoinUserType() {
        ScheduleChooseUserTypeFragment.showInActivity((Fragment)this, 2001, this.mJoinUserType, this.mJoinSpecifiedDomains);
    }

    private void onClickOnlySignJoin() {
        this.mChkOnlySignJoin.setChecked(!this.mChkOnlySignJoin.isChecked());
    }

    private void onClickBtnSave() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mBtnSave);
        if (this.mMeetingItem == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showNormalErrorOrTimeoutDialog();
            return;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        MeetingInfo meetingInfo = new MeetingInfo();
        meetingInfo.setTopic(this.mMeetingItem.getTopic());
        meetingInfo.setPassword(this.getPassword());
        meetingInfo.setType(this.mMeetingItem.getMeetingType());
        meetingInfo.setStartTime(this.mMeetingItem.getStartTime() / 1000L);
        meetingInfo.setDuration(this.mMeetingItem.getDuration());
        meetingInfo.setCanJoinBeforeHost(this.mChkEnableJBH.isChecked());
        meetingInfo.setRepeatType(this.mMeetingItem.getRepeatType());
        meetingInfo.setRepeatEndTime(this.mMeetingItem.getRepeatEndTime() / 1000L);
        meetingInfo.setId(this.mMeetingItem.getId());
        meetingInfo.setMeetingNumber(this.mMeetingItem.getMeetingNo());
        meetingInfo.setMeetingStatus(this.mMeetingItem.getMeetingStatus());
        meetingInfo.setInviteEmailContent(this.mMeetingItem.getInvitationEmailContent());
        meetingInfo.setExtendMeetingType(this.mMeetingItem.getExtendMeetingType());
        boolean isOnlySignJoin = PTApp.getInstance().isSignedInUserMeetingOn();
        boolean isSpecifiedDomains = PTApp.getInstance().isSpecifiedDomainsMeetingOn();
        if (isSpecifiedDomains) {
            meetingInfo.setIsOnlySignJoin(this.mJoinUserType != 1);
            if (this.mJoinUserType == 3 && !TextUtils.isEmpty((CharSequence)this.mJoinSpecifiedDomains)) {
                meetingInfo.setSpecialDomains(this.mJoinSpecifiedDomains);
            }
        } else if (isOnlySignJoin) {
            meetingInfo.setIsOnlySignJoin(this.mChkOnlySignJoin.isChecked());
        }
        meetingInfo.setHostVideoOff(!this.mHostVideoOn);
        meetingInfo.setAttendeeVideoOff(!this.mAttendeeVideoOn);
        if (profile.hasSelfTelephony() && this.mSelectedAudioOption == 3) {
            meetingInfo.setIsSelfTelephonyOn(true);
            meetingInfo.setOtherTeleConfInfo(this.mEdt3rdPartyAudioInfo.getText().toString());
        } else {
            meetingInfo.setIsSelfTelephonyOn(false);
            if (profile.hasSelfTelephony() || !profile.isDisablePSTN()) {
                meetingInfo.setVoipOff(this.mSelectedAudioOption != 0 && this.mSelectedAudioOption != 2);
                meetingInfo.setTelephonyOff(this.mSelectedAudioOption != 1 && this.mSelectedAudioOption != 2);
            }
        }
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper == null) {
            return;
        }
        boolean res = helper.editMeeting(meetingInfo, TimeZone.getDefault().getID());
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showNormalErrorOrTimeoutDialog();
        }
    }

    private void onListMeetingResult(int result) {
        this.updateUI();
    }

    private void onPMIEvent(int event, int result, MeetingInfo item) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.dismissEditSuccess(ScheduledMeetingItem.fromMeetingInfo(item));
        } else if (result == 5003) {
            this.showNormalErrorOrTimeoutDialog();
        } else {
            this.showErrorCodeDialog(result);
        }
    }

    private void showWaitingDialog() {
        WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_waiting_edit_meeting);
        dialog.setCancelable(true);
        dialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
    }

    private void dismissWaitingDialog() {
        WaitingDialog dialog = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    public void dismissEditSuccess(ScheduledMeetingItem item) {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null) {
            Intent intent = new Intent();
            intent.putExtra("meetingItem", (Serializable)item);
            activity.setResult(-1, intent);
            activity.finish();
        }
    }

    private void onClickBtnBack() {
        this.dismiss(true);
    }

    private void dismiss(boolean animation) {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.finish();
            if (!animation) {
                activity.overridePendingTransition(0, 0);
            }
        }
    }

    private void onClickEnableJBH() {
        this.mChkEnableJBH.setChecked(!this.mChkEnableJBH.isChecked());
    }

    private void onClickChkHostVideo() {
        this.mChkHostVideo.setChecked(!this.mChkHostVideo.isChecked());
        this.mHostVideoOn = this.mChkHostVideo.isChecked();
    }

    private void onClickChkAttendeeVideo() {
        this.mChkAttendeeVideo.setChecked(!this.mChkAttendeeVideo.isChecked());
        this.mAttendeeVideoOn = this.mChkAttendeeVideo.isChecked();
    }

    private void onClickOptionAudio() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile == null) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        AudioOptionMenuItem item = null;
        item = new AudioOptionMenuItem(0, activity.getString(R.string.zm_lbl_audio_option_voip), this.mSelectedAudioOption == 0);
        menuAdapter.addItem((IZMMenuItem)item);
        if (!profile.isDisablePSTN()) {
            item = new AudioOptionMenuItem(1, activity.getString(R.string.zm_lbl_audio_option_telephony), this.mSelectedAudioOption == 1);
            menuAdapter.addItem((IZMMenuItem)item);
            if (!profile.isScheduleAudioBothDisabled()) {
                item = new AudioOptionMenuItem(2, activity.getString(R.string.zm_lbl_audio_option_voip_and_telephony), this.mSelectedAudioOption == 2);
                menuAdapter.addItem((IZMMenuItem)item);
            }
        }
        if (profile.hasSelfTelephony()) {
            item = new AudioOptionMenuItem(3, activity.getString(R.string.zm_lbl_audio_option_3rd_party), this.mSelectedAudioOption == 3);
            menuAdapter.addItem((IZMMenuItem)item);
        }
        menuAdapter.setShowSelectedStatus(true);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_lbl_audio_option_21201).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AudioOptionMenuItem mi = (AudioOptionMenuItem)((Object)menuAdapter.getItem(which));
                PMIEditFragment.this.onSelectAudioOptionMenuItem(mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectAudioOptionMenuItem(AudioOptionMenuItem mi) {
        this.mSelectedAudioOption = mi.getAction();
        this.updateAudioOptions();
    }

    private String getPassword() {
        return this.mEdtPassword.getText().toString();
    }

    private boolean validateInput() {
        boolean isPasswordValid = this.validatePassword(this.mEdtPassword.getText().toString().trim());
        boolean is3rdPartyAudioInfoValid = this.validata3rdPartyAudioInfo();
        return isPasswordValid && is3rdPartyAudioInfoValid;
    }

    private boolean validata3rdPartyAudioInfo() {
        if (this.mOption3rdPartyAudioInfo.isShown()) {
            return this.mEdt3rdPartyAudioInfo.getText().length() > 0;
        }
        return true;
    }

    public boolean validatePassword(String password) {
        return true;
    }

    private void showErrorCodeDialog(int errorCode) {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(this.getActivity().getString(R.string.zm_msg_edit_meeting_failed_unknown_error, new Object[]{errorCode}));
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    private void showNormalErrorOrTimeoutDialog() {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_edit_meeting_failed_normal_or_timeout);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    static class AudioOptionMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_VOIP = 0;
        public static final int ACTION_TELEPHONY = 1;
        public static final int ACTION_BOTH = 2;
        public static final int ACTION_3RD_PARTY = 3;

        public AudioOptionMenuItem(int action, String label, boolean selected) {
            super(action, label, null, selected);
        }
    }
}

