/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.AttentionTrackEventSinkUI;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.ZoomShareUI;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.confapp.meeting.PromoteOrDowngradeItem;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.fragment.InviteViaDialogFragment;
import com.zipow.videobox.fragment.PListItemActionDialog;
import com.zipow.videobox.fragment.meeting.PromoteOrDowngradeMockFragment;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.InviteContentGenerator;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.PListView;
import java.util.HashMap;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.UiModeUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.androidlib.widget.ZMTipLayer;
import us.zoom.template.Template;
import us.zoom.videomeetings.R;

public class PListFragment
extends ZMTipFragment
implements View.OnClickListener,
TextView.OnEditorActionListener,
ZMKeyboardDetector.KeyboardListener {
    private static final String TAG = PListFragment.class.getSimpleName();
    public static final int REQUEST_CHAT = 1000;
    public static final int REQUEST_INVITE_BUDDIES = 1001;
    public static final int REQUEST_INVITE_BY_PHONE = 1002;
    public static final int REQUEST_INVITE_ROOM_SYSTEM = 1003;
    public static final String ARG_ANCHOR_ID = "anchorId";
    public static final int DISPLAY_SEARCH_BAR_NUM = 7;
    public static final int USERID_EVEROYONE = 0;
    private int mAnchorId = 0;
    private PListView mPListView;
    private TextView mTxtTitle;
    private TextView mTxtUnreadMessageCount;
    private View mLayoutChatWithAll;
    private Button mBtnBack;
    private Button mBtnChatWithAll;
    private Button mBtnMuteAll;
    private Button mBtnUnmuteAll;
    private Button mBtnInvite;
    private ZMTipLayer mTipLayer;
    private View mPanelActions;
    private FrameLayout mListContainer;
    private EditText mEdtSearch;
    private boolean mBKeyboardOpen = false;
    private Button mBtnClearSearchView;
    private View mPanelTitleBar;
    private View mPanelSearchBar;
    private Drawable mDimmedForground = null;
    private Handler mHandler = new Handler();
    private ConfUI.IConfUIListener mConfUIListener;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private AttentionTrackEventSinkUI.IAttentionTrackEventSinkUIListener mAttentionTrackEventSinkUIListener;
    private ZoomShareUI.SimpleZoomShareUIListener mShareUIListener;
    private ZMAlertDialog mUnlockToInviteDialog;
    private long mlShowInviteOnMeetingUnlockedTriggerTime = 0L;
    private boolean isWebinar = false;
    private PromoteOrDowngradeMockFragment mPromoteOrDowngradeMockFragment;
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = PListFragment.this.mEdtSearch.getText().toString();
            PListFragment.this.mPListView.filter(key);
            if (key.length() > 0 && PListFragment.this.mPListView.getCount() > 0 || PListFragment.this.mPanelTitleBar.getVisibility() == 0) {
                PListFragment.this.mListContainer.setForeground(null);
            } else {
                PListFragment.this.mListContainer.setForeground(PListFragment.this.mDimmedForground);
            }
        }
    };

    public static void show(FragmentManager fm, int anchorId) {
        PListFragment f = PListFragment.getPListFragment(fm);
        if (f == null) {
            f = new PListFragment();
            Bundle args = new Bundle();
            args.putInt(ARG_ANCHOR_ID, anchorId);
            f.setArguments(args);
            f.show(fm, PListFragment.class.getName());
        } else {
            f.setTipVisible(true);
        }
    }

    public static PListFragment getPListFragment(FragmentManager fm) {
        return (PListFragment)fm.findFragmentByTag(PListFragment.class.getName());
    }

    public static boolean hide(FragmentManager fm) {
        PListFragment f = PListFragment.getPListFragment(fm);
        if (f != null) {
            if (!f.getShowsTip()) {
                f.dismiss();
                return true;
            }
            if (f.isTipVisible()) {
                f.setTipVisible(false);
                return true;
            }
        }
        return false;
    }

    public static boolean dismiss(FragmentManager fm) {
        PListFragment f = PListFragment.getPListFragment(fm);
        if (f != null) {
            f.dismiss();
            return true;
        }
        return false;
    }

    public void onResume() {
        super.onResume();
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    return PListFragment.this.onConfStatusChanged2(cmd, ret);
                }

                @Override
                public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
                    return PListFragment.this.onUserStatusChanged(cmd, userId);
                }

                @Override
                public boolean onUserEvent(int eventType, long userId, int flag) {
                    return PListFragment.this.onUserEvent(eventType, userId, flag);
                }

                @Override
                public boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
                    return PListFragment.this.onChatMessageReceived(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        if (this.mAttentionTrackEventSinkUIListener == null) {
            this.mAttentionTrackEventSinkUIListener = new AttentionTrackEventSinkUI.SimpleAttentionTrackEventSinkUIListener(){

                @Override
                public void OnUserAttentionStatusChanged(int nUserID, boolean bInAttentionMode) {
                    PListFragment.this.OnUserAttentionStatusChanged(nUserID, bInAttentionMode);
                }

                @Override
                public void OnConfAttentionTrackStatusChanged(boolean bEnabled) {
                    PListFragment.this.refresh();
                }
            };
        }
        AttentionTrackEventSinkUI.getInstance().addListener(this.mAttentionTrackEventSinkUIListener);
        if (this.mQAUIListener == null) {
            this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                @Override
                public void onWebinarAttendeeRaisedHand(long nodeID) {
                    PListFragment.this.attendeeRaiseOrLowerHand(nodeID);
                }

                @Override
                public void onWebinarAttendeeLowerHand(long nodeID) {
                    PListFragment.this.attendeeRaiseOrLowerHand(nodeID);
                }

                @Override
                public void onWebinarAttendeeGuestStatusChanged(long nodeID, boolean isGuest) {
                    PListFragment.this.onWebinarAttendeeGuestStatusChanged(nodeID);
                }
            };
        }
        ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        if (this.mShareUIListener == null) {
            this.mShareUIListener = new ZoomShareUI.SimpleZoomShareUIListener(){

                @Override
                public void OnStartViewPureComputerAudio(long nShareSourceID) {
                    PListFragment.this.refresh();
                }

                @Override
                public void OnStopViewPureComputerAudio(long nShareSourceID) {
                    PListFragment.this.refresh();
                }
            };
        }
        ZoomShareUI.getInstance().addListener(this.mShareUIListener);
        this.refresh();
    }

    public void onDestroy() {
        super.onDestroy();
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity.isFinishing()) {
            activity.finishActivity(1001);
            activity.finishActivity(1002);
            activity.finishActivity(1003);
        }
    }

    public void promoteOrDowngrade(PromoteOrDowngradeItem promoteOrDowngradeItem) {
        if (this.mPromoteOrDowngradeMockFragment != null) {
            this.mPromoteOrDowngradeMockFragment.promoteOrDowngrade(promoteOrDowngradeItem);
        }
    }

    public void updateAttendeeCount() {
        this.mPListView.updateAttendeeCount();
    }

    private boolean isHostOrCohost() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return false;
        }
        return myself.isHost() || myself.isCoHost() || myself.isBOModerator();
    }

    public void refresh() {
        this.mPListView.reloadAllItems();
        this.updateTitle();
        this.updateChatWithAllButton();
        this.updateActionButtons();
        this.updateBtnClearSearchView();
        this.updateAttendeeCount();
        this.mPListView.updateQAAnonymously();
    }

    @SuppressLint(value={"StringFormatMatches"})
    private void updateTitle() {
        String title;
        if (this.isWebinar) {
            int cntViewOnly = ConfMgr.getInstance().getViewOnlyUserCount();
            int cntPaneList = ConfMgr.getInstance().getClientUserCount();
            title = this.getActivity().getResources().getString(R.string.zm_title_plist, new Object[]{cntPaneList + cntViewOnly});
        } else {
            int count = this.isHostOrCohost() ? ConfMgr.getInstance().getClientUserCount() : ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount();
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            title = activity.getResources().getString(R.string.zm_title_plist, new Object[]{count});
        }
        this.mTxtTitle.setText((CharSequence)title);
    }

    public void onPause() {
        super.onPause();
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null || !UiModeUtil.isInDesktopMode((Context)activity) && !activity.isInMultiWindowMode()) {
            ConfUI.getInstance().removeListener(this.mConfUIListener);
            ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
            ZoomShareUI.getInstance().removeListener(this.mShareUIListener);
            AttentionTrackEventSinkUI.getInstance().removeListener(this.mAttentionTrackEventSinkUIListener);
        }
    }

    public void onStop() {
        super.onStop();
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity != null && (UiModeUtil.isInDesktopMode((Context)activity) || activity.isInMultiWindowMode())) {
            ConfUI.getInstance().removeListener(this.mConfUIListener);
            ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
            ZoomShareUI.getInstance().removeListener(this.mShareUIListener);
            AttentionTrackEventSinkUI.getInstance().removeListener(this.mAttentionTrackEventSinkUIListener);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isTipVisible", this.isTipVisible());
        if (this.mPromoteOrDowngradeMockFragment != null) {
            this.mPromoteOrDowngradeMockFragment.onSaveInstanceState(outState);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        CmmConfContext confContext;
        View view = inflater.inflate(R.layout.zm_plist_screen, container, false);
        this.mPromoteOrDowngradeMockFragment = new PromoteOrDowngradeMockFragment((Fragment)this);
        this.mPromoteOrDowngradeMockFragment.onCreateView(savedInstanceState);
        this.mPListView = (PListView)view.findViewById(R.id.plistView);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mTipLayer = (ZMTipLayer)view.findViewById(R.id.tipLayer);
        this.mBtnMuteAll = (Button)view.findViewById(R.id.btnMuteAll);
        this.mBtnUnmuteAll = (Button)view.findViewById(R.id.btnUnmuteAll);
        this.mBtnInvite = (Button)view.findViewById(R.id.btnInvite);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mPanelSearchBar = view.findViewById(R.id.panelSearchBar);
        this.mLayoutChatWithAll = view.findViewById(R.id.layoutChatWithAll);
        ZMKeyboardDetector keyboardDetector = (ZMKeyboardDetector)view.findViewById(R.id.keyboardDetector);
        this.mBtnChatWithAll = (Button)view.findViewById(R.id.btnChatWithAll);
        this.mTxtUnreadMessageCount = (TextView)view.findViewById(R.id.txtUnreadMessageCount);
        this.mPanelActions = view.findViewById(R.id.panelActions);
        this.mBtnChatWithAll.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnMuteAll.setOnClickListener((View.OnClickListener)this);
        this.mBtnUnmuteAll.setOnClickListener((View.OnClickListener)this);
        this.mBtnInvite.setOnClickListener((View.OnClickListener)this);
        if (this.mTipLayer != null) {
            this.mTipLayer.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return PListFragment.this.mTipLayer.dismissAllTips();
                }
            });
        }
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            this.mBtnBack.setVisibility(8);
        }
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                PListFragment.this.mHandler.removeCallbacks(PListFragment.this.mRunnableFilter);
                PListFragment.this.mHandler.postDelayed(PListFragment.this.mRunnableFilter, 300L);
                PListFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        keyboardDetector.setKeyboardListener((ZMKeyboardDetector.KeyboardListener)this);
        this.updateChatWithAllButton();
        this.updateActionButtons();
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        if ((confContext = ConfMgr.getInstance().getConfContext()) != null) {
            this.isWebinar = confContext.isWebinar();
        }
        return view;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = this.getView();
        if (view == null) {
            return null;
        }
        int width = UIUtil.dip2px((Context)context, (float)400.0f);
        if (UIUtil.getDisplayWidth((Context)context) < width) {
            width = UIUtil.getDisplayWidth((Context)context);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -2);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        ZMTip tip = new ZMTip(context);
        tip.setBackgroundColor(-263173);
        tip.setArrowSize(UIUtil.dip2px((Context)context, (float)30.0f), UIUtil.dip2px((Context)context, (float)11.0f));
        tip.setCornerArcSize(0);
        tip.addView(view);
        Bundle args = this.getArguments();
        this.mAnchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (this.mAnchorId > 0 && (anchor = this.getActivity().findViewById(this.mAnchorId)) != null) {
            tip.setAnchor(anchor, 1);
        }
        if (savedInstanceState != null) {
            boolean visible = savedInstanceState.getBoolean("isTipVisible", true);
            tip.setVisibility(visible ? 0 : 4);
        }
        return tip;
    }

    private boolean isInviteDisabled() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            ParamsList params = confContext.getAppContextParams();
            if (params == null) {
                return false;
            }
            return params.getBoolean("no_invite", false);
        }
        return false;
    }

    private boolean onConfStatusChanged2(int cmd, final long ret) {
        EventTaskManager eventTaskMgr;
        if (cmd == 3) {
            EventTaskManager eventTaskMgr2 = this.getEventTaskManager();
            if (eventTaskMgr2 != null) {
                eventTaskMgr2.pushLater("onConfLockStatusChanged", new EventAction("onConfLockStatusChanged"){

                    public void run(IUIElement ui) {
                        PListFragment f = (PListFragment)ui;
                        if (f != null) {
                            f.onConfLockStatusChanged();
                        }
                    }
                });
            }
        } else if (cmd == 86) {
            this.updateTitle();
            this.updateAttendeeCount();
        } else if (cmd == 74) {
            this.mPListView.reloadAllItems();
            this.updateActionButtons();
        } else if (cmd == 28) {
            this.onAllowAttendeeChatStatusChange();
        } else if (cmd == 30) {
            this.onQAAnonymouslyStatusChanged();
        } else if (cmd == 99) {
            EventTaskManager eventTaskMgr3 = this.getEventTaskManager();
            if (eventTaskMgr3 != null) {
                eventTaskMgr3.pushLater("onPromotePanelistResult", new EventAction("onPromotePanelistResult"){

                    public void run(IUIElement ui) {
                        if (PListFragment.this.mPromoteOrDowngradeMockFragment != null) {
                            PListFragment pListFragment;
                            PListFragment.this.mPromoteOrDowngradeMockFragment.onPromotePanelistResult((int)ret);
                            if (ret == 0L && (pListFragment = (PListFragment)ui) != null) {
                                pListFragment.onRemoveItem(PListFragment.this.mPromoteOrDowngradeMockFragment.getCurUserId());
                            }
                        }
                    }
                });
            }
        } else if (cmd == 100 && (eventTaskMgr = this.getEventTaskManager()) != null) {
            eventTaskMgr.push("onDePromotePanelist", new EventAction("onDePromotePanelist"){

                public void run(IUIElement ui) {
                    if (PListFragment.this.mPromoteOrDowngradeMockFragment != null) {
                        PListFragment pListFragment;
                        PListFragment.this.mPromoteOrDowngradeMockFragment.onDePromotePanelist((int)ret);
                        if (ret == 0L && (pListFragment = (PListFragment)ui) != null) {
                            pListFragment.onRemoveItem(PListFragment.this.mPromoteOrDowngradeMockFragment.getCurUserId());
                        }
                    }
                }
            });
        }
        return true;
    }

    protected void onConfLockStatusChanged() {
        this.updateActionButtons();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (this.mPromoteOrDowngradeMockFragment != null && confStatus != null && !confStatus.isConfLocked()) {
            this.mPromoteOrDowngradeMockFragment.onConfLockStatusChanged();
        }
        if (Math.abs(System.currentTimeMillis() - this.mlShowInviteOnMeetingUnlockedTriggerTime) < 5000L && confStatus != null && !confStatus.isConfLocked()) {
            this.onClickBtnInvite();
        }
    }

    private void onAllowAttendeeChatStatusChange() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null) {
            PListItemActionDialog.refreshAction(fm);
        }
    }

    private void onQAAnonymouslyStatusChanged() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (this.mPListView != null && myself != null && (myself.isHost() || myself.isCoHost())) {
            this.mPListView.updateQAAnonymously();
        }
    }

    private void OnUserAttentionStatusChanged(int nUserID, boolean bInAttentionMode) {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (this.mPListView != null && myself != null && (myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
            this.mPListView.onUserUpdate(-1, nUserID, false);
        }
    }

    private boolean onUserStatusChanged(int cmd, long userId) {
        this.mPListView.onUserUpdate(cmd, userId, cmd == 1 || cmd == 43 || cmd == 45);
        switch (cmd) {
            case 1: 
            case 43: {
                this.processOnHostOrCoHostChanged();
                break;
            }
            case 12: {
                AccessibilityManager accessibilityManager;
                FragmentActivity context = this.getActivity();
                if (context == null || (accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility")) != null && accessibilityManager.isEnabled()) break;
                this.updateUserAudioStatus(userId);
                break;
            }
            case 9: 
            case 21: {
                this.updateUserAudioStatus(userId);
                break;
            }
            case 25: {
                this.ccPrivilegeChange(userId);
            }
        }
        return true;
    }

    public void processOnHostOrCoHostChanged() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        boolean isCurUserHost = myself != null && myself.isHost();
        boolean isCurUserCoHost = myself != null && myself.isCoHost();
        this.updateTitle();
        this.updateActionButtons();
        this.mPListView.updateQAAnonymously();
        if (!isCurUserHost && !isCurUserCoHost && this.mUnlockToInviteDialog != null && this.mUnlockToInviteDialog.isShowing()) {
            this.mUnlockToInviteDialog.cancel();
        }
    }

    private boolean onUserEvent(final int eventType, final long userId, final int flag) {
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.push(new EventAction(){

                public void run(IUIElement ui) {
                    PListFragment f = (PListFragment)ui;
                    if (f != null) {
                        f.handleOnUserEvent(eventType, userId, flag);
                    }
                }
            });
        }
        return true;
    }

    private void handleOnUserEvent(int eventType, long userId, int flag) {
        switch (eventType) {
            case 0: {
                this.mPListView.onUserJoin(userId, flag);
                break;
            }
            case 1: {
                this.mPListView.onUserLeave(userId);
                break;
            }
            case 2: {
                this.mPListView.onUserUpdate(-1, userId, true);
                this.updateActionButtons();
            }
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PListFragment.this.mPListView.requestLayout();
                PListFragment.this.updateTitle();
            }
        });
        if (this.mPListView.getCount() >= 7) {
            this.mPanelSearchBar.setVisibility(0);
        }
    }

    private boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        if (!this.isWebinar) {
            this.mPListView.onUserUpdate(-1, sender, false);
            this.mPListView.onUserUpdate(-1, receiver, false);
        }
        if (this.isWebinar) {
            this.updateChatWithAllButton();
        }
        return false;
    }

    private void updateChatWithAllButton() {
        if (this.isWebinar) {
            int unReadCount = ConfMgr.getInstance().getUnreadChatMessageIndexes().length;
            this.mTxtUnreadMessageCount.setText((CharSequence)("" + unReadCount));
            this.mTxtUnreadMessageCount.setVisibility(unReadCount == 0 ? 8 : 0);
        } else {
            this.mTxtUnreadMessageCount.setVisibility(8);
            this.mBtnChatWithAll.setPadding(this.mBtnChatWithAll.getPaddingLeft(), this.mBtnChatWithAll.getPaddingTop(), this.mBtnChatWithAll.getPaddingLeft(), this.mBtnChatWithAll.getPaddingBottom());
        }
    }

    private void updateActionButtons() {
        boolean noButtons = true;
        CmmUser myself = ConfMgr.getInstance().getMyself();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        if (myself != null && (myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
            this.mBtnMuteAll.setVisibility(0);
            this.mBtnUnmuteAll.setVisibility(0);
            noButtons = false;
        } else {
            this.mBtnMuteAll.setVisibility(8);
            this.mBtnUnmuteAll.setVisibility(8);
        }
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (this.isInviteDisabled() || boMgr != null && boMgr.isInBOMeeting()) {
            this.mBtnInvite.setVisibility(8);
        } else {
            this.mBtnInvite.setVisibility(0);
            noButtons = false;
        }
        if (confContext.isChatOff()) {
            this.mLayoutChatWithAll.setVisibility(8);
        } else {
            this.mLayoutChatWithAll.setVisibility(0);
            noButtons = false;
        }
        this.mPanelActions.setVisibility(noButtons ? 8 : 0);
    }

    private void updateUserAudioStatus(long userId) {
        this.mPListView.updateUser(userId, true);
    }

    private void attendeeRaiseOrLowerHand(long nodeId) {
        this.mPListView.updateUser(nodeId, true);
    }

    private void onWebinarAttendeeGuestStatusChanged(long nodeId) {
        this.mPListView.updateUser(nodeId, true);
    }

    private void ccPrivilegeChange(long userId) {
        this.mPListView.ccPrivilegeChange(userId);
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    public boolean onSearchRequested() {
        if (this.getView() == null) {
            return true;
        }
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        this.mPanelTitleBar.setVisibility(8);
        this.mPanelSearchBar.setVisibility(0);
        this.mPListView.setInSearchProgress(true);
        this.mListContainer.setForeground(this.mDimmedForground);
        this.mEdtSearch.requestFocus();
        return true;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    public void onKeyboardOpen() {
        this.mBKeyboardOpen = true;
    }

    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mBKeyboardOpen = false;
        if (this.mPListView.getCount() == 0 || this.mEdtSearch.getText().length() == 0) {
            this.mEdtSearch.setText((CharSequence)"");
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBar.setVisibility(4);
            this.mPListView.setInSearchProgress(false);
        }
        this.mListContainer.setForeground(null);
        this.mPListView.post(new Runnable(){

            @Override
            public void run() {
                PListFragment.this.mPListView.requestLayout();
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnChatWithAll) {
            this.onClickBtnChatWidthAll();
        } else if (id2 == R.id.btnMuteAll) {
            this.onClickBtnMuteAll();
        } else if (id2 == R.id.btnUnmuteAll) {
            this.onClickBtnUnmuteAll();
        } else if (id2 == R.id.btnInvite) {
            this.onClickBtnInvite();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        }
    }

    private void onClickBtnBack() {
        if (this.getShowsTip()) {
            this.setTipVisible(false);
        } else {
            this.dismiss();
        }
    }

    private void onClickBtnChatWidthAll() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        ConfLocalHelper.showChatUI(activity, 0L);
    }

    private void onClickBtnMuteAll() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        LayoutInflater inflator = LayoutInflater.from((Context)activity);
        View contentView = inflator.inflate(R.layout.zm_mute_all_confirm, null, false);
        final CheckBox chkBox = (CheckBox)contentView.findViewById(R.id.check);
        chkBox.setChecked(!ConfMgr.getInstance().disabledAttendeeUnmuteSelf());
        ZMAlertDialog alertDlg = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_msg_mute_all_confirm).setView(contentView).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (ConfMgr.getInstance().handleUserCmd(48, 0L) && AccessibilityUtil.isSpokenFeedbackEnabled((Context)PListFragment.this.getContext())) {
                    AccessibilityUtil.announceForAccessibilityCompat((View)PListFragment.this.mBtnUnmuteAll, (int)R.string.zm_accessibility_muted_all_23049);
                }
                if (chkBox.isChecked()) {
                    ConfMgr.getInstance().handleConfCmd(82);
                } else {
                    ConfMgr.getInstance().handleConfCmd(83);
                }
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setCancelable(true).create();
        alertDlg.show();
    }

    private void onClickBtnUnmuteAll() {
        if (ConfMgr.getInstance().handleUserCmd(49, 0L) && AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getContext())) {
            AccessibilityUtil.announceForAccessibilityCompat((View)this.mBtnUnmuteAll, (int)R.string.zm_accessibility_unmuted_all_23049);
        }
    }

    private void onClickBtnInvite() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isConfLocked()) {
            this.showCannotInviteForMeetingLocked();
            return;
        }
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        if (meetingInfo == null) {
            return;
        }
        String url = meetingInfo.getJoinMeetingUrl();
        long meetingId = meetingInfo.getMeetingNumber();
        String password = meetingInfo.getPassword();
        String rawPassword = confContext.getRawMeetingPassword();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("joinMeetingUrl", url);
        config.put("meetingId", String.valueOf(meetingId));
        Template template = new Template(this.getString(R.string.zm_msg_sms_invite_in_meeting));
        String smsContent = template.format(config);
        String subject = meetingInfo.getInviteEmailSubject();
        String content = meetingInfo.getInviteEmailContent();
        String myName = "";
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null) {
            myName = myself.getScreenName();
        }
        String className = ResourcesUtil.getString((Context)this.getActivity(), (int)R.string.zm_config_invite_content_generator);
        try {
            String genSmsContent;
            String genEmailContent;
            Class<?> clazz = Class.forName(className);
            InviteContentGenerator generator = (InviteContentGenerator)clazz.newInstance();
            String genEmailTopic = generator.genEmailTopic((Context)VideoBoxApplication.getInstance(), meetingId, url, myName, password, rawPassword);
            if (!StringUtil.isEmptyOrNull((String)genEmailTopic)) {
                subject = genEmailTopic;
            }
            if (!StringUtil.isEmptyOrNull((String)(genEmailContent = generator.genEmailContent((Context)VideoBoxApplication.getInstance(), meetingId, url, myName, password, rawPassword)))) {
                content = genEmailContent;
            }
            if (!StringUtil.isEmptyOrNull((String)(genSmsContent = generator.genSmsContent((Context)VideoBoxApplication.getInstance(), meetingId, url, myName, password, rawPassword)))) {
                smsContent = genSmsContent;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtil.isEmptyOrNull((String)subject)) {
            subject = this.getResources().getString(R.string.zm_title_invite_email_topic);
        }
        InviteViaDialogFragment.show(this.getFragmentManager(), subject, content, smsContent, url, meetingId, password, rawPassword, 1001, 1002, 1003);
    }

    private void showCannotInviteForMeetingLocked() {
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_msg_cannot_invite_for_meeting_is_locked).setCancelable(true);
        CmmUser myself = ConfMgr.getInstance().getMyself();
        boolean needDismissOnHostChanged = false;
        if (myself != null && (myself.isHost() || myself.isCoHost())) {
            builder.setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_mi_unlock_meeting, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PListFragment.this.mlShowInviteOnMeetingUnlockedTriggerTime = System.currentTimeMillis();
                    ConfMgr.getInstance().handleConfCmd(57);
                }
            });
            needDismissOnHostChanged = true;
        } else {
            builder.setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            });
        }
        ZMAlertDialog dlg = builder.create();
        dlg.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                PListFragment.this.mUnlockToInviteDialog = null;
            }
        });
        dlg.show();
        if (needDismissOnHostChanged) {
            this.mUnlockToInviteDialog = dlg;
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        if (!this.mBKeyboardOpen) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBar.setVisibility(4);
            this.mPListView.setInSearchProgress(false);
            this.mListContainer.setForeground(null);
        }
    }

    public void dismiss() {
        if (this.getShowsTip()) {
            super.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private boolean isTipVisible() {
        ZMTip tip = this.getTip();
        if (tip != null) {
            return tip.getVisibility() == 0;
        }
        return false;
    }

    private void setTipVisible(boolean visible) {
        ZMTip tip = this.getTip();
        if (tip != null && tip.getVisibility() == 0 != visible) {
            tip.setVisibility(visible ? 0 : 4);
            if (visible) {
                Animation fadeIn = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.zm_tip_fadein);
                tip.startAnimation(fadeIn);
            } else {
                ((ConfActivity)this.getActivity()).onPListTipClosed();
            }
        }
    }

    private void onRemoveItem(long userId) {
        if (userId < 0L) {
            return;
        }
        this.mPListView.onUserLeave(userId);
        this.mPListView.updateAttendeeCount();
    }
}

