/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.fragment.NonVerbalFeedbackListFragment;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class NonVerbalFeedbackPromptTip
extends ZMTipFragment
implements View.OnClickListener {
    private View mOptionRaiseHand;
    private TextView mTxtRaiseHandCnt;
    private View mOptionYes;
    private TextView mTxtYesCnt;
    private View mOptionNo;
    private TextView mTxtNoCnt;
    private View mOptionFaster;
    private TextView mTxtFasterCnt;
    private View mOptionSlower;
    private TextView mTxtSlowerCnt;
    private View mOptionEmojis;
    private TextView mTxtEmojisCnt;
    private View mPanelFeedback;
    private ConfUI.IConfUIListener mConfUIListener;

    public static void show(FragmentManager fm, long time) {
        if (fm == null) {
            return;
        }
        NonVerbalFeedbackPromptTip.dismiss(fm);
        Bundle args = new Bundle();
        NonVerbalFeedbackPromptTip tip = new NonVerbalFeedbackPromptTip();
        tip.setArguments(args);
        tip.show(fm, NonVerbalFeedbackPromptTip.class.getName(), time);
    }

    public static NonVerbalFeedbackPromptTip getTip(FragmentManager fm) {
        if (fm == null) {
            return null;
        }
        return (NonVerbalFeedbackPromptTip)fm.findFragmentByTag(NonVerbalFeedbackPromptTip.class.getName());
    }

    public static boolean dismiss(FragmentManager fm) {
        NonVerbalFeedbackPromptTip tip = NonVerbalFeedbackPromptTip.getTip(fm);
        if (tip == null) {
            return false;
        }
        tip.dismiss();
        return true;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View view = layoutInflater.inflate(R.layout.zm_non_verbal_feedback_prompt, null);
        this.mOptionRaiseHand = view.findViewById(R.id.optionRaiseHand);
        this.mTxtRaiseHandCnt = (TextView)view.findViewById(R.id.txtRaiseHandCnt);
        this.mOptionYes = view.findViewById(R.id.optionYes);
        this.mTxtYesCnt = (TextView)view.findViewById(R.id.txtYesCnt);
        this.mOptionNo = view.findViewById(R.id.optionNo);
        this.mTxtNoCnt = (TextView)view.findViewById(R.id.txtNoCnt);
        this.mOptionFaster = view.findViewById(R.id.optionFaster);
        this.mTxtFasterCnt = (TextView)view.findViewById(R.id.txtFastCnt);
        this.mOptionSlower = view.findViewById(R.id.optionSlower);
        this.mTxtSlowerCnt = (TextView)view.findViewById(R.id.txtSlowCnt);
        this.mOptionEmojis = view.findViewById(R.id.optionEmojis);
        this.mTxtEmojisCnt = (TextView)view.findViewById(R.id.txtEmojisCnt);
        this.mPanelFeedback = view.findViewById(R.id.panelFeedback);
        if (this.mPanelFeedback != null) {
            this.mPanelFeedback.setOnClickListener((View.OnClickListener)this);
        }
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        tip.setCornerArcSize(UIUtil.dip2px((Context)context, (float)10.0f));
        tip.setLayoutGravity(3, UIUtil.dip2px((Context)context, (float)60.0f));
        tip.setBackgroundColor(context.getResources().getColor(R.color.zm_message_tip_background));
        tip.setBorderColor(context.getResources().getColor(R.color.zm_message_tip_border));
        tip.setShadow(4.0f, 0, 0, context.getResources().getColor(R.color.zm_message_tip_shadow));
        return tip;
    }

    public void onResume() {
        super.onResume();
        if (this.mConfUIListener == null) {
            this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                @Override
                public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
                    if (cmd == 39) {
                        NonVerbalFeedbackPromptTip.this.sinkFeedbackChanged(userId);
                    } else if (cmd == 35) {
                        NonVerbalFeedbackPromptTip.this.sinkUserRaiseLowerHand(userId, true);
                    } else if (cmd == 36) {
                        NonVerbalFeedbackPromptTip.this.sinkUserRaiseLowerHand(userId, false);
                    }
                    return true;
                }

                @Override
                public boolean onConfStatusChanged2(int cmd, long ret) {
                    if (cmd == 92) {
                        NonVerbalFeedbackPromptTip.this.sinkFeedbackAllCleared();
                    }
                    return true;
                }
            };
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        this.update();
    }

    protected void sinkUserRaiseLowerHand(final long userId, final boolean raise) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackIndicatorTipHand", new EventAction("onRaiseLowerHand"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackPromptTip)ui).onRaiseLowerHand(userId, raise);
                }
            });
        }
    }

    protected void onRaiseLowerHand(long userId, boolean b) {
        this.update();
    }

    protected void sinkFeedbackAllCleared() {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackPromptTipCleared", new EventAction("onFeedbackAllCleared"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackPromptTip)ui).onFeedbackAllCleared();
                }
            });
        }
    }

    protected void onFeedbackAllCleared() {
        this.dismiss();
    }

    public void onPause() {
        super.onPause();
        ConfUI.getInstance().removeListener(this.mConfUIListener);
    }

    protected void sinkFeedbackChanged(final long userId) {
        EventTaskManager eventTaskMgr = this.getEventTaskManager();
        if (eventTaskMgr != null) {
            eventTaskMgr.push("NonVerbalFeedbackPromptTipChanged", new EventAction("onFeedbackChanged"){

                public void run(IUIElement ui) {
                    ((NonVerbalFeedbackPromptTip)ui).onFeedbackChanged(userId);
                }
            });
        }
    }

    protected void onFeedbackChanged(long userId) {
        this.update();
    }

    public void update() {
        CmmFeedbackMgr feedbackMgr = ConfMgr.getInstance().getFeedbackMgr();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (feedbackMgr == null || confContext == null) {
            return;
        }
        boolean enable = confContext.isFeedbackEnable();
        if (!enable) {
            this.mOptionRaiseHand.setVisibility(8);
            this.mOptionYes.setVisibility(8);
            this.mOptionNo.setVisibility(8);
            this.mOptionSlower.setVisibility(8);
            this.mOptionFaster.setVisibility(8);
            this.mOptionEmojis.setVisibility(8);
            return;
        }
        int count = feedbackMgr.getAllFeedbackCount();
        if (count <= 0) {
            this.dismiss();
        }
        int raisehandCnt = feedbackMgr.getFeedbackCount(1);
        int yesCnt = feedbackMgr.getFeedbackCount(2);
        int noCnt = feedbackMgr.getFeedbackCount(3);
        int slowerCnt = feedbackMgr.getFeedbackCount(5);
        int fasterCnt = feedbackMgr.getFeedbackCount(4);
        int emojisCnt = feedbackMgr.getEmojiFeedbackCount();
        if (raisehandCnt > 0) {
            this.mOptionRaiseHand.setVisibility(0);
            this.mTxtRaiseHandCnt.setText((CharSequence)String.valueOf(raisehandCnt));
        } else {
            this.mOptionRaiseHand.setVisibility(8);
        }
        if (yesCnt > 0) {
            this.mOptionYes.setVisibility(0);
            this.mTxtYesCnt.setText((CharSequence)String.valueOf(yesCnt));
        } else {
            this.mOptionYes.setVisibility(8);
        }
        if (noCnt > 0) {
            this.mOptionNo.setVisibility(0);
            this.mTxtNoCnt.setText((CharSequence)String.valueOf(noCnt));
        } else {
            this.mOptionNo.setVisibility(8);
        }
        if (slowerCnt > 0) {
            this.mOptionSlower.setVisibility(0);
            this.mTxtSlowerCnt.setText((CharSequence)String.valueOf(slowerCnt));
        } else {
            this.mOptionSlower.setVisibility(8);
        }
        if (fasterCnt > 0) {
            this.mOptionFaster.setVisibility(0);
            this.mTxtFasterCnt.setText((CharSequence)String.valueOf(fasterCnt));
        } else {
            this.mOptionFaster.setVisibility(8);
        }
        if (emojisCnt > 0) {
            this.mOptionEmojis.setVisibility(0);
            this.mTxtEmojisCnt.setText((CharSequence)String.valueOf(emojisCnt));
        } else {
            this.mOptionEmojis.setVisibility(8);
        }
    }

    public void onClick(View v) {
        NonVerbalFeedbackListFragment.showAsActivity((ZMActivity)this.getActivity());
        this.dismiss();
    }
}

