/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.NewGroupChatFragment;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.MMSelectSessionListView;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMSelectSessionFragment
extends ZMFragment
implements View.OnClickListener,
TextView.OnEditorActionListener,
ABContactsCache.IABContactsCacheListener {
    private final String TAG = MMSelectSessionFragment.class.getSimpleName();
    public static final int REQUEST_MM_NEW_CHAT = 100;
    public static final int REQUEST_MM_NEW_GROUP_CHAT = 101;
    private static final String ARG_ACTION_SEND_INTENT = "actionSendIntent";
    private MMSelectSessionListView mChatsListView;
    private EditText mEdtSearch;
    private Button mBtnClearSearchView;
    private View mBtnNewChat;
    private View mBtnNewGroup;
    private View mPanelConnectionAlert;
    private TextView mTxtNetworkAlert;
    private TextView mTxtTitle;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private View mPanelSearch;
    private Drawable mDimmedForground = null;
    private Handler mHandler = new Handler();
    private BroadcastReceiver mNetworkStateReceiver;
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = MMSelectSessionFragment.this.mEdtSearch.getText().toString();
            MMSelectSessionFragment.this.mChatsListView.filter(key);
            if (key.length() > 0 && MMSelectSessionFragment.this.mChatsListView.getCount() > 0 || MMSelectSessionFragment.this.mPanelTitleBar.getVisibility() == 0) {
                MMSelectSessionFragment.this.mListContainer.setForeground(null);
            } else {
                MMSelectSessionFragment.this.mListContainer.setForeground(MMSelectSessionFragment.this.mDimmedForground);
            }
        }
    };
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onBeginConnect() {
            MMSelectSessionFragment.this.onBeginConnect();
        }

        @Override
        public void onConnectReturn(int errorCode) {
            MMSelectSessionFragment.this.onConnectReturn(errorCode);
        }

        @Override
        public void onIndicateBuddyInfoUpdated(String phoneNumber) {
            MMSelectSessionFragment.this.onIndicateBuddyInfoUpdated(phoneNumber);
        }

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
            MMSelectSessionFragment.this.onIndicateBuddyInfoUpdatedWithJID(jid);
        }

        @Override
        public void onIndicateBuddyListUpdated() {
            MMSelectSessionFragment.this.onIndicateBuddyListUpdated();
        }

        @Override
        public void onGroupAction(int result, GroupAction action, String msgId) {
            MMSelectSessionFragment.this.onGroupAction(result, action, msgId);
        }

        @Override
        public void onNotify_ChatSessionListUpdate() {
            MMSelectSessionFragment.this.onNotify_ChatSessionListUpdate();
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
            MMSelectSessionFragment.this.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }
    };
    private ZMAlertDialog mStreamConflictDialog;

    public static void showSendTo(ZMActivity activity, Intent actionSendIntent) {
        Bundle args = new Bundle();
        args.putParcelable(ARG_ACTION_SEND_INTENT, (Parcelable)actionSendIntent);
        SimpleActivity.show(activity, MMSelectSessionFragment.class.getName(), args, 0, false, 1);
    }

    private Intent getActionSendIntent() {
        Bundle args = this.getArguments();
        if (args != null) {
            Intent intent = (Intent)args.getParcelable(ARG_ACTION_SEND_INTENT);
            return intent;
        }
        return null;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_select_session_list, container, false);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mChatsListView = (MMSelectSessionListView)view.findViewById(R.id.chatsListView);
        this.mBtnNewChat = view.findViewById(R.id.btnNewChat);
        this.mBtnNewGroup = view.findViewById(R.id.btnNewGroup);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelConnectionAlert = view.findViewById(R.id.panelConnectionAlert);
        this.mTxtNetworkAlert = (TextView)view.findViewById(R.id.txtNetworkAlert);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mPanelSearch = view.findViewById(R.id.panelSearch);
        this.mChatsListView.setParentFragment(this);
        this.mBtnNewChat.setOnClickListener((View.OnClickListener)this);
        this.mBtnNewGroup.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mPanelConnectionAlert.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                MMSelectSessionFragment.this.mHandler.removeCallbacks(MMSelectSessionFragment.this.mRunnableFilter);
                MMSelectSessionFragment.this.mHandler.postDelayed(MMSelectSessionFragment.this.mRunnableFilter, 300L);
                MMSelectSessionFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.onKeyboardClosed();
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mPanelSearch.setVisibility(8);
        }
        return view;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    private void updatePanelConnectionAlert() {
        if (!PTApp.getInstance().hasZoomMessenger()) {
            this.mPanelConnectionAlert.setVisibility(8);
            return;
        }
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            switch (ZoomMessengerUI.getInstance().getConnectionStatus()) {
                case -1: 
                case 1: 
                case 2: {
                    this.mPanelConnectionAlert.setVisibility(8);
                    break;
                }
                case 0: {
                    this.mPanelConnectionAlert.setVisibility(0);
                    if (this.mTxtNetworkAlert == null) break;
                    this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_stream_conflict);
                }
            }
        } else {
            this.mPanelConnectionAlert.setVisibility(0);
            if (this.mTxtNetworkAlert != null) {
                this.mTxtNetworkAlert.setText(R.string.zm_mm_msg_network_unavailable);
            }
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearch.hasFocus()) {
            this.mEdtSearch.setCursorVisible(true);
            this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_focused);
            this.mPanelTitleBar.setVisibility(8);
            this.mListContainer.setForeground(this.mDimmedForground);
        }
    }

    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearch.setCursorVisible(false);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_normal);
        this.mListContainer.setForeground(null);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MMSelectSessionFragment.this.isResumed()) {
                    MMSelectSessionFragment.this.mPanelTitleBar.setVisibility(0);
                }
            }
        });
    }

    public void onResume() {
        super.onResume();
        if (PTApp.getInstance().hasZoomMessenger()) {
            this.mBtnNewChat.setVisibility(0);
            this.mBtnNewGroup.setVisibility(0);
        } else {
            this.mBtnNewChat.setVisibility(4);
            this.mBtnNewGroup.setVisibility(4);
        }
        if (this.mChatsListView != null) {
            this.mChatsListView.onParentFragmentResume();
        }
        this.updateTitle();
        this.updateBtnClearSearchView();
        this.updatePanelConnectionAlert();
        this.startToListenNetworkEvent();
        ABContactsCache.getInstance().addListener(this);
        if (ABContactsCache.getInstance().needReloadAll()) {
            ABContactsCache.getInstance().reloadAllContacts();
        }
    }

    public void onStart() {
        super.onStart();
        if (this.mChatsListView != null) {
            this.mChatsListView.onParentFragmentStart();
        }
    }

    private void updateTitle() {
        switch (ZoomMessengerUI.getInstance().getConnectionStatus()) {
            case -1: 
            case 0: 
            case 1: {
                if (this.mTxtTitle == null) break;
                this.mTxtTitle.setText(R.string.zm_mm_title_send_to);
                break;
            }
            case 2: {
                if (this.mTxtTitle == null) break;
                this.mTxtTitle.setText(R.string.zm_mm_title_chats_connecting);
            }
        }
        if (this.mTxtTitle != null) {
            this.mTxtTitle.getParent().requestLayout();
        }
    }

    private void startToListenNetworkEvent() {
        if (this.mNetworkStateReceiver == null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            this.mNetworkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    MMSelectSessionFragment.this.updatePanelConnectionAlert();
                }
            };
            context.registerReceiver(this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void stopToListenNetworkEvent() {
        if (this.mNetworkStateReceiver != null) {
            FragmentActivity context = this.getActivity();
            if (context == null) {
                return;
            }
            context.unregisterReceiver(this.mNetworkStateReceiver);
            this.mNetworkStateReceiver = null;
        }
    }

    @Override
    public void onContactsCacheUpdated() {
        if (this.mChatsListView != null) {
            this.mChatsListView.loadData(false);
            this.mChatsListView.notifyDataSetChanged(true);
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mChatsListView != null) {
            this.mChatsListView.onParentFragmentPause();
        }
        this.stopToListenNetworkEvent();
        ABContactsCache.getInstance().removeListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void dismiss() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.finish();
        }
    }

    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null) {
            ArrayList abItems = (ArrayList)data.getSerializableExtra("selectedItems");
            if (abItems == null || abItems.size() == 0) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            if (abItems.size() == 1) {
                IMAddrBookItem item = (IMAddrBookItem)abItems.get(0);
                ZoomBuddy buddy = messenger.getBuddyWithJID(item.getJid());
                if (buddy == null) {
                    return;
                }
                this.startOneToOneChat(buddy);
            } else {
                this.makeGroup(messenger, abItems, "", 80);
            }
        } else if (requestCode == 101 && resultCode == -1 && data != null) {
            ArrayList abItems;
            String groupName = data.getStringExtra("group.subject");
            if (groupName == null) {
                groupName = "";
            }
            if ((abItems = (ArrayList)data.getSerializableExtra("selectedItems")) == null || abItems.size() == 0) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            this.makeGroup(messenger, abItems, groupName, 8);
        }
    }

    public void makeGroup(ZoomMessenger messenger, ArrayList<IMAddrBookItem> abItems, String groupName, int mucType) {
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String myJid = myself.getJid();
        if (StringUtil.isEmptyOrNull((String)myJid)) {
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (int i = 0; i < abItems.size(); ++i) {
            IMAddrBookItem item = abItems.get(i);
            String jid = item.getJid();
            if (StringUtil.isEmptyOrNull((String)jid)) continue;
            buddies.add(jid);
        }
        buddies.add(myJid);
        if (buddies.size() == 0) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        PTAppProtos.MakeGroupResult result = messenger.makeGroup(buddies, groupName, mucType);
        if (result != null && result.getResult()) {
            if (result.getValid()) {
                String groupId = result.getReusableGroupId();
                if (StringUtil.isEmptyOrNull((String)groupId)) {
                    return;
                }
                this.startGroupChat(groupId);
            } else {
                this.showWaitingMakeGroupDialog();
            }
        } else {
            this.showMakeGroupFailureMessage(1);
        }
    }

    public void startOneToOneChat(ZoomBuddy buddy) {
        MMChatActivity.showAsOneToOneChat((ZMActivity)this.getActivity(), buddy, this.getActionSendIntent());
        this.dismiss();
    }

    public void startGroupChat(String groupId) {
        MMChatActivity.showAsGroupChat((ZMActivity)this.getActivity(), groupId, this.getActionSendIntent());
        this.dismiss();
    }

    public void onClick(View v) {
        if (v == this.mBtnNewChat) {
            this.startNewChat();
        } else if (v == this.mBtnNewGroup) {
            this.startNewGroupChat();
        } else if (v == this.mBtnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (v == this.mPanelConnectionAlert) {
            this.onClickPanelConnectionAlert();
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    private void onClickPanelConnectionAlert() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (!NetworkUtil.hasDataNetwork((Context)activity)) {
            Toast.makeText((Context)activity, (int)R.string.zm_alert_network_disconnected, (int)1).show();
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.isStreamConflict()) {
            this.showStreamConflictMessage();
        } else {
            messenger.trySignon();
        }
    }

    private void showStreamConflictMessage() {
        if (this.mStreamConflictDialog != null && this.mStreamConflictDialog.isShowing()) {
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mStreamConflictDialog = new ZMAlertDialog.Builder((Context)activity).setTitle(R.string.zm_mm_msg_stream_conflict_msg).setCancelable(true).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton(R.string.zm_btn_sign_in_again, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMSelectSessionFragment.this.forceConnectMessenger();
            }
        }).create();
        this.mStreamConflictDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                MMSelectSessionFragment.this.mStreamConflictDialog = null;
            }
        });
        this.mStreamConflictDialog.setCanceledOnTouchOutside(false);
        this.mStreamConflictDialog.show();
    }

    private void forceConnectMessenger() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            messenger.forceSignon();
        }
    }

    private void startNewChat() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        String title = activity.getString(R.string.zm_mm_title_new_chat);
        String btnOkText = activity.getString(R.string.zm_mm_btn_start_chat);
        String instructionMessage = activity.getString(R.string.zm_msg_select_buddies_to_chat_instructions);
        MMSelectContactsActivity.show((Fragment)this, title, null, btnOkText, instructionMessage, false, null, false, 100, true, null, false, PTApp.getInstance().getMaxChatGroupBuddyNumber() - 1);
    }

    private void startNewGroupChat() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        NewGroupChatFragment.showAsActivity((Fragment)this, 101);
    }

    private void showWaitingMakeGroupDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, "WaitingMakeGroupDialog");
    }

    private boolean dismissWaitingMakeGroupDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return false;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingMakeGroupDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
            return true;
        }
        return false;
    }

    private void showMakeGroupFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 8) {
            Toast.makeText((Context)context, (int)R.string.zm_mm_msg_make_group_failed_too_many_buddies, (int)1).show();
        } else {
            String msg = context.getString(R.string.zm_mm_msg_make_group_failed, new Object[]{result});
            Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    private void onBeginConnect() {
        if (NetworkUtil.hasDataNetwork((Context)this.getActivity()) && this.isResumed()) {
            this.updateTitle();
            this.updatePanelConnectionAlert();
        }
    }

    private void onConnectReturn(int errorCode) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && this.isResumed()) {
            this.updateTitle();
            this.updatePanelConnectionAlert();
            if (this.mChatsListView != null) {
                this.mChatsListView.notifyDataSetChanged(true);
            }
        }
    }

    private void onIndicateBuddyInfoUpdated(String phoneNumber) {
        if (this.mChatsListView != null) {
            this.mChatsListView.onIndicateBuddyInfoUpdated(phoneNumber);
        }
    }

    private void onIndicateBuddyInfoUpdatedWithJID(String jid) {
        if (this.mChatsListView != null) {
            this.mChatsListView.onIndicateBuddyInfoUpdatedWithJID(jid);
        }
    }

    private void onGroupAction(final int result, final GroupAction action, String msgId) {
        if (action == null) {
            return;
        }
        this.mChatsListView.onGroupAction(result, action, msgId);
        if (action.getActionType() == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                public void run(IUIElement ui) {
                    MMSelectSessionFragment f = (MMSelectSessionFragment)ui;
                    if (f != null) {
                        f.handleGroupActionMakeGroup(result, action);
                    }
                }
            });
        }
    }

    private void handleGroupActionMakeGroup(int result, GroupAction action) {
        if (!this.dismissWaitingMakeGroupDialog()) {
            return;
        }
        if (result == 0) {
            String groupId = action.getGroupId();
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            this.startGroupChat(groupId);
        } else {
            this.showMakeGroupFailureMessage(result);
        }
    }

    private void onNotify_ChatSessionListUpdate() {
        if (this.mChatsListView != null) {
            this.mChatsListView.loadData(false);
            if (this.isResumed()) {
                this.mChatsListView.notifyDataSetChanged(true);
            }
        }
    }

    private void onIndicateBuddyListUpdated() {
        if (this.mChatsListView != null) {
            this.mChatsListView.loadData(false);
            if (this.isResumed()) {
                this.mChatsListView.notifyDataSetChanged(true);
            }
        }
    }

    private void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        if (this.mChatsListView != null) {
            this.mChatsListView.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }
    }
}

