/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.TextView;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.ContactsMatchHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.MMLocalHelper;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.MMSelectContactsListItemSpan;
import com.zipow.videobox.view.ZMReplaceSpanMovementMethod;
import com.zipow.videobox.view.mm.MMSelectContactsListItem;
import com.zipow.videobox.view.mm.MMSelectContactsListView;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMEditText;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.videomeetings.R;

public class MMSelectContactsFragment
extends ZMDialogFragment
implements View.OnClickListener,
MMSelectContactsListView.Listener,
ZMKeyboardDetector.KeyboardListener,
ABContactsCache.IABContactsCacheListener {
    public static final String JID_SELECTED_EVERYONE = "jid_select_everyone";
    public static final String ARG_PARAMTERS = "paramters";
    public static final String ARG_RESULT_DATA = "resultData";
    private static final String TAG = MMSelectContactsFragment.class.getSimpleName();
    private MMSelectContactsListView mListView;
    private ZMEditText mEdtSelected;
    private Button mBtnOK;
    private TextView mTxtTitle;
    private int mMaxSelectCount = -1;
    private int mMinSelectCount = -1;
    private ProgressDialog mProgressDialog;
    private Dialog mMessageDialog;
    private Handler mHandler = new Handler();
    private boolean mIsSingleChoice = false;
    private boolean mOnlySameOrganizion = false;
    private boolean mAcceptNoSestion = false;
    private boolean mIncludeRobot = true;
    private boolean mOnlyRobot = false;
    private boolean mFilterZoomRooms = false;
    private boolean mIsAlternativeHost;
    private GestureDetector mGestureDetector;
    private MemCache<String, Bitmap> mAvatarCache = new MemCache(20);
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;
    private SearchFilterRunnable mRunnableFilter = new SearchFilterRunnable();

    public static void showInActivity(ZMActivity activity, MMSelectContactsActivity.SelectContactsParamter prarameter, Bundle resultData) {
        if (activity == null || prarameter == null) {
            return;
        }
        MMSelectContactsFragment f = new MMSelectContactsFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_PARAMTERS, (Serializable)prarameter);
        if (resultData != null) {
            args.putBundle(ARG_RESULT_DATA, resultData);
        }
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, MMSelectContactsFragment.class.getName()).commit();
    }

    public static void showAsDialog(FragmentManager fm, MMSelectContactsActivity.SelectContactsParamter prarameter) {
        MMSelectContactsFragment f = MMSelectContactsFragment.getSelectContactsFragment(fm);
        if (f == null) {
            f = new MMSelectContactsFragment();
            Bundle args = new Bundle();
            args.putSerializable(ARG_PARAMTERS, (Serializable)prarameter);
            f.setArguments(args);
            f.show(fm, MMSelectContactsFragment.class.getName());
        }
    }

    public static MMSelectContactsFragment getSelectContactsFragment(FragmentManager fm) {
        return (MMSelectContactsFragment)fm.findFragmentByTag(MMSelectContactsFragment.class.getName());
    }

    public static boolean dismiss(FragmentManager fm) {
        MMSelectContactsFragment f = MMSelectContactsFragment.getSelectContactsFragment(fm);
        if (f != null) {
            f.dismiss();
            return true;
        }
        return false;
    }

    public void onDestroy() {
        if (this.mListView != null) {
            this.mListView.stop();
        }
        this.mHandler.removeCallbacks((Runnable)this.mRunnableFilter);
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        if (this.mMessageDialog != null && this.mMessageDialog.isShowing()) {
            this.mMessageDialog.dismiss();
        }
        super.onDestroy();
    }

    public void onResume() {
        super.onResume();
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        MMSelectContactsActivity.SelectContactsParamter paramter = (MMSelectContactsActivity.SelectContactsParamter)args.getSerializable(ARG_PARAMTERS);
        if (paramter != null) {
            String title = paramter.title;
            if (title != null) {
                this.mTxtTitle.setText((CharSequence)title);
            }
            if (this.mListView != null) {
                ArrayList<String> preSelectedItems = paramter.preSelectedItems;
                String groupId = paramter.groupId;
                this.mListView.setGroupId(groupId, paramter.isContainsAllInGroup);
                if (paramter.isAlternativeHost) {
                    this.mListView.setPreSelectedItems(preSelectedItems, true);
                } else {
                    this.mListView.setPreSelectedItems(preSelectedItems);
                }
            }
        }
        if (this.mListView != null) {
            this.mListView.setFilter(this.getFilter());
            this.mListView.reloadAllBuddyItems();
            if (this.mIsAlternativeHost) {
                this.mListView.loadEmailForVisibleItems();
            }
            this.mListView.onResume();
        }
        int cntSelected = this.getSelectedBuddiesCount();
        this.updateButtonOK(cntSelected);
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.addListener(this);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (MMSelectContactsFragment.this.isResumed()) {
                    MMSelectContactsFragment.this.mEdtSelected.requestFocus();
                    UIUtil.openSoftKeyboard((Context)MMSelectContactsFragment.this.getActivity(), (View)MMSelectContactsFragment.this.mEdtSelected);
                }
            }
        }, 100L);
    }

    public void onPause() {
        super.onPause();
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.removeListener(this);
        this.mAvatarCache.clear();
    }

    public void onDestroyView() {
        if (this.mZoomMessengerUIListener != null) {
            ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        }
        super.onDestroyView();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        MMSelectContactsActivity.SelectContactsParamter parameter;
        View view = null;
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            view = inflater.inflate(R.layout.zm_mm_select_contacts, null);
        } else {
            view = inflater.inflate(R.layout.zm_mm_select_contacts_main_screen, null);
            ZMKeyboardDetector keyboardDetector = (ZMKeyboardDetector)view.findViewById(R.id.keyboardDetector);
            keyboardDetector.setKeyboardListener((ZMKeyboardDetector.KeyboardListener)this);
        }
        this.mListView = (MMSelectContactsListView)view.findViewById(R.id.buddyListView);
        this.mEdtSelected = (ZMEditText)view.findViewById(R.id.edtSelected);
        this.mBtnOK = (Button)view.findViewById(R.id.btnOK);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        Button btnBack = (Button)view.findViewById(R.id.btnBack);
        this.mEdtSelected.setOnClickListener((View.OnClickListener)this);
        this.mEdtSelected.setSelected(true);
        this.mEdtSelected.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (after < count) {
                    Editable editable = MMSelectContactsFragment.this.mEdtSelected.getText();
                    final MMSelectContactsListItemSpan[] spans = (MMSelectContactsListItemSpan[])editable.getSpans(start + after, start + count, MMSelectContactsListItemSpan.class);
                    if (spans.length <= 0) {
                        return;
                    }
                    MMSelectContactsFragment.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (!MMSelectContactsFragment.this.isResumed()) {
                                return;
                            }
                            for (MMSelectContactsListItemSpan span : spans) {
                                MMSelectContactsListItem item = span.getItem();
                                if (item == null) continue;
                                MMSelectContactsFragment.this.mListView.unselectBuddy(item);
                            }
                        }
                    });
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                MMSelectContactsFragment.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!MMSelectContactsFragment.this.isResumed()) {
                            return;
                        }
                        MMSelectContactsFragment.this.formatSearchEditText();
                        String key = MMSelectContactsFragment.this.getFilter();
                        MMSelectContactsFragment.this.startFilter(key);
                    }
                });
            }
        });
        this.mEdtSelected.setMovementMethod((MovementMethod)ZMReplaceSpanMovementMethod.getInstance());
        this.mEdtSelected.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (event == null) {
                    return false;
                }
                if (actionId == 6 || event.getKeyCode() == 66 && event.getAction() == 0) {
                    if (MMSelectContactsFragment.this.mIsAlternativeHost) {
                        MMSelectContactsFragment.this.handEnterKey();
                    }
                    return true;
                }
                return false;
            }
        });
        this.mBtnOK.setOnClickListener((View.OnClickListener)this);
        btnBack.setOnClickListener((View.OnClickListener)this);
        this.mListView.setListener(this);
        this.mListView.setParentFragment(this);
        this.mListView.setAvatarMemCache(this.mAvatarCache);
        this.mGestureDetector = new GestureDetector((Context)this.getActivity(), (GestureDetector.OnGestureListener)new GuestureListener((View)this.mListView, (View)this.mEdtSelected));
        this.mListView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return MMSelectContactsFragment.this.mGestureDetector.onTouchEvent(event);
            }
        });
        Bundle args = this.getArguments();
        if (args != null && (parameter = (MMSelectContactsActivity.SelectContactsParamter)args.getSerializable(ARG_PARAMTERS)) != null) {
            this.mIsSingleChoice = parameter.isSingleChoice;
            this.mOnlySameOrganizion = parameter.isOnlySameOrganization;
            this.mMaxSelectCount = parameter.maxSelectCount;
            this.mMinSelectCount = parameter.minSelectCount;
            this.mAcceptNoSestion = parameter.isAcceptNoSestion;
            this.mIncludeRobot = parameter.includeRobot;
            this.mOnlyRobot = parameter.onlyRobot;
            this.mFilterZoomRooms = parameter.mFilterZoomRooms;
            this.mIsAlternativeHost = parameter.isAlternativeHost;
        }
        if (this.mIsSingleChoice) {
            this.mListView.setChoiceMode(1);
            btnBack.setVisibility(8);
        }
        this.mListView.setMaxSelectCount(this.mMaxSelectCount);
        this.mListView.setOnlySameOrganization(this.mOnlySameOrganizion);
        this.mListView.setIncludeRobot(this.mIncludeRobot);
        this.mListView.setmOnlyRobot(this.mOnlyRobot);
        this.mListView.setmIsShowEmail(this.mIsAlternativeHost);
        this.mListView.setmIsDisabledForPreSelected(!this.mIsAlternativeHost);
        this.mListView.setmIsNeedHaveEmail(this.mIsAlternativeHost);
        this.mListView.setmIsNeedSortSelectedItems(!this.mIsAlternativeHost);
        this.mListView.setmIsAutoWebSearch(this.mIsAlternativeHost);
        this.mListView.setmFilterZoomRooms(this.mFilterZoomRooms);
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public void onIndicateBuddyInfoUpdated(String phoneNumber) {
                    MMSelectContactsFragment.this.onIndicateZoomMessengerBuddyInfoUpdated(phoneNumber);
                }

                @Override
                public void onIndicateBuddyListUpdated() {
                    MMSelectContactsFragment.this.onIndicateZoomMessengerBuddyListUpdated();
                }

                @Override
                public void onIndicateInfoUpdatedWithJID(String jid) {
                    MMSelectContactsFragment.this.onIndicateZoomMessengerInfoUpdatedWithJID(jid);
                }

                @Override
                public void onConnectReturn(int errorCode) {
                    MMSelectContactsFragment.this.onIndicationZoomMessengerConnectReturn(errorCode);
                }

                @Override
                public void onSearchBuddyByKey(String key, int result) {
                    MMSelectContactsFragment.this.onIndicationZoomMessengerSearchBuddyByKey(key, result);
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.READ_CONTACTS") != 0 && PTApp.getInstance().isPhoneNumberRegistered() && AppUtil.canRequestContactPermission()) {
            this.zm_requestPermissions(new String[]{"android.permission.READ_CONTACTS"}, 0);
            AppUtil.saveRequestContactPermissionTime();
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (MMSelectContactsFragment.this.isResumed()) {
                    MMSelectContactsFragment.this.mEdtSelected.requestFocus();
                    UIUtil.openSoftKeyboard((Context)MMSelectContactsFragment.this.getActivity(), (View)MMSelectContactsFragment.this.mEdtSelected);
                }
            }
        }, 100L);
        return view;
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager == null) {
            return;
        }
        eventTaskManager.push(new EventAction(){

            public void run(IUIElement ui) {
                ((MMSelectContactsFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    private void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.READ_CONTACTS".equals(permissions[i]) || grantResults[i] != 0) continue;
            ABContactsCache cache = ABContactsCache.getInstance();
            cache.reloadAllContacts();
        }
    }

    private void formatSearchEditText() {
        Editable editable = this.mEdtSelected.getEditableText();
        MMSelectContactsListItemSpan[] spans = (MMSelectContactsListItemSpan[])StringUtil.getSortedSpans((Spanned)editable, MMSelectContactsListItemSpan.class);
        if (spans.length <= 0) {
            return;
        }
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)editable);
        boolean hasNormalCharInMiddle = false;
        for (int i = 0; i < spans.length; ++i) {
            int preEnd;
            int start = builder.getSpanStart((Object)spans[i]);
            int n = preEnd = i == 0 ? 0 : builder.getSpanEnd((Object)spans[i - 1]);
            if (start == preEnd) continue;
            CharSequence str = builder.subSequence(preEnd, start);
            builder.replace(preEnd, start, (CharSequence)"");
            int end = builder.getSpanEnd((Object)spans[spans.length - 1]);
            builder.replace(end, end, str);
            hasNormalCharInMiddle = true;
        }
        if (hasNormalCharInMiddle) {
            this.mEdtSelected.setText((CharSequence)builder);
            this.mEdtSelected.setSelection(builder.length());
        }
    }

    private String getFilter() {
        String key = "";
        Editable editable = this.mEdtSelected.getText();
        MMSelectContactsListItemSpan[] spans = (MMSelectContactsListItemSpan[])editable.getSpans(0, editable.length(), MMSelectContactsListItemSpan.class);
        if (spans.length <= 0) {
            key = editable.toString();
        } else {
            int length;
            MMSelectContactsListItemSpan lastSpan = spans[spans.length - 1];
            int pos = editable.getSpanEnd((Object)lastSpan);
            if (pos < (length = editable.length())) {
                key = editable.subSequence(pos, length).toString();
            }
        }
        return key;
    }

    private void startFilter(String key) {
        String oldKey;
        if (key == null) {
            key = "";
        }
        if (key.equals(oldKey = this.mRunnableFilter.getKey())) {
            return;
        }
        this.mRunnableFilter.setKey(key);
        this.mHandler.removeCallbacks((Runnable)this.mRunnableFilter);
        this.mHandler.postDelayed((Runnable)this.mRunnableFilter, 300L);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnOK) {
            this.onClickBtnOK();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.edtSelected) {
            this.onClickEditSelectedView();
        }
    }

    private void onClickEditSelectedView() {
        this.mEdtSelected.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSelected);
    }

    public void onClickEveryone() {
        MMSelectContactsActivity activity = (MMSelectContactsActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        ArrayList<IMAddrBookItem> abItems = new ArrayList<IMAddrBookItem>();
        IMAddrBookItem item = new IMAddrBookItem();
        item.setJid(JID_SELECTED_EVERYONE);
        item.setScreenName(this.getString(R.string.zm_lbl_select_everyone));
        abItems.add(item);
        Bundle extraData = args.getBundle(ARG_RESULT_DATA);
        activity.onSelectContactsDone(abItems, extraData);
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickBtnOK() {
        if (this.mIsSingleChoice) {
            this.dismiss();
            return;
        }
        this.onSelectionConfirmed();
    }

    private void onSelectionConfirmed() {
        List<MMSelectContactsListItem> items = this.mListView.getSelectedBuddies();
        if (!(this.mIsAlternativeHost || this.mAcceptNoSestion || items != null && items.size() != 0)) {
            this.onClickBtnBack();
            return;
        }
        MMSelectContactsActivity activity = (MMSelectContactsActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        ArrayList<IMAddrBookItem> abItems = new ArrayList<IMAddrBookItem>();
        for (MMSelectContactsListItem item : items) {
            IMAddrBookItem abItem = item.getAddrBookItem();
            if (abItem == null) continue;
            abItem.setManualInput(item.isManualInput());
            abItems.add(abItem);
        }
        UIUtil.closeSoftKeyboard((Context)activity, (View)this.getView());
        Bundle extraData = args.getBundle(ARG_RESULT_DATA);
        activity.onSelectContactsDone(abItems, extraData);
    }

    public void clearSelection() {
        this.mListView.clearSelection();
    }

    @Override
    public void onSelectionChanged() {
        int cntSelected = this.getSelectedBuddiesCount();
        this.updateButtonOK(cntSelected);
        if (this.mIsAlternativeHost) {
            if (this.mListView.getSelectedBuddies().isEmpty()) {
                this.mTxtTitle.setText((CharSequence)this.getString(R.string.zm_lbl_schedule_alter_host_21201));
            } else {
                this.mTxtTitle.setText((CharSequence)this.getString(R.string.zm_title_select_alternative_host_21201, new Object[]{this.mListView.getSelectedBuddies().size()}));
            }
        }
        if (this.mIsSingleChoice && cntSelected == 1) {
            this.onSelectionConfirmed();
        }
    }

    private void updateButtonOK(int cntSelected) {
        if (!this.mAcceptNoSestion && !this.mIsSingleChoice && cntSelected <= 0) {
            if (this.mIsAlternativeHost) {
                this.mBtnOK.setEnabled(true);
            } else {
                this.mBtnOK.setEnabled(false);
            }
        } else if (!this.mIsAlternativeHost && cntSelected < this.mMinSelectCount) {
            this.mBtnOK.setEnabled(false);
        } else {
            this.mBtnOK.setEnabled(true);
        }
    }

    private int getSelectedBuddiesCount() {
        List<MMSelectContactsListItem> items = this.mListView.getSelectedBuddies();
        return items.size();
    }

    public void onKeyboardOpen() {
        this.mEdtSelected.setCursorVisible(true);
    }

    public void onKeyboardClosed() {
        this.mEdtSelected.setCursorVisible(false);
        this.mListView.setForeground(null);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MMSelectContactsFragment.this.mListView.requestLayout();
            }
        });
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    public boolean onSearchRequested() {
        this.mEdtSelected.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSelected);
        return true;
    }

    private void onIndicateZoomMessengerBuddyInfoUpdated(String phoneNumber) {
        if (this.mListView != null && this.isResumed()) {
            this.mListView.notifyDataSetChanged(true);
        }
    }

    private void onIndicateZoomMessengerBuddyListUpdated() {
        if (this.mListView != null && this.isResumed()) {
            this.mListView.reloadAllBuddyItems();
        }
    }

    private void onIndicateZoomMessengerInfoUpdatedWithJID(String jid) {
        if (this.mListView != null && this.isResumed()) {
            this.mListView.updateBuddyInfoWithJid(jid);
        }
    }

    private void onIndicationZoomMessengerConnectReturn(int errCode) {
        if (this.mListView != null && this.isResumed()) {
            this.mListView.notifyDataSetChanged(true);
        }
    }

    private void onIndicationZoomMessengerSearchBuddyByKey(String key, int result) {
        if (this.mListView != null) {
            if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
                this.mProgressDialog.dismiss();
                this.mListView.onIndicationZoomMessengerSearchBuddyByKey(key, result);
            } else {
                this.mListView.onIndicationZoomMessengerSearchBuddyByKeyForNoProgressDialog(key, result);
            }
        }
    }

    private void lazyLoadAvatar(final AvatarView avatarView, final MMSelectContactsListItem item, final Context context, final MemCache<String, Bitmap> avatarCache) {
        avatarView.setAvatar((String)null);
        avatarView.setTag(item);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Object obj = avatarView.getTag();
                if (obj != item) {
                    return;
                }
                MMSelectContactsFragment.this.loadAvatar(avatarView, item, context, false, avatarCache);
            }
        }, 300L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadAvatar(AvatarView avatarView, MMSelectContactsListItem item, Context context, boolean fromMemCacheOnly, MemCache<String, Bitmap> avatarCache) {
        Bitmap bitmap;
        avatarView.setName(item.getScreenName());
        avatarView.setBgColorSeedString(item.getBuddyJid());
        String avatar = item.getAvatar();
        if (StringUtil.isEmptyOrNull((String)avatar)) {
            Bitmap bitmap2;
            if (!item.isAddrBookItem()) return true;
            IMAddrBookItem abItem = item.getAddrBookItem();
            if (abItem == null) return false;
            if (avatarCache != null && (bitmap2 = avatarCache.getCachedItem(String.valueOf(abItem.getContactId()))) != null) {
                avatarView.setAvatar(bitmap2);
                return true;
            }
            bitmap2 = abItem.getAvatarBitmap(context, fromMemCacheOnly);
            avatarView.setAvatar(bitmap2);
            if (bitmap2 == null) return false;
            if (avatarCache == null) return true;
            avatarCache.cacheItem(String.valueOf(abItem.getContactId()), bitmap2);
            return true;
        }
        if (avatarCache != null && (bitmap = avatarCache.getCachedItem(avatar)) != null) {
            avatarView.setAvatar(bitmap);
            return true;
        }
        File file = new File(avatar);
        if (!file.exists() || !file.isFile()) return false;
        Bitmap bitmap3 = ZMBitmapFactory.decodeFile(avatar, fromMemCacheOnly);
        if (bitmap3 != null) {
            avatarView.setAvatar(bitmap3);
            if (avatarCache == null) return true;
            avatarCache.cacheItem(avatar, bitmap3);
            return true;
        }
        avatarView.setAvatar((Bitmap)null);
        return false;
    }

    @Override
    public void onViewMoreClick() {
        boolean res;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            return;
        }
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        if (res = messenger.searchBuddyByKey(this.getFilter())) {
            this.mProgressDialog = UIUtil.showSimpleWaitingDialog((Activity)this.getActivity(), (int)R.string.zm_msg_waiting);
        }
    }

    @Override
    public void onSelectCountReachMax() {
        this.mMessageDialog = UIUtil.showSimpleMessageDialog((Activity)this.getActivity(), null, (String)this.getString(R.string.zm_alert_select_count_reach_max));
    }

    @Override
    public void onSelected(boolean selected, MMSelectContactsListItem item) {
        MMLocalHelper.onSelected((Context)this.getActivity(), this.mEdtSelected, selected, item);
    }

    @Override
    public void onContactsCacheUpdated() {
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.removeListener(this);
        this.mListView.reloadAllBuddyItems();
        int cntSelected = this.getSelectedBuddiesCount();
        this.updateButtonOK(cntSelected);
        ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
        if (helper == null) {
            return;
        }
        if (PTApp.getInstance().isWebSignedOn() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber()) && ABContactsHelper.isTimeToMatchPhoneNumbers()) {
            this.startABMatching();
        } else if (!StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber())) {
            this.matchNewNumbers();
        }
    }

    private int startABMatching() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return 11;
        }
        if (!PTApp.getInstance().isWebSignedOn()) {
            return 9;
        }
        return ContactsMatchHelper.getInstance().matchAllNumbers((Context)context);
    }

    private void matchNewNumbers() {
        if (!PTApp.getInstance().isWebSignedOn()) {
            return;
        }
        ContactsMatchHelper.getInstance().matchNewNumbers((Context)this.getActivity());
    }

    private void handEnterKey() {
        String filter = StringUtil.safeString((String)this.getFilter()).trim();
        boolean isEmail = StringUtil.isValidEmailAddress((String)filter);
        if (isEmail) {
            MMSelectContactsListItem item = MMLocalHelper.transformEmailToMMSelectContactsListItem(filter);
            item.setManualInput(true);
            this.mListView.addSelectedItem(item);
        }
    }

    public static class GuestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private View mHolderView;
        private View mKeyboardView;

        public GuestureListener(View view, View keyboardView) {
            this.mHolderView = view;
            this.mKeyboardView = keyboardView;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (this.mHolderView != null) {
                this.mHolderView.requestFocus();
                UIUtil.closeSoftKeyboard((Context)this.mHolderView.getContext(), (View)this.mKeyboardView);
            }
            return super.onScroll(e1, e2, distanceX, distanceY);
        }
    }

    public class SelectedListAdapter
    extends BaseAdapter {
        private static final int ITEM_TYPE_NORMAL = 0;
        private Context mContext;
        private List<MMSelectContactsListItem> mItems;
        private MemCache<String, Bitmap> mAvatarCache;

        public SelectedListAdapter(Context c) {
            this.mContext = c;
        }

        public void setAvatarMemCache(MemCache<String, Bitmap> avatarCache) {
            this.mAvatarCache = avatarCache;
        }

        public void update(List<MMSelectContactsListItem> items) {
            this.mItems = items;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            if (this.mItems == null) {
                return 1;
            }
            return this.mItems.size();
        }

        public Object getItem(int position) {
            if (this.mItems == null) {
                return null;
            }
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            if (position < 0 || position >= this.getCount()) {
                return -1L;
            }
            Object obj = this.getItem(position);
            if (!(obj instanceof MMSelectContactsListItem)) {
                return 0L;
            }
            MMSelectContactsListItem item = (MMSelectContactsListItem)obj;
            return item.getItemId().hashCode();
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object obj = this.getItem(position);
            LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
            if (obj instanceof MMSelectContactsListItem) {
                MMSelectContactsListItem item;
                AvatarView avatarView;
                View itemView = convertView;
                if (itemView == null || !"normalItem".equals(itemView.getTag())) {
                    itemView = factory.inflate(R.layout.zm_invite_selected_listview_item, parent, false);
                    itemView.setTag((Object)"normalItem");
                }
                if ((avatarView = (AvatarView)itemView.findViewById(R.id.avatarView)) == null) {
                    itemView = factory.inflate(R.layout.zm_invite_selected_listview_item, parent, false);
                    avatarView = (AvatarView)itemView.findViewById(R.id.avatarView);
                }
                if (!MMSelectContactsFragment.this.loadAvatar(avatarView, item = (MMSelectContactsListItem)obj, this.mContext, true, this.mAvatarCache)) {
                    MMSelectContactsFragment.this.lazyLoadAvatar(avatarView, item, this.mContext, this.mAvatarCache);
                }
                return itemView;
            }
            return null;
        }
    }

    public class SearchFilterRunnable
    implements Runnable {
        private String mKey = "";

        public void setKey(String key) {
            this.mKey = key == null ? "" : key;
        }

        public String getKey() {
            return this.mKey;
        }

        @Override
        public void run() {
            MMSelectContactsFragment.this.mListView.filter(this.mKey);
        }
    }
}

