/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.MMNotificationDndSettingsFragment;
import com.zipow.videobox.fragment.MMNotificationExceptionGroupsSettingsFragment;
import com.zipow.videobox.fragment.MMNotificationsAddContactFragment;
import com.zipow.videobox.fragment.MMNotificationsAddKeyWordsFragment;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.PreferenceUtil;
import java.util.Calendar;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.videomeetings.R;

public class MMNotificationsFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private CheckedTextView mChkDisableInMeeting;
    private CheckedTextView mChkAlertSound;
    private CheckedTextView mChkAlertVibrate;
    private CheckedTextView mChkCallAlertSound;
    private CheckedTextView mChkCallAlertVibrate;
    private TextView mTxtDisturb;
    private View mPanelDisturb;
    private ImageView mImgAllMsg;
    private ImageView mImgNotificationPrivate;
    private ImageView mImgNotificationNo;
    private ImageView mImgNotificationInstant;
    private ImageView mImgNotificationIdle;
    private View mPanelNotificationSettings;
    private View mPanelTurnOnNotification;
    private View mPanelExceptionGroups;
    private TextView mTxtGroupNumber;
    private View mPanelNotificationKeys;
    private TextView mTxtKeysNumber;
    private View mPanelNotificationContancts;
    private TextView mTxtContanctsNumber;
    private NotificationSettingUI.INotificationSettingUIListener mListener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnDNDSettingsUpdated() {
            MMNotificationsFragment.this.onDNDSettingsUpdated();
        }

        @Override
        public void OnBlockAllSettingsUpdated() {
            MMNotificationsFragment.this.onBlockAllSettingsUpdated();
        }

        @Override
        public void OnInCallSettingUpdated() {
            MMNotificationsFragment.this.onInCallSettingUpdated();
        }

        @Override
        public void OnMUCSettingUpdated() {
            MMNotificationsFragment.this.onMUCSettingUpdated();
        }
    };
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            MMNotificationsFragment.this.onGroupAction(result, action, messageId);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            MMNotificationsFragment.this.On_NotifyGroupDestroy(groupID, groupName, tm);
        }
    };

    public static void showAsActivity(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMNotificationsFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_notification, container, false);
        this.mChkDisableInMeeting = (CheckedTextView)view.findViewById(R.id.chkDisableInMeeting);
        this.mChkAlertSound = (CheckedTextView)view.findViewById(R.id.chkAlertSound);
        this.mChkAlertVibrate = (CheckedTextView)view.findViewById(R.id.chkAlertVibrate);
        this.mChkCallAlertSound = (CheckedTextView)view.findViewById(R.id.chkCallAlertSound);
        this.mChkCallAlertVibrate = (CheckedTextView)view.findViewById(R.id.chkCallAlertVibrate);
        this.mTxtDisturb = (TextView)view.findViewById(R.id.txtDisturb);
        this.mPanelDisturb = view.findViewById(R.id.panelDisturb);
        this.mImgAllMsg = (ImageView)view.findViewById(R.id.imgAllMsg);
        this.mImgNotificationPrivate = (ImageView)view.findViewById(R.id.imgNotificationPrivate);
        this.mImgNotificationNo = (ImageView)view.findViewById(R.id.imgNotificationNo);
        this.mImgNotificationInstant = (ImageView)view.findViewById(R.id.imgNotificationInstant);
        this.mImgNotificationIdle = (ImageView)view.findViewById(R.id.imgNotificationIdle);
        this.mPanelNotificationSettings = view.findViewById(R.id.panelNotificationSettings);
        this.mPanelTurnOnNotification = view.findViewById(R.id.panelTurnOnNotification);
        this.mTxtGroupNumber = (TextView)view.findViewById(R.id.txtGroupNumber);
        this.mPanelExceptionGroups = view.findViewById(R.id.panelExceptionGroups);
        this.mPanelNotificationKeys = view.findViewById(R.id.panelNotificationKeywords);
        this.mTxtKeysNumber = (TextView)view.findViewById(R.id.txtNotificationKeywords);
        this.mPanelNotificationContancts = view.findViewById(R.id.panelNotificationContacts);
        this.mTxtContanctsNumber = (TextView)view.findViewById(R.id.txtNotificationContacts);
        view.findViewById(R.id.panelAllMsg).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.panelAllMsg).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.panelPrivateMsg).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.panelNoMsg).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.panelNotificationInstant).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.panelNotificationIdle).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.panelAllMsg).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnTurnOnNotification).setOnClickListener((View.OnClickListener)this);
        this.mPanelDisturb.setOnClickListener((View.OnClickListener)this);
        this.mChkDisableInMeeting.setOnClickListener((View.OnClickListener)this);
        this.mChkAlertSound.setOnClickListener((View.OnClickListener)this);
        this.mChkAlertVibrate.setOnClickListener((View.OnClickListener)this);
        this.mChkCallAlertSound.setOnClickListener((View.OnClickListener)this);
        this.mChkCallAlertVibrate.setOnClickListener((View.OnClickListener)this);
        this.mPanelExceptionGroups.setOnClickListener((View.OnClickListener)this);
        this.mPanelNotificationContancts.setOnClickListener((View.OnClickListener)this);
        this.mPanelNotificationKeys.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onResume() {
        super.onResume();
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        NotificationSettingUI.getInstance().addListener(this.mListener);
        this.updateUI();
    }

    public void onPause() {
        NotificationSettingUI.getInstance().removeListener(this.mListener);
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onPause();
    }

    private void onGroupAction(int result, GroupAction action, String messageId) {
        this.updateUI();
    }

    private void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        this.updateUI();
    }

    private void onBlockAllSettingsUpdated() {
        this.updateUI();
    }

    private void onInCallSettingUpdated() {
        this.updateUI();
    }

    private void onMUCSettingUpdated() {
        this.updateUI();
    }

    private void onDNDSettingsUpdated() {
        this.updateUI();
    }

    private void updateUI() {
        if (NotificationMgr.areNotificationsEnabled((Context)this.getActivity())) {
            this.mPanelTurnOnNotification.setVisibility(8);
            this.mPanelNotificationSettings.setVisibility(0);
            NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
            if (mgr == null) {
                return;
            }
            int[] allSettings = mgr.getBlockAllSettings();
            if (allSettings == null) {
                return;
            }
            int action = allSettings[0];
            int type = allSettings[1];
            int timing = allSettings[2];
            this.mImgAllMsg.setVisibility(action == 1 && type == 1 ? 0 : 8);
            if (action == 2) {
                this.mImgNotificationNo.setVisibility(0);
                this.mPanelNotificationContancts.setVisibility(0);
            } else {
                this.mImgNotificationNo.setVisibility(8);
                this.mPanelNotificationContancts.setVisibility(8);
            }
            this.mImgNotificationPrivate.setVisibility(action == 1 && type == 4 ? 0 : 8);
            this.mImgNotificationInstant.setVisibility(timing == 1 ? 0 : 8);
            this.mImgNotificationIdle.setVisibility(timing == 2 ? 0 : 8);
            NotificationSettingMgr.DndSetting dndSettings = mgr.getDndSettings();
            if (dndSettings == null || !dndSettings.isEnable()) {
                this.mTxtDisturb.setText((CharSequence)"");
            } else {
                String start = TimeUtil.formatTime((Context)this.getActivity(), (Calendar)dndSettings.getStart());
                String end = TimeUtil.formatTime((Context)this.getActivity(), (Calendar)dndSettings.getEnd());
                this.mTxtDisturb.setText((CharSequence)this.getString(R.string.zm_lbl_notification_dnd_19898, new Object[]{start, end}));
            }
            this.mChkDisableInMeeting.setChecked(this.isImNotificationDisableInMeeting());
            PTAppProtos.MUCNotifySettings mucSettings = mgr.getMUCDiffFromGeneralSetting();
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            int count = 0;
            if (mucSettings != null) {
                for (PTAppProtos.MUCNotifySettingItem item : mucSettings.getItemsList()) {
                    ZoomGroup group = messenger.getGroupById(item.getSessionId());
                    if (group == null) continue;
                    ++count;
                }
            }
            int personCount = 0;
            int keysCount = 0;
            NotificationSettingMgr settingMgr = PTApp.getInstance().getNotificationSettingMgr();
            if (settingMgr != null) {
                List<String> keysList;
                List<String> personList = mgr.getPersonSetting();
                if (personList != null) {
                    personCount = personList.size();
                }
                if ((keysList = mgr.getKeywordSetting()) != null) {
                    keysCount = keysList.size();
                }
            }
            this.mTxtGroupNumber.setText((CharSequence)(count <= 0 ? this.getString(R.string.zm_mm_lbl_not_set) : "" + count));
            this.mTxtKeysNumber.setText((CharSequence)(keysCount == 0 ? this.getString(R.string.zm_mm_lbl_not_set) : "" + keysCount));
            this.mTxtContanctsNumber.setText((CharSequence)(personCount == 0 ? this.getString(R.string.zm_mm_lbl_not_set) : "" + personCount));
        } else {
            this.mPanelTurnOnNotification.setVisibility(0);
            this.mPanelNotificationSettings.setVisibility(8);
        }
        this.mChkAlertVibrate.setChecked(this.getPlayAlertVibrate());
        this.mChkAlertSound.setChecked(this.getPlayAlertSound());
        this.mChkCallAlertVibrate.setChecked(PreferenceUtil.readBooleanValue("incoming_call_play_alert_vibrate", true));
        this.mChkCallAlertSound.setChecked(PreferenceUtil.readBooleanValue("incoming_call_play_alert_sound", true));
    }

    private boolean isImNotificationDisableInMeeting() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return false;
        }
        return mgr.getInCallSettings();
    }

    private void saveImNotificationDisableInMeeting(boolean b) {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        mgr.applyInCallSettings(b);
        this.mChkDisableInMeeting.setChecked(this.isImNotificationDisableInMeeting());
    }

    private boolean getPlayAlertSound() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            return settingHelper.getPlayAlertSound();
        }
        return true;
    }

    private void savePlayAlertSound(boolean b) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            settingHelper.savePlayAlertSound(b);
        }
        this.mChkAlertSound.setChecked(this.getPlayAlertSound());
    }

    private boolean getPlayAlertVibrate() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            return settingHelper.getPlayAlertVibrate();
        }
        return true;
    }

    private void savePlayAlertVibrate(boolean b) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper != null) {
            settingHelper.savePlayAlertVibrate(b);
        }
        this.mChkAlertVibrate.setChecked(this.getPlayAlertVibrate());
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.panelAllMsg) {
            this.onClickPanelAllMsg();
        } else if (id2 == R.id.panelPrivateMsg) {
            this.onClickPanelPrivateMsg();
        } else if (id2 == R.id.panelNoMsg) {
            this.onClickPanelNoMsg();
        } else if (id2 == R.id.panelNotificationInstant) {
            this.onClickPanelNotificationInstant();
        } else if (id2 == R.id.panelNotificationIdle) {
            this.onClickPanelNotificationIdle();
        } else if (id2 == R.id.chkAlertSound) {
            this.onClickChkAlertSound();
        } else if (id2 == R.id.chkDisableInMeeting) {
            this.onClickChkDisableInMeeting();
        } else if (id2 == R.id.chkAlertVibrate) {
            this.onClickChkAlertVibrate();
        } else if (id2 == R.id.panelDisturb) {
            this.onClickPanelDisturb();
        } else if (id2 == R.id.btnTurnOnNotification) {
            this.onClickTurnOnNotification();
        } else if (id2 == R.id.panelExceptionGroups) {
            this.onClickPanelExceptionGroups();
        } else if (id2 == R.id.chkCallAlertSound) {
            this.onClickChkCallAlertSound();
        } else if (id2 == R.id.chkCallAlertVibrate) {
            this.onClickChkCallAlertVibrate();
        } else if (id2 == R.id.panelNotificationContacts) {
            this.onClickPanelNotificationContacts();
        } else if (id2 == R.id.panelNotificationKeywords) {
            this.onClickPanelNotificationKeywords();
        }
    }

    private void onClickPanelNotificationContacts() {
        MMNotificationsAddContactFragment.showAsActivity((Fragment)this);
    }

    private void onClickPanelNotificationKeywords() {
        MMNotificationsAddKeyWordsFragment.showAsActivity((Fragment)this);
    }

    private void onClickPanelExceptionGroups() {
        MMNotificationExceptionGroupsSettingsFragment.showAsActivity((Fragment)this, 0);
    }

    private void onClickTurnOnNotification() {
        if (!NotificationMgr.areNotificationsEnabled((Context)this.getActivity())) {
            Uri packageURI = Uri.parse((String)("package:" + this.getActivity().getPackageName()));
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", packageURI);
            this.startActivity(intent);
        } else {
            this.updateUI();
        }
    }

    private void onClickPanelDisturb() {
        MMNotificationDndSettingsFragment.showAsActivity((Fragment)this);
    }

    private void onClickChkAlertSound() {
        boolean isChecked = this.mChkAlertSound.isChecked();
        this.savePlayAlertSound(!isChecked);
    }

    private void onClickChkDisableInMeeting() {
        boolean isChecked = this.mChkDisableInMeeting.isChecked();
        this.saveImNotificationDisableInMeeting(!isChecked);
    }

    private void onClickChkAlertVibrate() {
        boolean isChecked = this.mChkAlertVibrate.isChecked();
        this.savePlayAlertVibrate(!isChecked);
    }

    private void onClickChkCallAlertSound() {
        boolean isChecked = this.mChkCallAlertSound.isChecked();
        PreferenceUtil.saveBooleanValue("incoming_call_play_alert_sound", !isChecked);
        this.mChkCallAlertSound.setChecked(!isChecked);
    }

    private void onClickChkCallAlertVibrate() {
        boolean isChecked = this.mChkCallAlertVibrate.isChecked();
        PreferenceUtil.saveBooleanValue("incoming_call_play_alert_vibrate", !isChecked);
        this.mChkCallAlertVibrate.setChecked(!isChecked);
    }

    private void onClickPanelNotificationIdle() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        int[] settings = mgr.getBlockAllSettings();
        if (settings == null) {
            return;
        }
        mgr.applyBlockAllSettings(settings[0], settings[1], 2);
        this.updateUI();
    }

    private void onClickPanelNotificationInstant() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        int[] settings = mgr.getBlockAllSettings();
        if (settings == null) {
            return;
        }
        mgr.applyBlockAllSettings(settings[0], settings[1], 1);
        this.updateUI();
    }

    private void onClickPanelNoMsg() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        int[] settings = mgr.getBlockAllSettings();
        if (settings == null) {
            return;
        }
        mgr.applyBlockAllSettings(2, 1, settings[2]);
        this.updateUI();
    }

    private void onClickPanelPrivateMsg() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        int[] settings = mgr.getBlockAllSettings();
        if (settings == null) {
            return;
        }
        mgr.applyBlockAllSettings(1, 4, settings[2]);
        this.updateUI();
    }

    private void onClickPanelAllMsg() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        int[] settings = mgr.getBlockAllSettings();
        if (settings == null) {
            return;
        }
        mgr.applyBlockAllSettings(1, 1, settings[2]);
        this.updateUI();
    }

    private void onClickBtnBack() {
        this.dismiss();
    }
}

