/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMNotificationsAddKeyWordsFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private Button mBackBtn;
    private TextView mSaveBtn;
    private TextView mTitle;
    private EditText mContent;
    private List<String> originalKeywords;
    private NotificationSettingUI.SimpleNotificationSettingUIListener mListener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnKeyWordSettingUpdated() {
            super.OnKeyWordSettingUpdated();
            MMNotificationsAddKeyWordsFragment.this.dismiss();
        }
    };

    public static void showAsActivity(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMNotificationsAddKeyWordsFragment.class.getName(), args, 0);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_notification_add_keywords, container, false);
        this.mBackBtn = (Button)view.findViewById(R.id.btnBack);
        this.mSaveBtn = (TextView)view.findViewById(R.id.viewRight);
        this.mTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mContent = (EditText)view.findViewById(R.id.zm_notification_keywords_editText);
        this.mBackBtn.setOnClickListener((View.OnClickListener)this);
        this.mSaveBtn.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onStart() {
        super.onStart();
        NotificationSettingUI.getInstance().addListener(this.mListener);
    }

    public void onStop() {
        super.onStop();
        NotificationSettingUI.getInstance().removeListener(this.mListener);
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr != null) {
            this.originalKeywords = mgr.getKeywordSetting();
        }
        if (this.originalKeywords != null && !this.originalKeywords.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.originalKeywords.size(); ++i) {
                if (i == 0) {
                    sb.append(this.originalKeywords.get(i));
                    continue;
                }
                sb.append(",").append(this.originalKeywords.get(i));
            }
            this.mContent.setText((CharSequence)sb.toString());
            this.mContent.setSelection(sb.length());
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.dismiss();
        } else if (id2 == R.id.viewRight) {
            NotificationSettingMgr mgr;
            String keywords = this.mContent.getText().toString();
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            if (!messenger.isConnectionGood()) {
                return;
            }
            List<String> newKeywords = Arrays.asList(keywords.split(","));
            if (newKeywords != null && !newKeywords.isEmpty()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (String key : newKeywords) {
                    if (TextUtils.isEmpty((CharSequence)key) || map.containsKey(key.toLowerCase())) continue;
                    map.put(key.toLowerCase(), key);
                }
                newKeywords = map.isEmpty() ? new ArrayList<String>() : new ArrayList(map.values());
            }
            if ((mgr = PTApp.getInstance().getNotificationSettingMgr()) != null) {
                if (this.originalKeywords == null || this.originalKeywords.isEmpty()) {
                    mgr.applyKeyword(newKeywords, null);
                } else {
                    ArrayList<String> addList = new ArrayList<String>();
                    ArrayList<String> removeList = new ArrayList<String>();
                    for (String keyword : newKeywords) {
                        if (this.originalKeywords.contains(keyword)) continue;
                        addList.add(keyword);
                    }
                    for (String keyword : this.originalKeywords) {
                        if (newKeywords.contains(keyword)) continue;
                        removeList.add(keyword);
                    }
                    mgr.applyKeyword(addList, removeList);
                }
            }
            this.dismiss();
        }
    }
}

