/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMNotificationsAddContactFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final int REQUEST_NOTIFICATIONS_MEMEBERS = 1;
    private Button backBtn;
    private LinearLayout addContactLinear;
    private ListView mListView;
    private TextView label;
    private LinearLayout removeLinear;
    private ContactAdapter mAdapter;
    private List<ContactItem> contactList = new ArrayList<ContactItem>();
    private NotificationSettingUI.SimpleNotificationSettingUIListener listener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnHLPersonSettingUpdated() {
            super.OnHLPersonSettingUpdated();
        }
    };

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMNotificationsAddContactFragment.class.getName(), args, 0, true, 1);
    }

    public static MMNotificationsAddContactFragment findMMNotificationsAddContactFragment(FragmentManager fm) {
        MMNotificationsAddContactFragment f = (MMNotificationsAddContactFragment)fm.findFragmentByTag(MMNotificationsAddContactFragment.class.getName());
        return f;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_notification_add_contact, container, false);
        this.backBtn = (Button)view.findViewById(R.id.btnBack);
        this.addContactLinear = (LinearLayout)view.findViewById(R.id.panelAddContact);
        this.mListView = (ListView)view.findViewById(R.id.listView);
        this.removeLinear = (LinearLayout)view.findViewById(R.id.panelRemoveAll);
        this.label = (TextView)view.findViewById(R.id.notification_label);
        return view;
    }

    public void onStart() {
        super.onStart();
        NotificationSettingUI.getInstance().addListener(this.listener);
        this.backBtn.setOnClickListener((View.OnClickListener)this);
        this.addContactLinear.setOnClickListener((View.OnClickListener)this);
        this.removeLinear.setOnClickListener((View.OnClickListener)this);
    }

    public void onStop() {
        super.onStop();
        NotificationSettingUI.getInstance().removeListener(this.listener);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        List<String> list;
        NotificationSettingMgr mgr;
        super.onActivityCreated(savedInstanceState);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (mgr = PTApp.getInstance().getNotificationSettingMgr()) != null && (list = mgr.getPersonSetting()) != null) {
            for (String item : list) {
                ContactItem contactItem = new ContactItem(messenger, item);
                if (TextUtils.isEmpty((CharSequence)contactItem.displayName)) continue;
                this.contactList.add(contactItem);
            }
            this.sortContactList(this.contactList);
            this.mAdapter = new ContactAdapter(this.getContext(), this.contactList);
            this.mListView.setAdapter((ListAdapter)this.mAdapter);
        }
        this.updateView();
    }

    private void sortContactList(List<ContactItem> list) {
        if (list == null || list.size() < 2) {
            return;
        }
        final Collator mCollator = Collator.getInstance(CompatUtils.getLocalDefault());
        mCollator.setStrength(0);
        Collections.sort(list, new Comparator<ContactItem>(){

            @Override
            public int compare(ContactItem o1, ContactItem o2) {
                return mCollator.compare(o1.getDisplayName(), o2.getDisplayName());
            }
        });
    }

    private void updateView() {
        if (this.contactList == null || this.contactList.isEmpty()) {
            this.mListView.setVisibility(8);
            this.removeLinear.setVisibility(8);
            this.label.setVisibility(8);
        } else {
            this.mListView.setVisibility(0);
            this.removeLinear.setVisibility(0);
            this.label.setVisibility(0);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.finishFragment(true);
        } else if (id2 == R.id.panelAddContact) {
            MMSelectContactsActivity.SelectContactsParamter paramter = new MMSelectContactsActivity.SelectContactsParamter();
            paramter.title = this.getString(R.string.zm_lbl_receive_notifications_add_contacts_31156);
            paramter.btnOkText = this.getString(R.string.zm_btn_ok);
            paramter.isAnimBottomTop = true;
            paramter.isOnlySameOrganization = false;
            paramter.isContainsAllInGroup = false;
            paramter.includeRobot = false;
            paramter.mFilterZoomRooms = true;
            paramter.maxSelectCount = PTApp.getInstance().getMaxChatGroupBuddyNumber();
            if (this.contactList != null && !this.contactList.isEmpty()) {
                ArrayList<String> preSelectList = new ArrayList<String>();
                for (ContactItem item : this.contactList) {
                    preSelectList.add(item.getJid());
                }
                paramter.preSelectedItems = preSelectList;
            }
            MMSelectContactsActivity.show((Fragment)this, paramter, 1, null);
        } else if (id2 == R.id.panelRemoveAll) {
            ConfirmRemoveAllDialog.showConfirmRemoveAllDialog(this.getFragmentManager());
        }
    }

    public void removeAllContacts() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            for (ContactItem item : this.contactList) {
                removeList.add(item.getJid());
            }
            mgr.applyPersonSetting(null, removeList);
        }
        this.contactList.clear();
        this.mAdapter.notifyDataSetChanged();
        this.updateView();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                if (resultCode != -1) {
                    return;
                }
                if (data == null) {
                    return;
                }
                ArrayList abItems = (ArrayList)data.getSerializableExtra("selectedItems");
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                if (abItems != null) {
                    ArrayList<String> addList = new ArrayList<String>();
                    for (IMAddrBookItem item : abItems) {
                        addList.add(item.getJid());
                        ContactItem contactItem = new ContactItem(messenger, item.getJid());
                        if (TextUtils.isEmpty((CharSequence)contactItem.displayName)) continue;
                        this.contactList.add(contactItem);
                    }
                    this.sortContactList(this.contactList);
                    NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
                    if (mgr != null) {
                        mgr.applyPersonSetting(addList, null);
                    }
                    this.mAdapter.notifyDataSetChanged();
                }
                this.updateView();
                break;
            }
        }
    }

    public static class ConfirmRemoveAllDialog
    extends ZMDialogFragment {
        private Button mBtnOK = null;

        public static void showConfirmRemoveAllDialog(FragmentManager fm) {
            ConfirmRemoveAllDialog dialog = new ConfirmRemoveAllDialog();
            dialog.show(fm, ConfirmRemoveAllDialog.class.getName());
        }

        public ConfirmRemoveAllDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public void onResume() {
            super.onResume();
            this.mBtnOK = ((ZMAlertDialog)this.getDialog()).getButton(-1);
            this.mBtnOK.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ConfirmRemoveAllDialog.this.onClickBtnOK();
                }
            });
        }

        private void onClickBtnOK() {
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            FragmentManager fm = activity.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            MMNotificationsAddContactFragment f = MMNotificationsAddContactFragment.findMMNotificationsAddContactFragment(fm);
            if (f == null) {
                return;
            }
            f.removeAllContacts();
            this.dismissAllowingStateLoss();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_lbl_receive_notifications_remove_all_31156).setMessage(R.string.zm_lbl_receive_notification_remove_all_msg_31156).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).setPositiveButton(R.string.zm_lbl_confirm, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            return dialog;
        }
    }

    private class ContactAdapter
    extends BaseAdapter {
        private LayoutInflater mInflater;
        private List<ContactItem> mList;

        public ContactAdapter(@NonNull Context context, List<ContactItem> list) {
            this.mInflater = LayoutInflater.from((Context)context);
            this.mList = list;
        }

        public int getCount() {
            return this.mList.size();
        }

        public Object getItem(int position) {
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.zm_notification_contact_list_item, parent, false);
            }
            TextView name = (TextView)convertView.findViewById(R.id.zm_notification_contact_list_item_name);
            ImageView deleteBtn = (ImageView)convertView.findViewById(R.id.zm_notification_contact_list_item_delete_btn);
            name.setText((CharSequence)this.mList.get(position).getDisplayName());
            deleteBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
                    if (mgr != null) {
                        ArrayList<String> removeList = new ArrayList<String>();
                        removeList.add(((ContactItem)ContactAdapter.this.mList.get(position)).getJid());
                        mgr.applyPersonSetting(null, removeList);
                    }
                    ContactAdapter.this.mList.remove(position);
                    ContactAdapter.this.notifyDataSetChanged();
                    MMNotificationsAddContactFragment.this.updateView();
                }
            });
            return convertView;
        }
    }

    private class ContactItem {
        private String jid;
        private String displayName;

        public ContactItem(@NonNull ZoomMessenger zoomMessenger, String jid) {
            this.jid = jid;
            ZoomBuddy buddy = zoomMessenger.getBuddyWithJID(jid);
            this.displayName = BuddyNameUtil.getBuddyDisplayName(buddy, null);
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

