/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.NotificationSettingUI;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMNotificationGroupSettingsFragment
extends ZMDialogFragment
implements View.OnClickListener {
    public static final String RESULT_SESSION_ID = "sessionId";
    public static final String RESULT_MUC_TYPE = "mucType";
    private static final String ARGS_MUC_TYPE = "mucType";
    private static final String ARGS_SESSION_ID = "sessionId";
    private String mSessionId;
    private View mPanelAllMsg;
    private ImageView mImgAllMsg;
    private View mPanelPrivateMsg;
    private ImageView mImgNotificationPrivate;
    private View mPanelNoMsg;
    private ImageView mImgNotificationNo;
    private View mPanelRestDefault;
    private TextView mTxtTitle;
    private View mBtnBack;
    private int mMUCtype = 0;
    private NotificationSettingUI.INotificationSettingUIListener mListener = new NotificationSettingUI.SimpleNotificationSettingUIListener(){

        @Override
        public void OnMUCSettingUpdated() {
            MMNotificationGroupSettingsFragment.this.OnMUCSettingUpdated();
        }
    };
    private ZoomMessengerUI.SimpleZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            MMNotificationGroupSettingsFragment.this.onGroupAction(result, action, messageId);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            MMNotificationGroupSettingsFragment.this.On_NotifyGroupDestroy(groupID, groupName, tm);
        }
    };

    public static void showAsActivity(Fragment fragment, String sessionId, int mucType, int requestCode) {
        if (fragment == null || StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        Bundle args = new Bundle();
        args.putString("sessionId", sessionId);
        args.putInt("mucType", mucType);
        SimpleActivity.show(fragment, MMNotificationGroupSettingsFragment.class.getName(), args, requestCode);
    }

    public static void showAsActivity(Fragment fragment, String sessionId) {
        if (fragment == null || StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        Bundle args = new Bundle();
        args.putString("sessionId", sessionId);
        SimpleActivity.show(fragment, MMNotificationGroupSettingsFragment.class.getName(), args, 0);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_notification_group_detail, container, false);
        this.mPanelAllMsg = view.findViewById(R.id.panelAllMsg);
        this.mImgAllMsg = (ImageView)view.findViewById(R.id.imgAllMsg);
        this.mPanelPrivateMsg = view.findViewById(R.id.panelPrivateMsg);
        this.mImgNotificationPrivate = (ImageView)view.findViewById(R.id.imgNotificationPrivate);
        this.mPanelNoMsg = view.findViewById(R.id.panelNoMsg);
        this.mImgNotificationNo = (ImageView)view.findViewById(R.id.imgNotificationNo);
        this.mPanelRestDefault = view.findViewById(R.id.panelRestDefault);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mBtnBack = view.findViewById(R.id.btnBack);
        this.mPanelAllMsg.setOnClickListener((View.OnClickListener)this);
        this.mPanelPrivateMsg.setOnClickListener((View.OnClickListener)this);
        this.mPanelNoMsg.setOnClickListener((View.OnClickListener)this);
        this.mPanelRestDefault.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mSessionId = args.getString("sessionId");
            this.mMUCtype = args.getInt("mucType");
        }
        if (StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            this.dismiss();
        }
    }

    public void onResume() {
        super.onResume();
        NotificationSettingUI.getInstance().addListener(this.mListener);
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.updateUI();
    }

    public void onPause() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        NotificationSettingUI.getInstance().removeListener(this.mListener);
        super.onPause();
    }

    private void onGroupAction(int result, GroupAction action, String messageId) {
        this.checkAmIInGroup(action.getGroupId());
    }

    private void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        this.checkAmIInGroup(groupID);
    }

    private void OnMUCSettingUpdated() {
        this.updateUI();
    }

    private void checkAmIInGroup(String groupID) {
        if (!StringUtil.isSameString((String)groupID, (String)this.mSessionId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(groupID);
        if (group == null || !group.amIInGroup()) {
            this.dismiss();
        } else {
            this.updateUI();
        }
    }

    private void updateUI() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mSessionId);
        if (group == null) {
            return;
        }
        this.mTxtTitle.setText((CharSequence)group.getGroupDisplayName((Context)this.getActivity()));
        PTAppProtos.MUCNotifySettings settings = mgr.getMUCSettings();
        if (settings == null) {
            return;
        }
        int type = this.mMUCtype;
        if (type == 0) {
            for (int i = 0; i < settings.getItemsCount(); ++i) {
                PTAppProtos.MUCNotifySettingItem item = settings.getItems(i);
                if (!StringUtil.isSameString((String)item.getSessionId(), (String)this.mSessionId)) continue;
                type = item.getType();
            }
        }
        if (type == 0) {
            int[] allSettings = mgr.getBlockAllSettings();
            if (allSettings == null) {
                this.mImgNotificationNo.setVisibility(8);
                this.mImgAllMsg.setVisibility(0);
                this.mImgNotificationPrivate.setVisibility(8);
                return;
            }
            int action = allSettings[0];
            int globalType = allSettings[1];
            this.mImgAllMsg.setVisibility(action == 1 && globalType == 1 ? 0 : 8);
            this.mImgNotificationNo.setVisibility(action == 2 ? 0 : 8);
            this.mImgNotificationPrivate.setVisibility(action == 1 && globalType == 4 ? 0 : 8);
        } else {
            switch (type) {
                case 1: {
                    this.mImgNotificationNo.setVisibility(8);
                    this.mImgAllMsg.setVisibility(0);
                    this.mImgNotificationPrivate.setVisibility(8);
                    break;
                }
                case 2: {
                    this.mImgNotificationNo.setVisibility(8);
                    this.mImgAllMsg.setVisibility(8);
                    this.mImgNotificationPrivate.setVisibility(0);
                    break;
                }
                case 3: {
                    this.mImgNotificationNo.setVisibility(0);
                    this.mImgAllMsg.setVisibility(8);
                    this.mImgNotificationPrivate.setVisibility(8);
                }
            }
        }
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public void onClick(View v) {
        if (v == this.mPanelAllMsg) {
            this.onClickPanelAllMsg();
        } else if (v == this.mPanelNoMsg) {
            this.onClickPanelNoMsg();
        } else if (v == this.mPanelPrivateMsg) {
            this.onClickPanelPrivateMsg();
        } else if (v == this.mPanelRestDefault) {
            this.onClickPanelRestDefault();
        } else if (v == this.mBtnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickPanelRestDefault() {
        if (this.mMUCtype == 0) {
            NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
            if (mgr == null) {
                return;
            }
            ArrayList<String> sessionIds = new ArrayList<String>();
            sessionIds.add(this.mSessionId);
            mgr.resetMUCSettings(sessionIds);
            this.dismiss();
        } else {
            Intent intent = new Intent();
            intent.putExtra("mucType", 0);
            intent.putExtra("sessionId", this.mSessionId);
            this.getActivity().setResult(-1, intent);
            this.dismiss();
        }
    }

    private void onClickPanelAllMsg() {
        if (this.mMUCtype == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (!(messenger == null || messenger.isConnectionGood() && NetworkUtil.hasDataNetwork((Context)this.getActivity()))) {
                this.showConnectionError();
                return;
            }
            NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
            if (mgr == null) {
                return;
            }
            List<String> jids = mgr.getReceiveAllMUCSettings();
            if (jids != null && jids.contains(this.mSessionId)) {
                return;
            }
            mgr.applyMUCSettings(this.mSessionId, 1);
            this.updateUI();
        } else {
            Intent intent = new Intent();
            intent.putExtra("mucType", 1);
            intent.putExtra("sessionId", this.mSessionId);
            this.getActivity().setResult(-1, intent);
            this.dismiss();
        }
    }

    private void onClickPanelNoMsg() {
        if (this.mMUCtype == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (!(messenger == null || messenger.isConnectionGood() && NetworkUtil.hasDataNetwork((Context)this.getActivity()))) {
                this.showConnectionError();
                return;
            }
            NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
            if (mgr == null) {
                return;
            }
            List<String> disableJIds = mgr.getDisableMUCSettings();
            if (disableJIds != null && disableJIds.contains(this.mSessionId)) {
                return;
            }
            mgr.applyMUCSettings(this.mSessionId, 3);
            this.updateUI();
        } else {
            Intent intent = new Intent();
            intent.putExtra("mucType", 3);
            intent.putExtra("sessionId", this.mSessionId);
            this.getActivity().setResult(-1, intent);
            this.dismiss();
        }
    }

    private void onClickPanelPrivateMsg() {
        if (this.mMUCtype == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (!(messenger == null || messenger.isConnectionGood() && NetworkUtil.hasDataNetwork((Context)this.getActivity()))) {
                this.showConnectionError();
                return;
            }
            NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
            if (mgr == null) {
                return;
            }
            List<String> hlJids = mgr.getHLMUCSettings();
            if (hlJids != null && hlJids.contains(this.mSessionId)) {
                return;
            }
            mgr.applyMUCSettings(this.mSessionId, 2);
            this.updateUI();
        } else {
            Intent intent = new Intent();
            intent.putExtra("mucType", 2);
            intent.putExtra("sessionId", this.mSessionId);
            this.getActivity().setResult(-1, intent);
            this.dismiss();
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }
}

