/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.view.mm.MMImageViewPager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMImageViewerFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final String TAG = MMImageViewerFragment.class.getSimpleName();
    public static final String ARG_SESSION_ID = "sessionId";
    public static final String ARG_MESSAGE_ID = "messageId";
    protected static final int DISPLAY_ANIM_DURATION = 200;
    private static final int REQUEST_CODE_SAVE_IMAGE = 3101;
    private View mPanelTitleBar;
    private Button mBtnBack;
    private Button mBtnSaveImage;
    private MMImageViewPager mViewImage;
    private String mSessionId;
    private String mMessageId;
    private GestureDetector mGestureDetector = null;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;
    private Handler mHandler = new Handler();
    private ProgressDialog mWaitingSaveDialog;

    public static void showAsActivity(ZMActivity activity, String sessionId, String messageId) {
        Bundle args = new Bundle();
        args.putString(ARG_SESSION_ID, sessionId);
        args.putString(ARG_MESSAGE_ID, messageId);
        SimpleActivity.show(activity, MMImageViewerFragment.class.getName(), args, 0);
    }

    public static void showAsActivity(Fragment fragment, String sessionId, String messageId) {
        Bundle args = new Bundle();
        args.putString(ARG_SESSION_ID, sessionId);
        args.putString(ARG_MESSAGE_ID, messageId);
        SimpleActivity.show(fragment, MMImageViewerFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_image_viewer, container, false);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnSaveImage = (Button)view.findViewById(R.id.btnSaveImage);
        this.mViewImage = (MMImageViewPager)view.findViewById(R.id.viewImage);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSaveImage.setOnClickListener((View.OnClickListener)this);
        this.mPanelTitleBar.setVisibility(4);
        this.mGestureDetector = new GestureDetector((Context)this.getActivity(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                MMImageViewerFragment.this.onTapViewImage();
                return true;
            }
        });
        this.mViewImage.setImageViewAdapter(new MMImageViewPager.ImageViewAdapter(){

            @Override
            public void downloadImage(String sessionId, String messageId) {
                MMImageViewerFragment.this.downloadImage(sessionId, messageId);
            }

            @Override
            public boolean onInterceptTouchEvent(MotionEvent event) {
                return MMImageViewerFragment.this.mGestureDetector.onTouchEvent(event);
            }

            @Override
            public void onPageChanged() {
                MMImageViewerFragment.this.onPageChanged();
            }
        });
        return view;
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        String id2 = this.mViewImage.getCurrentImageMessageId();
        if (id2 != null) {
            this.mMessageId = id2;
        }
        outState.putString("mMessageId", this.mMessageId);
    }

    private void onTapViewImage() {
        boolean show;
        TranslateAnimation anim2 = null;
        boolean bl = show = this.mPanelTitleBar.getVisibility() != 0;
        if (show) {
            this.mPanelTitleBar.setVisibility(0);
            anim2 = new TranslateAnimation(0.0f, 0.0f, (float)(-this.mPanelTitleBar.getHeight()), 0.0f);
        } else {
            anim2 = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-this.mPanelTitleBar.getHeight()));
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    MMImageViewerFragment.this.mPanelTitleBar.setVisibility(4);
                }
            });
        }
        anim2.setInterpolator((Interpolator)new DecelerateInterpolator());
        anim2.setDuration(200L);
        this.mPanelTitleBar.startAnimation((Animation)anim2);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        FragmentActivity activity;
        Bundle args;
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            this.mMessageId = savedInstanceState.getString("mMessageId");
        }
        if ((args = this.getArguments()) != null) {
            this.mSessionId = args.getString(ARG_SESSION_ID);
            if (this.mMessageId == null) {
                this.mMessageId = args.getString(ARG_MESSAGE_ID);
            }
        }
        if ((activity = this.getActivity()) != null) {
            activity.setRequestedOrientation(4);
        }
    }

    private void loadImage(boolean downloadIfNotDownloaded) {
        this.mViewImage.loadImage(this.mSessionId, this.mMessageId);
        this.mBtnSaveImage.setEnabled(this.mViewImage.isCurrentImageFullSize());
    }

    private void onImageDownloadTimeout(String sessionId, String msgId) {
        if (StringUtil.isSameString((String)this.mSessionId, (String)sessionId)) {
            this.mViewImage.onDownloadImageFailed(sessionId, msgId);
        }
    }

    private void downloadImage(String sessionId, String messageId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            return;
        }
        boolean res = session.downloadFileForMessage(messageId);
        if (res) {
            this.mViewImage.onStartDownloadingImage(sessionId, messageId);
        } else {
            this.mViewImage.onDownloadImageFailed(sessionId, messageId);
        }
    }

    private void onPageChanged() {
        if (this.mBtnSaveImage != null) {
            this.mBtnSaveImage.setEnabled(this.mViewImage.isCurrentImageFullSize());
        }
    }

    public void onPause() {
        super.onPause();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
                    if (result == 0) {
                        if (StringUtil.isSameString((String)MMImageViewerFragment.this.mSessionId, (String)sessionId)) {
                            MMImageViewerFragment.this.mViewImage.onImageDownloaded(sessionId, messageId);
                            if (StringUtil.isSameString((String)messageId, (String)MMImageViewerFragment.this.mViewImage.getCurrentImageMessageId()) && MMImageViewerFragment.this.mViewImage.isCurrentImageFullSize()) {
                                MMImageViewerFragment.this.mBtnSaveImage.setEnabled(true);
                            }
                        }
                    } else if (StringUtil.isSameString((String)MMImageViewerFragment.this.mSessionId, (String)sessionId) && StringUtil.isSameString((String)messageId, (String)MMImageViewerFragment.this.mViewImage.getCurrentImageMessageId())) {
                        FragmentActivity context = MMImageViewerFragment.this.getActivity();
                        if (context == null) {
                            return;
                        }
                        MMImageViewerFragment.this.mViewImage.onDownloadImageFailed(sessionId, messageId);
                    }
                }

                @Override
                public void onConfirmPreviewPicFileDownloaded(String sessionId, String messageId, int result) {
                    if (result == 0 && StringUtil.isSameString((String)MMImageViewerFragment.this.mSessionId, (String)sessionId) && StringUtil.isSameString((String)messageId, (String)MMImageViewerFragment.this.mViewImage.getCurrentImageMessageId())) {
                        MMImageViewerFragment.this.mViewImage.onImageDownloaded(sessionId, messageId);
                    }
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.loadImage(true);
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mBtnSaveImage) {
            this.onClickBtnSaveImage();
        }
    }

    private void onClickBtnBack() {
        this.dimiss();
    }

    private void onClickBtnSaveImage() {
        if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.saveImage();
        } else {
            this.zm_requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 3101);
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater(new EventAction("MMImageViewFragmentPermissionResult"){

            public void run(IUIElement ui) {
                ((MMImageViewerFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    public void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 3101) {
            if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
                this.saveImage();
            } else {
                this.dimiss();
            }
        }
    }

    private void saveImage() {
        final String filePath = this.mViewImage.getCurrentImageFilePath();
        if (StringUtil.isEmptyOrNull((String)filePath) || !new File(filePath).exists()) {
            return;
        }
        Thread thread = new Thread("SaveImage"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block33: {
                    if (StringUtil.isEmptyOrNull((String)filePath)) {
                        return;
                    }
                    File file = new File(filePath);
                    if (!file.exists()) {
                        return;
                    }
                    File path = ImageUtil.getZoomGalleryPath();
                    if (path == null) {
                        return;
                    }
                    String destFilePath = path.getPath() + File.separator + file.getName();
                    File destFile = new File(destFilePath);
                    if (destFile.exists() && destFile.length() > 0L) {
                        this._onSaveImageDone(true);
                        return;
                    }
                    FileChannel inputChannel = null;
                    AbstractInterruptibleChannel outputChannel = null;
                    try {
                        inputChannel = new FileInputStream(file).getChannel();
                        outputChannel = new FileOutputStream(destFile).getChannel();
                        long size = ((FileChannel)outputChannel).transferFrom(inputChannel, 0L, inputChannel.size());
                        if (size <= 0L) break block33;
                        FragmentActivity context = MMImageViewerFragment.this.getActivity();
                        if (context == null) {
                            return;
                        }
                        AndroidAppUtil.addImageToGallery((Context)context, (String)destFilePath);
                        this._onSaveImageDone(true);
                    }
                    catch (Exception exception) {
                        break block33;
                    }
                    finally {
                        try {
                            if (inputChannel != null) {
                                inputChannel.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (outputChannel != null) {
                                outputChannel.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                }
                this._onSaveImageDone(false);
            }

            private void _onSaveImageDone(final boolean success) {
                MMImageViewerFragment.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        MMImageViewerFragment.this.onSaveImageDone(success);
                    }
                });
            }
        };
        this.showWaitingSaveDialog();
        thread.start();
    }

    private void onSaveImageDone(boolean success) {
        this.dismissWaitingSaveDialog();
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_mm_msg_saved_to_album, (int)0).show();
    }

    private void dimiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(0);
    }

    private void showWaitingSaveDialog() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (this.mWaitingSaveDialog != null) {
            this.mWaitingSaveDialog.dismiss();
        }
        this.mWaitingSaveDialog = new ProgressDialog((Context)activity);
        this.mWaitingSaveDialog.requestWindowFeature(1);
        this.mWaitingSaveDialog.setMessage((CharSequence)activity.getString(R.string.zm_msg_waiting));
        this.mWaitingSaveDialog.setCanceledOnTouchOutside(false);
        this.mWaitingSaveDialog.setCancelable(true);
        this.mWaitingSaveDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                MMImageViewerFragment.this.mWaitingSaveDialog = null;
            }
        });
        this.mWaitingSaveDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                MMImageViewerFragment.this.mWaitingSaveDialog = null;
            }
        });
        this.mWaitingSaveDialog.show();
    }

    private void dismissWaitingSaveDialog() {
        if (this.mWaitingSaveDialog == null) {
            return;
        }
        try {
            this.mWaitingSaveDialog.dismiss();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

