/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.AddrBookItemDetailsActivity;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.MMBuddyItem;
import com.zipow.videobox.view.mm.MMChatBuddiesGridView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.videomeetings.R;

public class MMGroupBuddiesFragment
extends ZMDialogFragment
implements View.OnClickListener,
ABContactsCache.IABContactsCacheListener,
MMChatBuddiesGridView.BuddyOperationListener {
    private static final String TAG = MMGroupBuddiesFragment.class.getSimpleName();
    private static final String ARG_GROUP_ID = "groupId";
    private static final int REQUEST_ONE_ON_ONE_BUDDY_DETAILS = 100;
    private String mGroupId;
    private Button mBtnBack;
    private MMChatBuddiesGridView mGvBuddies;
    private TextView mTxtTitle;
    private ZMDialogFragment mWaitingDialog;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            MMGroupBuddiesFragment.this.onGroupAction(result, action, messageId);
        }

        @Override
        public void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
            MMGroupBuddiesFragment.this.On_NotifyGroupDestroy(groupID, groupName, tm);
        }

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
            MMGroupBuddiesFragment.this.onIndicateInfoUpdatedWithJID(jid);
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
            MMGroupBuddiesFragment.this.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }

        @Override
        public void On_AssignGroupAdmins(int result, String actionOwner, String groupID, List<String> buddies, long tm) {
            MMGroupBuddiesFragment.this.On_AssignGroupAdmins(result, actionOwner, groupID, buddies, tm);
        }
    };

    public static MMGroupBuddiesFragment findMMChatInfoFragment(FragmentManager fm) {
        if (fm == null) {
            return null;
        }
        MMGroupBuddiesFragment f = (MMGroupBuddiesFragment)fm.findFragmentByTag(MMGroupBuddiesFragment.class.getName());
        return f;
    }

    public static void show(ZMActivity zmActivity, String mGroupId, int requestCode) {
        Bundle args = new Bundle();
        args.putString(ARG_GROUP_ID, mGroupId);
        SimpleActivity.show(zmActivity, MMGroupBuddiesFragment.class.getName(), args, requestCode, false);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        this.mGroupId = args.getString(ARG_GROUP_ID);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_chat_more_info, container, false);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mGvBuddies = (MMChatBuddiesGridView)view.findViewById(R.id.gvBuddies);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mGvBuddies.setBuddyOperationListener(this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        return view;
    }

    public void onResume() {
        ZoomGroup group;
        ZoomMessenger messenger;
        super.onResume();
        this.updateData();
        ABContactsCache.getInstance().addListener(this);
        if (ABContactsCache.getInstance().needReloadAll()) {
            ABContactsCache.getInstance().reloadAllContacts();
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) != null && (group = messenger.getGroupById(this.mGroupId)) != null && !group.amIInGroup()) {
            this.onClickBtnBack();
        }
    }

    private void updateData() {
        if (this.mGvBuddies != null) {
            this.mGvBuddies.loadAllBuddies(null, null, this.mGroupId);
            this.mGvBuddies.notifyDataSetChanged();
        }
        this.updateTitle();
    }

    private void updateTitle() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        int count = group.getBuddyCount();
        String title = context.getString(R.string.zm_mm_title_chat_options_group, new Object[]{count});
        this.mTxtTitle.setText((CharSequence)title);
    }

    @Override
    public void onContactsCacheUpdated() {
        if (this.mGvBuddies != null) {
            this.mGvBuddies.loadAllBuddies(null, null, this.mGroupId);
            this.mGvBuddies.notifyDataSetChanged();
        }
    }

    public void onPause() {
        super.onPause();
        ABContactsCache.getInstance().removeListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    private void onGroupAction(final int result, final GroupAction action, String messageId) {
        if (action.getActionType() == 3) {
            ZoomMessenger messenger;
            String groupId = action.getGroupId();
            if (!StringUtil.isSameString((String)groupId, (String)this.mGroupId)) {
                return;
            }
            if (this.isResumed()) {
                this.updateTitle();
            }
            if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                if (this.isResumed()) {
                    this.mGvBuddies.loadAllBuddies(null, null, this.mGroupId);
                    this.mGvBuddies.notifyDataSetChanged();
                }
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("GroupAction.ACTION_ADD_BUDDIES"){

                public void run(IUIElement ui) {
                    MMGroupBuddiesFragment f = (MMGroupBuddiesFragment)ui;
                    if (f != null) {
                        f.handleGroupActionAddBuddies(result, action);
                    }
                }
            });
        } else if (action.getActionType() == 4) {
            String groupId = action.getGroupId();
            if (!StringUtil.isSameString((String)groupId, (String)this.mGroupId)) {
                return;
            }
            if (this.isResumed()) {
                this.updateTitle();
            }
            if (this.isResumed() && action.isMeInBuddies()) {
                this.onClickBtnBack();
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                if (this.isResumed()) {
                    this.mGvBuddies.loadAllBuddies(null, null, this.mGroupId);
                    this.mGvBuddies.notifyDataSetChanged();
                }
                return;
            }
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("GroupAction.ACTION_REMOVE_BUDDY"){

                public void run(IUIElement ui) {
                    MMGroupBuddiesFragment f = (MMGroupBuddiesFragment)ui;
                    if (f != null) {
                        f.handleGroupActionRemoveBuddy(result, action);
                    }
                }
            });
        }
    }

    private void handleGroupActionAddBuddies(int result, GroupAction action) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.mGvBuddies.loadAllBuddies(null, null, this.mGroupId);
            this.mGvBuddies.notifyDataSetChanged();
            List<String> buddies = action.getNotAllowBuddies();
            if (buddies != null) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < buddies.size(); ++i) {
                    if (StringUtil.isEmptyOrNull((String)buddies.get(i))) continue;
                    buffer.append(buddies.get(i));
                    buffer.append(",");
                }
                if (buffer.length() > 0) {
                    String buddiesName = buffer.substring(0, buffer.length() - 1);
                    Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.zm_mm_msg_add_buddies_not_allowed, new Object[]{buddiesName}), (int)1).show();
                }
            }
        } else {
            this.showAddBuddiesFailureMessage(result);
        }
    }

    private void handleGroupActionRemoveBuddy(int result, GroupAction action) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.mGvBuddies.loadAllBuddies(null, null, this.mGroupId);
            this.mGvBuddies.setIsRemoveMode(true);
            this.mGvBuddies.notifyDataSetChanged();
        } else {
            this.showRemoveBuddyFailureMessage(result);
        }
    }

    private void On_NotifyGroupDestroy(String groupID, String groupName, long tm) {
        if (!StringUtil.isSameString((String)groupID, (String)this.mGroupId)) {
            return;
        }
        Intent data = new Intent();
        data.putExtra("isQuitGroup", true);
        this.getActivity().setResult(-1, data);
        this.getActivity().finish();
    }

    private void On_AssignGroupAdmins(final int result, String actionOwner, String groupID, List<String> buddies, long tm) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getMyself();
        if (buddy == null) {
            return;
        }
        if (!StringUtil.isSameString((String)actionOwner, (String)buddy.getJid())) {
            return;
        }
        this.dismissWaitingDialog();
        if (result != 0) {
            this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("AssignGroupAdmins"){

                public void run(IUIElement ui) {
                    FragmentActivity activty = MMGroupBuddiesFragment.this.getActivity();
                    if (activty == null) {
                        return;
                    }
                    Toast.makeText((Context)activty, (CharSequence)activty.getString(R.string.zm_mm_msg_assign_admin_failed, new Object[]{result}), (int)1).show();
                }
            });
        } else {
            this.quitGroup();
        }
    }

    private void quitGroup() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        boolean res = messenger.deleteGroup(this.mGroupId);
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showQuitGroupFailureMessage(1);
        }
    }

    private void showQuitGroupFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
            return;
        }
        String msg = context.getString(R.string.zm_mm_msg_quit_group_failed, new Object[]{result});
        Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
    }

    private void onIndicateInfoUpdatedWithJID(String jid) {
    }

    private void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        if (StringUtil.isSameString((String)groupID, (String)this.mGroupId)) {
            this.updateData();
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        }
    }

    public MMChatBuddiesGridView getMMChatBuddiesGridView() {
        return this.mGvBuddies;
    }

    private void onClickBtnBack() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        if (this.getShowsDialog()) {
            this.dismiss();
        } else if (activity != null) {
            activity.setResult(0);
            activity.finish();
        }
    }

    @Override
    public void onClickAddBtn() {
        List<MMBuddyItem> items;
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        ArrayList<String> preSelectedItems = null;
        if (this.mGvBuddies != null && (items = this.mGvBuddies.getAllItems()) != null) {
            preSelectedItems = new ArrayList<String>();
            for (MMBuddyItem item : items) {
                preSelectedItems.add(item.getBuddyJid());
            }
        }
        String title = activity.getString(R.string.zm_mm_title_add_contacts);
        String btnOkText = activity.getString(R.string.zm_btn_ok);
        String instructionMessage = this.getString(R.string.zm_msg_select_buddies_to_join_group_instructions);
        boolean onlySameOrganization = false;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        onlySameOrganization = (group.getMucType() & 4) != 0;
        MMSelectContactsActivity.SelectContactsParamter paramters = new MMSelectContactsActivity.SelectContactsParamter();
        paramters.title = title;
        paramters.preSelectedItems = preSelectedItems;
        paramters.btnOkText = btnOkText;
        paramters.instructionMessage = instructionMessage;
        paramters.isAnimBottomTop = true;
        paramters.isOnlySameOrganization = onlySameOrganization;
        paramters.maxSelectCount = PTApp.getInstance().getMaxChatGroupBuddyNumber();
        paramters.includeRobot = false;
        paramters.isContainsAllInGroup = false;
        MMSelectContactsActivity.show((Fragment)this, paramters, 100, null);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null) {
            ArrayList abItems = (ArrayList)data.getSerializableExtra("selectedItems");
            if (abItems == null) {
                return;
            }
            this.onContactsSelected(abItems);
        }
    }

    @Override
    public void onRemoveBuddy(MMBuddyItem item) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        if (StringUtil.isSameString((String)myself.getJid(), (String)item.getBuddyJid())) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        boolean res = messenger.removeBuddyFromGroup(this.mGroupId, item.getBuddyJid());
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showRemoveBuddyFailureMessage(1);
        }
    }

    @Override
    public void onClickBuddyItem(MMBuddyItem item) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(item.getBuddyJid());
        if (buddy == null) {
            return;
        }
        if (StringUtil.isSameString((String)buddy.getJid(), (String)myself.getJid())) {
            return;
        }
        IMAddrBookItem contact = item.getLocalContact();
        if (contact == null) {
            contact = IMAddrBookItem.fromZoomBuddy(buddy);
        }
        if (contact != null) {
            contact.setIsZoomUser(true);
        }
        AddrBookItemDetailsActivity.show((Fragment)this, contact, false, 100);
    }

    public void onContactsSelected(ArrayList<IMAddrBookItem> abItems) {
        if (abItems == null || abItems.size() == 0) {
            return;
        }
        this.addBuddiesToGroup(abItems);
    }

    private void addBuddiesToGroup(ArrayList<IMAddrBookItem> abItems) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (IMAddrBookItem item : abItems) {
            String jid = item.getJid();
            if (StringUtil.isEmptyOrNull((String)jid)) continue;
            buddies.add(item.getJid());
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        boolean res = messenger.addBuddyToGroup(this.mGroupId, buddies);
        if (res) {
            this.showWaitingDialog();
        } else {
            this.showAddBuddiesFailureMessage(1);
        }
    }

    private void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        this.mWaitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        this.mWaitingDialog.setCancelable(true);
        this.mWaitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        } else if (this.mWaitingDialog != null) {
            try {
                this.mWaitingDialog.dismissAllowingStateLoss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mWaitingDialog = null;
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    private void showAddBuddiesFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
        } else if (result == 8) {
            Toast.makeText((Context)context, (int)R.string.zm_mm_msg_add_buddies_to_group_failed_too_many_buddies, (int)1).show();
        } else {
            String msg = context.getString(R.string.zm_mm_msg_add_buddies_to_group_failed, new Object[]{result});
            Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
        }
    }

    private void showRemoveBuddyFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
            return;
        }
        String msg = context.getString(R.string.zm_mm_msg_remove_buddy_from_group_failed, new Object[]{result});
        Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
    }
}

