/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.ptapp.MeetingInfo;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class LoginAsHostAlertDialog
extends ZMDialogFragment {
    private static String TAG = LoginAsHostAlertDialog.class.getSimpleName();

    public static void showLoginAsHostAlertDialog(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        if (!ConfMgr.getInstance().isConfConnected()) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        LoginAsHostAlertDialog dlg = new LoginAsHostAlertDialog();
        Bundle args = new Bundle();
        dlg.setArguments(args);
        dlg.show(activity.getSupportFragmentManager(), LoginAsHostAlertDialog.class.getName());
    }

    public LoginAsHostAlertDialog() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return new Dialog((Context)this.getActivity());
        }
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        String hostName = meetingInfo.getMeetingHostName();
        if (hostName == null) {
            hostName = "";
        }
        final String joinMeetingUrl = meetingInfo.getJoinMeetingUrl();
        String message = this.getString(R.string.zm_msg_login_as_host, new Object[]{hostName, hostName});
        return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(message).setCancelable(true).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LoginAsHostAlertDialog.this.loginAsHost(joinMeetingUrl);
            }
        }).create();
    }

    private void loginAsHost(String joinMeetingUrl) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, IMActivity.class);
        intent.setAction(IMActivity.ACTION_LOGIN_AS_HOST);
        intent.putExtra(IMActivity.ARG_JOIN_MEETING_URL, joinMeetingUrl);
        intent.addFlags(131072);
        activity.startActivity(intent);
        activity.finish();
    }
}

