/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.JoinByURLActivity;
import com.zipow.videobox.view.JoinConfView;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class JoinConfFragment
extends ZMDialogFragment
implements JoinConfView.Listener {
    public static final String ARG_CONF_NUMBER = "hangoutNumber";
    public static final String ARG_SCREEN_NAME = "screenName";
    public static final String ARG_URL_ACTION = "urlAction";
    private JoinConfView mView;

    public static void showJoinByNumber(FragmentManager fm, String confNumber, String screenName) {
        JoinConfFragment f = new JoinConfFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_CONF_NUMBER, confNumber);
        bundle.putString(ARG_SCREEN_NAME, screenName);
        f.setArguments(bundle);
        f.show(fm, JoinConfFragment.class.getName());
    }

    public static void showJoinByUrl(FragmentManager fm, String urlAction) {
        JoinConfFragment f = new JoinConfFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_URL_ACTION, urlAction);
        f.setArguments(bundle);
        f.show(fm, JoinConfFragment.class.getName());
    }

    public static JoinConfFragment getJoinConfFragment(FragmentManager fm) {
        return (JoinConfFragment)fm.findFragmentByTag(JoinConfFragment.class.getName());
    }

    public JoinConfFragment() {
        this.setStyle(1, R.style.ZMDialog);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        FragmentActivity context;
        this.mView = new JoinConfView((Context)this.getActivity());
        this.mView.setListener(this);
        Bundle args = this.getArguments();
        if (args != null) {
            String confNumber = args.getString(ARG_CONF_NUMBER);
            String screenName = args.getString(ARG_SCREEN_NAME);
            String urlAction = args.getString(ARG_URL_ACTION);
            if (confNumber != null && confNumber.length() > 0) {
                this.mView.setConfNumber(confNumber);
            } else if (urlAction != null && urlAction.length() > 0) {
                this.mView.setUrlAction(urlAction);
            }
            if (screenName != null && screenName.length() > 0) {
                this.mView.setScreenName(screenName);
            }
        }
        if ((context = this.getActivity()) == null) {
            return this.mView;
        }
        float height = UIUtil.getDisplayHeightInDip((Context)context);
        if (UIUtil.isPortraitMode((Context)context) && height > 540.0f || UIUtil.isLargeScreen((Context)context)) {
            this.getActivity().getWindow().setSoftInputMode(4);
        } else {
            this.getActivity().getWindow().setSoftInputMode(2);
        }
        return this.mView;
    }

    @Override
    public void onJoinByNumber(long confNumber, String screenName, String vanityUrl, boolean noAudio, boolean noVideo) {
        this.finish(true);
        ConfActivity.joinById((Context)this.getActivity(), confNumber, screenName, vanityUrl, null, noAudio, noVideo);
    }

    @Override
    public void onJoinByUrl(String urlAction, String screenName) {
        this.finish(true);
        ConfActivity.joinByUrl((Context)this.getActivity(), urlAction, screenName);
    }

    @Override
    public void onBack() {
        this.finish(false);
    }

    private void finish(boolean ok) {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
                activity.overridePendingTransition(R.anim.zm_fade_in, R.anim.zm_slide_out_bottom);
            }
        }
    }

    public void onDismiss(DialogInterface dialog) {
        FragmentActivity activity;
        super.onDismiss(dialog);
        if (this.getShowsDialog() && (activity = this.getActivity()) instanceof JoinByURLActivity) {
            activity.finish();
        }
    }
}

