/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.InviteActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.fragment.InviteByPhoneFragment;
import com.zipow.videobox.fragment.InviteRoomSystemFragment;
import com.zipow.videobox.fragment.SelectCountryCodeFragment;
import com.zipow.videobox.ptapp.CountryCode;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PT_LOGIN_TYPE;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.util.InviteContentGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.template.Template;
import us.zoom.videomeetings.R;

public class InviteViaDialogFragment
extends ZMDialogFragment {
    private static final String TAG = InviteViaDialogFragment.class.getSimpleName();
    private static final String ARG_TOPIC = "topic";
    private static final String ARG_CONTENT = "content";
    private static final String ARG_SMS_CONTENT = "smsContent";
    private static final String ARG_MEETING_URL = "meetingUrl";
    private static final String ARG_MEETING_ID = "meetingId";
    private static final String ARG_MEETING_PSW = "meetingPassword";
    private static final String ARG_MEETING_RAW_PSW = "meetingRawPassword";
    private static final String ARG_REQUEST_CODE_FOR_INVITE_BUDDIES = "requestCodeForInviteBuddies";
    private static final String ARG_REQUEST_CODE_FOR_INVITE_BY_PHONE = "requestCodeForInviteByPhone";
    private static final String ARG_REQUEST_CODE_FOR_INVITE_ROOM_SYSTEM = "requestCodeForInviteRoomSystem";
    private OptionListAdapter mAdapter;

    public static void show(FragmentManager fm, String topic, String content, String smsContent, String meetingUrl, long meetingId, String password, String rawPassword, int requestCodeForInviteBuddies, int requestCodeForInviteByPhone, int requestCodeForInviteRoomSystem) {
        if (StringUtil.isEmptyOrNull((String)smsContent)) {
            smsContent = content;
        }
        Bundle args = new Bundle();
        args.putString(ARG_TOPIC, topic);
        args.putString(ARG_CONTENT, content);
        args.putString(ARG_SMS_CONTENT, smsContent);
        args.putString(ARG_MEETING_URL, meetingUrl);
        args.putLong(ARG_MEETING_ID, meetingId);
        args.putString(ARG_MEETING_PSW, password);
        args.putString(ARG_MEETING_RAW_PSW, rawPassword);
        args.putInt(ARG_REQUEST_CODE_FOR_INVITE_BUDDIES, requestCodeForInviteBuddies);
        args.putInt(ARG_REQUEST_CODE_FOR_INVITE_BY_PHONE, requestCodeForInviteByPhone);
        args.putInt(ARG_REQUEST_CODE_FOR_INVITE_ROOM_SYSTEM, requestCodeForInviteRoomSystem);
        InviteViaDialogFragment f = new InviteViaDialogFragment();
        f.setArguments(args);
        f.show(fm, InviteViaDialogFragment.class.getName());
    }

    public static boolean dismiss(FragmentManager fm) {
        if (fm == null) {
            return false;
        }
        InviteViaDialogFragment f = (InviteViaDialogFragment)fm.findFragmentByTag(InviteViaDialogFragment.class.getName());
        if (f != null) {
            f.dismissAllowingStateLoss();
            return true;
        }
        return false;
    }

    public InviteViaDialogFragment() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.mAdapter = new OptionListAdapter((ZMActivity)this.getActivity());
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_title_invite).setAdapter((ListAdapter)this.mAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                InviteViaDialogFragment.this.onClickItem(InviteViaDialogFragment.this.mAdapter, which);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    public void onResume() {
        super.onResume();
        this.mAdapter.reloadAll();
        if (this.mAdapter.getCount() == 1) {
            this.onClickItem(this.mAdapter, 0);
            this.dismiss();
            return;
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void onClickItem(OptionListAdapter adapter, int which) {
        Bundle args = this.getArguments();
        String topic = args.getString(ARG_TOPIC);
        String content = args.getString(ARG_CONTENT);
        String smsContent = args.getString(ARG_SMS_CONTENT);
        String meetingUrl = args.getString(ARG_MEETING_URL);
        long meetingId = args.getLong(ARG_MEETING_ID, 0L);
        String meetingPassword = args.getString(ARG_MEETING_PSW);
        String meetingRawPassword = args.getString(ARG_MEETING_RAW_PSW);
        Object item = adapter.getItem(which);
        if (item instanceof InviteAppItem) {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            ResolveInfo info = ((InviteAppItem)item).app;
            if (((InviteAppItem)item).type == 0) {
                AndroidAppUtil.sendEmailVia((ResolveInfo)info, (Context)activity, null, (String)topic, (String)content, null);
            } else if (((InviteAppItem)item).type == 1) {
                AndroidAppUtil.sendSMSVia((ResolveInfo)info, (Context)activity, null, (String)smsContent);
            } else if (((InviteAppItem)item).type == 2) {
                this.onClickCustomMeetingInvite(info, (Activity)activity, meetingUrl, topic, content, meetingId, meetingPassword, meetingRawPassword);
            }
        } else if (item instanceof Invite3rdPartyIMContactsItem) {
            this.onClickSendIM();
        } else if (item instanceof InviteCopyItem) {
            this.onClickCopyURL();
        } else if (item instanceof InviteAddrBookItem) {
            this.onClickInviteAddrBookItem();
        } else if (item instanceof InviteZoomRoomsItem) {
            this.onClickInviteZoomRoomsItem();
        } else if (item instanceof InviteByPhoneItem) {
            this.onClickInviteByPhoneItem();
        } else if (item instanceof InviteRoomSystemItem) {
            this.onClickInviteRoomSystem();
        }
    }

    private void onClickCustomMeetingInvite(ResolveInfo info, Activity activity, String meetingUrl, String topic, String content, long meetingId, String meetingPassword, String meetingRawPassword) {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        int requestCode = args.getInt(ARG_REQUEST_CODE_FOR_INVITE_BUDDIES);
        AndroidAppUtil.sendZoomMeetingInvitationVia((ResolveInfo)info, (Activity)activity, (String)meetingUrl, (String)topic, (String)content, (long)meetingId, (String)meetingPassword, (String)meetingRawPassword, (int)requestCode);
    }

    private void onClickSendIM() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        int requestCode = args.getInt(ARG_REQUEST_CODE_FOR_INVITE_BUDDIES);
        this.showInviteBuddies((Activity)activity, false, requestCode);
    }

    private void showInviteBuddies(Activity activity, boolean isAddrBook, int requestCode) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            Intent intent = new Intent((Context)this.getActivity(), InviteActivity.class);
            intent.putExtra("meetingNumber", confContext.getConfNumber());
            intent.putExtra(ARG_MEETING_ID, confContext.getMeetingId());
            if (isAddrBook) {
                intent.putExtra("inviteAddrBook", true);
            }
            activity.startActivityForResult(intent, requestCode);
        }
    }

    private void showInviteZoomRooms(Activity activity, int requestCode) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            Intent intent = new Intent((Context)this.getActivity(), InviteActivity.class);
            intent.putExtra("meetingNumber", confContext.getConfNumber());
            intent.putExtra(ARG_MEETING_ID, confContext.getMeetingId());
            intent.putExtra("inviteZoomRooms", true);
            activity.startActivityForResult(intent, requestCode);
        }
    }

    private void onClickCopyURL() {
        CmmConfContext context = ConfMgr.getInstance().getConfContext();
        if (context == null) {
            return;
        }
        MeetingInfo meetingInfo = context.getMeetingItem();
        if (meetingInfo == null) {
            return;
        }
        String url = meetingInfo.getJoinMeetingUrl();
        if (url == null) {
            return;
        }
        long meetingId = meetingInfo.getMeetingNumber();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        String myName = null;
        if (myself != null) {
            myName = myself.getScreenName();
        }
        String password = meetingInfo.getPassword();
        String rawPassword = context.getRawMeetingPassword();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("joinMeetingUrl", url);
        config.put(ARG_MEETING_ID, String.valueOf(meetingId));
        Template template = new Template(this.getString(R.string.zm_msg_meeting_url_for_copy_to_clipboard));
        String copyText = template.format(config);
        String className = ResourcesUtil.getString((Context)this.getActivity(), (int)R.string.zm_config_invite_content_generator);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            InviteContentGenerator generator = (InviteContentGenerator)clazz.newInstance();
            String genCopyUrlTxt = generator.genCopyUrlText((Context)VideoBoxApplication.getInstance(), meetingId, url, myName, password, rawPassword);
            if (!StringUtil.isEmptyOrNull((String)genCopyUrlTxt)) {
                copyText = genCopyUrlTxt;
            }
        }
        catch (Exception generator) {
            // empty catch block
        }
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            AndroidAppUtil.copyText((Context)activity, (CharSequence)copyText);
        }
    }

    private void onClickInviteAddrBookItem() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        int requestCode = args.getInt(ARG_REQUEST_CODE_FOR_INVITE_BUDDIES);
        this.showInviteBuddies((Activity)activity, true, requestCode);
    }

    private void onClickInviteZoomRoomsItem() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        int requestCode = args.getInt(ARG_REQUEST_CODE_FOR_INVITE_BUDDIES);
        this.showInviteZoomRooms((Activity)activity, requestCode);
    }

    private void onClickInviteByPhoneItem() {
        Bundle args;
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        MeetingInfo meetingItem = confContext.getMeetingItem();
        if (meetingItem == null) {
            return;
        }
        int supportCallOutType = meetingItem.getSupportCallOutType();
        ArrayList<CountryCode> codes = meetingItem.getCalloutCountryCodesList();
        ArrayList<SelectCountryCodeFragment.CountryCodeItem> calloutCodes = null;
        if (codes != null && codes.size() > 0) {
            calloutCodes = new ArrayList<SelectCountryCodeFragment.CountryCodeItem>();
            for (CountryCode code : codes) {
                String strCode = code.getCode();
                if (strCode.startsWith("+")) {
                    strCode = strCode.substring(1);
                }
                calloutCodes.add(new SelectCountryCodeFragment.CountryCodeItem(strCode, code.getId(), code.getName()));
            }
        }
        if ((args = this.getArguments()) == null) {
            return;
        }
        int requestCode = args.getInt(ARG_REQUEST_CODE_FOR_INVITE_BY_PHONE);
        InviteByPhoneFragment.showAsActivity(activity, supportCallOutType, calloutCodes, requestCode);
    }

    private void onClickInviteRoomSystem() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        int requestCode = args.getInt(ARG_REQUEST_CODE_FOR_INVITE_ROOM_SYSTEM);
        InviteRoomSystemFragment.showAsActivity(activity, null, requestCode);
    }

    static class OptionListAdapter
    extends BaseAdapter {
        private ZMActivity mActivity;
        private List<Object> mList = new ArrayList<Object>();

        public OptionListAdapter(ZMActivity activity) {
            this.mActivity = activity;
        }

        public void reloadAll() {
            this.mList.clear();
            int inviteOptions = this.getInviteOptions();
            List meetingInviteApps = AndroidAppUtil.queryZoomMeetingInviteActivities((Context)this.mActivity);
            for (Object info : meetingInviteApps) {
                this.mList.add(new InviteAppItem((ResolveInfo)info, 2));
            }
            if (ResourcesUtil.getBoolean((Context)this.mActivity, (int)R.bool.zm_config_invite_by_only_action_meeting_invite, (boolean)false)) {
                return;
            }
            if ((inviteOptions & 1) != 0) {
                List smsApps = AndroidAppUtil.querySMSActivities((Context)this.mActivity);
                for (ResolveInfo info : smsApps) {
                    this.mList.add(new InviteAppItem(info, 1));
                }
            }
            if ((inviteOptions & 2) != 0) {
                List emailApps = AndroidAppUtil.queryEmailActivities((Context)this.mActivity);
                for (ResolveInfo info : emailApps) {
                    this.mList.add(new InviteAppItem(info, 0));
                }
            }
            int loginType = PTAppDelegation.getInstance().getPTLoginType();
            boolean signedIn = PTAppDelegation.getInstance().isWebSignedOn();
            if (signedIn && PT_LOGIN_TYPE.isTypeSupportIM(loginType)) {
                int strId = 0;
                int iconId = 0;
                switch (loginType) {
                    case 0: {
                        if (!ConfMgr.getInstance().isFacebookImEnabled()) break;
                        strId = R.string.zm_lbl_invite_buddy_fb;
                        iconId = R.drawable.zm_ic_setting_fb;
                        break;
                    }
                    case 2: {
                        if (!ConfMgr.getInstance().isGoogleImEnabled()) break;
                        strId = R.string.zm_lbl_invite_buddy_google;
                        iconId = R.drawable.zm_ic_setting_google;
                    }
                }
                if (strId > 0 && iconId > 0) {
                    this.mList.add(new Invite3rdPartyIMContactsItem(iconId, this.mActivity.getString(strId)));
                }
            }
            boolean isZoomMessengerSupported = false;
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null) {
                isZoomMessengerSupported = confContext.hasZoomIM();
            }
            if (signedIn && isZoomMessengerSupported && !VideoBoxApplication.getInstance().isSDKMode()) {
                this.mList.add(new InviteAddrBookItem(R.drawable.zm_invite_contacts, this.mActivity.getString(R.string.zm_lbl_invite_buddy_zoom)));
            }
            if (signedIn && isZoomMessengerSupported && !VideoBoxApplication.getInstance().isSDKMode() && (confContext.getUserOption2() & 0x8000L) != 0L) {
                this.mList.add(new InviteZoomRoomsItem(R.drawable.zm_invite_zoom_rooms, this.mActivity.getString(R.string.zm_lbl_invite_zoom_rooms)));
            }
            if (this.isCalloutSupported()) {
                this.mList.add(new InviteByPhoneItem(R.drawable.zm_ic_invitebyphone, this.mActivity.getString(R.string.zm_callout_title_invite)));
            }
            if (this.isRoomSystemSupported()) {
                this.mList.add(new InviteRoomSystemItem(R.drawable.zm_ic_invite_roomsystem, this.mActivity.getString(R.string.zm_lbl_invite_room_system)));
            }
            if (!this.isCopyURLDisabled() && (inviteOptions & 4) != 0) {
                this.mList.add(new InviteCopyItem(R.drawable.zm_copy, this.mActivity.getString(R.string.zm_lbl_copy_url)));
            }
        }

        private boolean isCopyURLDisabled() {
            return ResourcesUtil.getBoolean((Context)this.mActivity, (int)R.bool.zm_config_no_copy_url, (boolean)false);
        }

        private boolean isCalloutSupported() {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return false;
            }
            ParamsList params = confContext.getAppContextParams();
            if (params.getBoolean("no_dial_out_to_phone", false)) {
                return false;
            }
            MeetingInfo meetingItem = confContext.getMeetingItem();
            if (meetingItem == null) {
                return false;
            }
            int supportCallOutType = meetingItem.getSupportCallOutType();
            return 0 != supportCallOutType && !meetingItem.getTelephonyOff();
        }

        private boolean isRoomSystemSupported() {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return false;
            }
            MeetingInfo info = confContext.getMeetingItem();
            if (info == null) {
                return false;
            }
            return info.getIsH323Enabled();
        }

        private int getInviteOptions() {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null) {
                ParamsList params = confContext.getAppContextParams();
                if (params == null) {
                    return 255;
                }
                int inviteOptions = params.getInt("invite_options", 255);
                return inviteOptions;
            }
            return 255;
        }

        public int getCount() {
            return this.mList.size();
        }

        public Object getItem(int position) {
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = View.inflate((Context)this.mActivity, (int)R.layout.zm_app_item, null);
            }
            ImageView imgIcon = (ImageView)convertView.findViewById(R.id.imgIcon);
            TextView txtLabel = (TextView)convertView.findViewById(R.id.txtLabel);
            Object item = this.mList.get(position);
            if (item instanceof InviteAppItem) {
                InviteAppItem appItem = (InviteAppItem)item;
                if (appItem.type == 2) {
                    ResolveInfo info = appItem.app;
                    txtLabel.setText((CharSequence)AndroidAppUtil.getActivityLabel((Context)this.mActivity, (ResolveInfo)info));
                    imgIcon.setImageDrawable(AndroidAppUtil.getActivityIcon((Context)this.mActivity, (ResolveInfo)info));
                } else {
                    ResolveInfo info = ((InviteAppItem)item).app;
                    txtLabel.setText((CharSequence)AndroidAppUtil.getApplicationLabel((Context)this.mActivity, (ResolveInfo)info));
                    imgIcon.setImageDrawable(AndroidAppUtil.getApplicationIcon((Context)this.mActivity, (ResolveInfo)info));
                }
            } else if (item instanceof BasicItem) {
                BasicItem basicItem = (BasicItem)item;
                txtLabel.setText((CharSequence)basicItem.label);
                imgIcon.setImageResource(basicItem.iconRes);
            }
            return convertView;
        }
    }

    static class InviteRoomSystemItem
    extends BasicItem {
        public InviteRoomSystemItem(int iconRes, String label) {
            super(iconRes, label);
        }
    }

    static class InviteByPhoneItem
    extends BasicItem {
        public InviteByPhoneItem(int iconRes, String label) {
            super(iconRes, label);
        }
    }

    static class InviteZoomRoomsItem
    extends BasicItem {
        public InviteZoomRoomsItem(int iconRes, String label) {
            super(iconRes, label);
        }
    }

    static class InviteAddrBookItem
    extends BasicItem {
        public InviteAddrBookItem(int iconRes, String label) {
            super(iconRes, label);
        }
    }

    static class InviteCopyItem
    extends BasicItem {
        public InviteCopyItem(int iconRes, String label) {
            super(iconRes, label);
        }
    }

    static class Invite3rdPartyIMContactsItem
    extends BasicItem {
        public Invite3rdPartyIMContactsItem(int iconRes, String label) {
            super(iconRes, label);
        }
    }

    static class BasicItem {
        int iconRes;
        String label;

        public BasicItem(int iconRes, String label) {
            this.iconRes = iconRes;
            this.label = label;
        }
    }

    static class InviteAppItem {
        public static final int TYPE_EMAIL = 0;
        public static final int TYPE_SMS = 1;
        public static final int TYPE_ZOOM_MEETING_INVITE = 2;
        ResolveInfo app;
        int type = 0;

        public InviteAppItem(ResolveInfo app, int type) {
            this.app = app;
            this.type = type;
        }
    }
}

