/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.AddrBookSetNumberActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.ContactsMatchHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.view.InviteLocalContactsListView;
import com.zipow.videobox.view.LocalContactItem;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMSendMessageFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

@Deprecated
public class InviteLocalContactsFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
TextView.OnEditorActionListener,
PTUI.IPhoneABListener,
PTUI.IPTUIListener,
PTUI.IIMListener,
ABContactsCache.IABContactsCacheListener {
    private final String TAG = InviteLocalContactsFragment.class.getSimpleName();
    private static final int REQUEST_SET_PHONE_NUMBER = 100;
    private static final String ARG_SHOW_AS_DIALOG = "showAsDialog";
    private InviteLocalContactsListView mListView;
    private EditText mEdtSearch;
    private Button mBtnClearSearchView;
    private Button mBtnBack;
    private View mPanelNoItemMsg;
    private TextView mTxtNoContactsMessage;
    private ImageView mImgNoBuddy;
    private TextView mTxtTitle;
    private View mContentView;
    private View mPanelTitleBar;
    private FrameLayout mListContainer;
    private Drawable mDimmedForground = null;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            if (ABContactsHelper.isMatchPhoneNumbersCalled()) {
                String key = InviteLocalContactsFragment.this.mEdtSearch.getText().toString();
                InviteLocalContactsFragment.this.mListView.filter(key);
                if (key.length() > 0 && InviteLocalContactsFragment.this.mListView.getCount() > 0 || InviteLocalContactsFragment.this.mPanelTitleBar.getVisibility() == 0) {
                    InviteLocalContactsFragment.this.mListContainer.setForeground(null);
                } else {
                    InviteLocalContactsFragment.this.mListContainer.setForeground(InviteLocalContactsFragment.this.mDimmedForground);
                }
            }
        }
    };

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_SHOW_AS_DIALOG, false);
        SimpleActivity.show(activity, InviteLocalContactsFragment.class.getName(), args, 0);
    }

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_SHOW_AS_DIALOG, false);
        SimpleActivity.show(fragment, InviteLocalContactsFragment.class.getName(), args, 0);
    }

    public static InviteLocalContactsFragment newInstance(int mode) {
        Bundle args = new Bundle();
        InviteLocalContactsFragment fragment = new InviteLocalContactsFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        boolean showAsDialog = args.getBoolean(ARG_SHOW_AS_DIALOG);
        if (!showAsDialog) {
            this.setShowsDialog(false);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_invite_local_contacts_list, container, false);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mListView = (InviteLocalContactsListView)view.findViewById(R.id.addrBookListView);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        this.mTxtNoContactsMessage = (TextView)view.findViewById(R.id.txtNoContactsMessage);
        this.mImgNoBuddy = (ImageView)view.findViewById(R.id.imgNoBuddy);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                InviteLocalContactsFragment.this.mHandler.removeCallbacks(InviteLocalContactsFragment.this.mRunnableFilter);
                InviteLocalContactsFragment.this.mHandler.postDelayed(InviteLocalContactsFragment.this.mRunnableFilter, 300L);
                InviteLocalContactsFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mListView.setParentFragment(this);
        if (this.getActivity() instanceof IMActivity && !((IMActivity)this.getActivity()).isKeyboardOpen()) {
            this.onKeyboardClosed();
        }
        this.mPanelNoItemMsg.setVisibility(8);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        SparseArray container = new SparseArray();
        View view = this.getView();
        if (view != null) {
            view.saveHierarchyState(container);
        } else if (this.mContentView != null) {
            this.mContentView.saveHierarchyState(container);
        }
        outState.putSparseParcelableArray(InviteLocalContactsFragment.class.getName() + ".State", container);
        super.onSaveInstanceState(outState);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1) {
            String countryCode = null;
            String number = null;
            if (data != null) {
                countryCode = data.getStringExtra("countryCode");
                number = data.getStringExtra("number");
            }
            this.onSetPhoneNumberDone(countryCode, number);
        }
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    private void onClickBtnBack() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.finish();
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    public boolean isFocusedOnSearchField() {
        if (this.getView() == null) {
            return false;
        }
        return this.mEdtSearch.hasFocus();
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearch.hasFocus()) {
            this.mEdtSearch.setCursorVisible(true);
            this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_focused);
            this.mPanelTitleBar.setVisibility(8);
            this.mListContainer.setForeground(this.mDimmedForground);
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearch.setCursorVisible(false);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_normal);
        this.mPanelTitleBar.setVisibility(0);
        this.mListContainer.setForeground(null);
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addPTUIListener(this);
        PTUI.getInstance().addIMListener(this);
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.addListener(this);
        ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
        if (helper == null) {
            return;
        }
        boolean reloadDone = true;
        if (cache.needReloadAll() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber())) {
            this.matchNewNumbers();
            reloadDone = cache.reloadAllContacts();
            if (reloadDone) {
                InviteLocalContactsListView.clearCaches();
            }
        }
        if (reloadDone && PTApp.getInstance().isWebSignedOn() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber()) && ABContactsHelper.isTimeToMatchPhoneNumbers()) {
            this.startABMatching();
        } else if (!StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber())) {
            this.matchNewNumbers();
        }
        this.refreshAll(true);
    }

    private void matchNewNumbers() {
        if (!PTApp.getInstance().isWebSignedOn()) {
            return;
        }
        int ret = ContactsMatchHelper.getInstance().matchNewNumbers((Context)this.getActivity());
        if (ret != 0) {
            if (ret == -1) {
                this.reloadAllItems(true);
            } else {
                this.showErrorDialog(ret);
            }
        }
    }

    private void updateUI() {
        if (PTApp.getInstance().isPhoneNumberRegistered()) {
            this.mEdtSearch.setVisibility(0);
            this.mTxtTitle.setText(R.string.zm_title_mm_add_phone_contacts);
        } else {
            this.mEdtSearch.setVisibility(8);
        }
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
        PTUI.getInstance().removeIMListener(this);
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.removeListener(this);
    }

    @Override
    public void onContactsCacheUpdated() {
        InviteLocalContactsListView.clearCaches();
        ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
        if (helper == null) {
            return;
        }
        if (PTApp.getInstance().isWebSignedOn() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber()) && ABContactsHelper.isTimeToMatchPhoneNumbers()) {
            this.startABMatching();
        } else if (!StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber())) {
            this.matchNewNumbers();
        }
        if (this.isResumed()) {
            this.refreshAll(true);
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        SparseArray myState = null;
        if (savedInstanceState != null) {
            myState = savedInstanceState.getSparseParcelableArray(InviteLocalContactsFragment.class.getName() + ".State");
        }
        this.mContentView = this.getView();
        if (this.mContentView != null && myState != null) {
            this.mContentView.restoreHierarchyState(myState);
        }
        if (this.mContentView == null) {
            this.mContentView = this.onCreateView(this.getLayoutInflater(savedInstanceState), null, savedInstanceState);
            if (this.mContentView != null && myState != null) {
                this.mContentView.restoreHierarchyState(myState);
            }
        }
        PTUI.getInstance().addPhoneABListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity.isFinishing() || this.isRemoving()) {
            PTUI.getInstance().removePhoneABListener(this);
        }
        this.mHandler.removeCallbacks(this.mRunnableFilter);
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    public void enableAddrBook() {
        AddrBookSetNumberActivity.show((Fragment)this, 100);
    }

    public void onSetPhoneNumberDone(String countryCode, String number) {
        this.onAddressBookEnabled();
    }

    public void onAddressBookEnabled() {
        this.mListView.startABMatching();
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity instanceof IMActivity) {
            ((IMActivity)activity).onAddressBookEnabled(true);
        } else {
            this.refreshAll(true);
        }
    }

    private void refreshAll(boolean force) {
        if (this.getView() == null) {
            return;
        }
        this.updateUI();
        this.mListView.setFilter(this.mEdtSearch.getText().toString());
        this.reloadAllItems(force);
        this.updateBtnClearSearchView();
    }

    public void reloadAllItems() {
        this.reloadAllItems(false);
    }

    public void reloadAllItems(boolean force) {
        if (this.getView() == null || this.mListView == null) {
            return;
        }
        if (!PTApp.getInstance().isPhoneNumberRegistered()) {
            this.mPanelNoItemMsg.setVisibility(8);
            this.mListView.reloadAllItems();
        } else if (ABContactsHelper.isMatchPhoneNumbersCalled() || force) {
            this.mListView.reloadAllItems();
            int count = this.mListView.getContactsItemCount();
            if (count > 0 || this.mEdtSearch.getText().length() > 0) {
                this.mPanelNoItemMsg.setVisibility(8);
            } else {
                this.mPanelNoItemMsg.setVisibility(0);
                this.mImgNoBuddy.setImageResource(R.drawable.zm_ic_no_buddy);
                this.mTxtNoContactsMessage.setText(R.string.zm_msg_no_system_contacts);
            }
        }
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        if (event == 0) {
            this.onWebLogin(result);
        }
    }

    private void onWebLogin(long result) {
        if (result == 0L) {
            ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
            if (helper == null) {
                return;
            }
            if (PTApp.getInstance().isWebSignedOn() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber()) && ABContactsHelper.isTimeToMatchPhoneNumbers()) {
                this.startABMatching();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    @Override
    public void onPhoneABEvent(final int event, final long result, final Object content) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("handlePhoneABEvent"){

            public void run(IUIElement ui) {
                ((InviteLocalContactsFragment)ui).handlePhoneABEvent(event, result, content);
            }
        });
    }

    private void handlePhoneABEvent(int event, long result, Object content) {
        switch (event) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.onPhoneABMatchUpdated(result);
            }
        }
    }

    private void onPhoneABMatchUpdated(long result) {
        this.mListView.onPhoneABMatchUpdated(result);
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        WaitingDialog dialog = (WaitingDialog)fm.findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
        switch ((int)result) {
            case 0: {
                this.reloadAllItems(true);
                break;
            }
            case 1104: {
                this.onPhoneBindByOther();
            }
        }
    }

    private void onPhoneBindByOther() {
    }

    public boolean startABMatching() {
        int ret = this.mListView.startABMatching();
        if (ret == 0) {
            return true;
        }
        if (ret == -1) {
            this.reloadAllItems(true);
        } else {
            this.showErrorDialog(ret);
        }
        return false;
    }

    private void showErrorDialog(int errorCode) {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_match_contacts_failed);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    @Override
    public void onIMLocalStatusChanged(int status) {
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
        if (this.mListView != null) {
            this.mListView.updateUnreadMessageCountBubble();
        }
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
    }

    @Override
    public void onIMBuddySort() {
    }

    @Override
    public void onSubscriptionRequest() {
    }

    @Override
    public void onSubscriptionUpdate() {
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    public void showNonZoomUserActions(LocalContactItem item) {
        if (item == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        int countNumbers = item.getPhoneNumberCount();
        int countEmails = item.getEmailCount();
        if (countNumbers == 1 && countEmails == 0) {
            InviteLocalContactsFragment.inviteBySMS((Context)activity, fm, item.getPhoneNumber(0));
        } else if (countNumbers == 0 && countEmails == 1) {
            InviteLocalContactsFragment.inviteByEmail((Context)activity, fm, item.getEmail(0));
        } else {
            ContextMenuFragment.show(fm, item);
        }
    }

    private static void inviteByEmail(Context context, FragmentManager fm, String email) {
        String topic = PTApp.getInstance().getZoomInvitationEmailSubject();
        String content = PTApp.getInstance().getZoomInvitationEmailBody();
        ZMSendMessageFragment.show((Context)context, (FragmentManager)fm, (String[])new String[]{email}, null, (String)topic, (String)content, (String)content, null, null, (int)1);
    }

    private static void inviteBySMS(Context context, FragmentManager fm, String phoneNumber) {
        String topic = PTApp.getInstance().getZoomInvitationEmailSubject();
        String content = context.getString(R.string.zm_msg_sms_invitation_content);
        ZMSendMessageFragment.show((Context)context, (FragmentManager)fm, null, (String[])new String[]{phoneNumber}, (String)topic, (String)content, (String)content, null, null, (int)2);
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }

    static class ContextMenuItem
    extends ZMSimpleMenuItem {
        private String mPhoneNumber;
        private String mEmail;

        public ContextMenuItem(String label, String phoneNumber, String email) {
            super(0, label);
            this.mPhoneNumber = phoneNumber;
            this.mEmail = email;
        }

        public String getPhoneNumber() {
            return this.mPhoneNumber;
        }

        public String getEmail() {
            return this.mEmail;
        }

        public boolean isPhoneNumberItem() {
            return !StringUtil.isEmptyOrNull((String)this.mPhoneNumber);
        }

        public boolean isEmailItem() {
            return !StringUtil.isEmptyOrNull((String)this.mEmail);
        }
    }

    public static class ContextMenuFragment
    extends ZMDialogFragment {
        private static final String ARG_ADDRBOOKITEM = "addrBookItem";
        private ZMMenuAdapter<ContextMenuItem> mAdapter;

        public static void show(@NonNull FragmentManager fm, @NonNull LocalContactItem item) {
            Bundle args = new Bundle();
            args.putSerializable(ARG_ADDRBOOKITEM, (Serializable)item);
            ContextMenuFragment f = new ContextMenuFragment();
            f.setArguments(args);
            f.show(fm, ContextMenuFragment.class.getName());
        }

        public ContextMenuFragment() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            LocalContactItem item = (LocalContactItem)this.getArguments().getSerializable(ARG_ADDRBOOKITEM);
            this.mAdapter = this.createUpdateAdapter();
            String title = item.getScreenName();
            title = StringUtil.isEmptyOrNull((String)title) ? this.getString(R.string.zm_title_invite) : this.getString(R.string.zm_title_invite_xxx, new Object[]{title});
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setAdapter(this.mAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ContextMenuFragment.this.onSelectItem(which);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

        private ZMMenuAdapter<ContextMenuItem> createUpdateAdapter() {
            LocalContactItem item = (LocalContactItem)this.getArguments().getSerializable(ARG_ADDRBOOKITEM);
            ContextMenuItem[] items = null;
            if (item != null) {
                int i;
                items = new ContextMenuItem[item.getPhoneNumberCount() + item.getEmailCount()];
                int idx = 0;
                for (i = 0; i < item.getPhoneNumberCount(); ++i) {
                    String number = item.getPhoneNumber(i);
                    items[idx++] = new ContextMenuItem(number, number, null);
                }
                for (i = 0; i < item.getEmailCount(); ++i) {
                    String email = item.getEmail(i);
                    items[idx++] = new ContextMenuItem(email, null, email);
                }
            }
            if (this.mAdapter == null) {
                this.mAdapter = new ZMMenuAdapter((Context)((ZMActivity)this.getActivity()), false);
            } else {
                this.mAdapter.clear();
            }
            if (items != null) {
                this.mAdapter.addAll((IZMMenuItem[])items);
            }
            return this.mAdapter;
        }

        public void refresh() {
            this.createUpdateAdapter().notifyDataSetChanged();
        }

        private void onSelectItem(int which) {
            ContextMenuItem menuItem = (ContextMenuItem)((Object)this.mAdapter.getItem(which));
            if (menuItem == null) {
                return;
            }
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            FragmentManager fm = activity.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            if (menuItem.isPhoneNumberItem()) {
                InviteLocalContactsFragment.inviteBySMS((Context)activity, fm, menuItem.getPhoneNumber());
            } else {
                InviteLocalContactsFragment.inviteByEmail((Context)activity, fm, menuItem.getEmail());
            }
        }
    }
}

