/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.LinearLayout;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.InviteActivity;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.ContactsMatchHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.ptapp.delegate.PTUIDelegation;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.InviteBuddyItem;
import com.zipow.videobox.view.InviteBuddyItemSpan;
import com.zipow.videobox.view.InviteBuddyListView;
import com.zipow.videobox.view.ZMReplaceSpanMovementMethod;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMEditText;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class InviteFragment
extends ZMTipFragment
implements View.OnClickListener,
InviteBuddyListView.Listener,
PTUI.IIMListener,
PTUI.IPTUIListener,
ZMKeyboardDetector.KeyboardListener,
ABContactsCache.IABContactsCacheListener {
    private static final String TAG = InviteFragment.class.getSimpleName();
    public static final String ARG_ANCHOR_ID = "anchorId";
    public static final String ARG_MEETING_ID = "meetingId";
    public static final String ARG_MEETING_NUMBER = "meetingNumber";
    public static final String ARG_SELECT_FROM_ADDRBOOK = "inviteAddrBook";
    public static final String ARG_SELECT_FROM_ZOOMROOMS = "inviteZoomRooms";
    private InviteBuddyListView mListView;
    private ZMEditText mEdtSelected;
    private Button mBtnInvite;
    private ProgressDialog mProgressDialog;
    private int mAnchorId = 0;
    private String mMeetingId;
    private long mMeetingNumber;
    private GestureDetector mGestureDetector;
    private MemCache<String, Bitmap> mAvatarCache = new MemCache(20);
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;
    private Handler mHandler = new Handler();
    private SearchFilterRunnable mRunnableFilter = new SearchFilterRunnable();

    public static void show(FragmentManager fm, int anchorId, long meetingNumber, String meetingId) {
        InviteFragment.show(fm, anchorId, meetingNumber, meetingId, false);
    }

    public static void show(FragmentManager fm, int anchorId, long meetingNumber, String meetingId, boolean inviteAddrBook) {
        InviteFragment.show(fm, anchorId, meetingNumber, meetingId, inviteAddrBook, false);
    }

    public static void show(FragmentManager fm, int anchorId, long meetingNumber, String meetingId, boolean inviteAddrBook, boolean inviteZoomRooms) {
        InviteFragment f = InviteFragment.getInviteFragment(fm);
        if (f == null) {
            f = new InviteFragment();
            Bundle args = new Bundle();
            args.putInt(ARG_ANCHOR_ID, anchorId);
            args.putLong(ARG_MEETING_NUMBER, meetingNumber);
            args.putString(ARG_MEETING_ID, meetingId);
            args.putBoolean(ARG_SELECT_FROM_ADDRBOOK, inviteAddrBook);
            args.putBoolean(ARG_SELECT_FROM_ZOOMROOMS, inviteZoomRooms);
            f.setArguments(args);
            f.show(fm, InviteFragment.class.getName());
        } else {
            Bundle args = f.getArguments();
            args.putLong(ARG_MEETING_NUMBER, meetingNumber);
            args.putString(ARG_MEETING_ID, meetingId);
            f.updateMeetingInfo(meetingNumber, meetingId);
            f.setTipVisible(true);
        }
    }

    public static InviteFragment getInviteFragment(FragmentManager fm) {
        return (InviteFragment)fm.findFragmentByTag(InviteFragment.class.getName());
    }

    public static boolean hide(FragmentManager fm) {
        InviteFragment f = InviteFragment.getInviteFragment(fm);
        if (f != null) {
            if (!f.getShowsTip()) {
                f.dismiss();
                return true;
            }
            if (f.isTipVisible()) {
                f.setTipVisible(false);
                return true;
            }
        }
        return false;
    }

    public static boolean dismiss(FragmentManager fm) {
        InviteFragment f = InviteFragment.getInviteFragment(fm);
        if (f != null) {
            f.dismiss();
            return true;
        }
        return false;
    }

    public void onDestroy() {
        this.mHandler.removeCallbacks((Runnable)this.mRunnableFilter);
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        super.onDestroy();
    }

    public void onResume() {
        super.onResume();
        if (!PTAppDelegation.getInstance().hasActiveCall()) {
            this.dismiss();
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        boolean bInviteAddrBook = args.getBoolean(ARG_SELECT_FROM_ADDRBOOK, false);
        boolean bInviteZoomRooms = args.getBoolean(ARG_SELECT_FROM_ZOOMROOMS, false);
        this.mListView.setFilter(this.getFilter());
        if (bInviteZoomRooms) {
            this.mListView.setIsInviteZoomRooms(true);
        } else {
            this.mListView.setIsInviteAddrBook(bInviteAddrBook);
        }
        this.mListView.reloadAllBuddyItems();
        if (!bInviteAddrBook) {
            PTUIDelegation.getInstance().addPTUIListener(this);
            PTUIDelegation.getInstance().addIMListener(this);
        }
        if (this.mListView != null) {
            this.mListView.onResume();
        }
        this.updateUIForConfCallStatus(PTAppDelegation.getInstance().getCallStatus());
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.addListener(this);
    }

    public void onPause() {
        super.onPause();
        PTUIDelegation.getInstance().removePTUIListener(this);
        PTUIDelegation.getInstance().removeIMListener(this);
        ABContactsCache cache = ABContactsCache.getInstance();
        cache.removeListener(this);
        this.mAvatarCache.clear();
    }

    public void onDestroyView() {
        if (this.mZoomMessengerUIListener != null) {
            ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        }
        super.onDestroyView();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isTipVisible", this.isTipVisible());
    }

    private void updateMeetingInfo(long meetingNumber, String meetingId) {
        this.mMeetingNumber = meetingNumber;
        this.mMeetingId = meetingId;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.mMeetingId = args.getString(ARG_MEETING_ID);
        this.mMeetingNumber = args.getLong(ARG_MEETING_NUMBER);
        View view = null;
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            view = inflater.inflate(R.layout.zm_invite, null);
        } else {
            view = inflater.inflate(R.layout.zm_invite_main_screen, null);
            ZMKeyboardDetector keyboardDetector = (ZMKeyboardDetector)view.findViewById(R.id.keyboardDetector);
            keyboardDetector.setKeyboardListener((ZMKeyboardDetector.KeyboardListener)this);
        }
        this.mListView = (InviteBuddyListView)view.findViewById(R.id.buddyListView);
        this.mEdtSelected = (ZMEditText)view.findViewById(R.id.edtSelected);
        this.mBtnInvite = (Button)view.findViewById(R.id.btnInvite);
        Button btnBack = (Button)view.findViewById(R.id.btnBack);
        this.updateMeetingInfo(this.mMeetingNumber, this.mMeetingId);
        this.mBtnInvite.setOnClickListener((View.OnClickListener)this);
        btnBack.setOnClickListener((View.OnClickListener)this);
        this.mListView.setListener(this);
        this.mListView.setAvatarMemCache(this.mAvatarCache);
        this.mEdtSelected.setSelected(true);
        this.mEdtSelected.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (after < count) {
                    Editable editable = InviteFragment.this.mEdtSelected.getText();
                    final InviteBuddyItemSpan[] spans = (InviteBuddyItemSpan[])editable.getSpans(start + after, start + count, InviteBuddyItemSpan.class);
                    if (spans.length <= 0) {
                        return;
                    }
                    InviteFragment.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (!InviteFragment.this.isResumed()) {
                                return;
                            }
                            for (InviteBuddyItemSpan span : spans) {
                                InviteBuddyItem item = span.getItem();
                                if (item == null) continue;
                                InviteFragment.this.mListView.unselectBuddy(item);
                            }
                        }
                    });
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                InviteFragment.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!InviteFragment.this.isResumed()) {
                            return;
                        }
                        String key = InviteFragment.this.getFilter();
                        InviteFragment.this.startFilter(key);
                    }
                });
            }
        });
        this.mEdtSelected.setMovementMethod((MovementMethod)ZMReplaceSpanMovementMethod.getInstance());
        this.mEdtSelected.setOnClickListener((View.OnClickListener)this);
        int cntSelected = this.getSelectedBuddiesCount();
        this.updateButtonInvite(cntSelected);
        this.mGestureDetector = new GestureDetector((Context)this.getActivity(), (GestureDetector.OnGestureListener)new GuestureListener((View)this.mListView, (View)this.mEdtSelected));
        this.mListView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return InviteFragment.this.mGestureDetector.onTouchEvent(event);
            }
        });
        boolean bInviteAddrBook = args.getBoolean(ARG_SELECT_FROM_ADDRBOOK, false);
        boolean bInviteZoomRooms = args.getBoolean(ARG_SELECT_FROM_ZOOMROOMS, false);
        if (bInviteAddrBook || bInviteZoomRooms) {
            if (this.mZoomMessengerUIListener == null) {
                this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                    @Override
                    public void onIndicateBuddyInfoUpdated(String phoneNumber) {
                        InviteFragment.this.onIndicateZoomMessengerBuddyInfoUpdated(phoneNumber);
                    }

                    @Override
                    public void onIndicateBuddyListUpdated() {
                        InviteFragment.this.onIndicateZoomMessengerBuddyListUpdated();
                    }

                    @Override
                    public void onIndicateInfoUpdatedWithJID(String jid) {
                        InviteFragment.this.onIndicateZoomMessengerInfoUpdatedWithJID(jid);
                    }

                    @Override
                    public void onConnectReturn(int errorCode) {
                        InviteFragment.this.onIndicationZoomMessengerConnectReturn(errorCode);
                    }

                    @Override
                    public void onSearchBuddyByKey(String key, int result) {
                        InviteFragment.this.onIndicationZoomMessengerSearchBuddyByKey(key, result);
                    }

                    @Override
                    public void Indicate_BuddyPresenceChanged(String jid) {
                        InviteFragment.this.onIndicateZoomMessengerInfoUpdatedWithJID(jid);
                    }

                    @Override
                    public void Indicate_OnlineBuddies(List<String> jidList) {
                        InviteFragment.this.onIndicateZoomMessengerOnlineBuddies(jidList);
                    }

                    @Override
                    public void Indicate_GetContactsPresence(List<String> onLines, List<String> offlines) {
                        InviteFragment.this.onIndicateZoomMessengerGetContactsPresence(onLines, offlines);
                    }
                };
            }
            ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
            if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.READ_CONTACTS") != 0 && PTApp.getInstance().isPhoneNumberRegistered() && AppUtil.canRequestContactPermission()) {
                this.zm_requestPermissions(new String[]{"android.permission.READ_CONTACTS"}, 0);
                AppUtil.saveRequestContactPermissionTime();
            }
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (InviteFragment.this.isResumed()) {
                    InviteFragment.this.mEdtSelected.requestFocus();
                    UIUtil.openSoftKeyboard((Context)InviteFragment.this.getActivity(), (View)InviteFragment.this.mEdtSelected);
                }
            }
        }, 100L);
        return view;
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((InviteFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    private void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.READ_CONTACTS".equals(permissions[i]) || grantResults[i] != 0) continue;
            ABContactsCache cache = ABContactsCache.getInstance();
            cache.reloadAllContacts();
        }
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = this.getView();
        if (view == null) {
            return null;
        }
        int width = UIUtil.dip2px((Context)context, (float)400.0f);
        if (UIUtil.getDisplayWidth((Context)context) < width) {
            width = UIUtil.getDisplayWidth((Context)context);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -2);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        ZMTip tip = new ZMTip(context);
        tip.setBackgroundColor(-263173);
        tip.setArrowSize(UIUtil.dip2px((Context)context, (float)30.0f), UIUtil.dip2px((Context)context, (float)11.0f));
        tip.setCornerArcSize(0);
        tip.addView(view);
        Bundle args = this.getArguments();
        this.mAnchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (this.mAnchorId > 0 && (anchor = this.getActivity().findViewById(this.mAnchorId)) != null) {
            tip.setAnchor(anchor, 1);
        }
        if (savedInstanceState != null) {
            boolean visible = savedInstanceState.getBoolean("isTipVisible", true);
            tip.setVisibility(visible ? 0 : 4);
        }
        return tip;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnInvite) {
            this.onClickBtnInvite();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.edtSelected) {
            this.onClickEditSelectedView();
        }
    }

    private void onClickEditSelectedView() {
        this.mEdtSelected.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSelected);
    }

    private void onClickBtnBack() {
        if (this.getShowsTip()) {
            this.setTipVisible(false);
        } else {
            this.dismiss();
        }
    }

    private void onClickBtnInvite() {
        List<InviteBuddyItem> items = this.mListView.getSelectedBuddies();
        if (items == null || items.size() == 0) {
            this.onClickBtnBack();
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        UIUtil.closeSoftKeyboard((Context)activity, (View)this.getView());
        String[] buddyJids = new String[items.size()];
        for (int i = 0; i < buddyJids.length; ++i) {
            buddyJids[i] = items.get((int)i).userId;
        }
        int ret = PTAppDelegation.getInstance().inviteBuddiesToConf(buddyJids, null, this.mMeetingId, this.mMeetingNumber, activity.getString(R.string.zm_msg_invitation_message_template));
        if (ret != 0) {
            this.onSentInvitationFailed();
        } else {
            this.onSentInvitationDone(items);
        }
    }

    private void onSentInvitationFailed() {
        new InviteFailedDialog().show(this.getFragmentManager(), InviteFailedDialog.class.getName());
    }

    private void onSentInvitationDone(List<InviteBuddyItem> items) {
        if (this.getShowsTip()) {
            Intent data = new Intent();
            data.putExtra("invitations_count", items.size());
            ((ConfActivity)this.getActivity()).onSentInvitationDone(data);
            this.setTipVisible(false);
        } else {
            ((InviteActivity)this.getActivity()).onSentInvitationDone(items.size());
        }
    }

    private void clearSelection() {
        this.mListView.clearSelection();
    }

    @Override
    public void onSelectionChanged() {
        int cntSelected = this.getSelectedBuddiesCount();
        this.updateButtonInvite(cntSelected);
    }

    private void updateButtonInvite(int cntSelected) {
        if (cntSelected <= 0) {
            this.mBtnInvite.setText((CharSequence)this.getResources().getString(R.string.zm_btn_invite));
            this.mBtnInvite.setEnabled(false);
        } else {
            this.mBtnInvite.setText((CharSequence)this.getResources().getString(R.string.zm_btn_invite));
            this.mBtnInvite.setEnabled(true);
        }
    }

    private int getSelectedBuddiesCount() {
        List<InviteBuddyItem> items = this.mListView.getSelectedBuddies();
        return items.size();
    }

    public void onKeyboardOpen() {
        this.mEdtSelected.setCursorVisible(true);
        if (this.mEdtSelected.hasFocus()) {
            this.mEdtSelected.setCursorVisible(true);
        }
    }

    public void onKeyboardClosed() {
        this.mEdtSelected.setCursorVisible(false);
        this.mListView.setForeground(null);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InviteFragment.this.mListView.requestLayout();
            }
        });
    }

    @Override
    public void onIMLocalStatusChanged(int status) {
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
        this.mListView.updateBuddyItem(item);
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
        this.mListView.updateBuddyItem(item);
        this.getSelectedBuddiesCount();
    }

    @Override
    public void onIMBuddySort() {
        this.mListView.sort();
        this.getSelectedBuddiesCount();
    }

    @Override
    public void onSubscriptionRequest() {
    }

    @Override
    public void onSubscriptionUpdate() {
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        if (event == 22) {
            this.updateUIForConfCallStatus((int)result);
        }
    }

    private void updateUIForConfCallStatus(int status) {
        switch (status) {
            case 0: 
            case 1: {
                this.dismiss();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void onIndicateZoomMessengerBuddyInfoUpdated(String phoneNumber) {
        if (this.mListView != null) {
            this.mListView.notifyDataSetChanged(true);
        }
    }

    private void onIndicateZoomMessengerBuddyListUpdated() {
        if (this.mListView != null) {
            this.mListView.reloadAllBuddyItems();
        }
    }

    private void onIndicateZoomMessengerGetContactsPresence(List<String> onLines, List<String> offLines) {
        if (this.mListView != null) {
            this.mListView.onIndicateZoomMessengerGetContactsPresence(onLines, offLines);
        }
    }

    private void onIndicateZoomMessengerOnlineBuddies(List<String> jidList) {
        if (this.mListView != null) {
            this.mListView.onIndicateZoomMessengerOnlineBuddies(jidList);
        }
    }

    private void onIndicateZoomMessengerInfoUpdatedWithJID(String jid) {
        if (this.mListView != null) {
            this.mListView.updateBuddyInfoWithJid(jid);
        }
    }

    private void onIndicationZoomMessengerConnectReturn(int errCode) {
        if (this.mListView != null) {
            this.mListView.notifyDataSetChanged(true);
        }
    }

    private void onIndicationZoomMessengerSearchBuddyByKey(String key, int result) {
        if (this.mListView != null && this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
            this.mListView.onIndicationZoomMessengerSearchBuddyByKey(key, result);
        }
    }

    public void dismiss() {
        if (this.getShowsTip()) {
            super.dismiss();
        } else {
            this.getActivity().finish();
        }
    }

    public boolean onSearchRequested() {
        this.mEdtSelected.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSelected);
        return true;
    }

    private boolean isTipVisible() {
        ZMTip tip = this.getTip();
        if (tip != null) {
            return tip.getVisibility() == 0;
        }
        return false;
    }

    private void setTipVisible(boolean visible) {
        ZMTip tip = this.getTip();
        if (tip != null && tip.getVisibility() == 0 != visible) {
            tip.setVisibility(visible ? 0 : 4);
            if (visible) {
                this.clearSelection();
                Animation fadeIn = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.zm_tip_fadein);
                tip.startAnimation(fadeIn);
            } else {
                ((ConfActivity)this.getActivity()).onPListTipClosed();
            }
        }
    }

    private String getFilter() {
        String key = "";
        Editable editable = this.mEdtSelected.getText();
        InviteBuddyItemSpan[] spans = (InviteBuddyItemSpan[])editable.getSpans(0, editable.length(), InviteBuddyItemSpan.class);
        if (spans.length <= 0) {
            key = editable.toString();
        } else {
            int length;
            InviteBuddyItemSpan lastSpan = spans[spans.length - 1];
            int pos = editable.getSpanEnd((Object)lastSpan);
            if (pos < (length = editable.length())) {
                key = editable.subSequence(pos, length).toString();
            }
        }
        return key;
    }

    private void startFilter(String key) {
        String oldKey;
        if (key == null) {
            key = "";
        }
        if (key.equals(oldKey = this.mRunnableFilter.getKey())) {
            return;
        }
        this.mRunnableFilter.setKey(key);
        this.mHandler.removeCallbacks((Runnable)this.mRunnableFilter);
        this.mHandler.postDelayed((Runnable)this.mRunnableFilter, 300L);
    }

    private boolean isSameItem(InviteBuddyItemSpan span, InviteBuddyItem item) {
        if (span == null || item == null) {
            return false;
        }
        InviteBuddyItem spanItem = span.getItem();
        if (spanItem == null) {
            return false;
        }
        String userId = item.userId;
        return userId != null && userId.equals(spanItem.userId);
    }

    @Override
    public void onSelected(boolean selected, InviteBuddyItem item) {
        if (item == null) {
            return;
        }
        Editable editable = this.mEdtSelected.getText();
        InviteBuddyItemSpan[] spans = (InviteBuddyItemSpan[])editable.getSpans(0, editable.length(), InviteBuddyItemSpan.class);
        InviteBuddyItemSpan itemSpan = null;
        for (InviteBuddyItemSpan span : spans) {
            if (!this.isSameItem(span, item)) continue;
            itemSpan = span;
            break;
        }
        if (selected) {
            if (itemSpan != null) {
                itemSpan.setItem(item);
                return;
            }
            int count = spans.length;
            if (count > 0) {
                int length;
                InviteBuddyItemSpan lastSpan = spans[count - 1];
                int lastSpanEnd = editable.getSpanEnd((Object)lastSpan);
                if (lastSpanEnd < (length = editable.length())) {
                    editable.delete(lastSpanEnd, length);
                }
            } else {
                editable.clear();
            }
            itemSpan = new InviteBuddyItemSpan((Context)this.getActivity(), item);
            itemSpan.setInterval(UIUtil.dip2px((Context)this.getActivity(), (float)2.0f));
            int start = editable.length();
            int end = start + item.screenName.length();
            editable.append((CharSequence)item.screenName);
            editable.setSpan((Object)itemSpan, start, end, 17);
            this.mEdtSelected.setSelection(end);
            this.mEdtSelected.setCursorVisible(true);
        } else {
            if (itemSpan == null) {
                return;
            }
            int start = editable.getSpanStart((Object)itemSpan);
            int end = editable.getSpanEnd((Object)itemSpan);
            if (start >= 0 && end >= 0 && end >= start) {
                editable.delete(start, end);
                editable.removeSpan((Object)itemSpan);
            }
        }
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }

    @Override
    public void onViewMoreClick() {
        boolean res;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            return;
        }
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        if (res = messenger.searchBuddyByKey(this.getFilter())) {
            this.mProgressDialog = UIUtil.showSimpleWaitingDialog((Activity)this.getActivity(), (int)R.string.zm_msg_waiting);
        }
    }

    private int startABMatching() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return 11;
        }
        if (!PTApp.getInstance().isWebSignedOn()) {
            return 9;
        }
        return ContactsMatchHelper.getInstance().matchAllNumbers((Context)context);
    }

    private void matchNewNumbers() {
        if (!PTApp.getInstance().isWebSignedOn()) {
            return;
        }
        ContactsMatchHelper.getInstance().matchNewNumbers((Context)this.getActivity());
    }

    @Override
    public void onContactsCacheUpdated() {
        ABContactsHelper helper = PTApp.getInstance().getABContactsHelper();
        if (helper == null) {
            return;
        }
        if (PTApp.getInstance().isWebSignedOn() && !StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber()) && ABContactsHelper.isTimeToMatchPhoneNumbers()) {
            this.startABMatching();
        } else if (!StringUtil.isEmptyOrNull((String)helper.getVerifiedPhoneNumber())) {
            this.matchNewNumbers();
        }
    }

    public static class GuestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private View mHolderView;
        private View mKeyboardView;

        public GuestureListener(View view, View keyboardView) {
            this.mHolderView = view;
            this.mKeyboardView = keyboardView;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (this.mHolderView != null) {
                this.mHolderView.requestFocus();
                UIUtil.closeSoftKeyboard((Context)this.mHolderView.getContext(), (View)this.mKeyboardView);
            }
            return super.onScroll(e1, e2, distanceX, distanceY);
        }
    }

    public static class InviteFailedDialog
    extends ZMDialogFragment {
        public InviteFailedDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_invite_failed).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
        }
    }

    public class SearchFilterRunnable
    implements Runnable {
        private String mKey = "";

        public void setKey(String key) {
            this.mKey = key == null ? "" : key;
        }

        public String getKey() {
            return this.mKey;
        }

        @Override
        public void run() {
            InviteFragment.this.mListView.filter(this.mKey);
        }
    }
}

