/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.view.mm.MMSavedSessionsListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class IMSavedSessionsFragment
extends ZMDialogFragment
implements View.OnClickListener,
TextView.OnEditorActionListener,
SimpleActivity.ExtListener {
    private View mPanelTitleBar;
    private EditText mEdtSearch;
    private FrameLayout mListContainer;
    private Button mBtnClearSearchView;
    private Drawable mDimmedForground = null;
    private MMSavedSessionsListView mSavedSessionsListView;
    private View mPanelNoItemMsg;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = IMSavedSessionsFragment.this.mEdtSearch.getText().toString();
            IMSavedSessionsFragment.this.mSavedSessionsListView.filter(key);
            if (key.length() > 0 && IMSavedSessionsFragment.this.mSavedSessionsListView.getCount() > 0 || IMSavedSessionsFragment.this.mPanelTitleBar.getVisibility() == 0) {
                IMSavedSessionsFragment.this.mListContainer.setForeground(null);
            } else {
                IMSavedSessionsFragment.this.mListContainer.setForeground(IMSavedSessionsFragment.this.mDimmedForground);
            }
        }
    };
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String msgId) {
            IMSavedSessionsFragment.this.onGroupAction(result, action, msgId);
        }

        @Override
        public void onNotify_ChatSessionListUpdate() {
            IMSavedSessionsFragment.this.onNotify_ChatSessionListUpdate();
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
            IMSavedSessionsFragment.this.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }
    };

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, IMSavedSessionsFragment.class.getName(), args, requestCode, false, 1);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_saved_sessions, container, false);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mSavedSessionsListView = (MMSavedSessionsListView)view.findViewById(R.id.sessionsListView);
        this.mListContainer = (FrameLayout)view.findViewById(R.id.listContainer);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        this.mSavedSessionsListView.setEmptyView(this.mPanelNoItemMsg);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                IMSavedSessionsFragment.this.mHandler.removeCallbacks(IMSavedSessionsFragment.this.mRunnableFilter);
                IMSavedSessionsFragment.this.mHandler.postDelayed(IMSavedSessionsFragment.this.mRunnableFilter, 300L);
                IMSavedSessionsFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.mSavedSessionsListView.reloadAll();
    }

    public void onDestroyView() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDestroyView();
    }

    public void onGroupAction(int result, GroupAction action, String msgId) {
        this.mSavedSessionsListView.onGroupAction(result, action, msgId);
    }

    public void onNotify_ChatSessionListUpdate() {
        this.mSavedSessionsListView.onNotify_ChatSessionListUpdate();
    }

    public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        this.mSavedSessionsListView.onNotify_MUCGroupInfoUpdatedImpl(groupID);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearch.hasFocus()) {
            this.mEdtSearch.setCursorVisible(true);
            this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_focused);
            this.mPanelTitleBar.setVisibility(8);
            this.mListContainer.setForeground(this.mDimmedForground);
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearch.setCursorVisible(false);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_normal);
        this.mListContainer.setForeground(null);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMSavedSessionsFragment.this.isResumed()) {
                    IMSavedSessionsFragment.this.mPanelTitleBar.setVisibility(0);
                }
            }
        });
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.dismiss();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        }
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }
}

