/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.view.ScheduledMeetingsView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.videomeetings.R;

public class IMMyMeetingsFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    public static final String ARG_SHOW_BACK_BUTTON = "showBackButton";
    private ScheduledMeetingsView mScheduledMeetingsView;
    private View mBtnRefresh;
    private View mBtnBack;

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_SHOW_BACK_BUTTON, true);
        SimpleActivity.show(activity, IMMyMeetingsFragment.class.getName(), args, 0, true);
    }

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_SHOW_BACK_BUTTON, true);
        SimpleActivity.show(fragment, IMMyMeetingsFragment.class.getName(), args, 0, true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_my_meetings, container, false);
        this.mBtnBack = view.findViewById(R.id.btnBack);
        this.mBtnRefresh = view.findViewById(R.id.btnRefresh);
        this.mScheduledMeetingsView = (ScheduledMeetingsView)view.findViewById(R.id.scheduledMeetingsView);
        this.mBtnRefresh.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        boolean showBackButton = false;
        Bundle args = this.getArguments();
        if (args != null) {
            showBackButton = args.getBoolean(ARG_SHOW_BACK_BUTTON, false);
        }
        if (!showBackButton) {
            this.mBtnBack.setVisibility(4);
        }
        return view;
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addPTUIListener(this);
        if (this.mScheduledMeetingsView != null) {
            this.mScheduledMeetingsView.onResume();
        }
        PTApp.getInstance().getCalendarIntegrationConfig();
    }

    public void onStop() {
        super.onStop();
        if (this.mScheduledMeetingsView != null) {
            this.mScheduledMeetingsView.onStop();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnRefresh) {
            this.onClickBtnRefresh();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private void onClickBtnRefresh() {
        if (this.mScheduledMeetingsView != null && !this.mScheduledMeetingsView.isRefreshing()) {
            this.mScheduledMeetingsView.refresh();
        }
    }

    private void onCallStatusChanged(long result) {
        if (!this.isResumed()) {
            return;
        }
        if (this.mScheduledMeetingsView != null) {
            this.mScheduledMeetingsView.onCallStatusChanged(result);
        }
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 22: {
                this.onCallStatusChanged(result);
                break;
            }
            case 65: {
                if (this.mScheduledMeetingsView == null) break;
                this.mScheduledMeetingsView.refreshCalenderIntegeration();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }
}

