/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.AddFavoriteActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.SettingFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.FavoriteListView;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class IMFavoriteListFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener,
PTUI.IFavoriteListener,
TextView.OnEditorActionListener,
PTUI.IPTUIListener {
    public static final String ARG_SHOW_BACK_BUTTON = "showBackButton";
    private FavoriteListView mFavoriteListView;
    private EditText mEdtSearch;
    private View mPanelNoItemMsg;
    private Button mBtnClearSearchView;
    private TextView mTxtScreenName;
    private Button mBtnInviteBuddy;
    private AvatarView mAvatar;
    private View mBtnBack;
    private ViewGroup mPanelTitleBar;
    private Drawable mDimmedForground = null;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = IMFavoriteListFragment.this.mEdtSearch.getText().toString();
            IMFavoriteListFragment.this.mFavoriteListView.filter(key);
            if (key.length() > 0 && IMFavoriteListFragment.this.mFavoriteListView.getDataItemCount() > 0 || IMFavoriteListFragment.this.mPanelTitleBar.getVisibility() == 0) {
                IMFavoriteListFragment.this.mFavoriteListView.setForeground(null);
            } else {
                IMFavoriteListFragment.this.mFavoriteListView.setForeground(IMFavoriteListFragment.this.mDimmedForground);
            }
            IMFavoriteListFragment.this.checkToShowNoBuddyMessage();
        }
    };

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_SHOW_BACK_BUTTON, true);
        SimpleActivity.show(activity, IMFavoriteListFragment.class.getName(), args, 0);
    }

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_SHOW_BACK_BUTTON, true);
        SimpleActivity.show(fragment, IMFavoriteListFragment.class.getName(), args, 0);
    }

    private void checkToShowNoBuddyMessage() {
        boolean isSignedOn = PTApp.getInstance().isWebSignedOn();
        if (isSignedOn && StringUtil.isEmptyOrNull((String)this.mFavoriteListView.getFilter()) && this.mFavoriteListView.getDataItemCount() == 0) {
            this.mPanelNoItemMsg.setVisibility(0);
        } else {
            this.mPanelNoItemMsg.setVisibility(8);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_imview_favoritelist, container, false);
        this.mFavoriteListView = (FavoriteListView)view.findViewById(R.id.favoriteListView);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mPanelNoItemMsg = view.findViewById(R.id.panelNoItemMsg);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelTitleBar = (ViewGroup)view.findViewById(R.id.toolbar);
        this.mTxtScreenName = (TextView)this.mPanelTitleBar.findViewById(R.id.txtScreenName);
        TextView txtTitle = (TextView)this.mPanelTitleBar.findViewById(R.id.txtTitle);
        TextView txtInvitationsCount = (TextView)this.mPanelTitleBar.findViewById(R.id.txtInvitationsCount);
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            this.mTxtScreenName.setVisibility(0);
        } else {
            this.mTxtScreenName.setVisibility(8);
            txtTitle.setVisibility(0);
            txtTitle.setText(R.string.zm_tab_favorite_contacts);
        }
        txtInvitationsCount.setVisibility(8);
        this.mBtnInviteBuddy = (Button)this.mPanelTitleBar.findViewById(R.id.btnInviteBuddy);
        this.mAvatar = (AvatarView)this.mPanelTitleBar.findViewById(R.id.avatarView);
        this.mBtnBack = this.mPanelTitleBar.findViewById(R.id.btnBack);
        this.mBtnInviteBuddy.setText(R.string.zm_btn_invite_buddy_favorite);
        this.mBtnInviteBuddy.setVisibility(0);
        this.mPanelNoItemMsg.setVisibility(8);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            this.mAvatar.setOnClickListener(this);
        }
        this.mBtnInviteBuddy.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                IMFavoriteListFragment.this.mHandler.removeCallbacks(IMFavoriteListFragment.this.mRunnableFilter);
                IMFavoriteListFragment.this.mHandler.postDelayed(IMFavoriteListFragment.this.mRunnableFilter, 300L);
                IMFavoriteListFragment.this.updateBtnClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mEdtSearch.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity instanceof IMActivity && !((IMActivity)activity).isKeyboardOpen() || activity instanceof SimpleActivity && !((SimpleActivity)activity).isKeyboardOpen()) {
            this.onKeyboardClosed();
        }
        boolean showBackButton = false;
        Bundle args = this.getArguments();
        if (args != null) {
            showBackButton = args.getBoolean(ARG_SHOW_BACK_BUTTON, false);
        }
        if (showBackButton) {
            this.mBtnBack.setVisibility(0);
            this.mAvatar.setVisibility(8);
        } else {
            this.mBtnBack.setVisibility(8);
            this.mAvatar.setVisibility(8);
        }
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        return view;
    }

    private void updateBtnClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearch.getText().length() > 0 ? 0 : 8);
    }

    private void showMyInfo() {
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnInviteBuddy) {
            this.onClickBtnInviteBuddy();
        } else if (id2 == R.id.avatarView) {
            this.onClickAvatarView(v.getId());
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (v.getId() == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }

    private void onClickBtnInviteBuddy() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        AddFavoriteActivity.show((Activity)((ZMActivity)this.getActivity()), activity instanceof IMActivity ? 102 : 0);
    }

    private void onClickAvatarView(int viewId) {
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            FragmentManager fm = ((ZMActivity)this.getActivity()).getSupportFragmentManager();
            SettingFragment.show(fm, viewId);
        }
    }

    private void onClickBtnBack() {
        if (this.getShowsDialog()) {
            this.dismiss();
        } else {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    public boolean isFocusedOnSearchField() {
        if (this.getView() == null) {
            return false;
        }
        return this.mEdtSearch.hasFocus();
    }

    @Override
    public void onKeyboardOpen() {
        if (this.getView() == null) {
            return;
        }
        if (this.mEdtSearch.hasFocus()) {
            this.mEdtSearch.setCursorVisible(true);
            this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_focused);
            this.mPanelTitleBar.setVisibility(8);
            this.mFavoriteListView.setForeground(this.mDimmedForground);
        }
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearch.setCursorVisible(false);
        this.mEdtSearch.setBackgroundResource(R.drawable.zm_search_bg_normal);
        this.mPanelTitleBar.setVisibility(0);
        this.mFavoriteListView.setForeground(null);
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addFavoriteListener(this);
        PTUI.getInstance().addPTUIListener(this);
        this.refreshAll();
        if (this.mFavoriteListView != null) {
            this.mFavoriteListView.onResume();
        }
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removeFavoriteListener(this);
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mHandler.removeCallbacks(this.mRunnableFilter);
    }

    public void onIMReceived(PTAppProtos.IMMessage message) {
        if (this.getView() == null) {
            return;
        }
        this.mFavoriteListView.updateZoomContact(message.getFromScreenName());
    }

    public void reloadFavoriteItems() {
        if (this.getView() == null) {
            return;
        }
        this.mFavoriteListView.reloadFavoriteItems();
        this.checkToShowNoBuddyMessage();
    }

    public void onCallPlistChanged() {
        if (this.mFavoriteListView != null) {
            this.mFavoriteListView.refreshContextMenu();
        }
    }

    public void onCallStatusChanged(long result) {
        if (this.mFavoriteListView != null) {
            this.mFavoriteListView.refreshContextMenu();
        }
    }

    public void onWebLogin(long result) {
        if (this.mFavoriteListView != null) {
            this.mFavoriteListView.refreshContextMenu();
        }
    }

    @Override
    public boolean onSearchRequested() {
        this.mEdtSearch.requestFocus();
        UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
        return true;
    }

    public void onMyInfoReady() {
        this.showMyInfo();
    }

    public void onMyPictureReady() {
        this.showMyInfo();
    }

    private void refreshAll() {
        if (this.getView() == null) {
            return;
        }
        this.showMyInfo();
        this.mFavoriteListView.setFilter(this.mEdtSearch.getText().toString());
        this.reloadFavoriteItems();
        this.mFavoriteListView.refreshContextMenu();
        this.updateBtnClearSearchView();
    }

    @Override
    public void onFavoriteEvent(int event, long result) {
        switch (event) {
            case 2: {
                this.reloadFavoriteItems();
            }
        }
    }

    @Override
    public void onFavAvatarReady(String userId) {
        this.mFavoriteListView.updateZoomContact(userId);
    }

    @Override
    public void onFinishSearchDomainUser(String requestID, int result, int contactCount, List<ZoomContact> contacts) {
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 9: {
                this.onMyInfoReady();
                break;
            }
            case 12: {
                this.onMyPictureReady();
                break;
            }
            case 0: {
                this.onWebLogin(result);
                break;
            }
            case 22: {
                this.onCallStatusChanged(result);
                break;
            }
            case 23: {
                this.onCallPlistChanged();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }
}

