/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IMSession;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.IMBuddyItem;
import com.zipow.videobox.view.IMChatView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;

public class IMChatFragment
extends ZMFragment
implements IMChatView.Listener {
    public static final String ARG_BUDDYITEM = "buddyItem";
    public static final String ARG_MYNAME = "myName";
    private static final String TAG = IMChatFragment.class.getSimpleName();
    private IMChatView mChatView;
    private IMBuddyItem mBuddyItem;
    private String mMyName;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mChatView = new IMChatView((Context)this.getActivity());
        this.mChatView.setListener(this);
        return this.mChatView;
    }

    public void onResume() {
        super.onResume();
        boolean needClearNotification = false;
        Bundle args = this.getArguments();
        if (args != null) {
            this.mBuddyItem = (IMBuddyItem)args.getSerializable(ARG_BUDDYITEM);
            this.mMyName = args.getString(ARG_MYNAME);
            if (this.mBuddyItem == null || this.mBuddyItem.userId == null || this.mBuddyItem.screenName == null || this.mMyName == null) {
                if (this.mBuddyItem == null) {
                    // empty if block
                }
                return;
            }
            needClearNotification = this.getUnreadMessageCount(this.mBuddyItem.userId) > 0;
            this.mChatView.reloadData(this.mBuddyItem, this.mMyName);
        }
        if (needClearNotification) {
            NotificationMgr.removeMessageNotificationMM((Context)this.getActivity());
        }
        this.mChatView.scrollToBottom(true);
    }

    private int getUnreadMessageCount(String jid) {
        IMHelper helper = PTApp.getInstance().getIMHelper();
        IMSession session = helper.getSessionBySessionName(jid);
        if (session == null) {
            return 0;
        }
        return session.getUnreadMessageCount();
    }

    public void onCallPlistChanged() {
        if (((ZMActivity)this.getActivity()).isActive()) {
            this.mChatView.onCallPlistChanged();
        }
    }

    public void onCallStatusChanged(long result) {
        if (((ZMActivity)this.getActivity()).isActive()) {
            this.mChatView.onCallStatusChanged(result);
        }
    }

    public void onIMReceived(PTAppProtos.IMMessage message) {
        if (((ZMActivity)this.getActivity()).isActive()) {
            this.mChatView.onIMReceived(message);
        }
    }

    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
        if (((ZMActivity)this.getActivity()).isActive()) {
            this.mChatView.onIMBuddyPresence(item);
        }
    }

    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
        if (((ZMActivity)this.getActivity()).isActive()) {
            this.mChatView.onIMBuddyPic(item);
        }
    }

    public void onWebLogin(long result) {
        if (((ZMActivity)this.getActivity()).isActive()) {
            this.mChatView.onWebLogin(result);
        }
    }

    public Object getChatToUserId() {
        return this.mBuddyItem != null ? this.mBuddyItem.userId : null;
    }

    @Override
    public void onClickButtonBack() {
        if (!UIMgr.isLargeMode((Context)this.getActivity())) {
            this.getActivity().finish();
        }
    }
}

