/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.SystemInfoHelper;
import com.zipow.videobox.util.UIMgr;
import java.util.Timer;
import java.util.TimerTask;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class FeedbackFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_SENDING = 1;
    private static final int STATE_SEND_DONE = 2;
    private static final int STATE_SEND_FAILED = 3;
    private Button mBtnBack;
    private EditText mEdtFeedback;
    private TextView mTxtSending;
    private TextView mTxtSentFailed;
    private TextView mTxtThanks;
    private TextView mTxtWelcome;
    private View mPanelSendFeedback;
    private Timer mTimer;
    private boolean mbWaitingShowPanelSendFeedback = false;
    private long mWaitTime = 0L;
    private long mWaitStartTime = 0L;
    private int mState = 0;

    public static void showInActivity(ZMActivity activity) {
        FeedbackFragment f = new FeedbackFragment();
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, FeedbackFragment.class.getName()).commit();
    }

    public static void showDialog(FragmentManager fm) {
        if (FeedbackFragment.getFeedbackFragment(fm) != null) {
            return;
        }
        FeedbackFragment f = new FeedbackFragment();
        f.show(fm, FeedbackFragment.class.getName());
    }

    public static FeedbackFragment getFeedbackFragment(FragmentManager fm) {
        return (FeedbackFragment)fm.findFragmentByTag(FeedbackFragment.class.getName());
    }

    public static FeedbackFragment getFeedbackFragment(ZMActivity activity) {
        FeedbackFragment f = (FeedbackFragment)activity.getSupportFragmentManager().findFragmentByTag(FeedbackFragment.class.getName());
        return f;
    }

    public FeedbackFragment() {
        this.setStyle(1, R.style.ZMDialog);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        String url;
        View view = inflater.inflate(R.layout.zm_feedback, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mEdtFeedback = (EditText)view.findViewById(R.id.edtFeedback);
        Button btnSend = (Button)view.findViewById(R.id.btnSend);
        this.mTxtSending = (TextView)view.findViewById(R.id.txtSending);
        this.mTxtSentFailed = (TextView)view.findViewById(R.id.txtSentFailed);
        this.mTxtThanks = (TextView)view.findViewById(R.id.txtThanks);
        this.mPanelSendFeedback = view.findViewById(R.id.panelSendFeedback);
        this.mTxtWelcome = (TextView)view.findViewById(R.id.txtWelcome);
        this.mTxtSending.setVisibility(8);
        this.mTxtSentFailed.setVisibility(8);
        this.mTxtThanks.setVisibility(8);
        this.mTxtWelcome.setMovementMethod(LinkMovementMethod.getInstance());
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        btnSend.setOnClickListener((View.OnClickListener)this);
        if (savedInstanceState != null) {
            this.mState = savedInstanceState.getInt("mState");
            this.mbWaitingShowPanelSendFeedback = savedInstanceState.getBoolean("mbWaitingShowPanelSendFeedback");
            this.mWaitTime = savedInstanceState.getLong("mWaitTime");
            this.updateUIForCurrentState();
            if (this.mbWaitingShowPanelSendFeedback) {
                this.showPanelSendFeedbackDelayed(this.mWaitTime);
            }
        }
        if (UIMgr.isLargeMode((Context)this.getActivity())) {
            this.mBtnBack.setVisibility(8);
        }
        if (!StringUtil.isEmptyOrNull((String)(url = PTApp.getInstance().getURLByType(0)))) {
            String html = this.getString(R.string.zm_msg_feedback_welcome, new Object[]{url});
            this.mTxtWelcome.setText((CharSequence)Html.fromHtml((String)html));
        }
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        PTUI.getInstance().addPTUIListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePTUIListener(this);
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    public void onResume() {
        super.onResume();
        View view = this.getView();
        if (view != null) {
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FeedbackFragment.this.mEdtFeedback.requestFocus();
                    UIUtil.openSoftKeyboard((Context)FeedbackFragment.this.getActivity(), (View)FeedbackFragment.this.mEdtFeedback);
                }
            }, 100L);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("mState", this.mState);
        outState.putBoolean("mbWaitingShowPanelSendFeedback", this.mbWaitingShowPanelSendFeedback);
        if (this.mbWaitingShowPanelSendFeedback) {
            outState.putLong("mWaitTime", System.currentTimeMillis() - this.mWaitStartTime);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSend) {
            this.onClickBtnSend();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickBtnSend() {
        String feedback = this.mEdtFeedback.getText().toString().trim();
        if (feedback.length() == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(feedback);
        builder.append("\n[");
        builder.append(SystemInfoHelper.getHardwareInfo());
        builder.append("]");
        builder.append("\n[Version:");
        builder.append(this.getString(R.string.zm_version_name));
        builder.append("]");
        feedback = builder.toString();
        this.mPanelSendFeedback.setVisibility(8);
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        if (PTApp.getInstance().sendFeedback(feedback)) {
            this.mState = 1;
            this.updateUIForCurrentState();
        } else {
            this.mState = 3;
            this.updateUIForCurrentState();
            this.showPanelSendFeedbackDelayed(2000L);
        }
    }

    private void showPanelSendFeedbackDelayed(long time) {
        this.mbWaitingShowPanelSendFeedback = true;
        this.mWaitTime = time;
        this.mWaitStartTime = System.currentTimeMillis();
        final ZMActivity activity = (ZMActivity)this.getActivity();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                FeedbackFragment.this.mbWaitingShowPanelSendFeedback = false;
                FeedbackFragment.this.mWaitTime = 0L;
                FeedbackFragment.this.mWaitStartTime = 0L;
                FeedbackFragment.this.mTimer = null;
                if (activity.isActive()) {
                    FeedbackFragment.this.onShowPanelSendFeedback();
                }
            }
        }, time);
    }

    private void onShowPanelSendFeedback() {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FeedbackFragment.this.mState = 0;
                FeedbackFragment.this.updateUIForCurrentState();
            }
        });
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 29: {
                this.onSendFeedbackResult(result);
            }
        }
    }

    private void onSendFeedbackResult(final long result) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                FeedbackFragment f = (FeedbackFragment)ui;
                if (f != null) {
                    f.handleOnSendFeedbackResult(result);
                }
            }
        });
    }

    private void handleOnSendFeedbackResult(long result) {
        if (result == 0L) {
            this.mState = 2;
            this.mEdtFeedback.setText((CharSequence)"");
            this.updateUIForCurrentState();
            this.showPanelSendFeedbackDelayed(8000L);
        } else {
            this.mState = 3;
            this.updateUIForCurrentState();
            this.showPanelSendFeedbackDelayed(2000L);
        }
    }

    private void updateUIForCurrentState() {
        switch (this.mState) {
            case 0: {
                this.mPanelSendFeedback.setVisibility(0);
                this.mTxtWelcome.setVisibility(0);
                this.mTxtSending.setVisibility(8);
                this.mTxtThanks.setVisibility(8);
                this.mTxtSentFailed.setVisibility(8);
                break;
            }
            case 1: {
                this.mPanelSendFeedback.setVisibility(8);
                this.mTxtWelcome.setVisibility(8);
                this.mTxtSending.setVisibility(0);
                this.mTxtThanks.setVisibility(8);
                this.mTxtSentFailed.setVisibility(8);
                break;
            }
            case 2: {
                this.mPanelSendFeedback.setVisibility(8);
                this.mTxtWelcome.setVisibility(8);
                this.mTxtSending.setVisibility(8);
                this.mTxtThanks.setVisibility(0);
                this.mTxtSentFailed.setVisibility(8);
                break;
            }
            case 3: {
                this.mPanelSendFeedback.setVisibility(8);
                this.mTxtWelcome.setVisibility(8);
                this.mTxtSending.setVisibility(8);
                this.mTxtThanks.setVisibility(8);
                this.mTxtSentFailed.setVisibility(0);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }
}

