/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ExpelUserAlertDialog
extends ZMDialogFragment {
    private static final String ARG_USERID = "userId";
    private long mUserId = 0L;

    public static void showExpelUserAlertDialog(ZMActivity activity, long userId) {
        ExpelUserAlertDialog dlg = new ExpelUserAlertDialog();
        Bundle args = new Bundle();
        args.putLong(ARG_USERID, userId);
        dlg.setArguments(args);
        dlg.show(activity.getSupportFragmentManager(), ExpelUserAlertDialog.class.getName());
    }

    public static ExpelUserAlertDialog getExpelUserAlertDialog(FragmentManager fm) {
        ExpelUserAlertDialog f = (ExpelUserAlertDialog)fm.findFragmentByTag(ExpelUserAlertDialog.class.getName());
        return f;
    }

    public ExpelUserAlertDialog() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.mUserId = args.getLong(ARG_USERID);
        CmmUser user = ConfMgr.getInstance().getUserById(this.mUserId);
        if (user == null) {
            this.mUserId = 0L;
            return this.createEmptyDialog();
        }
        String title = this.getActivity().getString(R.string.zm_alert_expel_user_confirm_44379, new Object[]{user.getScreenName()});
        return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setCancelable(true).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ExpelUserAlertDialog.this.expelUser();
            }
        }).create();
    }

    public void onResume() {
        super.onResume();
        if (this.mUserId == 0L) {
            this.dismissAllowingStateLoss();
        }
    }

    public long getUserId() {
        return this.mUserId;
    }

    private void expelUser() {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        long userId = args.getLong(ARG_USERID);
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(29, userId);
    }
}

