/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.Serializable;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ErrorMsgDialog
extends ZMDialogFragment {
    private static final String ARG_ERROR_MESSAGE = "message";
    private static final String ARG_FINISH_ACTIVITY_ON_DISMISS = "finishActivityOnDismiss";
    private static final String ARG_EXT_ERROR_MESSAGES = "extMessages";
    private static final String ARG_DISMISS_INTERVAL = "interval";
    private ArrayList<ErrorInfo> mExtErrorMsg = new ArrayList();
    private boolean mFinishActivityOnDismiss = false;

    public static ErrorMsgDialog newInstance(String message, int errorCode, ArrayList<ErrorInfo> extInfos, boolean finishActivityOnDismiss, long interval) {
        ErrorMsgDialog dialog = new ErrorMsgDialog();
        dialog.setCancelable(true);
        Bundle args = new Bundle();
        args.putSerializable(ARG_ERROR_MESSAGE, (Serializable)new ErrorInfo(message, errorCode));
        args.putBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS, finishActivityOnDismiss);
        args.putSerializable(ARG_EXT_ERROR_MESSAGES, extInfos);
        args.putLong(ARG_DISMISS_INTERVAL, interval);
        dialog.setArguments(args);
        return dialog;
    }

    public static ErrorMsgDialog newInstance(String message, int errorCode, ArrayList<ErrorInfo> extInfos, boolean finishActivityOnDismiss) {
        return ErrorMsgDialog.newInstance(message, errorCode, extInfos, finishActivityOnDismiss, 5000L);
    }

    public static ErrorMsgDialog newInstance(String message, int errorCode, boolean finishActivityOnDismiss, long interval) {
        return ErrorMsgDialog.newInstance(message, errorCode, null, finishActivityOnDismiss, interval);
    }

    public static ErrorMsgDialog newInstance(String message, int errorCode, boolean finishActivityOnDismiss) {
        return ErrorMsgDialog.newInstance(message, errorCode, null, finishActivityOnDismiss);
    }

    public static ErrorMsgDialog newInstance(String message, int errorCode) {
        return ErrorMsgDialog.newInstance(message, errorCode, false);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ArrayList extMsgs;
        Bundle args = this.getArguments();
        ErrorInfo errorMsg = null;
        long interval = 5000L;
        if (args != null) {
            this.mFinishActivityOnDismiss = args.getBoolean(ARG_FINISH_ACTIVITY_ON_DISMISS, false);
            errorMsg = (ErrorInfo)args.getSerializable(ARG_ERROR_MESSAGE);
            extMsgs = (ArrayList)args.getSerializable(ARG_EXT_ERROR_MESSAGES);
            if (extMsgs != null) {
                this.mExtErrorMsg = extMsgs;
            }
            interval = args.getLong(ARG_DISMISS_INTERVAL, 5000L);
        }
        if (savedInstanceState != null && (extMsgs = (ArrayList)savedInstanceState.getSerializable(ARG_EXT_ERROR_MESSAGES)) != null) {
            this.mExtErrorMsg = extMsgs;
        }
        View content = View.inflate((Context)this.getActivity(), (int)R.layout.zm_mm_error_dialog, null);
        TextView txtErrorMsg = (TextView)content.findViewById(R.id.txtErrorMsg);
        ImageView imgErrorIcon = (ImageView)content.findViewById(R.id.imgErrorIcon);
        String msg = null;
        msg = errorMsg == null ? this.getActivity().getString(R.string.zm_alert_unknown_error) : errorMsg.message;
        txtErrorMsg.setText((CharSequence)msg);
        if (errorMsg == null || errorMsg.errorCode != 0) {
            interval = this.mExtErrorMsg == null || this.mExtErrorMsg.size() == 0 ? interval : 2000L;
            imgErrorIcon.setImageResource(R.drawable.zm_ic_error_msg_attation);
        } else {
            interval = 1000L;
            imgErrorIcon.setImageResource(R.drawable.zm_ic_success_msg_attation);
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ErrorMsgDialog dialog = ErrorMsgDialog.this;
                if (dialog.isAdded()) {
                    dialog.dismissAllowingStateLoss();
                }
            }
        }, interval);
        return new ZMAlertDialog.Builder((Context)this.getActivity()).setView(content).setTheme(R.style.ZMDialog_Material_Transparent).create();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        FragmentActivity activity = this.getActivity();
        if (this.mExtErrorMsg.size() > 0) {
            ErrorInfo msg = this.mExtErrorMsg.remove(0);
            ErrorMsgDialog dlg = ErrorMsgDialog.newInstance(msg.message, msg.errorCode, this.mExtErrorMsg, this.mFinishActivityOnDismiss);
            dlg.show(this.getFragmentManager(), ErrorMsgDialog.class.getName());
            return;
        }
        if (this.mFinishActivityOnDismiss && activity != null) {
            activity.finish();
        }
    }

    public void onNewErrorMsg(String msg, int code) {
        this.mExtErrorMsg.add(new ErrorInfo(msg, code));
    }

    public static class ErrorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String message;
        private int errorCode;

        public ErrorInfo(String message, int code) {
            this.message = message;
            this.errorCode = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }
    }
}

