/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class CustomStatusFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private EditText mEdtCustomStatus;
    private Button mBtnSave;
    private ImageView mImgClear;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerListener;

    public static void showAsActivity(Fragment fragment, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, CustomStatusFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ZoomBuddy myself;
        View view = inflater.inflate(R.layout.zm_custom_status, container, false);
        this.mEdtCustomStatus = (EditText)view.findViewById(R.id.edtCustomStatus);
        this.mBtnSave = (Button)view.findViewById(R.id.btnSave);
        this.mImgClear = (ImageView)view.findViewById(R.id.imgClear);
        this.mEdtCustomStatus.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                CustomStatusFragment.this.mImgClear.setVisibility(s.length() > 0 ? 0 : 4);
            }
        });
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (myself = messenger.getMyself()) != null) {
            this.mEdtCustomStatus.setText((CharSequence)myself.getSignature());
            if (!TextUtils.isEmpty((CharSequence)myself.getSignature())) {
                this.mEdtCustomStatus.setSelection(myself.getSignature().length());
            }
        }
        this.mImgClear.setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        this.mBtnSave.setOnClickListener((View.OnClickListener)this);
        this.mEdtCustomStatus.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                CustomStatusFragment.this.onClickBtnSave();
                return true;
            }
        });
        return view;
    }

    public void onResume() {
        super.onResume();
        if (this.mZoomMessengerListener == null) {
            this.mZoomMessengerListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public void Indicate_VCardInfoReady(String jid) {
                    CustomStatusFragment.this.Indicate_VCardInfoReady(jid);
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerListener);
    }

    private void Indicate_VCardInfoReady(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        if (StringUtil.isSameString((String)myself.getJid(), (String)jid)) {
            this.mEdtCustomStatus.setText((CharSequence)myself.getSignature());
            if (!TextUtils.isEmpty((CharSequence)myself.getSignature())) {
                this.mEdtCustomStatus.setSelection(myself.getSignature().length());
            }
        }
    }

    public void onPause() {
        super.onPause();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerListener);
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.imgClear) {
            this.onClickImgClear();
        } else if (id2 == R.id.btnCancel) {
            this.onClickBtnCancel();
        } else if (id2 == R.id.btnSave) {
            this.onClickBtnSave();
        }
    }

    private void onClickBtnSave() {
        String text = this.mEdtCustomStatus.getText().toString();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showConnectionError();
            return;
        }
        String reqId = messenger.setUserSignature(text);
        if (!StringUtil.isEmptyOrNull((String)reqId)) {
            this.dismiss();
        }
    }

    private void onClickBtnCancel() {
        this.dismiss();
    }

    private void onClickImgClear() {
        this.mEdtCustomStatus.setText((CharSequence)"");
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    public void dismiss() {
        this.finishFragment(true);
    }
}

