/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.videomeetings.R;

public class CreateProfileFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener {
    private static final String ARG_FIRST_NAME = "firstName";
    private static final String ARG_LAST_NAME = "lastName";
    private static final String ARG_EMAIL = "email";
    private static final String ARG_CODE = "code";
    private Button mBtnBack;
    private Button mBtnOK;
    private TextView mTxtError;
    private EditText mEdtPassword;
    private EditText mEdtVerifyPassword;
    private EditText mEdtFirstName;
    private EditText mEdtLastName;
    private String mEmail = null;
    private String mCode = null;
    private String mFirstName = null;
    private String mLastName = null;
    private boolean mVerifyFailed = false;

    public static void showAsActivity(ZMActivity activity, String firstName, String lastName, String email, String code) {
        Bundle args = CreateProfileFragment.buildArguments(firstName, lastName, email, code);
        SimpleActivity.show(activity, CreateProfileFragment.class.getName(), args, 0);
    }

    public static void showAsActivity(Fragment fragment, String firstName, String lastName, String email, String code) {
        Bundle args = CreateProfileFragment.buildArguments(firstName, lastName, email, code);
        SimpleActivity.show(fragment, CreateProfileFragment.class.getName(), args, 0);
    }

    private static Bundle buildArguments(String firstName, String lastName, String email, String code) {
        Bundle args = new Bundle();
        args.putString(ARG_FIRST_NAME, firstName);
        args.putString(ARG_LAST_NAME, lastName);
        args.putString(ARG_EMAIL, email);
        args.putString(ARG_CODE, code);
        return args;
    }

    public CreateProfileFragment() {
        this.setStyle(1, R.style.ZMDialog);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_create_profile, null);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnOK = (Button)view.findViewById(R.id.btnOK);
        this.mTxtError = (TextView)view.findViewById(R.id.txtError);
        this.mEdtPassword = (EditText)view.findViewById(R.id.edtPassword);
        this.mEdtVerifyPassword = (EditText)view.findViewById(R.id.edtVerifyPassword);
        EditText edtEmail = (EditText)view.findViewById(R.id.edtEmail);
        this.mEdtFirstName = (EditText)view.findViewById(R.id.edtFirstName);
        this.mEdtLastName = (EditText)view.findViewById(R.id.edtLastName);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mEmail = args.getString(ARG_EMAIL);
            this.mCode = args.getString(ARG_CODE);
            this.mFirstName = args.getString(ARG_FIRST_NAME);
            this.mLastName = args.getString(ARG_LAST_NAME);
        }
        if (savedInstanceState == null) {
            if (edtEmail != null && this.mEmail != null) {
                edtEmail.setText((CharSequence)this.mEmail);
            }
            if (this.mEdtFirstName != null && this.mFirstName != null) {
                this.mEdtFirstName.setText((CharSequence)this.mFirstName);
            }
            if (this.mEdtLastName != null && this.mLastName != null) {
                this.mEdtLastName.setText((CharSequence)this.mLastName);
            }
        } else {
            this.mVerifyFailed = savedInstanceState.getBoolean("mVerifyFailed");
        }
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnOK.setOnClickListener((View.OnClickListener)this);
        TextWatcher inputValidator = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                CreateProfileFragment.this.updateOKButton();
                CreateProfileFragment.this.mVerifyFailed = false;
                CreateProfileFragment.this.mTxtError.setVisibility(4);
            }
        };
        this.mEdtPassword.addTextChangedListener(inputValidator);
        this.mEdtVerifyPassword.addTextChangedListener(inputValidator);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.updateUI();
        PTUI.getInstance().addPTUIListener(this);
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("mVerifyFailed", this.mVerifyFailed);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnOK) {
            this.onClickBtnOK();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickBtnOK() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        if (!this.validateInput()) {
            return;
        }
        String password = this.mEdtPassword.getText().toString();
        String verify = this.mEdtVerifyPassword.getText().toString();
        String firstName = this.mEdtFirstName.getText().toString().trim();
        String lastName = this.mEdtLastName.getText().toString().trim();
        if (!password.equals(verify)) {
            this.mVerifyFailed = true;
            this.mTxtError.setVisibility(0);
            return;
        }
        boolean res = PTApp.getInstance().setPassword(false, this.mEmail, password, this.mCode, firstName, lastName);
        if (res) {
            WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_requesting_setpwd);
            dialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
        } else {
            this.showSetPwdErrorDialog();
        }
    }

    private void showSetPwdErrorDialog() {
        int msgId = R.string.zm_msg_activate_account_failed;
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(msgId);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    private void updateUI() {
        if (this.mVerifyFailed) {
            this.mTxtError.setVisibility(0);
        } else {
            this.mTxtError.setVisibility(4);
        }
        this.updateOKButton();
    }

    private void updateOKButton() {
        this.mBtnOK.setEnabled(this.validateInput());
    }

    private boolean validateInput() {
        String password = this.mEdtPassword.getText().toString();
        String verify = this.mEdtVerifyPassword.getText().toString();
        String firstName = this.mEdtFirstName.getText().toString().trim();
        String lastName = this.mEdtLastName.getText().toString().trim();
        if (password.length() == 0) {
            return false;
        }
        if (verify.length() == 0) {
            return false;
        }
        if (firstName.length() == 0) {
            return false;
        }
        return lastName.length() != 0;
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 41: {
                this.onSetPasswordRet(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void onSetPasswordRet(long result) {
        WaitingDialog waitingDlg = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (waitingDlg != null) {
            waitingDlg.dismiss();
        }
        switch ((int)result) {
            case 0: {
                this.autoLogin();
                break;
            }
            default: {
                this.showSetPwdErrorDialog();
            }
        }
    }

    private void autoLogin() {
        this.dismiss();
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            LoginActivity.show((Context)activity, false);
            activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
    }
}

